/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.text;

import com.ibm.uima.text.CharArrayString;
import java.util.Arrays;

public class TextTokenizer {
    public static final int EOS = 0;
    public static final int SEP = 1;
    public static final int WSP = 2;
    public static final int WCH = 3;
    private final char[] text;
    private final int end;
    private int pos;
    private char[] eosDels = new char[0];
    private char[] separators = new char[0];
    private char[] whitespace = new char[0];
    private char[] wordChars = new char[0];
    private int nextTokenStart;
    private int nextTokenEnd;
    private int nextTokenType;
    private boolean nextComputed = false;
    private boolean showWhitespace = true;
    private boolean showSeparators = true;

    public TextTokenizer(CharArrayString charArrayString) {
        this.text = charArrayString.getChars();
        this.pos = charArrayString.getStart();
        this.end = charArrayString.getEnd() - 1;
    }

    public TextTokenizer(String string) {
        this(new CharArrayString(string));
    }

    public void setShowWhitespace(boolean bl) {
        this.showWhitespace = bl;
    }

    public void setShowSeparators(boolean bl) {
        this.showSeparators = bl;
    }

    public void setEndOfSentenceChars(String string) {
        if (string == null) {
            string = "";
        }
        this.eosDels = this.makeSortedList(string);
    }

    public void addToEndOfSentenceChars(String string) {
        if (string == null) {
            return;
        }
        this.eosDels = this.addToSortedList(string, this.eosDels);
    }

    public void setSeparators(String string) {
        if (string == null) {
            string = "";
        }
        this.separators = this.makeSortedList(string);
    }

    public void addSeparators(String string) {
        if (string == null) {
            return;
        }
        this.separators = this.addToSortedList(string, this.separators);
    }

    public void setWhitespaceChars(String string) {
        if (string == null) {
            string = "";
        }
        this.whitespace = this.makeSortedList(string);
    }

    public void addWhitespaceChars(String string) {
        if (string == null) {
            return;
        }
        this.whitespace = this.addToSortedList(string, this.whitespace);
    }

    public void setWordChars(String string) {
        if (string == null) {
            string = "";
        }
        this.wordChars = this.makeSortedList(string);
    }

    public void addWordChars(String string) {
        if (string == null) {
            return;
        }
        this.wordChars = this.addToSortedList(string, this.wordChars);
    }

    public int getNextTokenType() {
        this.computeNextToken();
        if (this.nextComputed) {
            return this.nextTokenType;
        }
        return -1;
    }

    public boolean hasNext() {
        if (this.nextComputed) {
            return true;
        }
        return this.computeNextToken();
    }

    public String nextToken() {
        this.computeNextToken();
        if (!this.nextComputed) {
            return null;
        }
        this.nextComputed = false;
        return new String(this.text, this.nextTokenStart, this.nextTokenEnd - this.nextTokenStart);
    }

    private boolean computeNextToken() {
        if (this.nextComputed) {
            return true;
        }
        if (this.pos >= this.end) {
            this.nextComputed = false;
            return false;
        }
        this.nextTokenStart = this.pos;
        int n = this.getCharType(this.text[this.pos]);
        block0 : switch (n) {
            case 0: {
                ++this.pos;
                this.nextTokenType = 0;
                break;
            }
            case 1: {
                ++this.pos;
                if (!this.showSeparators) {
                    return this.computeNextToken();
                }
                this.nextTokenType = 1;
                break;
            }
            case 2: {
                ++this.pos;
                while (this.pos <= this.end && this.getCharType(this.text[this.pos]) == 2) {
                    ++this.pos;
                }
                if (!this.showWhitespace) {
                    return this.computeNextToken();
                }
                this.nextTokenType = 2;
                break;
            }
            case 3: {
                ++this.pos;
                this.nextTokenType = 3;
                n = this.getCharType(this.text[this.pos]);
                while (this.pos < this.end && (n == 3 || n == 0)) {
                    ++this.pos;
                    if (n == 0) {
                        if (this.pos >= this.end) {
                            --this.pos;
                            break block0;
                        }
                        n = this.getCharType(this.text[this.pos]);
                        if (n != 3) {
                            --this.pos;
                            break block0;
                        }
                    }
                    n = this.getCharType(this.text[this.pos]);
                }
                break;
            }
            default: {
                return false;
            }
        }
        this.nextTokenEnd = this.pos;
        this.nextComputed = true;
        return true;
    }

    public int getCharType(char c) {
        if (Arrays.binarySearch(this.eosDels, c) >= 0) {
            return 0;
        }
        if (Arrays.binarySearch(this.separators, c) >= 0) {
            return 1;
        }
        if (Arrays.binarySearch(this.whitespace, c) >= 0) {
            return 2;
        }
        if (Arrays.binarySearch(this.wordChars, c) >= 0) {
            return 3;
        }
        if (Character.isWhitespace(c)) {
            return 2;
        }
        return 3;
    }

    private char[] addToSortedList(String string, char[] cArray) {
        char[] cArray2 = new char[cArray.length + string.length()];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        string.getChars(0, string.length(), cArray2, cArray.length);
        Arrays.sort(cArray2);
        return cArray2;
    }

    private char[] makeSortedList(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        Arrays.sort(cArray);
        return cArray;
    }
}

