/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.text;

import java.util.Arrays;

public class TextStringTokenizer {
    public static final int EOS = 0;
    public static final int SEP = 1;
    public static final int WSP = 2;
    public static final int WCH = 3;
    private final String text;
    private final int end;
    private int pos;
    private char[] eosDels = new char[0];
    private char[] separators = new char[0];
    private char[] whitespace = new char[0];
    private char[] wordChars = new char[0];
    private int nextTokenStart;
    private int nextTokenEnd;
    private int nextTokenType;
    private boolean nextComputed = false;
    private boolean showWhitespace = true;
    private boolean showSeparators = true;

    public TextStringTokenizer(String string) {
        this.text = string;
        this.pos = 0;
        this.end = string.length() - 1;
        this.setToNext();
    }

    public void setShowWhitespace(boolean bl) {
        this.showWhitespace = bl;
    }

    public void setShowSeparators(boolean bl) {
        this.showSeparators = bl;
    }

    public void setEndOfSentenceChars(String string) {
        if (string == null) {
            TextStringTokenizer.makeSortedList("");
        } else {
            this.eosDels = TextStringTokenizer.makeSortedList(string);
        }
    }

    public void addToEndOfSentenceChars(String string) {
        if (string == null) {
            return;
        }
        this.eosDels = TextStringTokenizer.addToSortedList(string, this.eosDels);
    }

    public void setSeparators(String string) {
        if (string == null) {
            string = "";
        }
        this.separators = TextStringTokenizer.makeSortedList(string);
    }

    public void addSeparators(String string) {
        if (string == null) {
            return;
        }
        this.separators = TextStringTokenizer.addToSortedList(string, this.separators);
    }

    public void setWhitespaceChars(String string) {
        if (string == null) {
            string = "";
        }
        this.whitespace = TextStringTokenizer.makeSortedList(string);
    }

    public void addWhitespaceChars(String string) {
        if (string == null) {
            return;
        }
        this.whitespace = TextStringTokenizer.addToSortedList(string, this.whitespace);
    }

    public void setWordChars(String string) {
        if (string == null) {
            string = "";
        }
        this.wordChars = TextStringTokenizer.makeSortedList(string);
    }

    public void addWordChars(String string) {
        if (string == null) {
            return;
        }
        this.wordChars = TextStringTokenizer.addToSortedList(string, this.wordChars);
    }

    public int getTokenType() {
        if (this.nextComputed) {
            return this.nextTokenType;
        }
        return -1;
    }

    public boolean isValid() {
        return this.nextComputed;
    }

    public void setToFirst() {
        this.pos = 0;
        this.setToNext();
    }

    public String getToken() {
        if (!this.nextComputed) {
            return null;
        }
        return this.text.substring(this.nextTokenStart, this.nextTokenEnd);
    }

    public int getTokenStart() {
        if (!this.nextComputed) {
            return -1;
        }
        return this.nextTokenStart;
    }

    public int getTokenEnd() {
        if (!this.nextComputed) {
            return -1;
        }
        return this.nextTokenEnd;
    }

    public void setToNext() {
        if (this.pos > this.end) {
            this.nextComputed = false;
            return;
        }
        this.nextTokenStart = this.pos;
        int n = this.getCharType(this.text.charAt(this.pos));
        block0 : switch (n) {
            case 0: {
                ++this.pos;
                this.nextTokenType = 0;
                break;
            }
            case 1: {
                ++this.pos;
                if (!this.showSeparators) {
                    this.setToNext();
                    return;
                }
                this.nextTokenType = 1;
                break;
            }
            case 2: {
                ++this.pos;
                while (this.pos <= this.end && this.getCharType(this.text.charAt(this.pos)) == 2) {
                    ++this.pos;
                }
                if (!this.showWhitespace) {
                    this.setToNext();
                    return;
                }
                this.nextTokenType = 2;
                break;
            }
            case 3: {
                ++this.pos;
                this.nextTokenType = 3;
                if (this.pos > this.end) break;
                n = this.getCharType(this.text.charAt(this.pos));
                while (this.pos < this.end && (n == 3 || n == 0)) {
                    ++this.pos;
                    if (n == 0) {
                        if (this.pos >= this.end) {
                            --this.pos;
                            break block0;
                        }
                        n = this.getCharType(this.text.charAt(this.pos));
                        if (n != 3) {
                            --this.pos;
                            break block0;
                        }
                    }
                    n = this.getCharType(this.text.charAt(this.pos));
                }
                break;
            }
            default: {
                return;
            }
        }
        this.nextTokenEnd = this.pos;
        this.nextComputed = true;
    }

    public int getCharType(char c) {
        if (Arrays.binarySearch(this.eosDels, c) >= 0) {
            return 0;
        }
        if (Arrays.binarySearch(this.separators, c) >= 0) {
            return 1;
        }
        if (Arrays.binarySearch(this.whitespace, c) >= 0) {
            return 2;
        }
        if (Arrays.binarySearch(this.wordChars, c) >= 0) {
            return 3;
        }
        if (Character.isWhitespace(c)) {
            return 2;
        }
        return 3;
    }

    private static final char[] addToSortedList(String string, char[] cArray) {
        char[] cArray2 = new char[cArray.length + string.length()];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        string.getChars(0, string.length(), cArray2, cArray.length);
        Arrays.sort(cArray2);
        return cArray2;
    }

    private static final char[] makeSortedList(String string) {
        char[] cArray = new char[string.length()];
        string.getChars(0, string.length(), cArray, 0);
        Arrays.sort(cArray);
        return cArray;
    }
}

