/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.text;

import com.ibm.uima.util.StringUtils;
import java.util.ArrayList;

public class CharacterUtils {
    private static final boolean isType(char c, int[] nArray) {
        int n = Character.getType(c);
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            if (n != nArray[i]) continue;
            return true;
        }
        return false;
    }

    private static ArrayList getCharacterRanges(int[] nArray) {
        ArrayList<CharRange> arrayList = new ArrayList<CharRange>();
        for (char c = '\u0000'; c <= '\uffff'; c = (char)(c + '\u0001')) {
            if (CharacterUtils.isType(c, nArray)) {
                CharRange charRange = new CharRange();
                charRange.start = c;
                charRange.end = c;
                if (c == '\uffff') break;
                for (c = (char)(c + '\u0001'); c <= '\uffff' && CharacterUtils.isType(c, nArray); c = (char)(c + '\u0001')) {
                    charRange.end = c;
                    if (c == '\uffff') break;
                }
                arrayList.add(charRange);
            }
            if (c == '\uffff') break;
        }
        return arrayList;
    }

    public static String toUnicodeChar(char c) {
        String string = "\\u";
        String string2 = Integer.toHexString(c);
        switch (string2.length()) {
            case 1: {
                return string + "000" + string2;
            }
            case 2: {
                return string + "00" + string2;
            }
            case 3: {
                return string + "0" + string2;
            }
        }
        return string + string2;
    }

    public static String toHexString(char c) {
        String string = "0x";
        String string2 = Integer.toHexString(c);
        switch (string2.length()) {
            case 1: {
                return string + "000" + string2;
            }
            case 2: {
                return string + "00" + string2;
            }
            case 3: {
                return string + "0" + string2;
            }
        }
        return string + string2;
    }

    public static ArrayList getLetterRange() {
        int[] nArray = new int[]{1, 2, 3, 4, 5};
        return CharacterUtils.getCharacterRanges(nArray);
    }

    public static ArrayList getDigitRange() {
        int[] nArray = new int[]{9};
        return CharacterUtils.getCharacterRanges(nArray);
    }

    public static void printAntlrLexRule(String string, ArrayList arrayList) {
        System.out.print(string + " : ");
        StringBuffer stringBuffer = new StringBuffer();
        StringUtils.printSpaces(string.length(), stringBuffer);
        String string2 = stringBuffer.toString();
        for (int i = 0; i < arrayList.size(); ++i) {
            CharRange charRange;
            if (i != 0) {
                System.out.print("\n" + string2 + " | ");
            }
            if ((charRange = (CharRange)arrayList.get(i)).start == charRange.end) {
                System.out.print(" '" + CharacterUtils.toUnicodeChar(charRange.start) + "'");
                continue;
            }
            System.out.print(" '" + CharacterUtils.toUnicodeChar(charRange.start) + "' .. '" + CharacterUtils.toUnicodeChar(charRange.end) + "' ");
        }
        System.out.println("\n" + string2 + " ;");
    }

    public static void printJavaCCLexRule(String string, ArrayList arrayList) {
        System.out.print(string + " = ");
        StringBuffer stringBuffer = new StringBuffer();
        StringUtils.printSpaces(string.length(), stringBuffer);
        String string2 = stringBuffer.toString();
        for (int i = 0; i < arrayList.size(); ++i) {
            CharRange charRange;
            if (i != 0) {
                System.out.print("\n" + string2 + " | ");
            }
            if ((charRange = (CharRange)arrayList.get(i)).start == charRange.end) {
                System.out.print(CharacterUtils.toHexString(charRange.start));
                continue;
            }
            System.out.print("[" + CharacterUtils.toHexString(charRange.start) + ".." + CharacterUtils.toHexString(charRange.end) + "]");
        }
        System.out.println("\n" + string2 + " ;");
    }

    public static void main(String[] stringArray) {
        ArrayList arrayList = CharacterUtils.getDigitRange();
        CharacterUtils.printJavaCCLexRule("udigit", arrayList);
    }

    private static class CharRange {
        private char start;
        private char end;

        private CharRange() {
        }
    }
}

