/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.text;

public class CharArrayString {
    private final int start;
    private final int len;
    private final int end;
    private final char[] chars;
    private static final int SEED1 = 31415;
    private static final int SEED2 = 27183;

    public CharArrayString(String string) {
        this.len = string.length();
        this.start = 0;
        this.end = this.len;
        this.chars = new char[this.len];
        string.getChars(0, this.len, this.chars, 0);
    }

    public CharArrayString(char[] cArray) {
        this(cArray, 0, cArray.length);
    }

    public CharArrayString(char[] cArray, int n, int n2) {
        this.start = n;
        this.len = n2;
        this.end = this.start + this.len;
        this.chars = cArray;
    }

    public int length() {
        return this.len;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public char[] getChars() {
        return this.chars;
    }

    public CharArrayString trim() {
        int n;
        int n2 = this.end - 1;
        for (n = this.start; n <= n2 && Character.isWhitespace(this.chars[n]); ++n) {
        }
        while (n2 >= n && Character.isWhitespace(this.chars[n2])) {
            --n2;
        }
        if (this.start != n || this.end != ++n2) {
            return new CharArrayString(this.chars, n, n2 - n);
        }
        return this;
    }

    public CharArrayString substring(int n, int n2) throws IndexOutOfBoundsException {
        if (n >= this.len || n > n2 || n < 0) {
            throw new IndexOutOfBoundsException();
        }
        return new CharArrayString(this.chars, this.start + n, n2 - n);
    }

    public CharArrayString substring(int n) {
        return this.substring(n, this.len);
    }

    public int lastIndexOf(char c) {
        int n;
        for (int i = n = this.end - 1; i >= this.start; --i) {
            if (this.chars[i] != c) continue;
            return i - this.start;
        }
        return -1;
    }

    public String toString() {
        return new String(this.chars, this.start, this.len);
    }

    public boolean endsWith(CharArrayString charArrayString) {
        if (charArrayString.len > this.len) {
            return false;
        }
        int n = this.end;
        int n2 = charArrayString.end;
        while (n2 > charArrayString.start) {
            if (this.chars[--n] == charArrayString.chars[--n2]) continue;
            return false;
        }
        return true;
    }

    public boolean endsWith(char c) {
        if (this.len <= 0) {
            return false;
        }
        return this.chars[this.start + this.len - 1] == c;
    }

    public char charAt(int n) {
        if (n < this.start || n >= this.len) {
            throw new IndexOutOfBoundsException();
        }
        return this.chars[n + this.start];
    }

    public int indexOf(char c, int n) throws IndexOutOfBoundsException {
        if (n < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = this.start + n; i < this.end; ++i) {
            if (this.chars[i] != c) continue;
            return i - this.start;
        }
        return -1;
    }

    public int indexOf(char c) {
        return this.indexOf(c, 0);
    }

    public void setChar(int n, char c) throws IndexOutOfBoundsException {
        if ((n += this.start) < this.start || n >= this.end) {
            throw new IndexOutOfBoundsException();
        }
        this.chars[n] = c;
    }

    public CharArrayString copy() {
        char[] cArray = new char[this.len];
        System.arraycopy(this.chars, 0, cArray, 0, this.len);
        return new CharArrayString(cArray, 0, this.len);
    }

    public int hashCode() {
        return CharArrayString.hashCode(this.chars, this.start, this.end);
    }

    public static final int hashCode(char[] cArray, int n, int n2) {
        int n3 = 0;
        int n4 = 31415;
        int n5 = 27183;
        for (int i = n; i < n2; ++i) {
            n3 = n4 * n3 + cArray[i];
            n4 *= n5;
        }
        return Math.abs(n3);
    }

    public static final int hashCode(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        int n2 = 31415;
        int n3 = string.length();
        for (int i = 0; i < n3; ++i) {
            n = n2 * n + string.charAt(i);
            n2 *= 27183;
        }
        return Math.abs(n);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (object instanceof CharArrayString) {
            CharArrayString charArrayString = (CharArrayString)object;
            if (this.len != charArrayString.len) {
                return false;
            }
            int n = charArrayString.start;
            for (int i = this.start; i < this.end; ++i) {
                if (this.chars[i] != charArrayString.chars[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }
}

