/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.text;

import com.ibm.uima.text.CharArrayString;
import java.util.ArrayList;

public class CharArraySpanMap {
    private static final int MIN_ARRAY_SIZE = 1024;
    private static final int MIN_MAP_SIZE = 5003;
    private char[] charArray;
    private int pos;
    private ArrayList[] map;

    public CharArraySpanMap() {
        this(1024);
    }

    public CharArraySpanMap(int n) {
        this(n, 5003);
    }

    public CharArraySpanMap(int n, int n2) {
        if (n < 1024) {
            n = 1024;
        }
        if (n2 < 5003) {
            n2 = 5003;
        }
        this.charArray = new char[n];
        this.map = new ArrayList[n2];
        for (int i = 0; i < n2; ++i) {
            this.map[i] = new ArrayList();
        }
        this.pos = 0;
    }

    private final int isInList(String string, ArrayList arrayList) {
        int n = arrayList.size();
        int n2 = string.length();
        boolean bl = false;
        int n3 = 0;
        while (n3 < n) {
            Entry entry = (Entry)arrayList.get(n3);
            if (n2 != entry.length) {
                ++n3;
                continue;
            }
            bl = true;
            for (int i = 0; i < n2; ++i) {
                if (string.charAt(i) == this.charArray[i + entry.start]) continue;
                bl = false;
                break;
            }
            if (bl) break;
            ++n3;
        }
        return bl ? n3 : -1;
    }

    private final int isInList(char[] cArray, int n, int n2, ArrayList arrayList) {
        int n3 = arrayList.size();
        boolean bl = false;
        int n4 = 0;
        while (n4 < n3) {
            Entry entry = (Entry)arrayList.get(n4);
            if (n2 != entry.length) {
                ++n4;
                continue;
            }
            bl = true;
            int n5 = entry.start;
            int n6 = n + n2;
            for (int i = n; i < n6; ++i) {
                if (cArray[i] != this.charArray[n5]) {
                    bl = false;
                    break;
                }
                ++n5;
            }
            if (bl) break;
            ++n4;
        }
        return bl ? n4 : -1;
    }

    public void put(String string, Object object) {
        int n = CharArrayString.hashCode(string);
        ArrayList arrayList = this.map[n % this.map.length];
        int n2 = this.isInList(string, arrayList);
        if (n2 >= 0) {
            Entry entry = (Entry)arrayList.get(n2);
            entry.value = object;
            return;
        }
        int n3 = this.pos;
        this.addString(string);
        Entry entry = new Entry();
        entry.start = n3;
        entry.length = this.pos - n3;
        entry.value = object;
        arrayList.add(entry);
    }

    public final boolean containsKey(char[] cArray, int n, int n2) {
        int n3 = CharArrayString.hashCode(cArray, n, n + n2);
        ArrayList arrayList = this.map[n3 % this.map.length];
        int n4 = this.isInList(cArray, n, n2, arrayList);
        return n4 >= 0;
    }

    public final Object get(char[] cArray, int n, int n2) {
        int n3 = CharArrayString.hashCode(cArray, n, n + n2);
        ArrayList arrayList = this.map[n3 % this.map.length];
        int n4 = this.isInList(cArray, n, n2, arrayList);
        return n4 >= 0 ? ((Entry)arrayList.get(n4)).value : null;
    }

    private final void addString(String string) {
        int n;
        int n2 = string.length();
        int n3 = this.pos + n2;
        boolean bl = false;
        for (n = this.charArray.length; n < n3; n += 1024) {
            bl = true;
        }
        if (bl) {
            char[] cArray = new char[n];
            System.arraycopy(this.charArray, 0, cArray, 0, this.pos);
            this.charArray = cArray;
        }
        for (int i = 0; i < n2; ++i) {
            this.charArray[this.pos] = string.charAt(i);
            ++this.pos;
        }
    }

    private static final class Entry {
        private int start = 0;
        private int length = 0;
        private Object value = null;

        private Entry() {
        }
    }
}

