/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.resource;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.UIMA_IllegalStateException;
import com.ibm.uima.UimaContext;
import com.ibm.uima.UimaContextAdmin;
import com.ibm.uima.resource.ExternalResourceDependency;
import com.ibm.uima.resource.Resource;
import com.ibm.uima.resource.ResourceConfigurationException;
import com.ibm.uima.resource.ResourceCreationSpecifier;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceManager;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.resource.metadata.ResourceManagerConfiguration;
import com.ibm.uima.resource.metadata.ResourceMetaData;
import com.ibm.uima.util.InvalidXMLException;
import com.ibm.uima.util.Logger;
import java.util.Map;

public abstract class Resource_ImplBase
implements Resource {
    private ResourceMetaData mMetaData;
    private UimaContextAdmin mUimaContextAdmin;
    private boolean mInitialized = false;

    public boolean initialize(ResourceSpecifier resourceSpecifier, Map map) throws ResourceInitializationException {
        Object object;
        String string = this.getMetaData() != null ? this.getMetaData().getName() : this.getClass().getName();
        if (this.mInitialized) {
            throw new UIMA_IllegalStateException("resource_already_initialized", new Object[]{string});
        }
        if (map != null) {
            this.mUimaContextAdmin = (UimaContextAdmin)map.get("UIMA_CONTEXT");
        }
        if (this.mUimaContextAdmin == null) {
            object = null;
            if (map != null) {
                object = (ResourceManager)map.get("RESOURCE_MANAGER");
            }
            if (object == null) {
                object = UIMAFramework.newDefaultResourceManager();
            }
            this.mUimaContextAdmin = UIMAFramework.newUimaContext(UIMAFramework.getLogger(this.getClass()), (ResourceManager)object, UIMAFramework.newConfigurationManager());
        } else {
            this.mUimaContextAdmin.setLogger(UIMAFramework.getLogger(this.getClass()));
        }
        if (resourceSpecifier instanceof ResourceCreationSpecifier) {
            ExternalResourceDependency[] externalResourceDependencyArray;
            object = ((ResourceCreationSpecifier)resourceSpecifier).getMetaData();
            string = object.getName();
            try {
                object.resolveImports(this.getResourceManager());
            }
            catch (InvalidXMLException invalidXMLException) {
                throw new ResourceInitializationException(invalidXMLException);
            }
            this.setMetaData((ResourceMetaData)object);
            try {
                this.mUimaContextAdmin.getConfigurationManager().createContext(this.mUimaContextAdmin.getQualifiedContextName(), this.getMetaData());
                this.mUimaContextAdmin.getConfigurationManager().setSession(this.mUimaContextAdmin.getSession());
            }
            catch (ResourceConfigurationException resourceConfigurationException) {
                throw new ResourceInitializationException("error_initializing_from_descriptor", new Object[]{string, object.getSourceUrlString()}, resourceConfigurationException);
            }
            ResourceManagerConfiguration resourceManagerConfiguration = ((ResourceCreationSpecifier)resourceSpecifier).getResourceManagerConfiguration();
            if (resourceManagerConfiguration != null) {
                try {
                    resourceManagerConfiguration.resolveImports(this.getResourceManager());
                }
                catch (InvalidXMLException invalidXMLException) {
                    throw new ResourceInitializationException(invalidXMLException);
                }
                this.mUimaContextAdmin.getResourceManager().initializeExternalResources(resourceManagerConfiguration, this.mUimaContextAdmin.getQualifiedContextName(), map);
            }
            if ((externalResourceDependencyArray = ((ResourceCreationSpecifier)resourceSpecifier).getExternalResourceDependencies()) != null) {
                this.mUimaContextAdmin.getResourceManager().resolveAndValidateResourceDependencies(externalResourceDependencyArray, this.mUimaContextAdmin.getQualifiedContextName());
            }
        }
        this.mInitialized = true;
        return true;
    }

    public void destroy() {
    }

    public ResourceMetaData getMetaData() {
        return this.mMetaData;
    }

    protected void setMetaData(ResourceMetaData resourceMetaData) {
        this.mMetaData = resourceMetaData;
    }

    public Logger getLogger() {
        return this.getUimaContext() == null ? null : this.getUimaContext().getLogger();
    }

    public void setLogger(Logger logger) {
        if (this.getUimaContext() != null) {
            this.getUimaContextAdmin().setLogger(logger);
        }
    }

    public ResourceManager getResourceManager() {
        if (this.getUimaContextAdmin() != null) {
            return this.getUimaContextAdmin().getResourceManager();
        }
        return null;
    }

    public UimaContext getUimaContext() {
        return this.mUimaContextAdmin;
    }

    public UimaContextAdmin getUimaContextAdmin() {
        return this.mUimaContextAdmin;
    }
}

