/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.util;

import com.ibm.uima.util.InvalidXMLException;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public abstract class XMLUtils {
    static /* synthetic */ Class class$java$lang$String;

    public static void normalize(String string, StringBuffer stringBuffer) {
        XMLUtils.normalize(string, stringBuffer, false);
    }

    public static void normalize(String string, StringBuffer stringBuffer, boolean bl) {
        if (string != null) {
            int n = string.length();
            block8: for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (c > '\u007f') {
                    stringBuffer.append("&#").append((int)c).append(';');
                    continue;
                }
                switch (c) {
                    case '<': {
                        stringBuffer.append("&lt;");
                        continue block8;
                    }
                    case '>': {
                        stringBuffer.append("&gt;");
                        continue block8;
                    }
                    case '&': {
                        stringBuffer.append("&amp;");
                        continue block8;
                    }
                    case '\"': {
                        stringBuffer.append("&quot;");
                        continue block8;
                    }
                    case '\n': {
                        stringBuffer.append(bl ? " " : "\n");
                        continue block8;
                    }
                    case '\r': {
                        stringBuffer.append(bl ? " " : "\r");
                        continue block8;
                    }
                    default: {
                        stringBuffer.append(c);
                    }
                }
            }
        }
    }

    public static void writeNormalizedString(String string, Writer writer, boolean bl) throws IOException {
        if (string == null) {
            return;
        }
        int n = string.length();
        block8: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    continue block8;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block8;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block8;
                }
                case '\"': {
                    writer.write("&quot;");
                    continue block8;
                }
                case '\n': {
                    writer.write(bl ? " " : "\n");
                    continue block8;
                }
                case '\r': {
                    writer.write(bl ? " " : "\r");
                    continue block8;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    public static void writePrimitiveValue(Object object, Writer writer) throws IOException {
        String string = object.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n > -1) {
            string = string.substring(n + 1).toLowerCase();
        }
        writer.write("<");
        writer.write(string);
        writer.write(">");
        XMLUtils.writeNormalizedString(object.toString(), writer, true);
        writer.write("</");
        writer.write(string);
        writer.write(">");
    }

    public static void writePrimitiveValue(Object object, ContentHandler contentHandler) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = object.getClass().getName();
        int n = string.lastIndexOf(".");
        if (n > -1) {
            string = string.substring(n + 1).toLowerCase();
        }
        contentHandler.startElement(null, string, string, attributesImpl);
        String string2 = object.toString();
        contentHandler.characters(string2.toCharArray(), 0, string2.length());
        contentHandler.endElement(null, string, string);
    }

    public static Element getChildByTagName(Element element, String string) {
        NodeList nodeList = element.getElementsByTagName(string);
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element2 = (Element)nodeList.item(i);
            if (element2.getParentNode() != element) continue;
            return element2;
        }
        return null;
    }

    public static Element getFirstChildElement(Element element) {
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            return (Element)node;
        }
        return null;
    }

    public static Object readPrimitiveValue(Element element) throws InvalidXMLException {
        String string = element.getTagName();
        if (string.endsWith("_p")) {
            string = string.substring(0, string.lastIndexOf("_p"));
        }
        char[] cArray = string.toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        String string2 = "java.lang." + new String(cArray);
        String string3 = XMLUtils.getText(element, true);
        try {
            Class<?> clazz = Class.forName(string2);
            Constructor<?> constructor = clazz.getConstructor(class$java$lang$String == null ? (class$java$lang$String = XMLUtils.class$("java.lang.String")) : class$java$lang$String);
            return constructor.newInstance(string3);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Text) {
                stringBuffer.append(((Text)node).getData());
                continue;
            }
            if (!(node instanceof Element)) continue;
            stringBuffer.append('<').append(((Element)node).getTagName()).append('>');
            stringBuffer.append(XMLUtils.getText((Element)node));
            stringBuffer.append("</").append(((Element)node).getTagName()).append('>');
        }
        return stringBuffer.toString().trim();
    }

    public static String getText(Element element, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            if (node instanceof Text) {
                stringBuffer.append(((Text)node).getData());
                continue;
            }
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            if (bl && "envVarRef".equals(element2.getTagName())) {
                String string = XMLUtils.getText(element2, false);
                String string2 = System.getProperty(string);
                if (string2 == null) continue;
                stringBuffer.append(string2);
                continue;
            }
            stringBuffer.append('<').append(((Element)node).getTagName()).append('>');
            stringBuffer.append(XMLUtils.getText((Element)node, bl));
            stringBuffer.append("</").append(((Element)node).getTagName()).append('>');
        }
        return stringBuffer.toString().trim();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

