/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class UIMALogFormatter
extends Formatter {
    private static final String timestampFormat = "{0,date,short} {0,time}";
    private static final String CRLF = System.getProperties().getProperty("line.separator");

    public synchronized String format(LogRecord logRecord) {
        if (logRecord == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        Date date = new Date(logRecord.getMillis());
        Object[] objectArray = new Object[]{date};
        String string = MessageFormat.format(timestampFormat, objectArray);
        stringBuffer.append(string);
        stringBuffer.append(" - ");
        stringBuffer.append(logRecord.getThreadID());
        stringBuffer.append(": ");
        if (logRecord.getSourceClassName() == null || logRecord.getSourceClassName().equals("")) {
            stringBuffer.append(logRecord.getLoggerName());
        } else {
            stringBuffer.append(logRecord.getSourceClassName());
        }
        if (logRecord.getSourceMethodName() != null) {
            stringBuffer.append(".");
            stringBuffer.append(logRecord.getSourceMethodName());
        }
        stringBuffer.append(": ");
        stringBuffer.append(logRecord.getLevel().getLocalizedName());
        stringBuffer.append(": ");
        stringBuffer.append(logRecord.getMessage());
        if (logRecord.getThrown() != null) {
            stringBuffer.append(CRLF);
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            logRecord.getThrown().printStackTrace(printWriter);
            printWriter.close();
            stringBuffer.append(stringWriter.toString());
        }
        stringBuffer.append(CRLF);
        return stringBuffer.toString();
    }
}

