/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.util;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.UIMARuntimeException;
import com.ibm.uima.reference_impl.util.XIncluder;
import com.ibm.uima.util.InvalidXMLException;
import com.ibm.uima.util.Level;
import com.ibm.uima.util.SaxDeserializer;
import com.ibm.uima.util.XMLParser;
import com.ibm.uima.util.XMLSerializer;
import com.ibm.uima.util.XMLizable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class SaxDeserializer_impl
implements SaxDeserializer {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    static final String JAXP_SCHEMA_SOURCE = "http://java.sun.com/xml/jaxp/properties/schemaSource";
    private static final SAXTransformerFactory transformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
    private boolean mValidate;
    private DocumentBuilder mDocumentBuilder;
    private DOMResult mDOMResult;
    private ByteArrayOutputStream mBytes;
    private TransformerHandler mXIncludeTransformerHandler;
    private XMLParser mUimaXmlParser;
    private XMLParser.ParsingOptions mOptions;
    private ParseErrorHandler mErrorHandler;

    public SaxDeserializer_impl(XMLParser xMLParser, String string, URL uRL, XMLParser.ParsingOptions parsingOptions) {
        block7: {
            this.mUimaXmlParser = xMLParser;
            this.mOptions = parsingOptions;
            this.mValidate = string != null && uRL != null;
            try {
                this.mXIncludeTransformerHandler = parsingOptions.expandXIncludes ? XIncluder.newXIncludeHandler() : transformerFactory.newTransformerHandler();
                if (!this.mValidate) {
                    this.mDOMResult = new DOMResult();
                    this.mXIncludeTransformerHandler.setResult(this.mDOMResult);
                    break block7;
                }
                this.mBytes = new ByteArrayOutputStream();
                XMLSerializer xMLSerializer = new XMLSerializer(this.mBytes);
                SAXResult sAXResult = new SAXResult(xMLSerializer.getContentHandler());
                this.mXIncludeTransformerHandler.setResult(sAXResult);
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                documentBuilderFactory.setNamespaceAware(true);
                try {
                    documentBuilderFactory.setAttribute(JAXP_SCHEMA_LANGUAGE, W3C_XML_SCHEMA);
                    documentBuilderFactory.setAttribute(JAXP_SCHEMA_SOURCE, uRL.toString());
                    documentBuilderFactory.setValidating(true);
                }
                catch (Exception exception) {
                    UIMAFramework.getLogger().log(Level.INFO, "The installed XML Parser does not support schema validation.  No validation will occur.");
                    documentBuilderFactory.setValidating(false);
                }
                this.mDocumentBuilder = documentBuilderFactory.newDocumentBuilder();
                this.mErrorHandler = new ParseErrorHandler();
                this.mDocumentBuilder.setErrorHandler(this.mErrorHandler);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new UIMARuntimeException(parserConfigurationException);
            }
            catch (SecurityException securityException) {
                throw new UIMARuntimeException(securityException);
            }
            catch (TransformerConfigurationException transformerConfigurationException) {
                throw new UIMARuntimeException(transformerConfigurationException);
            }
        }
    }

    public XMLizable getObject() throws InvalidXMLException {
        Element element;
        Object object;
        if (this.mValidate) {
            object = new ByteArrayInputStream(this.mBytes.toByteArray());
            try {
                InputSource inputSource = new InputSource((InputStream)object);
                element = this.mDocumentBuilder.parse(inputSource).getDocumentElement();
            }
            catch (IOException iOException) {
                throw new InvalidXMLException(iOException);
            }
            catch (SAXException sAXException) {
                throw new InvalidXMLException(sAXException);
            }
            if (this.mErrorHandler.getException() != null) {
                throw new InvalidXMLException(this.mErrorHandler.getException());
            }
        } else {
            element = ((Document)this.mDOMResult.getNode()).getDocumentElement();
        }
        object = this.mUimaXmlParser.buildObject(element, this.mOptions);
        if (this.mValidate) {
            this.mBytes = new ByteArrayOutputStream();
            this.mErrorHandler.clear();
        } else {
            this.mDOMResult = new DOMResult();
            this.mXIncludeTransformerHandler.setResult(this.mDOMResult);
        }
        return object;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this.mXIncludeTransformerHandler.characters(cArray, n, n2);
    }

    public void endDocument() throws SAXException {
        this.mXIncludeTransformerHandler.endDocument();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.mXIncludeTransformerHandler.endElement(string, string2, string3);
    }

    public void endPrefixMapping(String string) throws SAXException {
        this.mXIncludeTransformerHandler.endPrefixMapping(string);
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.mXIncludeTransformerHandler.ignorableWhitespace(cArray, n, n2);
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.mXIncludeTransformerHandler.processingInstruction(string, string2);
    }

    public void setDocumentLocator(Locator locator) {
        this.mXIncludeTransformerHandler.setDocumentLocator(locator);
    }

    public void skippedEntity(String string) throws SAXException {
        this.mXIncludeTransformerHandler.skippedEntity(string);
    }

    public void startDocument() throws SAXException {
        this.mXIncludeTransformerHandler.startDocument();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.mXIncludeTransformerHandler.startElement(string, string2, string3, attributes);
    }

    public void startPrefixMapping(String string, String string2) throws SAXException {
        this.mXIncludeTransformerHandler.startPrefixMapping(string, string2);
    }

    static class ParseErrorHandler
    extends DefaultHandler {
        private SAXParseException mException = null;

        ParseErrorHandler() {
        }

        public void error(SAXParseException sAXParseException) {
            if (this.mException == null) {
                this.mException = sAXParseException;
            }
        }

        public void fatalError(SAXParseException sAXParseException) {
            if (this.mException == null) {
                this.mException = sAXParseException;
            }
        }

        public void warning(SAXParseException sAXParseException) {
            System.err.println("XML Warning: " + sAXParseException.getMessage());
        }

        public SAXParseException getException() {
            return this.mException;
        }

        public void clear() {
            this.mException = null;
        }
    }
}

