/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.util;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.resource.Resource;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.resource.Resource_ImplBase;
import com.ibm.uima.resource.metadata.ResourceMetaData;
import com.ibm.uima.util.Level;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class ResourcePool {
    private static final String LOG_RESOURCE_BUNDLE = "com.ibm.uima.reference_impl.log_messages";
    private static final Class CLASS_NAME = class$com$ibm$uima$reference_impl$util$ResourcePool == null ? (class$com$ibm$uima$reference_impl$util$ResourcePool = ResourcePool.class$("com.ibm.uima.reference_impl.util.ResourcePool")) : class$com$ibm$uima$reference_impl$util$ResourcePool;
    private Vector mAllInstances = new Vector();
    private Vector mFreeInstances = new Vector();
    private int mNumInstances;
    private ResourceMetaData mMetaData;
    static /* synthetic */ Class class$com$ibm$uima$reference_impl$util$ResourcePool;

    public ResourcePool(int n, ResourceSpecifier resourceSpecifier, Class clazz) throws ResourceInitializationException {
        this(n, resourceSpecifier, clazz, null);
    }

    public ResourcePool(int n, ResourceSpecifier resourceSpecifier, Class clazz, Map map) throws ResourceInitializationException {
        this.mNumInstances = n;
        this.fillPool(resourceSpecifier, clazz, map);
    }

    public synchronized Resource getResource() {
        if (!this.mFreeInstances.isEmpty()) {
            Resource resource = (Resource)this.mFreeInstances.remove(0);
            return resource;
        }
        return null;
    }

    public synchronized void releaseResource(Resource resource) {
        if (!this.mAllInstances.contains(resource) || this.mFreeInstances.contains(resource)) {
            UIMAFramework.getLogger(CLASS_NAME).logrb(Level.WARNING, CLASS_NAME.getName(), "releaseResource", LOG_RESOURCE_BUNDLE, "UIMA_return_resource_to_pool__WARNING");
        } else {
            this.mFreeInstances.add(resource);
        }
        this.notifyAll();
    }

    public synchronized Resource getResource(long l) {
        Resource resource;
        long l2 = new Date().getTime();
        while ((resource = this.getResource()) == null) {
            try {
                this.wait(l);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (l <= 0L || new Date().getTime() - l2 < l) continue;
            return null;
        }
        return resource;
    }

    public synchronized void destroy() {
        Iterator iterator = this.mAllInstances.iterator();
        while (iterator.hasNext()) {
            Resource resource = (Resource)iterator.next();
            resource.destroy();
        }
        this.mAllInstances.clear();
        this.mFreeInstances.clear();
    }

    public int getSize() {
        return this.mNumInstances;
    }

    public ResourceMetaData getMetaData() {
        return this.mMetaData;
    }

    protected void fillPool(ResourceSpecifier resourceSpecifier, Class clazz, Map map) throws ResourceInitializationException {
        for (int i = 0; i < this.mNumInstances; ++i) {
            Resource_ImplBase resource_ImplBase = (Resource_ImplBase)UIMAFramework.produceResource(clazz, resourceSpecifier, map);
            this.mAllInstances.add(resource_ImplBase);
            this.mFreeInstances.add(resource_ImplBase);
            if (i != 0) continue;
            this.mMetaData = resource_ImplBase.getMetaData();
        }
    }

    protected Vector getAllInstances() {
        return this.mAllInstances;
    }

    protected Vector getFreeInstances() {
        return this.mFreeInstances;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

