/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.util;

import com.ibm.uima.util.ProcessTraceEvent;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ProcessTraceEvent_impl
implements ProcessTraceEvent {
    private static final long serialVersionUID = 4275351517280216988L;
    private String mComponentName;
    private String mType;
    private String mDescription;
    private int mDuration;
    private String mResultMessage;
    private List mSubEvents;
    private long mStartTime;

    public ProcessTraceEvent_impl() {
    }

    public ProcessTraceEvent_impl(String string, String string2, String string3) {
        this.mComponentName = string;
        this.mType = string2;
        this.mDescription = string3;
    }

    public String getComponentName() {
        return this.mComponentName;
    }

    public void setComponentName(String string) {
        this.mComponentName = string;
    }

    public String getType() {
        return this.mType;
    }

    public void setType(String string) {
        this.mType = string;
    }

    public String getDescription() {
        return this.mDescription;
    }

    public void setDescription(String string) {
        this.mDescription = string;
    }

    public int getDuration() {
        return this.mDuration;
    }

    public void setDuration(int n) {
        this.mDuration = n;
    }

    public void addToDuration(long l) {
        this.mDuration = (int)((long)this.mDuration + l);
    }

    public String getResultMessage() {
        return this.mResultMessage;
    }

    public void setResultMessage(String string) {
        this.mResultMessage = string;
    }

    public List getSubEvents() {
        if (this.mSubEvents == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mSubEvents;
    }

    public void addSubEvent(ProcessTraceEvent processTraceEvent) {
        if (this.mSubEvents == null) {
            this.mSubEvents = new ArrayList();
        }
        this.mSubEvents.add(processTraceEvent);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, 0);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer, int n) {
        this.toString(stringBuffer, n, 0);
    }

    public void toString(StringBuffer stringBuffer, int n, int n2) {
        List list;
        Object object;
        int n3;
        DecimalFormat decimalFormat = new DecimalFormat("##.##%");
        this.writeTabs(n, stringBuffer);
        stringBuffer.append("Component Name: ").append(this.getComponentName()).append("\n");
        this.writeTabs(n, stringBuffer);
        stringBuffer.append("Event Type: ").append(this.getType()).append("\n");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            this.writeTabs(n, stringBuffer);
            stringBuffer.append("Description: ").append(this.getDescription()).append("\n");
        }
        if ((n3 = this.getDuration()) >= 0) {
            this.writeTabs(n, stringBuffer);
            stringBuffer.append("Duration: ").append(n3).append("ms");
            if (n2 > 0) {
                double d = (double)n3 / (double)n2;
                object = decimalFormat.format(d);
                stringBuffer.append(" (").append((String)object).append(')');
            }
            stringBuffer.append('\n');
        }
        if (this.getResultMessage() != null && this.getResultMessage().length() > 0) {
            this.writeTabs(n, stringBuffer);
            stringBuffer.append("Result: ").append(this.getResultMessage()).append("\n");
        }
        if (!(list = this.getSubEvents()).isEmpty()) {
            this.writeTabs(n, stringBuffer);
            stringBuffer.append("Sub-events:").append("\n");
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object = (ProcessTraceEvent)iterator.next();
                object.toString(stringBuffer, n + 1, n2);
                stringBuffer.append("\n");
            }
        }
    }

    public int getDurationExcludingSubEvents() {
        int n = this.getDuration();
        Iterator iterator = this.getSubEvents().iterator();
        while (iterator.hasNext()) {
            ProcessTraceEvent processTraceEvent = (ProcessTraceEvent)iterator.next();
            n -= processTraceEvent.getDuration();
        }
        return n;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public void setStartTime(long l) {
        this.mStartTime = l;
    }

    protected void writeTabs(int n, StringBuffer stringBuffer) {
        for (int i = 0; i < n; ++i) {
            stringBuffer.append('\t');
        }
    }
}

