/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.util;

import com.ibm.uima.reference_impl.util.I18nUtil;
import com.ibm.uima.util.Level;
import com.ibm.uima.util.Logger;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.Date;

public class Logger_impl
implements Logger {
    private static final PrintStream defaultOut = System.out;
    private PrintStream mOut;
    private Level configLevel = Level.INFO;
    private static final Logger_impl defaultLogger = new Logger_impl();

    private Logger_impl() {
        this.mOut = defaultOut;
    }

    public static synchronized Logger getInstance(Class clazz) {
        return new Logger_impl();
    }

    public static synchronized Logger getInstance() {
        return defaultLogger;
    }

    public void log(String string) {
        if (this.isLoggable(Level.INFO) && this.mOut != null) {
            this.mOut.print(new Date());
            this.mOut.print(": " + Level.INFO.toString() + ": ");
            this.mOut.println(string);
        }
    }

    public void log(String string, String string2, Object[] objectArray) {
        if (this.isLoggable(Level.INFO)) {
            this.log(I18nUtil.localizeMessage(string, string2, objectArray));
        }
    }

    public void logException(Exception exception) {
        if (this.isLoggable(Level.INFO) && this.mOut != null) {
            this.mOut.print(new Date());
            this.mOut.print(": " + Level.INFO.toString() + ": ");
            exception.printStackTrace(this.mOut);
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        this.mOut = outputStream == null || outputStream instanceof PrintStream ? (PrintStream)outputStream : new PrintStream(outputStream);
    }

    public void setOutputStream(PrintStream printStream) {
        this.mOut = printStream;
    }

    private void logException(Level level, Throwable throwable) {
        this.mOut.print(new Date());
        this.mOut.print(": " + level.toString() + ": ");
        throwable.printStackTrace(this.mOut);
    }

    private void logMessage(Level level, String string) {
        if (this.mOut != null) {
            this.mOut.print(new Date());
            this.mOut.print(": " + level.toString() + ": ");
            this.mOut.println(string);
        }
    }

    public boolean isLoggable(Level level) {
        return this.configLevel.isGreaterOrEqual(level);
    }

    public void log(Level level, String string) {
        if (this.isLoggable(level)) {
            this.logMessage(level, string);
        }
    }

    public void log(Level level, String string, Object object) {
        if (this.isLoggable(level)) {
            String string2 = MessageFormat.format(string, object);
            this.logMessage(level, string2);
        }
    }

    public void log(Level level, String string, Object[] objectArray) {
        if (this.isLoggable(level)) {
            String string2 = MessageFormat.format(string, objectArray);
            this.logMessage(level, string2);
        }
    }

    public void log(Level level, String string, Throwable throwable) {
        if (this.isLoggable(level)) {
            this.logMessage(level, string);
            this.logException(level, throwable);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object object) {
        if (this.isLoggable(level)) {
            this.logMessage(level, I18nUtil.localizeMessage(string3, string4, new Object[]{object}));
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (this.isLoggable(level)) {
            this.logMessage(level, I18nUtil.localizeMessage(string3, string4, objectArray));
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (this.isLoggable(level)) {
            this.logMessage(level, I18nUtil.localizeMessage(string3, string4, null));
            this.logException(level, throwable);
        }
    }

    public void logrb(Level level, String string, String string2, String string3, String string4) {
        if (this.isLoggable(level)) {
            this.logMessage(level, I18nUtil.localizeMessage(string3, string4, null));
        }
    }

    public void setLevel(Level level) {
        this.configLevel = level;
    }
}

