/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.util;

import com.ibm.uima.reference_impl.util.I18nUtil;
import com.ibm.uima.reference_impl.util.UIMALogFormatter;
import com.ibm.uima.reference_impl.util.UIMAStreamHandler;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class JSR47Logger_impl
implements com.ibm.uima.util.Logger {
    private static final String EXCEPTION_MESSAGE = "Exception occurred";
    private Logger logger = null;

    private JSR47Logger_impl(Class clazz) {
        this.logger = clazz != null ? Logger.getLogger(clazz.getName()) : Logger.getLogger("com.ibm.uima");
    }

    private JSR47Logger_impl() {
        this(null);
    }

    public static synchronized com.ibm.uima.util.Logger getInstance(Class clazz) {
        return new JSR47Logger_impl(clazz);
    }

    public static synchronized com.ibm.uima.util.Logger getInstance() {
        return new JSR47Logger_impl();
    }

    public void log(String string) {
        if (this.isLoggable(com.ibm.uima.util.Level.INFO)) {
            if (string == null || string.equals("")) {
                return;
            }
            String[] stringArray = this.getStackTraceInfo(new Throwable());
            this.logger.logp(Level.INFO, stringArray[0], stringArray[1], string);
        }
    }

    public void log(String string, String string2, Object[] objectArray) {
        if (this.isLoggable(com.ibm.uima.util.Level.INFO)) {
            if (string2 == null || string2.equals("")) {
                return;
            }
            String[] stringArray = this.getStackTraceInfo(new Throwable());
            this.logger.logp(Level.INFO, stringArray[0], stringArray[1], I18nUtil.localizeMessage(string, string2, objectArray));
        }
    }

    public void logException(Exception exception) {
        if (this.isLoggable(com.ibm.uima.util.Level.INFO)) {
            if (exception == null) {
                return;
            }
            String[] stringArray = this.getStackTraceInfo(new Throwable());
            this.logger.logp(Level.INFO, stringArray[0], stringArray[1], EXCEPTION_MESSAGE, exception);
        }
    }

    public void setOutputStream(OutputStream outputStream) {
        if (outputStream == null) {
            LogManager.getLogManager().getLogger("").setLevel(Level.OFF);
            return;
        }
        Handler[] handlerArray = LogManager.getLogManager().getLogger("").getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            LogManager.getLogManager().getLogger("").removeHandler(handlerArray[i]);
        }
        UIMAStreamHandler uIMAStreamHandler = new UIMAStreamHandler(outputStream, new UIMALogFormatter());
        uIMAStreamHandler.setLevel(Level.ALL);
        LogManager.getLogManager().getLogger("").addHandler(uIMAStreamHandler);
    }

    public void setOutputStream(PrintStream printStream) {
        if (printStream == null) {
            LogManager.getLogManager().getLogger("").setLevel(Level.OFF);
            return;
        }
        Handler[] handlerArray = LogManager.getLogManager().getLogger("").getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            LogManager.getLogManager().getLogger("").removeHandler(handlerArray[i]);
        }
        UIMAStreamHandler uIMAStreamHandler = new UIMAStreamHandler(printStream, new UIMALogFormatter());
        uIMAStreamHandler.setLevel(Level.ALL);
        LogManager.getLogManager().getLogger("").addHandler(uIMAStreamHandler);
    }

    public boolean isLoggable(com.ibm.uima.util.Level level) {
        Level level2 = this.getJSR47Level(level);
        return this.logger.isLoggable(level2);
    }

    public void setLevel(com.ibm.uima.util.Level level) {
        Level level2 = this.getJSR47Level(level);
        this.logger.setLevel(level2);
    }

    public void log(com.ibm.uima.util.Level level, String string) {
        if (this.isLoggable(level)) {
            if (string == null || string.equals("")) {
                return;
            }
            Level level2 = this.getJSR47Level(level);
            String[] stringArray = this.getStackTraceInfo(new Throwable());
            this.logger.logp(level2, stringArray[0], stringArray[1], string);
        }
    }

    public void log(com.ibm.uima.util.Level level, String string, Object object) {
        if (this.isLoggable(level)) {
            if (string == null || string.equals("")) {
                return;
            }
            Level level2 = this.getJSR47Level(level);
            String[] stringArray = this.getStackTraceInfo(new Throwable());
            this.logger.logp(level2, stringArray[0], stringArray[1], MessageFormat.format(string, object));
        }
    }

    public void log(com.ibm.uima.util.Level level, String string, Object[] objectArray) {
        if (this.isLoggable(level)) {
            if (string == null || string.equals("")) {
                return;
            }
            Level level2 = this.getJSR47Level(level);
            String[] stringArray = this.getStackTraceInfo(new Throwable());
            this.logger.logp(level2, stringArray[0], stringArray[1], MessageFormat.format(string, objectArray));
        }
    }

    public void log(com.ibm.uima.util.Level level, String string, Throwable throwable) {
        if (this.isLoggable(level)) {
            String[] stringArray;
            Level level2;
            if (string != null && !string.equals("")) {
                level2 = this.getJSR47Level(level);
                stringArray = this.getStackTraceInfo(new Throwable());
                this.logger.logp(level2, stringArray[0], stringArray[1], string, throwable);
            }
            if (throwable != null && (string == null || string.equals(""))) {
                level2 = this.getJSR47Level(level);
                stringArray = this.getStackTraceInfo(new Throwable());
                this.logger.logp(level2, stringArray[0], stringArray[1], EXCEPTION_MESSAGE, throwable);
            }
        }
    }

    public void logrb(com.ibm.uima.util.Level level, String string, String string2, String string3, String string4, Object object) {
        if (this.isLoggable(level)) {
            if (string4 == null || string4.equals("")) {
                return;
            }
            Level level2 = this.getJSR47Level(level);
            this.logger.logp(level2, string, string2, I18nUtil.localizeMessage(string3, string4, new Object[]{object}));
        }
    }

    public void logrb(com.ibm.uima.util.Level level, String string, String string2, String string3, String string4, Object[] objectArray) {
        if (this.isLoggable(level)) {
            if (string4 == null || string4.equals("")) {
                return;
            }
            Level level2 = this.getJSR47Level(level);
            this.logger.logp(level2, string, string2, I18nUtil.localizeMessage(string3, string4, objectArray));
        }
    }

    public void logrb(com.ibm.uima.util.Level level, String string, String string2, String string3, String string4, Throwable throwable) {
        if (this.isLoggable(level)) {
            Level level2;
            if (string4 != null && !string4.equals("")) {
                level2 = this.getJSR47Level(level);
                this.logger.logp(level2, string, string2, I18nUtil.localizeMessage(string3, string4, null), throwable);
            }
            if (throwable != null && (string4 == null || string4.equals(""))) {
                level2 = this.getJSR47Level(level);
                this.logger.logp(level2, string, string2, EXCEPTION_MESSAGE, throwable);
            }
        }
    }

    public void logrb(com.ibm.uima.util.Level level, String string, String string2, String string3, String string4) {
        if (this.isLoggable(level)) {
            if (string4 == null || string4.equals("")) {
                return;
            }
            Level level2 = this.getJSR47Level(level);
            this.logger.logp(level2, string, string2, I18nUtil.localizeMessage(string3, string4, null));
        }
    }

    private Level getJSR47Level(com.ibm.uima.util.Level level) {
        switch (level.toInteger()) {
            case 0x7FFFFFFF: {
                return Level.OFF;
            }
            case 70000: {
                return Level.SEVERE;
            }
            case 60000: {
                return Level.WARNING;
            }
            case 50000: {
                return Level.INFO;
            }
            case 40000: {
                return Level.CONFIG;
            }
            case 30000: {
                return Level.FINE;
            }
            case 20000: {
                return Level.FINER;
            }
            case 10000: {
                return Level.FINEST;
            }
        }
        return Level.ALL;
    }

    private String[] getStackTraceInfo(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string = "";
        String string2 = "";
        int n = 0;
        try {
            n = stackTraceElementArray[1].getLineNumber();
            string = stackTraceElementArray[1].getMethodName();
            string2 = stackTraceElementArray[1].getClassName();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (n > 0) {
            StringBuffer stringBuffer = new StringBuffer(25);
            stringBuffer.append(string);
            stringBuffer.append("(");
            stringBuffer.append(n);
            stringBuffer.append(")");
            string = stringBuffer.toString();
        }
        return new String[]{string2, string};
    }
}

