/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.util;

import java.io.IOException;

public class BrowserUtil {
    private static int __osId;
    private static String __browserLauncher;
    private static final int WINDOWS_NT = 0;
    private static final int WINDOWS_9x = 1;
    private static final int LINUX = 2;
    private static final int OTHER = -1;
    private static final String FIRST_WINDOWS_PARAMETER = "/c";
    private static final String SECOND_WINDOWS_PARAMETER = "start";
    private static final String THIRD_WINDOWS_PARAMETER = "\"\"";
    private static final String MOZILLA_REMOTE_PARAMETER = "-remote";
    private static final String MOZILLA_OPEN_PARAMETER_START = "openURL(";
    private static final String MOZILLA_OPEN_PARAMETER_END = ")";
    private static final String NETSCAPE_REMOTE_PARAMETER = "-remote";
    private static final String NETSCAPE_OPEN_PARAMETER_START = "'openURL(";
    private static final String NETSCAPE_OPEN_PARAMETER_END = ")'";

    public static void main(String[] stringArray) {
        String string = stringArray.length > 0 ? stringArray[0] : "http://www.ibm.com";
        try {
            Process process = BrowserUtil.openUrlInDefaultBrowser(string);
            process.waitFor();
        }
        catch (Exception exception) {
            System.err.println("Error in BrowserUtil.main():");
            exception.printStackTrace(System.err);
        }
    }

    private BrowserUtil() {
    }

    public static Process openUrlInDefaultBrowser(String string) throws IOException {
        Process process = null;
        switch (__osId) {
            case 0: 
            case 1: {
                process = Runtime.getRuntime().exec(new String[]{__browserLauncher, FIRST_WINDOWS_PARAMETER, SECOND_WINDOWS_PARAMETER, THIRD_WINDOWS_PARAMETER, '\"' + string + '\"'});
                try {
                    process.waitFor();
                    process.exitValue();
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("InterruptedException while launching browser: " + interruptedException.getMessage());
                }
            }
            case 2: {
                process = Runtime.getRuntime().exec(new String[]{__browserLauncher, "-remote", MOZILLA_OPEN_PARAMETER_START + string + MOZILLA_OPEN_PARAMETER_END});
                try {
                    int n = process.waitFor();
                    if (n == 0) break;
                    process = Runtime.getRuntime().exec(new String[]{__browserLauncher, string});
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("InterruptedException while launching browser: " + interruptedException.getMessage());
                }
            }
            case -1: {
                process = Runtime.getRuntime().exec(new String[]{__browserLauncher, "-remote", NETSCAPE_OPEN_PARAMETER_START + string + NETSCAPE_OPEN_PARAMETER_END});
                try {
                    int n = process.waitFor();
                    if (n == 0) break;
                    Runtime.getRuntime().exec(new String[]{__browserLauncher, string});
                    break;
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("InterruptedException while launching browser: " + interruptedException.getMessage());
                }
            }
            default: {
                process = Runtime.getRuntime().exec(new String[]{__browserLauncher, string});
            }
        }
        return process;
    }

    static {
        String string = System.getProperty("os.name");
        if (string.startsWith("Windows")) {
            if (string.indexOf("9") > -1) {
                __osId = 1;
                __browserLauncher = "command.com";
            } else {
                __osId = 0;
                __browserLauncher = "cmd.exe";
            }
        } else if (string.startsWith("Linux")) {
            __osId = 2;
            __browserLauncher = "mozilla";
        } else {
            __osId = -1;
            __browserLauncher = "netscape";
        }
    }
}

