/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.resource;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.reference_impl.resource.FileResourceSpecifier_impl;
import com.ibm.uima.reference_impl.resource.RelativePathResolver_impl;
import com.ibm.uima.reference_impl.util.UIMAClassLoader;
import com.ibm.uima.resource.DataResource;
import com.ibm.uima.resource.ExternalResourceDependency;
import com.ibm.uima.resource.ExternalResourceDescription;
import com.ibm.uima.resource.ParameterizedDataResource;
import com.ibm.uima.resource.RelativePathResolver;
import com.ibm.uima.resource.ResourceAccessException;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceManager;
import com.ibm.uima.resource.SharedResourceObject;
import com.ibm.uima.resource.metadata.ExternalResourceBinding;
import com.ibm.uima.resource.metadata.ResourceManagerConfiguration;
import com.ibm.uima.util.Level;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ResourceManager_impl
implements ResourceManager {
    private static final String LOG_RESOURCE_BUNDLE = "com.ibm.uima.reference_impl.log_messages";
    private RelativePathResolver mRelativePathResolver;
    private Map mResourceMap = Collections.synchronizedMap(new HashMap());
    private Map mInternalResourceRegistrationMap = Collections.synchronizedMap(new HashMap());
    private Map mParameterizedResourceImplClassMap = Collections.synchronizedMap(new HashMap());
    private Map mInternalParameterizedResourceImplClassMap = Collections.synchronizedMap(new HashMap());
    private Map mParameterizedResourceInstanceMap = Collections.synchronizedMap(new HashMap());
    private UIMAClassLoader uimaCL = null;
    static /* synthetic */ Class class$com$ibm$uima$reference_impl$resource$DataResource_impl;
    static /* synthetic */ Class class$com$ibm$uima$reference_impl$resource$ResourceManager_impl;
    static /* synthetic */ Class class$com$ibm$uima$resource$SharedResourceObject;

    public ResourceManager_impl() {
        this.mRelativePathResolver = new RelativePathResolver_impl();
    }

    public void setExtensionClassPath(String string, boolean bl) throws MalformedURLException {
        this.uimaCL = new UIMAClassLoader(string, this.getClass().getClassLoader());
        if (bl) {
            this.mRelativePathResolver.setPathResolverClassLoader(this.uimaCL);
        }
    }

    public void setExtensionClassPath(ClassLoader classLoader, String string, boolean bl) throws MalformedURLException {
        this.uimaCL = new UIMAClassLoader(string, classLoader);
        if (bl) {
            this.mRelativePathResolver.setPathResolverClassLoader(this.uimaCL);
        }
    }

    public ClassLoader getExtensionClassLoader() {
        return this.uimaCL;
    }

    public ResourceManager_impl(ClassLoader classLoader) {
        this.mRelativePathResolver = new RelativePathResolver_impl(classLoader);
    }

    public String getDataPath() {
        return this.mRelativePathResolver.getDataPath();
    }

    public void setDataPath(String string) throws MalformedURLException {
        this.mRelativePathResolver.setDataPath(string);
    }

    public URL resolveRelativePath(String string) throws MalformedURLException {
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = new URL("file", "", string);
        }
        return this.mRelativePathResolver.resolveRelativePath(uRL);
    }

    public Object getResource(String string) throws ResourceAccessException {
        Object v = this.mResourceMap.get(string);
        if (v instanceof ParameterizedDataResource) {
            throw new ResourceAccessException("parameters_required", new Object[]{string});
        }
        return v;
    }

    public Object getResource(String string, String[] stringArray) throws ResourceAccessException {
        DataResource dataResource;
        Object v = this.mResourceMap.get(string);
        if (v == null) {
            return null;
        }
        if (!(v instanceof ParameterizedDataResource)) {
            throw new ResourceAccessException("parameters_not_allowed", new Object[]{string});
        }
        ParameterizedDataResource parameterizedDataResource = (ParameterizedDataResource)v;
        try {
            dataResource = parameterizedDataResource.getDataResource(stringArray);
        }
        catch (ResourceInitializationException resourceInitializationException) {
            throw new ResourceAccessException(resourceInitializationException);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(string);
        arrayList.add(dataResource);
        Object v2 = this.mParameterizedResourceInstanceMap.get(arrayList);
        if (v2 != null) {
            return v2;
        }
        Class clazz = (Class)this.mParameterizedResourceImplClassMap.get(string);
        if (clazz != null) {
            try {
                SharedResourceObject sharedResourceObject = (SharedResourceObject)clazz.newInstance();
                sharedResourceObject.load(dataResource);
                this.mParameterizedResourceInstanceMap.put(arrayList, sharedResourceObject);
                return sharedResourceObject;
            }
            catch (InstantiationException instantiationException) {
                throw new ResourceAccessException(instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new ResourceAccessException(illegalAccessException);
            }
            catch (ResourceInitializationException resourceInitializationException) {
                throw new ResourceAccessException(resourceInitializationException);
            }
        }
        this.mParameterizedResourceInstanceMap.put(arrayList, dataResource);
        return dataResource;
    }

    public Class getResourceClass(String string) {
        Object v = this.mResourceMap.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof ParameterizedDataResource) {
            Class clazz = (Class)this.mParameterizedResourceImplClassMap.get(string);
            if (clazz == null) {
                return class$com$ibm$uima$reference_impl$resource$DataResource_impl == null ? (class$com$ibm$uima$reference_impl$resource$DataResource_impl = ResourceManager_impl.class$("com.ibm.uima.reference_impl.resource.DataResource_impl")) : class$com$ibm$uima$reference_impl$resource$DataResource_impl;
            }
            return clazz;
        }
        return v.getClass();
    }

    public InputStream getResourceAsStream(String string, String[] stringArray) throws ResourceAccessException {
        try {
            Object object = this.getResource(string, stringArray);
            if (object != null && object instanceof DataResource) {
                return ((DataResource)object).getInputStream();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new ResourceAccessException(iOException);
        }
    }

    public InputStream getResourceAsStream(String string) throws ResourceAccessException {
        try {
            Object object = this.getResource(string);
            if (object != null && object instanceof DataResource) {
                return ((DataResource)object).getInputStream();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new ResourceAccessException(iOException);
        }
    }

    public URL getResourceURL(String string, String[] stringArray) throws ResourceAccessException {
        Object object = this.getResource(string, stringArray);
        if (object != null && object instanceof DataResource) {
            return ((DataResource)object).getUrl();
        }
        return null;
    }

    public URL getResourceURL(String string) throws ResourceAccessException {
        Object object = this.getResource(string);
        if (object != null && object instanceof DataResource) {
            return ((DataResource)object).getUrl();
        }
        return null;
    }

    public void initializeExternalResources(ResourceManagerConfiguration resourceManagerConfiguration, String string, Map map) throws ResourceInitializationException {
        ResourceRegistration resourceRegistration;
        ExternalResourceDescription[] externalResourceDescriptionArray = resourceManagerConfiguration.getExternalResources();
        for (int i = 0; i < externalResourceDescriptionArray.length; ++i) {
            String string2 = externalResourceDescriptionArray[i].getName();
            resourceRegistration = (ResourceRegistration)this.mInternalResourceRegistrationMap.get(string2);
            if (resourceRegistration == null) {
                this.registerResource(string2, externalResourceDescriptionArray[i], string, map);
                continue;
            }
            if (resourceRegistration.description.equals(externalResourceDescriptionArray[i])) continue;
            if (string.startsWith(resourceRegistration.definingContext)) {
                UIMAFramework.getLogger().logrb(Level.CONFIG, (class$com$ibm$uima$reference_impl$resource$ResourceManager_impl == null ? ResourceManager_impl.class$("com.ibm.uima.reference_impl.resource.ResourceManager_impl") : class$com$ibm$uima$reference_impl$resource$ResourceManager_impl).getName(), "initializeExternalResources", LOG_RESOURCE_BUNDLE, "UIMA_overridden_resource__CONFIG", new Object[]{string2, resourceRegistration.definingContext, string});
                continue;
            }
            UIMAFramework.getLogger().logrb(Level.WARNING, (class$com$ibm$uima$reference_impl$resource$ResourceManager_impl == null ? ResourceManager_impl.class$("com.ibm.uima.reference_impl.resource.ResourceManager_impl") : class$com$ibm$uima$reference_impl$resource$ResourceManager_impl).getName(), "initializeExternalResources", LOG_RESOURCE_BUNDLE, "UIMA_duplicate_resource_name__WARNING", new Object[]{string2, string, resourceRegistration.definingContext});
        }
        ExternalResourceBinding[] externalResourceBindingArray = resourceManagerConfiguration.getExternalResourceBindings();
        for (int i = 0; i < externalResourceBindingArray.length; ++i) {
            resourceRegistration = (ResourceRegistration)this.mInternalResourceRegistrationMap.get(externalResourceBindingArray[i].getResourceName());
            if (resourceRegistration == null) {
                throw new ResourceInitializationException("unknown_resource_name", new Object[]{externalResourceBindingArray[i].getResourceName(), externalResourceBindingArray[i].getSourceUrlString()});
            }
            this.mResourceMap.put(string + externalResourceBindingArray[i].getKey(), resourceRegistration.resource);
            this.mParameterizedResourceImplClassMap.put(string + externalResourceBindingArray[i].getKey(), this.mInternalParameterizedResourceImplClassMap.get(externalResourceBindingArray[i].getResourceName()));
        }
    }

    public void resolveAndValidateResourceDependencies(ExternalResourceDependency[] externalResourceDependencyArray, String string) throws ResourceInitializationException {
        for (int i = 0; i < externalResourceDependencyArray.length; ++i) {
            Serializable serializable;
            Serializable serializable2;
            Object object;
            String string2 = string + externalResourceDependencyArray[i].getKey();
            Object object2 = this.mResourceMap.get(string2);
            if (object2 == null) {
                try {
                    object = new URL("file", "", externalResourceDependencyArray[i].getKey());
                }
                catch (MalformedURLException malformedURLException) {
                    throw new ResourceInitializationException(malformedURLException);
                }
                serializable2 = this.mRelativePathResolver.resolveRelativePath((URL)object);
                if (serializable2 != null) {
                    serializable = new FileResourceSpecifier_impl();
                    serializable.setFileUrl(((URL)serializable2).toString());
                    object2 = UIMAFramework.produceResource(serializable, null);
                    this.mResourceMap.put(string2, object2);
                }
            }
            if (object2 == null) {
                if (externalResourceDependencyArray[i].isOptional()) continue;
                throw new ResourceInitializationException("resource_dependency_not_satisfied", new Object[]{externalResourceDependencyArray[i].getKey(), externalResourceDependencyArray[i].getSourceUrlString()});
            }
            try {
                if (externalResourceDependencyArray[i].getInterfaceName() == null || externalResourceDependencyArray[i].getInterfaceName().length() <= 0) continue;
                object = this.getExtensionClassLoader();
                serializable2 = null;
                serializable2 = object != null ? ((ClassLoader)object).loadClass(externalResourceDependencyArray[i].getInterfaceName()) : Class.forName(externalResourceDependencyArray[i].getInterfaceName());
                if (((Class)serializable2).isAssignableFrom((Class<?>)(serializable = this.getResourceClass(string2)))) continue;
                throw new ResourceInitializationException("resource_does_not_implement_interface", new Object[]{string2, externalResourceDependencyArray[i].getInterfaceName(), externalResourceDependencyArray[i].getSourceUrlString()});
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ResourceInitializationException("class_not_found", new Object[]{externalResourceDependencyArray[i].getInterfaceName(), externalResourceDependencyArray[i].getSourceUrlString()});
            }
        }
    }

    private void registerResource(String string, ExternalResourceDescription externalResourceDescription, String string2, Map map) throws ResourceInitializationException {
        Object object;
        HashMap<String, RelativePathResolver> hashMap = map == null ? new HashMap<String, RelativePathResolver>() : new HashMap(map);
        hashMap.put("RELATIVE_PATH_RESOLVER", this.mRelativePathResolver);
        Object object2 = UIMAFramework.produceResource(externalResourceDescription.getResourceSpecifier(), hashMap);
        String string3 = externalResourceDescription.getImplementationName();
        Class<?> clazz = null;
        if (string3 != null && string3.length() > 0) {
            try {
                object = this.getExtensionClassLoader();
                clazz = object != null ? ((ClassLoader)object).loadClass(string3) : Class.forName(string3);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ResourceInitializationException("class_not_found", new Object[]{string3, externalResourceDescription.getSourceUrlString()}, classNotFoundException);
            }
            if (!(class$com$ibm$uima$resource$SharedResourceObject == null ? (class$com$ibm$uima$resource$SharedResourceObject = ResourceManager_impl.class$("com.ibm.uima.resource.SharedResourceObject")) : class$com$ibm$uima$resource$SharedResourceObject).isAssignableFrom(clazz)) {
                throw new ResourceInitializationException("not_a_shared_resource_object", new Object[]{string3, externalResourceDescription.getSourceUrlString()});
            }
        }
        if (object2 instanceof DataResource) {
            if (clazz != null) {
                try {
                    object = (SharedResourceObject)clazz.newInstance();
                    object.load((DataResource)object2);
                    object2 = object;
                }
                catch (InstantiationException instantiationException) {
                    throw new ResourceInitializationException("could_not_instantiate", new Object[]{clazz.getName(), externalResourceDescription.getSourceUrlString()}, instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new ResourceInitializationException("could_not_instantiate", new Object[]{clazz.getName(), externalResourceDescription.getSourceUrlString()}, illegalAccessException);
                }
            }
        } else if (object2 instanceof ParameterizedDataResource) {
            this.mInternalParameterizedResourceImplClassMap.put(string, clazz);
        } else if (clazz != null) {
            throw new ResourceInitializationException("not_a_data_resource", new Object[]{clazz.getName(), string, object2.getClass().getName(), externalResourceDescription.getSourceUrlString()});
        }
        object = new ResourceRegistration(object2, externalResourceDescription, string2);
        this.mInternalResourceRegistrationMap.put(string, object);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class ResourceRegistration {
        Object resource;
        ExternalResourceDescription description;
        String definingContext;

        ResourceRegistration(Object object, ExternalResourceDescription externalResourceDescription, String string) {
            this.resource = object;
            this.description = externalResourceDescription;
            this.definingContext = string;
        }
    }
}

