/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.resource;

import com.ibm.uima.resource.RelativePathResolver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class RelativePathResolver_impl
implements RelativePathResolver {
    private String mDataPath;
    private URL[] mBaseUrls;
    private ClassLoader mClassLoader;

    public RelativePathResolver_impl() {
        this(null);
        this.mClassLoader = this.getClass().getClassLoader();
    }

    public RelativePathResolver_impl(ClassLoader classLoader) {
        String string = null;
        try {
            string = System.getProperty("uima.datapath");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null) {
            try {
                string = System.getProperty("user.dir");
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (string == null) {
            string = "";
        }
        try {
            this.setDataPath(string);
        }
        catch (MalformedURLException malformedURLException) {
            this.mDataPath = "";
            this.mBaseUrls = new URL[0];
        }
        this.mClassLoader = classLoader;
    }

    public String getDataPath() {
        return this.mDataPath;
    }

    public void setDataPath(String string) throws MalformedURLException {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        String string2 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            URL uRL = new File(string3).toURL();
            arrayList.add(uRL);
        }
        this.mBaseUrls = new URL[arrayList.size()];
        arrayList.toArray(this.mBaseUrls);
        this.mDataPath = string;
    }

    public URL resolveRelativePath(URL uRL) {
        URL uRL2;
        URL[] uRLArray = this.getBaseUrls();
        for (int i = 0; i < uRLArray.length; ++i) {
            try {
                uRL2 = new URL(uRLArray[i], uRL.toString());
                if (!this.fileExistsAtUrl(uRL2)) continue;
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (uRL.getPath().startsWith("/") && this.fileExistsAtUrl(uRL)) {
            return uRL;
        }
        String string = uRL.getFile();
        uRL2 = this.mClassLoader != null ? this.mClassLoader.getResource(string) : ClassLoader.getSystemClassLoader().getResource(string);
        if (uRL2 != null) {
            return uRL2;
        }
        return null;
    }

    public void setPathResolverClassLoader(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean fileExistsAtUrl(URL uRL) {
        boolean bl;
        InputStream inputStream = null;
        try {
            try {
                inputStream = uRL.openStream();
                bl = true;
                Object var6_5 = null;
                if (inputStream == null) return bl;
            }
            catch (IOException iOException) {
                boolean bl2 = false;
                Object var6_6 = null;
                if (inputStream == null) return bl2;
                try {
                    inputStream.close();
                    return bl2;
                }
                catch (IOException iOException3) {
                    // empty catch block
                }
                return bl2;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (inputStream == null) throw throwable;
            try {}
            catch (IOException iOException2) {
                throw throwable;
            }
            inputStream.close();
            throw throwable;
        }
        try {}
        catch (IOException iOException) {
            // empty catch block
            return bl;
        }
        inputStream.close();
        return bl;
    }

    protected URL[] getBaseUrls() {
        return this.mBaseUrls;
    }
}

