/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.resource;

import com.ibm.uima.UIMARuntimeException;
import com.ibm.uima.reference_impl.resource.RelativePathResolver_impl;
import com.ibm.uima.resource.DataResource;
import com.ibm.uima.resource.FileResourceSpecifier;
import com.ibm.uima.resource.RelativePathResolver;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.resource.Resource_ImplBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class DataResource_impl
extends Resource_ImplBase
implements DataResource {
    private URL mFileUrl;
    private File mLocalCache;

    public boolean initialize(ResourceSpecifier resourceSpecifier, Map map) throws ResourceInitializationException {
        if (!(resourceSpecifier instanceof FileResourceSpecifier)) {
            return false;
        }
        FileResourceSpecifier fileResourceSpecifier = (FileResourceSpecifier)resourceSpecifier;
        RelativePathResolver relativePathResolver = null;
        if (map != null) {
            relativePathResolver = (RelativePathResolver)map.get("RELATIVE_PATH_RESOLVER");
        }
        if (relativePathResolver == null) {
            relativePathResolver = new RelativePathResolver_impl();
        }
        IOException iOException = null;
        try {
            this.mFileUrl = relativePathResolver.resolveRelativePath(new URL(fileResourceSpecifier.getFileUrl()));
            this.mLocalCache = fileResourceSpecifier.getLocalCache() == null ? null : new File(fileResourceSpecifier.getLocalCache());
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        if (this.mFileUrl == null) {
            throw new ResourceInitializationException("could_not_access_data", new Object[]{fileResourceSpecifier.getFileUrl()}, iOException);
        }
        return true;
    }

    public void destroy() {
    }

    public InputStream getInputStream() throws IOException {
        return this.mFileUrl.openStream();
    }

    public URL getUrl() {
        return this.mFileUrl;
    }

    public URI getUri() {
        try {
            String string = this.mFileUrl.toString();
            return new URI(string.replaceAll(" ", "%20"));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new UIMARuntimeException(uRISyntaxException);
        }
    }

    protected File getLocalCache() {
        return this.mLocalCache;
    }

    public boolean equals(Object object) {
        if (!(object instanceof DataResource_impl)) {
            return false;
        }
        URL uRL = ((DataResource_impl)object).getUrl();
        if (uRL == null || !uRL.equals(this.getUrl())) {
            return false;
        }
        File file = ((DataResource_impl)object).getLocalCache();
        if (file == null && this.getLocalCache() != null) {
            return false;
        }
        return file == null || file.equals(this.getLocalCache());
    }

    public int hashCode() {
        int n = 0;
        if (this.mFileUrl != null) {
            n += this.mFileUrl.hashCode();
        }
        if (this.mLocalCache != null) {
            n += this.mLocalCache.hashCode();
        }
        return n;
    }
}

