/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.resource;

import com.ibm.uima.reference_impl.resource.RelativePathResolver_impl;
import com.ibm.uima.resource.ConfigurableDataResourceSpecifier;
import com.ibm.uima.resource.DataResource;
import com.ibm.uima.resource.RelativePathResolver;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.resource.Resource_ImplBase;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;

public class ConfigurableDataResource_impl
extends Resource_ImplBase
implements DataResource {
    private URI mUri;
    private URL mFileUrl;

    public boolean initialize(ResourceSpecifier resourceSpecifier, Map map) throws ResourceInitializationException {
        if (!(resourceSpecifier instanceof ConfigurableDataResourceSpecifier)) {
            return false;
        }
        ConfigurableDataResourceSpecifier configurableDataResourceSpecifier = (ConfigurableDataResourceSpecifier)resourceSpecifier;
        try {
            this.mUri = new URI(configurableDataResourceSpecifier.getUrl());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new ResourceInitializationException(uRISyntaxException);
        }
        this.setMetaData(configurableDataResourceSpecifier.getMetaData());
        RelativePathResolver relativePathResolver = null;
        if (map != null) {
            relativePathResolver = (RelativePathResolver)map.get("RELATIVE_PATH_RESOLVER");
        }
        if (relativePathResolver == null) {
            relativePathResolver = new RelativePathResolver_impl();
        }
        try {
            this.mFileUrl = relativePathResolver.resolveRelativePath(new URL(this.mUri.toString()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return true;
    }

    public void destroy() {
    }

    public InputStream getInputStream() throws IOException {
        return this.mFileUrl.openStream();
    }

    public URI getUri() {
        return this.mUri;
    }

    public URL getUrl() {
        return this.mFileUrl;
    }

    protected File getLocalCache() {
        return null;
    }

    public boolean equals(Object object) {
        if (!(object instanceof ConfigurableDataResource_impl)) {
            return false;
        }
        URL uRL = ((ConfigurableDataResource_impl)object).getUrl();
        if (uRL == null || !uRL.equals(this.getUrl())) {
            return false;
        }
        File file = ((ConfigurableDataResource_impl)object).getLocalCache();
        if (file == null && this.getLocalCache() != null) {
            return false;
        }
        return file == null || file.equals(this.getLocalCache());
    }

    public int hashCode() {
        int n = 0;
        if (this.mFileUrl != null) {
            n += this.mFileUrl.hashCode();
        }
        return n;
    }
}

