/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.cas_data;

import com.ibm.uima.cas.impl.XCASParsingException;
import com.ibm.uima.cas_data.CasData;
import com.ibm.uima.cas_data.PrimitiveArrayFS;
import com.ibm.uima.cas_data.ReferenceArrayFS;
import com.ibm.uima.reference_impl.cas_data.FeatureStructureImpl;
import com.ibm.uima.reference_impl.cas_data.PrimitiveArrayFSImpl;
import com.ibm.uima.reference_impl.cas_data.PrimitiveValueImpl;
import com.ibm.uima.reference_impl.cas_data.ReferenceArrayFSImpl;
import com.ibm.uima.reference_impl.cas_data.ReferenceValueImpl;
import com.ibm.uima.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XCasToCasDataSaxHandler
extends DefaultHandler {
    private static final int DOC_STATE = 0;
    private static final int FS_STATE = 1;
    private static final int FEAT_STATE = 2;
    private static final int CONTENT_STATE = 3;
    private static final int FEAT_CONTENT_STATE = 4;
    private static final int ARRAY_ELE_CONTENT_STATE = 5;
    private static final int ARRAY_ELE_STATE = 6;
    private static final int DOC_TEXT_STATE = 7;
    private static final String reservedAttrPrefix = "_";
    private static final String unknownXMLSource = "<unknown>";
    private static final String DEFAULT_CONTENT_FEATURE = "value";
    private Locator locator;
    private CasData cas;
    private int state;
    private StringBuffer buffer = new StringBuffer();
    private FeatureStructureImpl currentFS;
    private String currentContentFeat;
    private int arrayPos;
    private int arrayType;
    private static final int INT_TYPE = 0;
    private static final int FLOAT_TYPE = 1;
    private static final int STRING_TYPE = 2;
    private static final int FS_TYPE = 3;

    public XCasToCasDataSaxHandler(CasData casData) {
        this.cas = casData;
    }

    private final void resetBuffer() {
        this.buffer = new StringBuffer();
    }

    public void startDocument() throws SAXException {
        this.state = 0;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.resetBuffer();
        switch (this.state) {
            case 0: {
                if (!string3.equals("CAS")) {
                    throw this.createException(0, string3);
                }
                this.state = 1;
                break;
            }
            case 1: {
                this.currentContentFeat = DEFAULT_CONTENT_FEATURE;
                this.readFS(string3, attributes);
                break;
            }
            case 6: {
                this.readArrayElement(string3, attributes);
                break;
            }
            default: {
                throw this.createException(1, string3);
            }
        }
    }

    private void readArrayElement(String string, Attributes attributes) throws SAXParseException {
        if (!string.equals("i")) {
            throw this.createException(2, string);
        }
        if (attributes.getLength() > 0) {
            throw this.createException(3);
        }
        this.state = 5;
        this.resetBuffer();
    }

    private void readFS(String string, Attributes attributes) throws SAXParseException {
        if (this.isArrayType(string)) {
            this.readArray(string, attributes);
        } else {
            this.currentFS = new FeatureStructureImpl();
            this.currentFS.setType(this.getCasTypeName(string));
            this.currentFS.setIndexed(false);
            this.readFS(this.currentFS, attributes);
        }
        this.cas.addFeatureStructure(this.currentFS);
    }

    private String getCasTypeName(String string) {
        return StringUtils.replaceAll(StringUtils.replaceAll(string, ":", "_colon_"), "-", "_dash_");
    }

    private void readFS(FeatureStructureImpl featureStructureImpl, Attributes attributes) throws SAXParseException {
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string = attributes.getQName(i);
            String string2 = attributes.getValue(i);
            if (string.startsWith(reservedAttrPrefix)) {
                if (string.equals("_id")) {
                    featureStructureImpl.setId(string2);
                    continue;
                }
                if (string.equals("_content")) {
                    this.currentContentFeat = string2;
                    continue;
                }
                if (string.equals("_indexed")) {
                    if (string2.equals("false")) continue;
                    featureStructureImpl.setIndexed(true);
                    continue;
                }
                this.handleFeature(featureStructureImpl, string, string2);
                continue;
            }
            this.handleFeature(featureStructureImpl, string, string2);
        }
        this.state = 3;
    }

    private void readArray(String string, Attributes attributes) throws SAXParseException {
        boolean bl = false;
        int n = 0;
        String string2 = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string3 = attributes.getQName(i);
            String string4 = attributes.getValue(i);
            if (string3.equals("_id")) {
                string2 = string4;
                continue;
            }
            if (string3.equals("size")) {
                try {
                    n = Integer.parseInt(string4);
                    if (n >= 0) continue;
                    throw this.createException(6, string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.createException(9, string4);
                }
            }
            if (string3.equals("_indexed")) {
                if (string4.equals("false")) continue;
                bl = true;
                continue;
            }
            throw this.createException(7, string3);
        }
        this.arrayPos = 0;
        if ("uima.cas.IntegerArray".equals(string)) {
            this.currentFS = new PrimitiveArrayFSImpl(new int[n]);
            this.arrayType = 0;
        } else if ("uima.cas.FloatArray".equals(string)) {
            this.currentFS = new PrimitiveArrayFSImpl(new float[n]);
            this.arrayType = 1;
        } else if ("uima.cas.StringArray".equals(string)) {
            this.currentFS = new PrimitiveArrayFSImpl(new String[n]);
            this.arrayType = 2;
        } else {
            this.currentFS = new ReferenceArrayFSImpl(new String[n]);
            this.arrayType = 3;
        }
        this.currentFS.setId(string2);
        this.currentFS.setType(string);
        this.currentFS.setIndexed(bl);
        this.currentFS.setFeatureValue("size", new PrimitiveValueImpl(n));
        this.state = 6;
    }

    private final boolean emptyVal(String string) {
        return string == null || string.length() == 0;
    }

    private void handleFeature(FeatureStructureImpl featureStructureImpl, String string, String string2) throws SAXParseException {
        if (string.startsWith("_ref_")) {
            String string3 = string.substring("_ref_".length());
            featureStructureImpl.setFeatureValue(string3, new ReferenceValueImpl(string2));
        } else {
            featureStructureImpl.setFeatureValue(string, new PrimitiveValueImpl(string2));
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.state == 7 || this.state == 3 || this.state == 5 || this.state == 4) {
            this.buffer.append(cArray, n, n2);
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        switch (this.state) {
            case 0: {
                break;
            }
            case 1: {
                this.state = 0;
                break;
            }
            case 2: {
                this.state = 1;
                break;
            }
            case 3: {
                if (!this.isAllWhitespace(this.buffer)) {
                    this.handleFeature(this.currentFS, this.currentContentFeat, this.buffer.toString());
                }
                this.state = 1;
                break;
            }
            case 4: {
                this.handleFeature(this.currentFS, string3, this.buffer.toString());
                this.state = 2;
                break;
            }
            case 5: {
                this.addArrayElement(this.buffer.toString());
                this.state = 6;
                break;
            }
            case 6: {
                this.state = 1;
            }
        }
    }

    boolean isAllWhitespace(StringBuffer stringBuffer) {
        int n = stringBuffer.length();
        for (int i = 0; i < n; ++i) {
            if (Character.isWhitespace(stringBuffer.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private void addArrayElement(String string) throws SAXParseException {
        switch (this.arrayType) {
            case 0: {
                if (this.emptyVal(string)) break;
                try {
                    ((PrimitiveArrayFS)((Object)this.currentFS)).toIntArray()[this.arrayPos] = Integer.parseInt(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.createException(9, string);
                }
            }
            case 1: {
                if (this.emptyVal(string)) break;
                try {
                    ((PrimitiveArrayFS)((Object)this.currentFS)).toFloatArray()[this.arrayPos] = Float.parseFloat(string);
                    break;
                }
                catch (NumberFormatException numberFormatException) {
                    throw this.createException(10, string);
                }
            }
            case 2: {
                ((PrimitiveArrayFS)((Object)this.currentFS)).toStringArray()[this.arrayPos] = string;
                break;
            }
            case 3: {
                if (this.emptyVal(string)) break;
                ((ReferenceArrayFS)((Object)this.currentFS)).getIdRefArray()[this.arrayPos] = string;
            }
        }
        ++this.arrayPos;
    }

    public void endDocument() throws SAXException {
    }

    private XCASParsingException createException(int n) {
        XCASParsingException xCASParsingException = new XCASParsingException(n);
        String string = unknownXMLSource;
        String string2 = unknownXMLSource;
        String string3 = unknownXMLSource;
        if (this.locator != null) {
            string = this.locator.getSystemId();
            if (string == null) {
                string = this.locator.getPublicId();
            }
            if (string == null) {
                string = unknownXMLSource;
            }
            string2 = Integer.toString(this.locator.getLineNumber());
            string3 = Integer.toString(this.locator.getColumnNumber());
        }
        xCASParsingException.addArgument(string);
        xCASParsingException.addArgument(string2);
        xCASParsingException.addArgument(string3);
        return xCASParsingException;
    }

    private XCASParsingException createException(int n, String string) {
        XCASParsingException xCASParsingException = this.createException(n);
        xCASParsingException.addArgument(string);
        return xCASParsingException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private boolean isArrayType(String string) {
        return "uima.cas.IntegerArray".equals(string) || "uima.cas.FloatArray".equals(string) || "uima.cas.StringArray".equals(string) || "uima.cas.FSArray".equals(string);
    }
}

