/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.cas_data;

import com.ibm.uima.cas_data.CasData;
import com.ibm.uima.cas_data.FeatureStructure;
import com.ibm.uima.cas_data.FeatureValue;
import com.ibm.uima.cas_data.PrimitiveArrayFS;
import com.ibm.uima.cas_data.PrimitiveValue;
import com.ibm.uima.cas_data.ReferenceArrayFS;
import com.ibm.uima.cas_data.ReferenceValue;
import com.ibm.uima.util.StringUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class CasDataToXCas {
    private String mDocumentTextTypeName = "uima.cpm.DocumentText";
    private String mDocumentTextFeatureName = "value";
    private String mXCasDocTextTag = "uima.cpm.DocumentText";
    private boolean mIncludeAnnotationSpannedText = false;
    private List mTypesToFilter = null;
    private ContentHandler mHandler;

    public String getDocumentTextTypeName() {
        return this.mDocumentTextTypeName;
    }

    public void setDocumentTextTypeName(String string) {
        this.mDocumentTextTypeName = string;
    }

    public String getDocumentTextFeatureName() {
        return this.mDocumentTextFeatureName;
    }

    public void setDocumentTextFeatureName(String string) {
        this.mDocumentTextFeatureName = string;
    }

    public void setXCasDocumentTextTagName(String string) {
        this.mXCasDocTextTag = string;
    }

    public void setIncludeAnnotationSpannedText(boolean bl) {
        this.mIncludeAnnotationSpannedText = bl;
    }

    public void setTypesToFilter(String[] stringArray) {
        this.mTypesToFilter = Arrays.asList(stringArray);
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.mHandler = contentHandler;
    }

    public void generateXCas(CasData casData) throws SAXException {
        this.generateXCas(casData, null, true);
    }

    public void generateXCas(CasData casData, String string) throws SAXException {
        this.generateXCas(casData, string, true);
    }

    public void generateXCas(CasData casData, String string, boolean bl) throws SAXException {
        if (bl) {
            this.mHandler.startDocument();
        }
        DocTextHolder docTextHolder = new DocTextHolder();
        this.mHandler.startElement("", "CAS", "CAS", new AttributesImpl());
        if (string != null) {
            this.mHandler.startElement("", "UEID", "UEID", new AttributesImpl());
            this.mHandler.characters(string.toCharArray(), 0, string.length());
            this.mHandler.endElement("", "UEID", "UEID");
        }
        Iterator iterator = casData.getFeatureStructures();
        while (iterator.hasNext()) {
            FeatureStructure featureStructure = (FeatureStructure)iterator.next();
            if (this.mTypesToFilter != null && this.mTypesToFilter.contains(featureStructure.getType())) continue;
            this._generate(featureStructure, docTextHolder);
        }
        this.mHandler.endElement("", "CAS", "CAS");
        if (bl) {
            this.mHandler.endDocument();
        }
    }

    private void _generate(FeatureStructure featureStructure, DocTextHolder docTextHolder) throws SAXException {
        if (featureStructure.getType().equals(this.getDocumentTextTypeName())) {
            this._generateDocFS(featureStructure, docTextHolder);
        } else {
            String[] stringArray;
            AttributesImpl attributesImpl = new AttributesImpl();
            String string = null;
            if (featureStructure.getId() != null) {
                attributesImpl.addAttribute("", "_id", "_id", "CDATA", featureStructure.getId());
            }
            attributesImpl.addAttribute("", "_indexed", "_indexed", "CDATA", Boolean.toString(featureStructure.isIndexed()));
            String[] stringArray2 = featureStructure.getFeatureNames();
            for (int i = 0; i < stringArray2.length; ++i) {
                stringArray = featureStructure.getFeatureValue(stringArray2[i]);
                if (stringArray instanceof PrimitiveValue) {
                    if (!"value".equals(stringArray2[i])) {
                        attributesImpl.addAttribute("", stringArray2[i], stringArray2[i], "CDATA", stringArray.toString());
                        continue;
                    }
                    string = stringArray.toString();
                    continue;
                }
                if (!"value".equals(stringArray2[i])) {
                    attributesImpl.addAttribute("", "_ref_" + stringArray2[i], "_ref_" + stringArray2[i], "CDATA", ((ReferenceValue)stringArray).getTargetId());
                    continue;
                }
                string = ((ReferenceValue)stringArray).getTargetId();
            }
            String string2 = this.getXCasElementName(featureStructure);
            this.mHandler.startElement("", string2, string2, attributesImpl);
            stringArray = null;
            if (featureStructure instanceof PrimitiveArrayFS) {
                stringArray = ((PrimitiveArrayFS)featureStructure).toStringArray();
            } else if (featureStructure instanceof ReferenceArrayFS) {
                stringArray = ((ReferenceArrayFS)featureStructure).getIdRefArray();
            }
            if (stringArray != null) {
                for (int i = 0; i < stringArray.length; ++i) {
                    this.mHandler.startElement("", "i", "i", new AttributesImpl());
                    if (stringArray[i] != null) {
                        this.mHandler.characters(stringArray[i].toCharArray(), 0, stringArray[i].length());
                    }
                    this.mHandler.endElement("", "i", "i");
                }
            }
            if (string != null) {
                this.mHandler.characters(string.toCharArray(), 0, string.length());
            } else if (this.mIncludeAnnotationSpannedText && docTextHolder.docText != null && docTextHolder.docText.length > 0) {
                FeatureValue featureValue = featureStructure.getFeatureValue("begin");
                FeatureValue featureValue2 = featureStructure.getFeatureValue("end");
                if (featureValue instanceof PrimitiveValue && featureValue2 instanceof PrimitiveValue) {
                    int n = ((PrimitiveValue)featureValue).toInt();
                    int n2 = ((PrimitiveValue)featureValue2).toInt();
                    if (n >= 0 && n2 > n && n2 <= docTextHolder.docText.length && (n > 0 || n2 < docTextHolder.docText.length)) {
                        this.mHandler.characters(docTextHolder.docText, n, n2 - n);
                    }
                }
            }
            this.mHandler.endElement("", string2, string2);
        }
    }

    private String getXCasElementName(FeatureStructure featureStructure) {
        return StringUtils.replaceAll(StringUtils.replaceAll(featureStructure.getType(), "_colon_", ":"), "_dash_", "-");
    }

    private void _generateDocFS(FeatureStructure featureStructure, DocTextHolder docTextHolder) throws SAXException {
        AttributesImpl attributesImpl = new AttributesImpl();
        String string = this.getDocumentTextFeatureName();
        FeatureValue featureValue = featureStructure.getFeatureValue(string);
        if (featureValue != null) {
            String string2 = featureValue.toString();
            docTextHolder.docText = string2.toCharArray();
            if (!string.equals("value")) {
                attributesImpl.addAttribute("", "_content", "_content", "CDATA", string);
            }
            this.mHandler.startElement("", this.mXCasDocTextTag, this.mXCasDocTextTag, attributesImpl);
            this.mHandler.characters(docTextHolder.docText, 0, docTextHolder.docText.length);
            this.mHandler.endElement("", this.mXCasDocTextTag, this.mXCasDocTextTag);
        } else {
            this.mHandler.startElement("", this.mXCasDocTextTag, this.mXCasDocTextTag, attributesImpl);
            this.mHandler.endElement("", this.mXCasDocTextTag, this.mXCasDocTextTag);
        }
    }

    private static class DocTextHolder {
        char[] docText;

        private DocTextHolder() {
        }
    }
}

