/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.analysis_engine.service;

import com.ibm.uima.analysis_engine.AnalysisProcessData;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.admin.CASMgr;
import com.ibm.uima.cas.impl.CASCompleteSerializer;
import com.ibm.uima.cas.impl.Serialization;
import com.ibm.uima.cas.text.TCASException;
import com.ibm.uima.util.ProcessTrace;
import java.io.Serializable;

public class ServiceDataCargo
implements Serializable {
    private static final long serialVersionUID = 2433836175315405277L;
    private CASCompleteSerializer mCasSer;
    private ProcessTrace mProcessTrace;

    public ServiceDataCargo(AnalysisProcessData analysisProcessData) {
        this.mCasSer = Serialization.serializeCASComplete((CASMgr)((Object)analysisProcessData.getCAS()));
        this.mProcessTrace = analysisProcessData.getProcessTrace();
    }

    public ServiceDataCargo(CAS cAS, ProcessTrace processTrace) {
        this.mCasSer = Serialization.serializeCASComplete((CASMgr)((Object)cAS));
        this.mProcessTrace = processTrace;
    }

    public void unmarshalInto(AnalysisProcessData analysisProcessData, boolean bl) throws TCASException {
        this.unmarshalCas(analysisProcessData.getCAS(), bl);
        analysisProcessData.getProcessTrace().addAll(this.mProcessTrace.getEvents());
    }

    public void unmarshalCas(CAS cAS, boolean bl) throws TCASException {
        CASMgr cASMgr = (CASMgr)((Object)cAS);
        if (bl) {
            Serialization.deserializeCASComplete(this.mCasSer, cASMgr);
        } else {
            Serialization.createCAS(cASMgr, this.mCasSer.getCASSerializer());
        }
    }

    public ProcessTrace getProcessTrace() {
        return this.mProcessTrace;
    }

    public void setProcessTrace(ProcessTrace processTrace) {
        this.mProcessTrace = processTrace;
    }
}

