/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.analysis_engine.service;

import com.ibm.uima.analysis_engine.AnalysisEngine;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.reference_impl.analysis_engine.service.ServiceDataCargo;
import com.ibm.uima.reference_impl.resource.service.ResourceService_impl;
import com.ibm.uima.reference_impl.util.ProcessTrace_impl;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceServiceException;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.util.CasPool;
import com.ibm.uima.util.ProcessTrace;
import java.util.HashMap;
import java.util.Map;

public class AnalysisEngineService_impl
extends ResourceService_impl {
    private CasPool mCasPool;
    private int mTimeout;
    static /* synthetic */ Class class$com$ibm$uima$analysis_engine$AnalysisEngine;

    public void initialize(ResourceSpecifier resourceSpecifier, Map map) throws ResourceInitializationException {
        super.initialize(resourceSpecifier, map);
        Integer n = (Integer)map.get("NUM_SIMULTANEOUS_REQUESTS");
        if (n == null) {
            n = new Integer(1);
        }
        this.mCasPool = new CasPool((int)n, this.getAnalysisEngine());
        Integer n2 = (Integer)map.get("TIMEOUT_PERIOD");
        this.mTimeout = n2 != null ? n2 : 0;
    }

    public void initialize(ResourceSpecifier resourceSpecifier, int n, int n2) throws ResourceInitializationException {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("NUM_SIMULTANEOUS_REQUESTS", new Integer(n));
        hashMap.put("TIMEOUT_PERIOD", new Integer(n2));
        this.initialize(resourceSpecifier, hashMap);
    }

    public ServiceDataCargo process(ServiceDataCargo serviceDataCargo, ResultSpecification resultSpecification) throws ResourceServiceException {
        ProcessTrace processTrace = serviceDataCargo.getProcessTrace();
        if (processTrace == null) {
            processTrace = new ProcessTrace_impl();
        }
        String string = this.getMetaData().getName();
        processTrace.startEvent(string, "SERVICE", "");
        CAS cAS = null;
        String string2 = "success";
        try {
            cAS = this.getCasFromPool(this.mTimeout);
            if (cAS == null) {
                throw new ResourceServiceException("resource_unavailable", new Object[0]);
            }
            serviceDataCargo.unmarshalCas(cAS, true);
            this.getAnalysisEngine().process(cAS, resultSpecification, processTrace);
            ServiceDataCargo serviceDataCargo2 = new ServiceDataCargo(cAS, processTrace);
            Object var9_9 = null;
            if (cAS != null) {
                this.getCasPool().releaseCas(cAS);
            }
            processTrace.endEvent(string, "SERVICE", string2);
            return serviceDataCargo2;
        }
        catch (Exception exception) {
            try {
                string2 = exception.getLocalizedMessage();
                if (exception instanceof ResourceServiceException) {
                    throw (ResourceServiceException)exception;
                }
                throw new ResourceServiceException(exception);
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (cAS != null) {
                    this.getCasPool().releaseCas(cAS);
                }
                processTrace.endEvent(string, "SERVICE", string2);
                throw throwable;
            }
        }
    }

    public AnalysisEngine getAnalysisEngine() {
        return (AnalysisEngine)this.getResource();
    }

    protected Class getResourceClass() {
        return class$com$ibm$uima$analysis_engine$AnalysisEngine == null ? (class$com$ibm$uima$analysis_engine$AnalysisEngine = AnalysisEngineService_impl.class$("com.ibm.uima.analysis_engine.AnalysisEngine")) : class$com$ibm$uima$analysis_engine$AnalysisEngine;
    }

    protected CasPool getCasPool() {
        return this.mCasPool;
    }

    protected CAS getCasFromPool(int n) throws ResourceServiceException {
        CAS cAS = this.getCasPool().getCas(n);
        if (cAS == null) {
            throw new ResourceServiceException("resource_unavailable", null);
        }
        return cAS;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

