/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.analysis_engine.sequencer;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.TypeOrFeature;
import com.ibm.uima.analysis_engine.sequencer.AnalysisSequence;
import com.ibm.uima.analysis_engine.sequencer.AnalysisSequenceNode;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.text.Language;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.reference_impl.analysis_engine.sequencer.AnalysisSequenceCapabilityNode;
import com.ibm.uima.reference_impl.analysis_engine.sequencer.CapabilityContainer;
import com.ibm.uima.util.Level;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CapabilityLanguageAnalysisSequence
implements AnalysisSequence {
    private static final String LOG_RESOURCE_BUNDLE = "com.ibm.uima.reference_impl.log_messages";
    private TypeSystem mLastTypeSystem;
    private List mNodeList;
    private int mIndex;
    private ResultSpecification mResultSpec;
    private Map mFlowTable;
    private static final char LANGUAGE_SEPARATOR = '-';
    static final long serialVersionUID = -5879514955935785660L;

    public CapabilityLanguageAnalysisSequence(List list, ResultSpecification resultSpecification) {
        this.mNodeList = list;
        this.mIndex = 0;
        this.mResultSpec = (ResultSpecification)resultSpecification.clone();
        this.mFlowTable = null;
        this.mLastTypeSystem = null;
    }

    public CapabilityLanguageAnalysisSequence(Map map) {
        this.mNodeList = null;
        this.mIndex = 0;
        this.mResultSpec = null;
        this.mFlowTable = map;
        this.mLastTypeSystem = null;
    }

    public AnalysisSequenceNode getNext(CAS cAS) {
        if (cAS == null) {
            return null;
        }
        if (this.mLastTypeSystem != cAS.getTypeSystem()) {
            this.mLastTypeSystem = cAS.getTypeSystem();
            this.recompileFlowTable();
        }
        TCAS tCAS = cAS.getTCAS();
        String string = Language.normalize(tCAS.getDocumentLanguage());
        if (this.mNodeList != null) {
            Cloneable cloneable;
            if (this.mIndex >= this.mNodeList.size()) {
                return null;
            }
            TypeOrFeature[] typeOrFeatureArray = this.mResultSpec.getResultTypesAndFeatures(string);
            int n = string.indexOf(45);
            if (n >= 0) {
                cloneable = new HashSet<TypeOrFeature>();
                if (typeOrFeatureArray.length > 0) {
                    int n2;
                    for (n2 = 0; n2 < typeOrFeatureArray.length; ++n2) {
                        ((HashSet)cloneable).add(typeOrFeatureArray[n2]);
                    }
                    typeOrFeatureArray = this.mResultSpec.getResultTypesAndFeatures(string.substring(0, n));
                    for (n2 = 0; n2 < typeOrFeatureArray.length; ++n2) {
                        ((HashSet)cloneable).add(typeOrFeatureArray[n2]);
                    }
                    typeOrFeatureArray = new TypeOrFeature[((HashSet)cloneable).size()];
                    ((HashSet)cloneable).toArray(typeOrFeatureArray);
                } else {
                    typeOrFeatureArray = this.mResultSpec.getResultTypesAndFeatures(string.substring(0, n));
                }
            }
            ResultSpecification resultSpecification = null;
            boolean bl = false;
            do {
                cloneable = (AnalysisSequenceCapabilityNode)this.mNodeList.get(this.mIndex++);
                CapabilityContainer capabilityContainer = ((AnalysisSequenceCapabilityNode)cloneable).getCapabilityContainer();
                resultSpecification = UIMAFramework.getResourceSpecifierFactory().createResultSpecification();
                for (int i = 0; i < typeOrFeatureArray.length; ++i) {
                    if (!capabilityContainer.hasOutputTypeOrFeature(typeOrFeatureArray[i], string, true)) continue;
                    resultSpecification.addResultTypeOrFeature(typeOrFeatureArray[i]);
                    bl = true;
                    this.mResultSpec.removeTypeOrFeature(typeOrFeatureArray[i]);
                }
                if (bl) continue;
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "getNext", LOG_RESOURCE_BUNDLE, "UIMA_capabilityLanguageFlow_compute_sequence_not_called__FINER", new Object[]{string, ((AnalysisSequenceCapabilityNode)cloneable).getCasProcessorKey()});
            } while (!bl && this.mIndex < this.mNodeList.size());
            if (bl) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "getNext", LOG_RESOURCE_BUNDLE, "UIMA_capabilityLanguageFlow_compute_sequence_called__FINER", new Object[]{string, ((AnalysisSequenceCapabilityNode)cloneable).getCasProcessorKey()});
                ((AnalysisSequenceCapabilityNode)cloneable).setResultSpec(resultSpecification);
                return cloneable;
            }
            return null;
        }
        if (this.mFlowTable != null) {
            AnalysisSequenceNode analysisSequenceNode = null;
            String string2 = string;
            List list = (List)this.mFlowTable.get(string);
            if (list == null) {
                int n = string.indexOf(45);
                if (n >= 0) {
                    string2 = string.substring(0, n);
                    list = (List)this.mFlowTable.get(string2);
                    if (list == null) {
                        string2 = "x-unspecified";
                        list = (List)this.mFlowTable.get("x-unspecified");
                    }
                } else {
                    string2 = "x-unspecified";
                    list = (List)this.mFlowTable.get("x-unspecified");
                }
            }
            if (list != null && list.size() > this.mIndex) {
                analysisSequenceNode = (AnalysisSequenceNode)list.get(this.mIndex++);
                while (analysisSequenceNode == null && list.size() > this.mIndex) {
                    analysisSequenceNode = (AnalysisSequenceNode)list.get(this.mIndex++);
                }
            }
            if (analysisSequenceNode != null) {
                UIMAFramework.getLogger(this.getClass()).logrb(Level.FINER, this.getClass().getName(), "getNext", LOG_RESOURCE_BUNDLE, "UIMA_capabilityLanguageFlow_flowTable_node__FINER", new Object[]{string2, analysisSequenceNode.getCasProcessorKey()});
            }
            return analysisSequenceNode;
        }
        return null;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void resetIndex() {
        this.mIndex = 0;
    }

    protected void recompileFlowTable() {
        if (this.mFlowTable != null) {
            Set set = this.mFlowTable.keySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                List list = (List)this.mFlowTable.get(iterator.next());
                for (int i = 0; i < list.size(); ++i) {
                    AnalysisSequenceCapabilityNode analysisSequenceCapabilityNode = (AnalysisSequenceCapabilityNode)list.get(i);
                    if (analysisSequenceCapabilityNode == null) continue;
                    analysisSequenceCapabilityNode.getResultSpec().compile(this.mLastTypeSystem);
                }
            }
        }
    }
}

