/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.analysis_engine.sequencer;

import com.ibm.uima.analysis_engine.TypeOrFeature;
import com.ibm.uima.resource.metadata.Capability;
import java.util.HashMap;
import java.util.HashSet;

public class CapabilityContainer {
    private Capability[] capabilities;
    private HashMap outputLanguageCapability;
    private HashMap outputToFCapability;
    private HashMap inputLanguageCapability;
    private HashMap inputToFCapability;
    private static final char LANGUAGE_SEPARATOR = '-';

    public CapabilityContainer(Capability[] capabilityArray) {
        this.capabilities = capabilityArray;
        this.outputLanguageCapability = this.createLanguageCapabilities(true);
        this.outputToFCapability = this.createToFCapabilities(true);
        this.inputLanguageCapability = this.createLanguageCapabilities(false);
        this.inputToFCapability = this.createToFCapabilities(false);
    }

    public CapabilityContainer(Capability[] capabilityArray, boolean bl, boolean bl2) {
        this.capabilities = capabilityArray;
        this.outputLanguageCapability = null;
        this.outputToFCapability = null;
        this.inputLanguageCapability = null;
        this.inputToFCapability = null;
        if (bl2) {
            this.outputLanguageCapability = this.createLanguageCapabilities(true);
            this.outputToFCapability = this.createToFCapabilities(true);
        }
        if (bl) {
            this.inputLanguageCapability = this.createLanguageCapabilities(false);
            this.inputToFCapability = this.createToFCapabilities(false);
        }
    }

    public void compileOutputCapabilitiy() {
        this.outputLanguageCapability = this.createLanguageCapabilities(true);
        this.outputToFCapability = this.createToFCapabilities(true);
    }

    public void compileInputCapabilitiy() {
        this.inputLanguageCapability = this.createLanguageCapabilities(true);
        this.inputToFCapability = this.createToFCapabilities(true);
    }

    public boolean hasOutputTypeOrFeature(TypeOrFeature typeOrFeature, String string, boolean bl) {
        int n;
        boolean bl2 = false;
        if (this.outputLanguageCapability == null) {
            return false;
        }
        HashSet hashSet = (HashSet)this.outputLanguageCapability.get(string);
        HashSet hashSet2 = (HashSet)this.outputLanguageCapability.get("x-unspecified");
        HashSet hashSet3 = null;
        if (hashSet != null || hashSet2 != null) {
            hashSet3 = new HashSet();
            if (hashSet != null) {
                hashSet3.addAll(hashSet);
            }
            if (hashSet2 != null) {
                hashSet3.addAll(hashSet2);
            }
        }
        if (hashSet3 != null && hashSet3.contains(typeOrFeature.getName())) {
            bl2 = true;
        }
        if (!bl2 && bl && (n = string.indexOf(45)) != -1 && (hashSet3 = (HashSet)this.outputLanguageCapability.get(string.substring(0, n))) != null && hashSet3.contains(typeOrFeature.getName())) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean hasOutputTypeOrFeature(TypeOrFeature typeOrFeature) {
        return this.outputToFCapability != null && this.outputToFCapability.containsKey(typeOrFeature.getName());
    }

    public boolean hasInputTypeOrFeature(TypeOrFeature typeOrFeature, String string, boolean bl) {
        int n;
        boolean bl2 = false;
        if (this.inputLanguageCapability == null) {
            return false;
        }
        HashSet hashSet = (HashSet)this.inputLanguageCapability.get(string);
        HashSet hashSet2 = (HashSet)this.inputLanguageCapability.get("x-unspecified");
        HashSet hashSet3 = null;
        if (hashSet != null || hashSet2 != null) {
            hashSet3 = new HashSet();
            if (hashSet != null) {
                hashSet3.addAll(hashSet);
            }
            if (hashSet2 != null) {
                hashSet3.addAll(hashSet2);
            }
        }
        if (hashSet3 != null && hashSet3.contains(typeOrFeature.getName())) {
            bl2 = true;
        }
        if (!bl2 && bl && (n = string.indexOf(45)) != -1 && (hashSet3 = (HashSet)this.outputLanguageCapability.get(string.substring(0, n))) != null && hashSet3.contains(typeOrFeature.getName())) {
            bl2 = true;
        }
        return bl2;
    }

    public boolean hasInputTypeOrFeature(TypeOrFeature typeOrFeature) {
        return this.inputToFCapability != null && this.inputToFCapability.containsKey(typeOrFeature.getName());
    }

    private HashMap createToFCapabilities(boolean bl) {
        if (this.capabilities == null) {
            return null;
        }
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.capabilities.length; ++i) {
            if (this.capabilities[i] == null) continue;
            String[] stringArray = this.capabilities[i].getLanguagesSupported();
            HashSet<String> hashSet = null;
            if (stringArray == null) continue;
            hashSet = new HashSet<String>(stringArray.length);
            for (int j = 0; j < stringArray.length; ++j) {
                hashSet.add(stringArray[j]);
            }
            TypeOrFeature[] typeOrFeatureArray = null;
            typeOrFeatureArray = bl ? this.capabilities[i].getOutputs() : this.capabilities[i].getInputs();
            if (typeOrFeatureArray == null) continue;
            for (int j = 0; j < typeOrFeatureArray.length; ++j) {
                if (typeOrFeatureArray[j] == null) continue;
                hashMap.put(typeOrFeatureArray[j].getName(), hashSet);
            }
        }
        return hashMap;
    }

    private HashMap createLanguageCapabilities(boolean bl) {
        if (this.capabilities == null) {
            return null;
        }
        HashMap<String, HashSet> hashMap = new HashMap<String, HashSet>();
        for (int i = 0; i < this.capabilities.length; ++i) {
            if (this.capabilities[i] == null) continue;
            String[] stringArray = this.capabilities[i].getLanguagesSupported();
            TypeOrFeature[] typeOrFeatureArray = bl ? this.capabilities[i].getOutputs() : this.capabilities[i].getInputs();
            if (stringArray == null || typeOrFeatureArray == null) continue;
            for (int j = 0; j < stringArray.length; ++j) {
                HashSet hashSet = null;
                hashSet = hashMap.containsKey(stringArray[j]) ? (HashSet)hashMap.get(stringArray[j]) : new HashSet(typeOrFeatureArray.length);
                if (hashSet != null) {
                    for (int k = 0; k < typeOrFeatureArray.length; ++k) {
                        if (typeOrFeatureArray[k] == null) continue;
                        hashSet.add(typeOrFeatureArray[k].getName());
                    }
                }
                hashMap.put(stringArray[j], hashSet);
            }
        }
        return hashMap;
    }
}

