/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.analysis_engine;

import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.TypeOrFeature;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.reference_impl.analysis_engine.TypeOrFeature_impl;
import com.ibm.uima.reference_impl.resource.metadata.MetaDataObject_impl;
import com.ibm.uima.reference_impl.resource.metadata.PropertyXmlInfo;
import com.ibm.uima.reference_impl.resource.metadata.XmlizationInfo;
import com.ibm.uima.resource.metadata.Capability;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class ResultSpecification_impl
extends MetaDataObject_impl
implements ResultSpecification {
    private static final String UNSPECIFIED_LANGUAGE = "x-unspecified";
    private Map mTypesAndFeatures = new HashMap();
    private Map mTypeNames = new HashMap();
    private Map mFeatureNames = new HashMap();
    private HashSet mDefaultLanguage = new HashSet();
    static final long serialVersionUID = 8516517600467270594L;

    public ResultSpecification_impl() {
        this.mDefaultLanguage.add(UNSPECIFIED_LANGUAGE);
    }

    public TypeOrFeature[] getResultTypesAndFeatures() {
        TypeOrFeature[] typeOrFeatureArray = new TypeOrFeature[this.mTypesAndFeatures.size()];
        this.mTypesAndFeatures.keySet().toArray(typeOrFeatureArray);
        return typeOrFeatureArray;
    }

    public TypeOrFeature[] getResultTypesAndFeatures(String string) {
        TypeOrFeature[] typeOrFeatureArray;
        Vector<TypeOrFeature[]> vector = new Vector<TypeOrFeature[]>();
        Iterator iterator = this.mTypesAndFeatures.keySet().iterator();
        while (iterator.hasNext()) {
            typeOrFeatureArray = (TypeOrFeature[])iterator.next();
            HashSet hashSet = (HashSet)this.mTypesAndFeatures.get(typeOrFeatureArray);
            if (!hashSet.contains(string) && !hashSet.contains(UNSPECIFIED_LANGUAGE)) continue;
            vector.add(typeOrFeatureArray);
        }
        typeOrFeatureArray = new TypeOrFeature[vector.size()];
        vector.toArray(typeOrFeatureArray);
        return typeOrFeatureArray;
    }

    public void setResultTypesAndFeatures(TypeOrFeature[] typeOrFeatureArray) {
        this.mTypesAndFeatures.clear();
        for (int i = 0; i < typeOrFeatureArray.length; ++i) {
            this.mTypesAndFeatures.put(typeOrFeatureArray[i], this.mDefaultLanguage);
        }
        this.mTypeNames.clear();
        this.mFeatureNames.clear();
    }

    public void setResultTypesAndFeatures(TypeOrFeature[] typeOrFeatureArray, String[] stringArray) {
        if (stringArray != null) {
            int n;
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (n = 0; n < stringArray.length; ++n) {
                hashSet.add(stringArray[n]);
            }
            this.mTypesAndFeatures.clear();
            for (n = 0; n < typeOrFeatureArray.length; ++n) {
                this.mTypesAndFeatures.put(typeOrFeatureArray[n], hashSet);
            }
            this.mTypeNames.clear();
            this.mFeatureNames.clear();
        } else {
            this.setResultTypesAndFeatures(typeOrFeatureArray);
        }
    }

    public void addResultTypeOrFeature(TypeOrFeature typeOrFeature) {
        this.mTypesAndFeatures.put(typeOrFeature, this.mDefaultLanguage);
        this.mTypeNames.clear();
        this.mFeatureNames.clear();
    }

    public void addResultTypeOrFeature(TypeOrFeature typeOrFeature, String[] stringArray) {
        if (stringArray != null) {
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            this.mTypesAndFeatures.put(typeOrFeature, hashSet);
            this.mTypeNames.clear();
            this.mFeatureNames.clear();
        } else {
            this.addResultTypeOrFeature(typeOrFeature);
        }
    }

    public void addResultType(String string, boolean bl) {
        TypeOrFeature_impl typeOrFeature_impl = new TypeOrFeature_impl();
        typeOrFeature_impl.setType(true);
        typeOrFeature_impl.setName(string);
        typeOrFeature_impl.setAllAnnotatorFeatures(bl);
        this.mTypesAndFeatures.put(typeOrFeature_impl, this.mDefaultLanguage);
        this.mTypeNames.clear();
        this.mFeatureNames.clear();
    }

    public void addResultType(String string, boolean bl, String[] stringArray) {
        if (stringArray != null) {
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            TypeOrFeature_impl typeOrFeature_impl = new TypeOrFeature_impl();
            typeOrFeature_impl.setType(true);
            typeOrFeature_impl.setName(string);
            typeOrFeature_impl.setAllAnnotatorFeatures(bl);
            this.mTypesAndFeatures.put(typeOrFeature_impl, hashSet);
            this.mTypeNames.clear();
            this.mFeatureNames.clear();
        } else {
            this.addResultType(string, bl);
        }
    }

    public void addResultFeature(String string) {
        TypeOrFeature_impl typeOrFeature_impl = new TypeOrFeature_impl();
        typeOrFeature_impl.setType(false);
        typeOrFeature_impl.setName(string);
        this.mTypesAndFeatures.put(typeOrFeature_impl, this.mDefaultLanguage);
        this.mTypeNames.clear();
        this.mFeatureNames.clear();
    }

    public void addResultFeature(String string, String[] stringArray) {
        if (stringArray != null) {
            HashSet<String> hashSet = new HashSet<String>(stringArray.length);
            for (int i = 0; i < stringArray.length; ++i) {
                hashSet.add(stringArray[i]);
            }
            TypeOrFeature_impl typeOrFeature_impl = new TypeOrFeature_impl();
            typeOrFeature_impl.setType(false);
            typeOrFeature_impl.setName(string);
            this.mTypesAndFeatures.put(typeOrFeature_impl, hashSet);
            this.mTypeNames.clear();
            this.mFeatureNames.clear();
        } else {
            this.addResultFeature(string);
        }
    }

    public void compile(TypeSystem typeSystem) {
        this.mTypeNames.clear();
        this.mFeatureNames.clear();
        Iterator iterator = this.mTypesAndFeatures.keySet().iterator();
        while (iterator.hasNext()) {
            TypeOrFeature typeOrFeature = (TypeOrFeature)iterator.next();
            if (typeOrFeature.isType()) {
                Type type;
                this.mTypeNames.put(typeOrFeature.getName(), this.mTypesAndFeatures.get(typeOrFeature));
                if (!typeOrFeature.isAllAnnotatorFeatures() || (type = typeSystem.getType(typeOrFeature.getName())) == null) continue;
                List list = type.getFeatures();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Feature feature = (Feature)iterator2.next();
                    this.mFeatureNames.put(feature.getName(), this.mTypesAndFeatures.get(typeOrFeature));
                }
                continue;
            }
            this.mFeatureNames.put(typeOrFeature.getName(), this.mTypesAndFeatures.get(typeOrFeature));
        }
    }

    public boolean containsType(String string) {
        if (!this.mTypeNames.isEmpty()) {
            return this.mTypeNames.containsKey(string);
        }
        Iterator iterator = this.mTypesAndFeatures.keySet().iterator();
        while (iterator.hasNext()) {
            TypeOrFeature typeOrFeature = (TypeOrFeature)iterator.next();
            if (!typeOrFeature.isType() || !string.equals(typeOrFeature.getName())) continue;
            return true;
        }
        return false;
    }

    public boolean containsType(String string, String string2) {
        boolean bl = false;
        if (!this.mTypeNames.isEmpty()) {
            HashSet hashSet = (HashSet)this.mTypeNames.get(string);
            if (hashSet != null && (hashSet.contains(string2) || hashSet.contains(UNSPECIFIED_LANGUAGE))) {
                bl = true;
            }
        } else {
            Iterator iterator = this.mTypesAndFeatures.keySet().iterator();
            while (iterator.hasNext()) {
                HashSet hashSet;
                TypeOrFeature typeOrFeature = (TypeOrFeature)iterator.next();
                if (!typeOrFeature.isType() || !string.equals(typeOrFeature.getName()) || (hashSet = (HashSet)this.mTypesAndFeatures.get(typeOrFeature)) == null || !hashSet.contains(string2) && !hashSet.contains(UNSPECIFIED_LANGUAGE)) continue;
                return true;
            }
        }
        return bl;
    }

    public boolean containsFeature(String string) {
        if (!this.mFeatureNames.isEmpty()) {
            return this.mFeatureNames.containsKey(string);
        }
        String string2 = "";
        int n = string.indexOf(58);
        if (n > 0) {
            string2 = string.substring(0, n);
        }
        Iterator iterator = this.mTypesAndFeatures.keySet().iterator();
        while (iterator.hasNext()) {
            TypeOrFeature typeOrFeature = (TypeOrFeature)iterator.next();
            if ((typeOrFeature.isType() || !string.equals(typeOrFeature.getName())) && (!typeOrFeature.isType() || !typeOrFeature.isAllAnnotatorFeatures() || !string2.equals(typeOrFeature.getName()))) continue;
            return true;
        }
        return false;
    }

    public boolean containsFeature(String string, String string2) {
        boolean bl = false;
        if (!this.mFeatureNames.isEmpty()) {
            HashSet hashSet = (HashSet)this.mFeatureNames.get(string);
            if (hashSet != null && (hashSet.contains(string2) || hashSet.contains(UNSPECIFIED_LANGUAGE))) {
                bl = true;
            }
        } else {
            String string3 = "";
            int n = string.indexOf(58);
            if (n > 0) {
                string3 = string.substring(0, n);
            }
            Iterator iterator = this.mTypesAndFeatures.keySet().iterator();
            while (iterator.hasNext()) {
                HashSet hashSet;
                TypeOrFeature typeOrFeature = (TypeOrFeature)iterator.next();
                if ((typeOrFeature.isType() || !string.equals(typeOrFeature.getName())) && (!typeOrFeature.isType() || !typeOrFeature.isAllAnnotatorFeatures() || !string3.equals(typeOrFeature.getName())) || (hashSet = (HashSet)this.mTypesAndFeatures.get(typeOrFeature)) == null || !hashSet.contains(string2) && !hashSet.contains(UNSPECIFIED_LANGUAGE)) continue;
                return true;
            }
        }
        return bl;
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo("resultSpecification", null, new PropertyXmlInfo[]{new PropertyXmlInfo("resultTypesAndFeatures", null)});
    }

    public void addCapabilities(Capability[] capabilityArray) {
        this.mTypesAndFeatures.clear();
        if (capabilityArray != null) {
            for (int i = 0; i < capabilityArray.length; ++i) {
                int n;
                TypeOrFeature[] typeOrFeatureArray = capabilityArray[i].getOutputs();
                String[] stringArray = capabilityArray[i].getLanguagesSupported();
                HashSet<String> hashSet = null;
                if (stringArray != null) {
                    hashSet = new HashSet<String>(stringArray.length);
                    for (n = 0; n < stringArray.length; ++n) {
                        hashSet.add(stringArray[n]);
                    }
                } else {
                    hashSet = this.mDefaultLanguage;
                }
                for (n = 0; n < typeOrFeatureArray.length; ++n) {
                    this.mTypesAndFeatures.put(typeOrFeatureArray[n], hashSet);
                }
            }
        }
        this.mTypeNames.clear();
        this.mFeatureNames.clear();
    }

    public void removeTypeOrFeature(TypeOrFeature typeOrFeature) {
        this.mTypesAndFeatures.remove(typeOrFeature);
        if (typeOrFeature.isType()) {
            this.mTypeNames.remove(typeOrFeature.getName());
        } else {
            this.mFeatureNames.remove(typeOrFeature.getName());
        }
    }

    public Object clone() {
        ResultSpecification_impl resultSpecification_impl = (ResultSpecification_impl)super.clone();
        resultSpecification_impl.mFeatureNames = new HashMap(this.mFeatureNames);
        resultSpecification_impl.mTypeNames = new HashMap(this.mTypeNames);
        resultSpecification_impl.mTypesAndFeatures = new HashMap(this.mTypesAndFeatures);
        resultSpecification_impl.mDefaultLanguage = new HashSet(this.mDefaultLanguage);
        return resultSpecification_impl;
    }
}

