/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.analysis_engine;

import com.ibm.uima.UimaContextAdmin;
import com.ibm.uima.analysis_engine.AnalysisEngine;
import com.ibm.uima.analysis_engine.AnalysisEngineProcessException;
import com.ibm.uima.analysis_engine.AnalysisProcessData;
import com.ibm.uima.analysis_engine.ResultNotSupportedException;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.reference_impl.analysis_engine.AnalysisEngineImplBase;
import com.ibm.uima.reference_impl.util.AnalysisEnginePool;
import com.ibm.uima.resource.ResourceConfigurationException;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.util.Logger;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MultiprocessingAnalysisEngine_impl
extends AnalysisEngineImplBase {
    private AnalysisEnginePool mPool;
    private static int DEFAULT_NUM_SIMULTANEOUS_REQUESTS = 3;
    private static int DEFAULT_TIMEOUT_PERIOD = 0;
    private int mTimeout;

    public boolean initialize(ResourceSpecifier resourceSpecifier, Map hashMap) throws ResourceInitializationException {
        Integer n;
        super.initialize(resourceSpecifier, hashMap);
        hashMap = hashMap == null ? new HashMap<String, UimaContextAdmin>() : new HashMap(hashMap);
        Properties properties = (Properties)hashMap.get("PERFORMANCE_TUNING_SETTINGS");
        if (properties != null) {
            this.setPerformanceTuningSettings(properties);
        }
        int n2 = (n = (Integer)hashMap.get("NUM_SIMULTANEOUS_REQUESTS")) != null ? n : DEFAULT_NUM_SIMULTANEOUS_REQUESTS;
        Integer n3 = (Integer)hashMap.get("TIMEOUT_PERIOD");
        this.mTimeout = n3 != null ? n3 : DEFAULT_TIMEOUT_PERIOD;
        hashMap.put("UIMA_CONTEXT", this.getUimaContextAdmin());
        hashMap.remove("NUM_SIMULTANEOUS_REQUESTS");
        this.mPool = new AnalysisEnginePool("", n2, resourceSpecifier, hashMap);
        this.setMetaData(this.mPool.getMetaData());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(AnalysisProcessData analysisProcessData, ResultSpecification resultSpecification) throws ResultNotSupportedException, AnalysisEngineProcessException {
        AnalysisEngine analysisEngine = null;
        try {
            analysisEngine = this.mPool.getAnalysisEngine(this.mTimeout);
            if (analysisEngine == null) {
                throw new AnalysisEngineProcessException("timeout_elapsed", new Object[]{new Integer(this.getTimeout())});
            }
            analysisEngine.process(analysisProcessData, resultSpecification);
            Object var5_4 = null;
            if (analysisEngine != null) {
                this.mPool.releaseAnalysisEngine(analysisEngine);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (analysisEngine != null) {
                this.mPool.releaseAnalysisEngine(analysisEngine);
            }
            throw throwable;
        }
    }

    public void reconfigure() throws ResourceConfigurationException {
        this.mPool.reconfigure();
    }

    public void destroy() {
        this.mPool.destroy();
    }

    public void setLogger(Logger logger) {
        super.setLogger(logger);
        this.mPool.setLogger(logger);
    }

    protected AnalysisEnginePool getPool() {
        return this.mPool;
    }

    protected int getTimeout() {
        return this.mTimeout;
    }
}

