/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.analysis_engine;

import com.ibm.itu.TAFAnnotator;
import com.ibm.uima.UIMAFramework;
import com.ibm.uima.UIMARuntimeException;
import com.ibm.uima.UimaContextAdmin;
import com.ibm.uima.analysis_engine.AnalysisEngineDescription;
import com.ibm.uima.analysis_engine.AnalysisEngineProcessException;
import com.ibm.uima.analysis_engine.AnalysisProcessData;
import com.ibm.uima.analysis_engine.ResultNotSupportedException;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.annotator.AnnotatorConfigurationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorInitializationException;
import com.ibm.uima.analysis_engine.annotator.AnnotatorProcessException;
import com.ibm.uima.analysis_engine.annotator.BaseAnnotator;
import com.ibm.uima.analysis_engine.annotator.GenericAnnotator;
import com.ibm.uima.analysis_engine.asb.ASB;
import com.ibm.uima.analysis_engine.asb.AsbException;
import com.ibm.uima.analysis_engine.asb.AsbMetaData;
import com.ibm.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import com.ibm.uima.analysis_engine.sequencer.AnalysisSequence;
import com.ibm.uima.analysis_engine.sequencer.AnalysisSequencer;
import com.ibm.uima.analysis_engine.sequencer.AnalysisSequencerException;
import com.ibm.uima.analysis_engine.sequencer.AnalysisSequencerMetaData;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.admin.CASMgr;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.text.Language;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.collection.base_cpm.CasObjectProcessor;
import com.ibm.uima.reference_impl.analysis_engine.AnalysisEngineImplBase;
import com.ibm.uima.reference_impl.analysis_engine.AnnotatorContext_impl;
import com.ibm.uima.reference_impl.analysis_engine.asb.AsbCreationSpecifier_impl;
import com.ibm.uima.reference_impl.analysis_engine.sequencer.AnalysisSequencerCreationSpecifier_impl;
import com.ibm.uima.reference_impl.util.UUIDGenerator;
import com.ibm.uima.resource.ConfigurableResource;
import com.ibm.uima.resource.ResourceConfigurationException;
import com.ibm.uima.resource.ResourceCreationSpecifier;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceProcessException;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.resource.metadata.Capability;
import com.ibm.uima.resource.metadata.ConfigurationGroup;
import com.ibm.uima.resource.metadata.ConfigurationParameter;
import com.ibm.uima.resource.metadata.ConfigurationParameterDeclarations;
import com.ibm.uima.resource.metadata.ConfigurationParameterSettings;
import com.ibm.uima.resource.metadata.FeatureDescription;
import com.ibm.uima.resource.metadata.FsIndexCollection;
import com.ibm.uima.resource.metadata.MetaDataObject;
import com.ibm.uima.resource.metadata.OperationalProperties;
import com.ibm.uima.resource.metadata.ProcessingResourceMetaData;
import com.ibm.uima.resource.metadata.TypeDescription;
import com.ibm.uima.resource.metadata.TypePriorities;
import com.ibm.uima.resource.metadata.TypeSystemDescription;
import com.ibm.uima.util.CasCreationUtils;
import com.ibm.uima.util.InvalidXMLException;
import com.ibm.uima.util.Level;
import com.ibm.uima.util.ProcessTrace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class AnalysisEngine_impl
extends AnalysisEngineImplBase {
    private static final String LOG_RESOURCE_BUNDLE = "com.ibm.uima.reference_impl.log_messages";
    private static final Class CLASS_NAME = class$com$ibm$uima$reference_impl$analysis_engine$AnalysisEngine_impl == null ? (class$com$ibm$uima$reference_impl$analysis_engine$AnalysisEngine_impl = AnalysisEngine_impl.class$("com.ibm.uima.reference_impl.analysis_engine.AnalysisEngine_impl")) : class$com$ibm$uima$reference_impl$analysis_engine$AnalysisEngine_impl;
    private AnalysisEngineDescription mDescription;
    private BaseAnnotator mAnnotator;
    private AnnotatorContext_impl mAnnotatorContext;
    private Map mComponentCasProcessorMetaData;
    private AnalysisSequencer mSequencer;
    private ASB mASB;
    private ResultSpecification mDefaultResultSpecification;
    private TypeSystem mLastAnnotatorTypeSystem;
    private boolean isTAFEngine = false;
    private boolean requiresTCas = false;
    private static final String TAF_ANNOTATOR_CLASS_NAME = "com.ibm.itu.TAFAnnotator";
    private boolean mVerificationMode = false;
    public static final String PARAM_VERIFICATION_MODE = "VERIFICATION_MODE";
    static /* synthetic */ Class class$com$ibm$uima$reference_impl$analysis_engine$AnalysisEngine_impl;
    static /* synthetic */ Class class$com$ibm$uima$analysis_engine$annotator$BaseAnnotator;
    static /* synthetic */ Class class$com$ibm$uima$analysis_engine$asb$ASB;
    static /* synthetic */ Class class$com$ibm$uima$analysis_engine$sequencer$AnalysisSequencer;

    private static final void normalizeIsoLangCodes(AnalysisEngineDescription analysisEngineDescription) {
        if (analysisEngineDescription == null || analysisEngineDescription.getAnalysisEngineMetaData() == null) {
            return;
        }
        Capability[] capabilityArray = analysisEngineDescription.getAnalysisEngineMetaData().getCapabilities();
        if (capabilityArray == null) {
            return;
        }
        for (int i = 0; i < capabilityArray.length; ++i) {
            Capability capability = capabilityArray[i];
            String[] stringArray = capability.getLanguagesSupported();
            for (int j = 0; j < stringArray.length; ++j) {
                stringArray[j] = Language.normalize(stringArray[j]);
            }
        }
    }

    public boolean initialize(ResourceSpecifier resourceSpecifier, Map hashMap) throws ResourceInitializationException {
        try {
            if (!(resourceSpecifier instanceof AnalysisEngineDescription)) {
                return false;
            }
            this.mDescription = (AnalysisEngineDescription)resourceSpecifier;
            String string = this.mDescription.getFrameworkImplementation();
            if (!string.startsWith("com.ibm.uima.java") && !string.startsWith("JEDII")) {
                if (string.startsWith("com.ibm.uima.cpp") || string.startsWith("TAF")) {
                    this.isTAFEngine = true;
                } else {
                    return false;
                }
            }
            super.initialize(resourceSpecifier, hashMap);
            AnalysisEngineMetaData analysisEngineMetaData = this.mDescription.getAnalysisEngineMetaData();
            this.getLogger().logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", LOG_RESOURCE_BUNDLE, "UIMA_analysis_engine_init_begin__CONFIG", analysisEngineMetaData.getName());
            AnalysisEngine_impl.normalizeIsoLangCodes(this.mDescription);
            AnalysisEngineMetaData analysisEngineMetaData2 = (AnalysisEngineMetaData)analysisEngineMetaData.clone();
            if (analysisEngineMetaData2.getUUID() == null) {
                analysisEngineMetaData2.setUUID(UUIDGenerator.generate());
            }
            this.setMetaData(analysisEngineMetaData2);
            this.validateDescription(this.mDescription);
            try {
                this.mDescription.getDelegateAnalysisEngineSpecifiers(this.getResourceManager());
            }
            catch (InvalidXMLException invalidXMLException) {
                throw new ResourceInitializationException(invalidXMLException);
            }
            hashMap = hashMap == null ? new HashMap<String, Object>() : new HashMap(hashMap);
            this.mVerificationMode = hashMap.containsKey(PARAM_VERIFICATION_MODE);
            Properties properties = (Properties)hashMap.get("PERFORMANCE_TUNING_SETTINGS");
            if (properties != null) {
                this.setPerformanceTuningSettings(properties);
            }
            hashMap.put("CONFIG_PARAM_SETTINGS", this.getCurrentConfigParameterSettings());
            hashMap.put("RESOURCE_MANAGER", this.getResourceManager());
            this.mDefaultResultSpecification = UIMAFramework.getResourceSpecifierFactory().createResultSpecification();
            Capability[] capabilityArray = this.getAnalysisEngineMetaData().getCapabilities();
            if (capabilityArray != null) {
                this.mDefaultResultSpecification.addCapabilities(capabilityArray);
            }
            if (this.mDescription.isPrimitive()) {
                this.initializePrimitiveAnalysisEngine(this.mDescription);
            } else {
                this.initializeAggregateAnalysisEngine(this.mDescription, hashMap);
            }
            this.getLogger().logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", LOG_RESOURCE_BUNDLE, "UIMA_analysis_engine_init_successful__CONFIG", analysisEngineMetaData.getName());
            return true;
        }
        catch (ResourceConfigurationException resourceConfigurationException) {
            throw new ResourceInitializationException(resourceConfigurationException);
        }
    }

    public void destroy() {
        if (this.mAnnotator != null) {
            this.mAnnotator.destroy();
        }
        if (this.mSequencer != null) {
            this.mSequencer.destroy();
        }
        if (this.mASB != null) {
            this.mASB.destroy();
        }
        this.getLogger().logrb(Level.CONFIG, CLASS_NAME.getName(), "initialize", LOG_RESOURCE_BUNDLE, "UIMA_analysis_engine_destroyed__CONFIG", this.getMetaData().getName());
    }

    public void process(AnalysisProcessData analysisProcessData, ResultSpecification resultSpecification) throws ResultNotSupportedException, AnalysisEngineProcessException {
        String string = this.getMetaData().getName();
        analysisProcessData.getProcessTrace().startEvent(string, "ANALYSIS_ENGINE", "");
        this.getLogger().logrb(Level.FINE, CLASS_NAME.getName(), "process", LOG_RESOURCE_BUNDLE, "UIMA_analysis_engine_process_begin__FINE", string);
        String string2 = null;
        try {
            block18: {
                if (this._getAnnotator() != null) {
                    if (resultSpecification == null) {
                        resultSpecification = this.mDefaultResultSpecification;
                    }
                    analysisProcessData.getProcessTrace().startEvent(string, "ANALYSIS", "");
                    try {
                        try {
                            this.enableProhibitedAnnotatorCasFunctions(analysisProcessData.getCAS(), false);
                            this._getAnnotatorContext().setProcessTrace(analysisProcessData.getProcessTrace());
                            if (this.mLastAnnotatorTypeSystem != analysisProcessData.getCAS().getTypeSystem()) {
                                this._getAnnotator().typeSystemInit(analysisProcessData.getCAS().getTypeSystem());
                                this.mLastAnnotatorTypeSystem = analysisProcessData.getCAS().getTypeSystem();
                                resultSpecification.compile(analysisProcessData.getCAS().getTypeSystem());
                            }
                            this.callAnnotator(analysisProcessData.getCAS(), resultSpecification);
                            string2 = "success";
                        }
                        catch (AnnotatorProcessException annotatorProcessException) {
                            string2 = annotatorProcessException.getLocalizedMessage();
                            throw new AnalysisEngineProcessException("annotator_exception", null, annotatorProcessException);
                        }
                        Object var7_5 = null;
                        analysisProcessData.getProcessTrace().endEvent(string, "ANALYSIS", string2);
                        this.enableProhibitedAnnotatorCasFunctions(analysisProcessData.getCAS(), true);
                        break block18;
                    }
                    catch (Throwable throwable) {
                        Object var7_6 = null;
                        analysisProcessData.getProcessTrace().endEvent(string, "ANALYSIS", string2);
                        this.enableProhibitedAnnotatorCasFunctions(analysisProcessData.getCAS(), true);
                        throw throwable;
                    }
                }
                try {
                    AnalysisSequence analysisSequence = this._getSequencer().computeSequence(resultSpecification, analysisProcessData.getCAS());
                    if (analysisSequence == null) {
                        throw new ResultNotSupportedException("no_sequence_found", null);
                    }
                    this._getASB().process(analysisProcessData, analysisSequence, -1);
                }
                catch (AnalysisSequencerException analysisSequencerException) {
                    throw new AnalysisEngineProcessException("sequencer_exception", null, analysisSequencerException);
                }
                catch (AsbException asbException) {
                    throw new AnalysisEngineProcessException("asb_exception", null, asbException);
                }
            }
            this.getLogger().logrb(Level.FINE, CLASS_NAME.getName(), "process", LOG_RESOURCE_BUNDLE, "UIMA_analysis_engine_process_end__FINE", string);
            string2 = "success";
            analysisProcessData.getProcessTrace().endEvent(string, "ANALYSIS_ENGINE", string2);
        }
        catch (Exception exception) {
            try {
                this.getLogger().log(Level.SEVERE, "", exception);
                string2 = exception.getLocalizedMessage();
                if (exception instanceof RuntimeException) {
                    throw (RuntimeException)exception;
                }
                if (exception instanceof AnalysisEngineProcessException) {
                    throw (AnalysisEngineProcessException)exception;
                }
                if (exception instanceof ResultNotSupportedException) {
                    throw (ResultNotSupportedException)exception;
                }
                throw new AnalysisEngineProcessException(exception);
            }
            catch (Throwable throwable) {
                analysisProcessData.getProcessTrace().endEvent(string, "ANALYSIS_ENGINE", string2);
                throw throwable;
            }
        }
    }

    protected boolean prepareAnnotatorCall(BaseAnnotator baseAnnotator) {
        if (baseAnnotator instanceof TAFAnnotator) {
            this.requiresTCas = true;
            Capability[] capabilityArray = this.getAnalysisEngineMetaData().getCapabilities();
            for (int i = 0; i < capabilityArray.length; ++i) {
                if (capabilityArray[i].getInputSofas().length <= 0 && capabilityArray[i].getOutputSofas().length <= 0) continue;
                this.requiresTCas = false;
                break;
            }
            return true;
        }
        this.requiresTCas = false;
        return baseAnnotator instanceof GenericAnnotator;
    }

    protected void callAnnotator(CAS cAS, ResultSpecification resultSpecification) throws AnalysisEngineProcessException, AnnotatorProcessException {
        if (this.requiresTCas) {
            TCAS tCAS = this.getDefaultTCAS(cAS);
            ((GenericAnnotator)this._getAnnotator()).process(tCAS, resultSpecification);
        } else {
            ((GenericAnnotator)this._getAnnotator()).process(((CASImpl)cAS).getBaseCAS(), resultSpecification);
        }
    }

    protected TCAS getDefaultTCAS(CAS cAS) {
        if (cAS instanceof TCAS) {
            return (TCAS)cAS;
        }
        return cAS.getTCAS(cAS.getSofa(this.getUimaContext().mapToSofaID("_DefaultTextSofaName")));
    }

    public void reconfigure() throws ResourceConfigurationException {
        super.reconfigure();
        if (this._getAnnotator() != null) {
            try {
                this._getAnnotator().reconfigure();
            }
            catch (AnnotatorConfigurationException annotatorConfigurationException) {
                throw new ResourceConfigurationException(annotatorConfigurationException);
            }
            catch (AnnotatorInitializationException annotatorInitializationException) {
                throw new ResourceConfigurationException(annotatorInitializationException);
            }
        } else {
            Map map = this._getASB().getComponentCasProcessors();
            Iterator iterator = map.values().iterator();
            while (iterator.hasNext()) {
                ConfigurableResource configurableResource = (ConfigurableResource)iterator.next();
                configurableResource.reconfigure();
            }
        }
    }

    public ConfigurationParameterSettings getCurrentConfigParameterSettings() {
        return this.getUimaContextAdmin().getConfigurationManager().getCurrentConfigParameterSettings(this.getUimaContextAdmin().getQualifiedContextName());
    }

    public void batchProcessComplete(ProcessTrace processTrace) throws ResourceProcessException, IOException {
        if (this._getASB() != null) {
            Iterator iterator = this._getASB().getComponentCasProcessors().values().iterator();
            while (iterator.hasNext()) {
                ((CasObjectProcessor)iterator.next()).batchProcessComplete(processTrace);
            }
        }
    }

    public void collectionProcessComplete(ProcessTrace processTrace) throws ResourceProcessException, IOException {
        if (this._getASB() != null) {
            Iterator iterator = this._getASB().getComponentCasProcessors().values().iterator();
            while (iterator.hasNext()) {
                ((CasObjectProcessor)iterator.next()).collectionProcessComplete(processTrace);
            }
        }
    }

    protected void validateDescription(AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException {
        if (!analysisEngineDescription.isPrimitive() && analysisEngineDescription.getAnalysisEngineMetaData().getTypeSystem() != null) {
            throw new ResourceInitializationException("aggregate_ae_type_system", new Object[]{analysisEngineDescription.getSourceUrlString()});
        }
        this.validateConfigurationParameters(analysisEngineDescription);
    }

    protected void validateConfigurationParameters(AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException {
        ConfigurationParameterDeclarations configurationParameterDeclarations = analysisEngineDescription.getMetaData().getConfigurationParameterDeclarations();
        ConfigurationParameter[] configurationParameterArray = configurationParameterDeclarations.getConfigurationParameters();
        if (configurationParameterArray.length > 0) {
            this.checkForDuplicateParameterNames(configurationParameterArray);
            this.checkForInvalidParameterOverrides(configurationParameterArray, null, analysisEngineDescription);
        } else {
            ConfigurationGroup[] configurationGroupArray;
            ConfigurationParameter[] configurationParameterArray2 = configurationParameterDeclarations.getCommonParameters();
            HashSet<String> hashSet = new HashSet<String>();
            if (configurationParameterArray2 != null) {
                for (int i = 0; i < configurationParameterArray2.length; ++i) {
                    if (hashSet.add(configurationParameterArray2[i].getName())) continue;
                    throw new ResourceInitializationException("duplicate_configuration_parameter_name", new Object[]{configurationParameterArray2[i].getName(), this.getMetaData().getName(), configurationParameterArray2[i].getSourceUrlString()});
                }
            }
            if ((configurationGroupArray = configurationParameterDeclarations.getConfigurationGroups()) != null) {
                HashMap hashMap = new HashMap();
                for (int i = 0; i < configurationGroupArray.length; ++i) {
                    String[] stringArray = configurationGroupArray[i].getNames();
                    for (int j = 0; j < stringArray.length; ++j) {
                        ConfigurationParameter[] configurationParameterArray3;
                        HashSet<String> hashSet2 = (HashSet<String>)hashMap.get(stringArray[j]);
                        if (hashSet2 == null) {
                            hashSet2 = new HashSet<String>(hashSet);
                        }
                        if ((configurationParameterArray3 = configurationGroupArray[i].getConfigurationParameters()) != null) {
                            for (int k = 0; k < configurationParameterArray3.length; ++k) {
                                if (hashSet2.add(configurationParameterArray3[k].getName())) continue;
                                throw new ResourceInitializationException("duplicate_configuration_parameter_name", new Object[]{configurationParameterArray3[k].getName(), this.getMetaData().getName(), configurationParameterArray3[k].getSourceUrlString()});
                            }
                        }
                        this.checkForInvalidParameterOverrides(configurationParameterArray3, stringArray[j], analysisEngineDescription);
                        if (configurationParameterArray2 == null) continue;
                        this.checkForInvalidParameterOverrides(configurationParameterArray2, stringArray[j], analysisEngineDescription);
                    }
                }
            }
        }
    }

    protected void checkForDuplicateParameterNames(ConfigurationParameter[] configurationParameterArray) throws ResourceInitializationException {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = 0; i < configurationParameterArray.length; ++i) {
            if (hashSet.add(configurationParameterArray[i].getName())) continue;
            throw new ResourceInitializationException("duplicate_configuration_parameter_name", new Object[]{configurationParameterArray[i].getName(), this.getMetaData().getName(), configurationParameterArray[i].getSourceUrlString()});
        }
    }

    protected void checkForInvalidParameterOverrides(ConfigurationParameter[] configurationParameterArray, String string, AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException {
        for (int i = 0; i < configurationParameterArray.length; ++i) {
            String[] stringArray = configurationParameterArray[i].getOverrides();
            if (stringArray.length > 0 && analysisEngineDescription.isPrimitive()) {
                throw new ResourceInitializationException("param_override_in_primitive", new Object[]{configurationParameterArray[i].getName(), this.getMetaData().getName(), configurationParameterArray[i].getSourceUrlString()});
            }
            if (stringArray.length == 0 && !analysisEngineDescription.isPrimitive()) {
                this.getLogger().logrb(Level.WARNING, this.getClass().getName(), "checkForInvalidParameterOverrides", LOG_RESOURCE_BUNDLE, "UIMA_aggregate_param_no_overrides__WARNING", new Object[]{this.getMetaData().getName(), configurationParameterArray[i].getName()});
            }
            for (int j = 0; j < stringArray.length; ++j) {
                ResourceSpecifier resourceSpecifier;
                int n = stringArray[j].indexOf(47);
                if (n <= 0 || n >= stringArray[j].length()) {
                    throw new ResourceInitializationException("invalid_param_override_syntax", new Object[]{stringArray[j], configurationParameterArray[i].getName(), this.getMetaData().getName(), configurationParameterArray[i].getSourceUrlString()});
                }
                String string2 = stringArray[j].substring(0, n);
                String string3 = stringArray[j].substring(n + 1);
                try {
                    resourceSpecifier = (ResourceSpecifier)analysisEngineDescription.getDelegateAnalysisEngineSpecifiers().get(string2);
                }
                catch (InvalidXMLException invalidXMLException) {
                    throw new ResourceInitializationException(invalidXMLException);
                }
                if (resourceSpecifier == null) {
                    throw new ResourceInitializationException("invalid_param_override_nonexistent_delegate", new Object[]{stringArray[j], configurationParameterArray[i].getName(), this.getMetaData().getName(), string2, configurationParameterArray[i].getSourceUrlString()});
                }
                if (!(resourceSpecifier instanceof ResourceCreationSpecifier)) continue;
                ConfigurationParameterDeclarations configurationParameterDeclarations = ((ResourceCreationSpecifier)resourceSpecifier).getMetaData().getConfigurationParameterDeclarations();
                ConfigurationParameter configurationParameter = null;
                if (string == null) {
                    configurationParameter = configurationParameterDeclarations.getConfigurationParameter(null, string3);
                    if (configurationParameter == null) {
                        throw new ResourceInitializationException("invalid_param_override_nonexistent_parameter", new Object[]{stringArray[j], configurationParameterArray[i].getName(), this.getMetaData().getName(), string2, string3, configurationParameterArray[i].getSourceUrlString()});
                    }
                } else {
                    configurationParameter = configurationParameterDeclarations.getConfigurationParameter(string, string3);
                    if (configurationParameter == null) {
                        throw new ResourceInitializationException("invalid_param_override_nonexistent_parameter_in_group", new Object[]{stringArray[j], configurationParameterArray[i].getName(), this.getMetaData().getName(), string2, string3, string, configurationParameterArray[i].getSourceUrlString()});
                    }
                }
                if (!configurationParameter.isMandatory() || configurationParameterArray[i].isMandatory()) continue;
                this.getLogger().logrb(Level.WARNING, this.getClass().getName(), "checkForInvalidParameterOverrides", LOG_RESOURCE_BUNDLE, "UIMA_optional_param_overrides_mandatory__WARNING", new Object[]{stringArray[j], configurationParameterArray[i].getName(), this.getMetaData().getName()});
            }
        }
    }

    protected void initializePrimitiveAnalysisEngine(AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException, ResourceConfigurationException {
        Object object;
        String string = this.isTAFEngine ? TAF_ANNOTATOR_CLASS_NAME : analysisEngineDescription.getAnnotatorImplementationName();
        if (string == null || string.length() == 0) {
            throw new ResourceInitializationException("missing_annotator_class_name", new Object[]{analysisEngineDescription.getSourceUrlString()});
        }
        Class<?> clazz = null;
        try {
            object = this.getUimaContextAdmin().getResourceManager().getExtensionClassLoader();
            clazz = object != null ? ((ClassLoader)object).loadClass(string) : Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ResourceInitializationException("annotator_class_not_found", new Object[]{string, analysisEngineDescription.getSourceUrlString()}, classNotFoundException);
        }
        object = this.getUimaContextAdmin();
        object.setLogger(UIMAFramework.getLogger(clazz));
        this.mAnnotatorContext = new AnnotatorContext_impl((UimaContextAdmin)object);
        try {
            if ((class$com$ibm$uima$analysis_engine$annotator$BaseAnnotator == null ? (class$com$ibm$uima$analysis_engine$annotator$BaseAnnotator = AnalysisEngine_impl.class$("com.ibm.uima.analysis_engine.annotator.BaseAnnotator")) : class$com$ibm$uima$analysis_engine$annotator$BaseAnnotator).isAssignableFrom(clazz)) {
                if (!this.mVerificationMode) {
                    this.mAnnotator = this.isTAFEngine ? new TAFAnnotator(analysisEngineDescription, this) : (BaseAnnotator)clazz.newInstance();
                }
            } else {
                throw new ResourceInitializationException("not_an_annotator", new Object[]{string, analysisEngineDescription.getSourceUrlString()});
            }
            if (this.mVerificationMode) {
                return;
            }
            if (!this.prepareAnnotatorCall(this.mAnnotator)) {
                throw new ResourceInitializationException("annotator_interface_not_supported", new Object[]{string, this.getClass().getName(), analysisEngineDescription.getSourceUrlString()});
            }
        }
        catch (ResourceInitializationException resourceInitializationException) {
            throw resourceInitializationException;
        }
        catch (Exception exception) {
            throw new ResourceInitializationException("could_not_instantiate_annotator", new Object[]{string, analysisEngineDescription.getSourceUrlString()}, exception);
        }
        try {
            this.mAnnotator.initialize(this.mAnnotatorContext);
        }
        catch (AnnotatorInitializationException annotatorInitializationException) {
            throw new ResourceInitializationException("annotator_initialization_failed", new Object[]{string, analysisEngineDescription.getSourceUrlString()}, annotatorInitializationException);
        }
        catch (AnnotatorConfigurationException annotatorConfigurationException) {
            throw new ResourceInitializationException("annotator_initialization_failed", new Object[]{string, analysisEngineDescription.getSourceUrlString()}, annotatorConfigurationException);
        }
    }

    protected void initializeAggregateAnalysisEngine(AnalysisEngineDescription analysisEngineDescription, Map map) throws ResourceInitializationException, ResourceConfigurationException {
        try {
            this.initASB(analysisEngineDescription, map);
            this.processDelegateAnalysisEngineMetaData();
            this.initSequencer(analysisEngineDescription);
        }
        catch (AsbException asbException) {
            throw new ResourceInitializationException(asbException);
        }
        catch (AnalysisSequencerException analysisSequencerException) {
            throw new ResourceInitializationException(analysisSequencerException);
        }
        if (this.isTAFEngine) {
            this.initializePrimitiveAnalysisEngine(analysisEngineDescription);
            this.mComponentCasProcessorMetaData = null;
            this.mASB = null;
            this.mSequencer = null;
        }
    }

    protected void initASB(AnalysisEngineDescription analysisEngineDescription, Map map) throws ResourceInitializationException, AsbException {
        HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
        hashMap.put("PARAM_AGGREGATE_ANALYSIS_ENGINE_NAME", this.getMetaData().getName());
        hashMap.put("AGGREGATE_SOFA_MAPPINGS", analysisEngineDescription.getSofaMappings());
        ResourceSpecifier resourceSpecifier = analysisEngineDescription.getAsbSpecifier();
        if (resourceSpecifier == null) {
            resourceSpecifier = this.getDefaultASBSpecifier();
        }
        this.mASB = (ASB)UIMAFramework.produceResource(class$com$ibm$uima$analysis_engine$asb$ASB == null ? (class$com$ibm$uima$analysis_engine$asb$ASB = AnalysisEngine_impl.class$("com.ibm.uima.analysis_engine.asb.ASB")) : class$com$ibm$uima$analysis_engine$asb$ASB, resourceSpecifier, hashMap);
        this.mASB.setComponentCasProcessorSpecifiers(this._getComponentCasProcessorSpecifierMap(), this.getUimaContextAdmin());
        this.mComponentCasProcessorMetaData = this._getASB().getComponentCasProcessorMetaData();
    }

    protected void processDelegateAnalysisEngineMetaData() throws ResourceInitializationException {
        MetaDataObject metaDataObject;
        FsIndexCollection fsIndexCollection;
        ArrayList<TypeSystemDescription> arrayList = new ArrayList<TypeSystemDescription>();
        ArrayList<TypePriorities> arrayList2 = new ArrayList<TypePriorities>();
        ArrayList<FsIndexCollection> arrayList3 = new ArrayList<FsIndexCollection>();
        TypePriorities typePriorities = this.getAnalysisEngineMetaData().getTypePriorities();
        if (typePriorities != null) {
            arrayList2.add(typePriorities);
        }
        if ((fsIndexCollection = this.getAnalysisEngineMetaData().getFsIndexCollection()) != null) {
            arrayList3.add(fsIndexCollection);
        }
        Iterator iterator = this._getComponentCasProcessorMetaData().values().iterator();
        while (iterator.hasNext()) {
            metaDataObject = (ProcessingResourceMetaData)iterator.next();
            if (metaDataObject.getTypeSystem() != null) {
                arrayList.add(metaDataObject.getTypeSystem());
            }
            if (metaDataObject.getTypePriorities() != null) {
                arrayList2.add(metaDataObject.getTypePriorities());
            }
            if (metaDataObject.getFsIndexCollection() == null) continue;
            arrayList3.add(metaDataObject.getFsIndexCollection());
        }
        metaDataObject = CasCreationUtils.mergeTypeSystems(arrayList, this.getResourceManager());
        TypePriorities typePriorities2 = CasCreationUtils.mergeTypePriorities(arrayList2, this.getResourceManager());
        FsIndexCollection fsIndexCollection2 = CasCreationUtils.mergeFsIndexes(arrayList3, this.getResourceManager());
        AnalysisEngineMetaData analysisEngineMetaData = this.getAnalysisEngineMetaData();
        analysisEngineMetaData.setTypeSystem((TypeSystemDescription)metaDataObject);
        analysisEngineMetaData.setTypePriorities(typePriorities2);
        analysisEngineMetaData.setFsIndexCollection(fsIndexCollection2);
        this.validateOperationalProperties();
    }

    protected void validateOperationalProperties() throws ResourceInitializationException {
        OperationalProperties operationalProperties = this.getAnalysisEngineMetaData().getOperationalProperties();
        if (operationalProperties != null) {
            Iterator iterator = this._getComponentCasProcessorMetaData().values().iterator();
            while (iterator.hasNext()) {
                ProcessingResourceMetaData processingResourceMetaData = (ProcessingResourceMetaData)iterator.next();
                OperationalProperties operationalProperties2 = processingResourceMetaData.getOperationalProperties();
                if (operationalProperties2 == null) continue;
                if (operationalProperties.isMultipleDeploymentAllowed() && !operationalProperties2.isMultipleDeploymentAllowed()) {
                    throw new ResourceInitializationException("invalid_multiple_deployment_allowed", new Object[]{this.getAnalysisEngineMetaData().getName(), processingResourceMetaData.getName(), this.getAnalysisEngineMetaData().getSourceUrlString()});
                }
                if (operationalProperties.getModifiesCas() || !operationalProperties2.getModifiesCas()) continue;
                throw new ResourceInitializationException("invalid_modifies_cas", new Object[]{this.getAnalysisEngineMetaData().getName(), processingResourceMetaData.getName(), this.getAnalysisEngineMetaData().getSourceUrlString()});
            }
        }
    }

    protected void initSequencer(AnalysisEngineDescription analysisEngineDescription) throws ResourceInitializationException, AnalysisSequencerException {
        ResourceSpecifier resourceSpecifier = analysisEngineDescription.getSequencerSpecifier();
        if (resourceSpecifier == null) {
            resourceSpecifier = this.getDefaultSequencerSpecifier();
        }
        this.mSequencer = (AnalysisSequencer)UIMAFramework.produceResource(class$com$ibm$uima$analysis_engine$sequencer$AnalysisSequencer == null ? (class$com$ibm$uima$analysis_engine$sequencer$AnalysisSequencer = AnalysisEngine_impl.class$("com.ibm.uima.analysis_engine.sequencer.AnalysisSequencer")) : class$com$ibm$uima$analysis_engine$sequencer$AnalysisSequencer, resourceSpecifier, null);
        Map map = this._getASB().getComponentCasProcessors();
        if (map == null) {
            map = this._getComponentCasProcessorMetaData();
        }
        this._getSequencer().setSequencingEnvironment(map, this.getAnalysisEngineMetaData().getFlowConstraints(), this.getAnalysisEngineMetaData().getCapabilities());
    }

    protected ResourceSpecifier getDefaultASBSpecifier() {
        AsbCreationSpecifier_impl asbCreationSpecifier_impl = new AsbCreationSpecifier_impl();
        AsbMetaData asbMetaData = asbCreationSpecifier_impl.getAsbMetaData();
        asbMetaData.setAsynchronousModeSupported(false);
        return asbCreationSpecifier_impl;
    }

    protected ResourceSpecifier getDefaultSequencerSpecifier() {
        AnalysisSequencerCreationSpecifier_impl analysisSequencerCreationSpecifier_impl = new AnalysisSequencerCreationSpecifier_impl();
        AnalysisSequencerMetaData analysisSequencerMetaData = analysisSequencerCreationSpecifier_impl.getAnalysisSequencerMetaData();
        analysisSequencerMetaData.setSupportedFlowConstraintsTypes(new String[]{"FIXED"});
        return analysisSequencerCreationSpecifier_impl;
    }

    protected TypeSystemDescription mergeTypeSystems(Collection collection) throws ResourceInitializationException {
        TypeSystemDescription typeSystemDescription = UIMAFramework.getResourceSpecifierFactory().createTypeSystemDescription();
        HashMap<String, TypeDescription> hashMap = new HashMap<String, TypeDescription>();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            TypeSystemDescription typeSystemDescription2 = (TypeSystemDescription)iterator.next();
            try {
                typeSystemDescription2.resolveImports(this.getResourceManager());
            }
            catch (InvalidXMLException invalidXMLException) {
                throw new ResourceInitializationException(invalidXMLException);
            }
            TypeDescription[] typeDescriptionArray = typeSystemDescription2.getTypes();
            if (typeDescriptionArray == null) continue;
            for (int i = 0; i < typeDescriptionArray.length; ++i) {
                FeatureDescription[] featureDescriptionArray;
                String string = typeDescriptionArray[i].getName();
                TypeDescription typeDescription = (TypeDescription)hashMap.get(string);
                if (typeDescription == null) {
                    typeDescription = typeSystemDescription.addType(typeDescriptionArray[i].getName(), typeDescriptionArray[i].getDescription(), typeDescriptionArray[i].getSupertypeName());
                    typeDescription.setAllowedValues(typeDescriptionArray[i].getAllowedValues());
                    hashMap.put(typeDescriptionArray[i].getName(), typeDescription);
                } else {
                    featureDescriptionArray = typeDescriptionArray[i].getSupertypeName();
                    String string2 = typeDescription.getSupertypeName();
                    if (!string2.equals(featureDescriptionArray)) {
                        if (this.subsumes(string2, (String)featureDescriptionArray, hashMap)) {
                            typeDescription.setSupertypeName((String)featureDescriptionArray);
                        } else if (!this.subsumes((String)featureDescriptionArray, string2, hashMap)) {
                            throw new ResourceInitializationException("incompatible_supertypes", new Object[]{string, featureDescriptionArray, string2, typeDescriptionArray[i].getSourceUrlString()});
                        }
                    }
                }
                featureDescriptionArray = typeDescriptionArray[i].getFeatures();
                if (featureDescriptionArray == null) continue;
                this.mergeFeatures(typeDescription, typeDescriptionArray[i].getFeatures());
            }
        }
        return typeSystemDescription;
    }

    protected boolean subsumes(String string, String string2, Map map) {
        if ("uima.cas.TOP".equals(string)) {
            return true;
        }
        String string3 = string2;
        while (string3 != null && !string3.equals(string)) {
            TypeDescription typeDescription = (TypeDescription)map.get(string3);
            if (typeDescription == null) {
                string3 = null;
                continue;
            }
            string3 = typeDescription.getSupertypeName();
        }
        return string3 != null;
    }

    protected void mergeFeatures(TypeDescription typeDescription, FeatureDescription[] featureDescriptionArray) throws ResourceInitializationException {
        FeatureDescription[] featureDescriptionArray2 = typeDescription.getFeatures();
        if (featureDescriptionArray2 == null) {
            featureDescriptionArray2 = new FeatureDescription[]{};
        }
        for (int i = 0; i < featureDescriptionArray.length; ++i) {
            String string = featureDescriptionArray[i].getName();
            String string2 = featureDescriptionArray[i].getRangeTypeName();
            FeatureDescription featureDescription = null;
            for (int j = 0; j < featureDescriptionArray2.length; ++j) {
                if (!featureDescriptionArray2[j].getName().equals(string)) continue;
                featureDescription = featureDescriptionArray2[j];
                break;
            }
            if (featureDescription == null) {
                typeDescription.addFeature(string, featureDescriptionArray[i].getDescription(), string2);
                continue;
            }
            if (featureDescription.getRangeTypeName().equals(string2)) continue;
            throw new ResourceInitializationException("incompatible_range_types", new Object[]{typeDescription.getName() + ":" + featureDescription.getName(), string2, featureDescription.getRangeTypeName(), typeDescription.getSourceUrlString()});
        }
    }

    protected void enableProhibitedAnnotatorCasFunctions(CAS cAS, boolean bl) {
        if (cAS instanceof CASMgr) {
            ((CASMgr)((Object)cAS)).enableReset(bl);
        }
    }

    protected BaseAnnotator _getAnnotator() {
        return this.mAnnotator;
    }

    protected AnnotatorContext_impl _getAnnotatorContext() {
        return this.mAnnotatorContext;
    }

    protected ASB _getASB() {
        return this.mASB;
    }

    protected AnalysisSequencer _getSequencer() {
        return this.mSequencer;
    }

    protected Map _getComponentCasProcessorMetaData() {
        return this.mComponentCasProcessorMetaData;
    }

    protected Map _getComponentCasProcessorSpecifierMap() {
        try {
            return this.mDescription.getDelegateAnalysisEngineSpecifiers();
        }
        catch (InvalidXMLException invalidXMLException) {
            throw new UIMARuntimeException(invalidXMLException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

