/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.analysis_engine;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.UIMARuntimeException;
import com.ibm.uima.analysis_engine.AnalysisEngine;
import com.ibm.uima.analysis_engine.AnalysisEngineProcessException;
import com.ibm.uima.analysis_engine.ResultNotSupportedException;
import com.ibm.uima.analysis_engine.ResultSpecification;
import com.ibm.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.CASException;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.jcas.impl.JCas;
import com.ibm.uima.reference_impl.analysis_engine.AnalysisProcessData_impl;
import com.ibm.uima.reference_impl.analysis_engine.ResultSpecification_impl;
import com.ibm.uima.resource.ConfigurableResource_ImplBase;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceProcessException;
import com.ibm.uima.resource.metadata.OperationalProperties;
import com.ibm.uima.resource.metadata.ProcessingResourceMetaData;
import com.ibm.uima.util.CasCreationUtils;
import com.ibm.uima.util.ProcessTrace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public abstract class AnalysisEngineImplBase
extends ConfigurableResource_ImplBase
implements AnalysisEngine {
    protected TypeSystem mFirstTypeSystem;
    protected CAS mNextCas;
    private Properties mPerformanceTuningSettings = UIMAFramework.getDefaultPerformanceTuningProperties();

    public AnalysisEngineMetaData getAnalysisEngineMetaData() {
        return (AnalysisEngineMetaData)this.getMetaData();
    }

    public ProcessingResourceMetaData getProcessingResourceMetaData() {
        return (ProcessingResourceMetaData)this.getMetaData();
    }

    public synchronized CAS newCAS() throws ResourceInitializationException {
        CAS cAS;
        if (this.mNextCas != null) {
            cAS = this.mNextCas;
            this.mNextCas = null;
        } else {
            ArrayList<AnalysisEngineMetaData> arrayList = new ArrayList<AnalysisEngineMetaData>();
            arrayList.add(this.getAnalysisEngineMetaData());
            cAS = CasCreationUtils.createCas(arrayList, this.getPerformanceTuningSettings(), this.getResourceManager());
            if (this.mFirstTypeSystem == null) {
                this.mFirstTypeSystem = cAS.getTypeSystem();
            }
        }
        return cAS;
    }

    public JCas newJCas() throws ResourceInitializationException {
        try {
            return this.newCAS().getJCas();
        }
        catch (CASException cASException) {
            throw new ResourceInitializationException(cASException);
        }
    }

    public ProcessTrace process(CAS cAS) throws AnalysisEngineProcessException {
        try {
            return this.process(cAS, (ResultSpecification)null);
        }
        catch (ResultNotSupportedException resultNotSupportedException) {
            return null;
        }
    }

    public ProcessTrace process(CAS cAS, ResultSpecification resultSpecification) throws ResultNotSupportedException, AnalysisEngineProcessException {
        AnalysisProcessData_impl analysisProcessData_impl = new AnalysisProcessData_impl(cAS, this.getPerformanceTuningSettings());
        this.process(analysisProcessData_impl, resultSpecification);
        return analysisProcessData_impl.getProcessTrace();
    }

    public void process(CAS cAS, ResultSpecification resultSpecification, ProcessTrace processTrace) throws ResultNotSupportedException, AnalysisEngineProcessException {
        AnalysisProcessData_impl analysisProcessData_impl = new AnalysisProcessData_impl(cAS, processTrace);
        this.process(analysisProcessData_impl, resultSpecification);
    }

    public ProcessTrace process(JCas jCas) throws AnalysisEngineProcessException {
        return this.process(jCas.getCas());
    }

    public ProcessTrace process(JCas jCas, ResultSpecification resultSpecification) throws ResultNotSupportedException, AnalysisEngineProcessException {
        return this.process(jCas.getCas(), resultSpecification);
    }

    public void process(JCas jCas, ResultSpecification resultSpecification, ProcessTrace processTrace) throws ResultNotSupportedException, AnalysisEngineProcessException {
        this.process(jCas.getCas(), resultSpecification, processTrace);
    }

    public void processCas(CAS cAS) throws ResourceProcessException {
        try {
            this.process(cAS, (ResultSpecification)null);
        }
        catch (AnalysisEngineProcessException analysisEngineProcessException) {
            throw new ResourceProcessException(analysisEngineProcessException);
        }
        catch (ResultNotSupportedException resultNotSupportedException) {
            throw new ResourceProcessException(resultNotSupportedException);
        }
    }

    public void processCas(CAS[] cASArray) throws ResourceProcessException {
        for (int i = 0; i < cASArray.length; ++i) {
            if (cASArray[i] == null) continue;
            this.processCas(cASArray[i]);
        }
    }

    public void processJCas(JCas jCas) throws ResourceProcessException {
        try {
            this.process(jCas, (ResultSpecification)null);
        }
        catch (AnalysisEngineProcessException analysisEngineProcessException) {
            throw new ResourceProcessException(analysisEngineProcessException);
        }
        catch (ResultNotSupportedException resultNotSupportedException) {
            throw new ResourceProcessException(resultNotSupportedException);
        }
    }

    public void processJCas(JCas[] jCasArray) throws ResourceProcessException {
        for (int i = 0; i < jCasArray.length; ++i) {
            if (jCasArray[i] == null) continue;
            this.processJCas(jCasArray[i]);
        }
    }

    public ResultSpecification createResultSpecification() {
        return new ResultSpecification_impl();
    }

    public synchronized String[] getFeatureNamesForType(String string) {
        Type type;
        if (this.mFirstTypeSystem == null) {
            try {
                this.mNextCas = this.newCAS();
            }
            catch (ResourceInitializationException resourceInitializationException) {
                throw new UIMARuntimeException(resourceInitializationException);
            }
        }
        if ((type = this.mFirstTypeSystem.getType(string)) != null) {
            List list = type.getFeatures();
            String[] stringArray = new String[list.size()];
            for (int i = 0; i < list.size(); ++i) {
                Feature feature = (Feature)list.get(i);
                stringArray[i] = feature.getShortName();
            }
            return stringArray;
        }
        return null;
    }

    public boolean isStateless() {
        return false;
    }

    public boolean isReadOnly() {
        OperationalProperties operationalProperties = this.getAnalysisEngineMetaData().getOperationalProperties();
        return operationalProperties == null ? false : !operationalProperties.getModifiesCas();
    }

    public void typeSystemInit(TypeSystem typeSystem) throws ResourceInitializationException {
    }

    public void batchProcessComplete(ProcessTrace processTrace) throws ResourceProcessException, IOException {
    }

    public void collectionProcessComplete(ProcessTrace processTrace) throws ResourceProcessException, IOException {
    }

    protected Properties getPerformanceTuningSettings() {
        return this.mPerformanceTuningSettings;
    }

    protected void setPerformanceTuningSettings(Properties properties) {
        this.mPerformanceTuningSettings = (Properties)properties.clone();
    }
}

