/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.reference_impl.analysis_engine;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.analysis_engine.AnalysisEngine;
import com.ibm.uima.analysis_engine.AnalysisEngineDescription;
import com.ibm.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import com.ibm.uima.analysis_engine.metadata.SofaMapping;
import com.ibm.uima.reference_impl.analysis_engine.metadata.AnalysisEngineMetaData_impl;
import com.ibm.uima.reference_impl.resource.ResourceCreationSpecifier_impl;
import com.ibm.uima.reference_impl.resource.metadata.Import_impl;
import com.ibm.uima.reference_impl.resource.metadata.PropertyXmlInfo;
import com.ibm.uima.reference_impl.resource.metadata.XmlizationInfo;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceManager;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.resource.metadata.Capability;
import com.ibm.uima.resource.metadata.Import;
import com.ibm.uima.resource.metadata.OperationalProperties;
import com.ibm.uima.util.InvalidXMLException;
import com.ibm.uima.util.NameClassPair;
import com.ibm.uima.util.XMLInputSource;
import com.ibm.uima.util.XMLParser;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.w3c.dom.Element;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class AnalysisEngineDescription_impl
extends ResourceCreationSpecifier_impl
implements AnalysisEngineDescription {
    protected static final XmlizationInfo XMLIZATION_INFO = new XmlizationInfo("analysisEngineDescription", new PropertyXmlInfo[]{new PropertyXmlInfo("frameworkImplementation"), new PropertyXmlInfo("primitive"), new PropertyXmlInfo("annotatorImplementationName"), new PropertyXmlInfo("delegateAnalysisEngineSpecifiersWithImports", "delegateAnalysisEngineSpecifiers"), new PropertyXmlInfo("metaData", null), new PropertyXmlInfo("externalResourceDependencies"), new PropertyXmlInfo("externalResources"), new PropertyXmlInfo("resourceManagerConfiguration", null), new PropertyXmlInfo("sofaMappings")});
    protected String PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS = "delegateAnalysisEngineSpecifiers";
    protected String PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS = "delegateAnalysisEngineSpecifiersWithImports";
    protected String ELEM_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS = "delegateAnalysisEngineSpecifiers";
    private String mFrameworkImplementation;
    private boolean mPrimitive;
    private String mAnnotatorImplementationName;
    private ResourceSpecifier mAsbSpecifier;
    private ResourceSpecifier mSequencerSpecifier;
    private Map mDelegateAnalysisEngineSpecifiers = new HashMap();
    private Map mDelegateAnalysisEngineSpecifiersWithImports = new HashMap();
    private Map mProcessedImports = new HashMap();
    private SofaMapping[] mSofaMappings;
    static final long serialVersionUID = -8103625125291855592L;
    static /* synthetic */ Class class$java$util$Map;

    public AnalysisEngineDescription_impl() {
        this.setMetaData(new AnalysisEngineMetaData_impl());
        this.setFrameworkImplementation("com.ibm.uima.java");
        OperationalProperties operationalProperties = UIMAFramework.getResourceSpecifierFactory().createOperationalProperties();
        operationalProperties.setModifiesCas(true);
        operationalProperties.setMultipleDeploymentAllowed(true);
        this.getAnalysisEngineMetaData().setOperationalProperties(operationalProperties);
    }

    public String getFrameworkImplementation() {
        return this.mFrameworkImplementation;
    }

    public void setFrameworkImplementation(String string) {
        this.mFrameworkImplementation = string;
    }

    public boolean isPrimitive() {
        return this.mPrimitive;
    }

    public void setPrimitive(boolean bl) {
        this.mPrimitive = bl;
    }

    public String getAnnotatorImplementationName() {
        return this.mAnnotatorImplementationName;
    }

    public void setAnnotatorImplementationName(String string) {
        this.mAnnotatorImplementationName = string;
    }

    public Map getDelegateAnalysisEngineSpecifiers() throws InvalidXMLException {
        this.resolveDelegateAnalysisEngineImports(UIMAFramework.newDefaultResourceManager());
        return Collections.unmodifiableMap(this.mDelegateAnalysisEngineSpecifiers);
    }

    public Map getDelegateAnalysisEngineSpecifiers(ResourceManager resourceManager) throws InvalidXMLException {
        this.resolveDelegateAnalysisEngineImports(resourceManager);
        return Collections.unmodifiableMap(this.mDelegateAnalysisEngineSpecifiers);
    }

    public Map getDelegateAnalysisEngineSpecifiersWithImports() {
        return this.mDelegateAnalysisEngineSpecifiersWithImports;
    }

    public ResourceSpecifier getAsbSpecifier() {
        return this.mAsbSpecifier;
    }

    public void setAsbSpecifier(ResourceSpecifier resourceSpecifier) {
        this.mAsbSpecifier = resourceSpecifier;
    }

    public ResourceSpecifier getSequencerSpecifier() {
        return this.mSequencerSpecifier;
    }

    public void setSequencerSpecifier(ResourceSpecifier resourceSpecifier) {
        this.mSequencerSpecifier = resourceSpecifier;
    }

    public AnalysisEngineMetaData getAnalysisEngineMetaData() {
        return (AnalysisEngineMetaData)this.getMetaData();
    }

    public SofaMapping[] getSofaMappings() {
        return this.mSofaMappings;
    }

    public void setSofaMappings(SofaMapping[] sofaMappingArray) {
        this.mSofaMappings = sofaMappingArray;
    }

    public void doFullValidation() throws ResourceInitializationException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("VERIFICATION_MODE", Boolean.TRUE);
        AnalysisEngine analysisEngine = UIMAFramework.produceAnalysisEngine(this, hashMap);
        this.validateSofaMappings();
        analysisEngine.newCAS();
    }

    public void doFullValidation(ResourceManager resourceManager) throws ResourceInitializationException {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put("VERIFICATION_MODE", Boolean.TRUE);
        AnalysisEngine analysisEngine = UIMAFramework.produceAnalysisEngine((ResourceSpecifier)this, resourceManager, hashMap);
        this.validateSofaMappings();
        analysisEngine.newCAS();
    }

    protected void validateSofaMappings() throws ResourceInitializationException {
        Object object;
        String string;
        Object object2;
        Object object3;
        Cloneable cloneable;
        Object object4;
        int n;
        Map map;
        if (this.isPrimitive()) {
            return;
        }
        try {
            map = this.getDelegateAnalysisEngineSpecifiers();
        }
        catch (InvalidXMLException invalidXMLException) {
            throw new ResourceInitializationException(invalidXMLException);
        }
        String string2 = this.getAnalysisEngineMetaData().getName();
        TreeMap<Capability[], String> treeMap = new TreeMap<Capability[], String>();
        SofaMapping[] sofaMappingArray = this.getSofaMappings();
        if (sofaMappingArray != null) {
            for (n = 0; n < sofaMappingArray.length; ++n) {
                object4 = sofaMappingArray[n].getComponentKey();
                cloneable = (ResourceSpecifier)map.get(object4);
                if (cloneable == null) {
                    throw new ResourceInitializationException("sofa_mapping_has_undefined_component_key", new Object[]{object4, sofaMappingArray[n].getAggregateSofaName(), string2, this.getSourceUrlString()});
                }
                object3 = sofaMappingArray[n].getComponentSofaName();
                if (object3 == null) {
                    object3 = "_DefaultTextSofaName";
                } else if (cloneable instanceof AnalysisEngineDescription && !this.declaresSofa((AnalysisEngineDescription)cloneable, (String)object3)) {
                    throw new ResourceInitializationException("sofa_mapping_has_undefined_component_sofa", new Object[]{object4, object3, sofaMappingArray[n].getAggregateSofaName(), string2, this.getSourceUrlString()});
                }
                object2 = sofaMappingArray[n].getComponentKey() + "@/@" + sofaMappingArray[n].getComponentSofaName();
                string = sofaMappingArray[n].getAggregateSofaName();
                object = (String)treeMap.get(object2);
                if (object != null && !((String)object).equals(string)) {
                    throw new ResourceInitializationException("sofa_mapping_conflict", new Object[]{sofaMappingArray[n].getComponentSofaName(), sofaMappingArray[n].getComponentKey(), string2, object, string, this.getSourceUrlString()});
                }
                treeMap.put((Capability[])object2, string);
            }
        }
        n = 0;
        object4 = new HashSet();
        cloneable = new HashSet();
        object3 = map.entrySet().iterator();
        while (object3.hasNext()) {
            object2 = object3.next();
            string = (String)object2.getKey();
            object = (String[])object2.getValue();
            if (object instanceof AnalysisEngineDescription) {
                Capability[] capabilityArray = ((AnalysisEngineDescription)object).getAnalysisEngineMetaData().getCapabilities();
                for (int i = 0; i < capabilityArray.length; ++i) {
                    String[] stringArray = capabilityArray[i].getOutputSofas();
                    for (int j = 0; j < stringArray.length; ++j) {
                        String string3 = (String)treeMap.get(string + "@/@" + stringArray[j]);
                        if (string3 == null) {
                            string3 = stringArray[j];
                        }
                        if (!this.capabilitiesContainSofa(string3, true)) {
                            throw new ResourceInitializationException("output_sofa_not_declared_in_aggregate", new Object[]{stringArray[j], string, string2, this.getSourceUrlString()});
                        }
                        object4.add(string3);
                    }
                    String[] stringArray2 = capabilityArray[i].getInputSofas();
                    for (int j = 0; j < stringArray2.length; ++j) {
                        String string4 = (String)treeMap.get(string + "@/@" + stringArray2[j]);
                        if (string4 == null) {
                            string4 = stringArray2[j];
                        }
                        if (!this.capabilitiesContainSofa(string4, false) && !this.capabilitiesContainSofa(string4, true)) {
                            throw new ResourceInitializationException("input_sofa_has_no_source", new Object[]{stringArray2[j], string, string2, this.getSourceUrlString()});
                        }
                        cloneable.add(string4);
                    }
                }
                continue;
            }
            n = 1;
        }
        if (n == 0) {
            object2 = this.getAnalysisEngineMetaData().getCapabilities();
            for (int i = 0; i < ((Capability[])object2).length; ++i) {
                int n2;
                object = object2[i].getOutputSofas();
                for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                    if (object4.contains(object[n2])) continue;
                    throw new ResourceInitializationException("aggregate_sofa_not_mapped", new Object[]{object[n2], string2, this.getSourceUrlString()});
                }
                object = object2[i].getInputSofas();
                for (n2 = 0; n2 < ((String[])object).length; ++n2) {
                    if (cloneable.contains(object[n2])) continue;
                    throw new ResourceInitializationException("aggregate_sofa_not_mapped", new Object[]{object[n2], string2, this.getSourceUrlString()});
                }
            }
        }
    }

    private boolean declaresSofa(AnalysisEngineDescription analysisEngineDescription, String string) {
        Capability[] capabilityArray = analysisEngineDescription.getAnalysisEngineMetaData().getCapabilities();
        for (int i = 0; i < capabilityArray.length; ++i) {
            int n;
            String[] stringArray = capabilityArray[i].getOutputSofas();
            for (n = 0; n < stringArray.length; ++n) {
                if (!string.equals(stringArray[n])) continue;
                return true;
            }
            stringArray = capabilityArray[i].getInputSofas();
            for (n = 0; n < stringArray.length; ++n) {
                if (!string.equals(stringArray[n])) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean capabilitiesContainSofa(String string, boolean bl) {
        Capability[] capabilityArray = this.getAnalysisEngineMetaData().getCapabilities();
        for (int i = 0; i < capabilityArray.length; ++i) {
            String[] stringArray = bl ? capabilityArray[i].getOutputSofas() : capabilityArray[i].getInputSofas();
            for (int j = 0; j < stringArray.length; ++j) {
                if (!string.equals(stringArray[j])) continue;
                return true;
            }
        }
        return false;
    }

    public List listAttributes() {
        List list = super.listAttributes();
        list.add(new NameClassPair(this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS, (class$java$util$Map == null ? (class$java$util$Map = AnalysisEngineDescription_impl.class$("java.util.Map")) : class$java$util$Map).getName()));
        return list;
    }

    public void toXML(OutputStream outputStream, boolean bl) throws SAXException, IOException {
        if (bl) {
            Map map = this.mDelegateAnalysisEngineSpecifiers;
            this.mDelegateAnalysisEngineSpecifiers = Collections.EMPTY_MAP;
            this.toXML(outputStream);
            this.mDelegateAnalysisEngineSpecifiers = map;
        } else {
            this.toXML(outputStream);
        }
    }

    public void toXML(Writer writer, boolean bl) throws SAXException, IOException {
        if (bl) {
            Map map = this.mDelegateAnalysisEngineSpecifiers;
            this.mDelegateAnalysisEngineSpecifiers = Collections.EMPTY_MAP;
            this.toXML(writer);
            this.mDelegateAnalysisEngineSpecifiers = map;
        } else {
            this.toXML(writer);
        }
    }

    public void toXML(ContentHandler contentHandler, boolean bl, boolean bl2) throws SAXException {
        if (bl2) {
            Map map = this.mDelegateAnalysisEngineSpecifiers;
            this.mDelegateAnalysisEngineSpecifiers = Collections.EMPTY_MAP;
            this.toXML(contentHandler, bl);
            this.mDelegateAnalysisEngineSpecifiers = map;
        } else {
            this.toXML(contentHandler, bl);
        }
    }

    protected void resolveDelegateAnalysisEngineImports(ResourceManager resourceManager) throws InvalidXMLException {
        Object object;
        Object object2;
        Object object3;
        HashSet<String> hashSet = new HashSet<String>();
        Iterator iterator = this.getDelegateAnalysisEngineSpecifiersWithImports().entrySet().iterator();
        while (iterator.hasNext()) {
            object3 = iterator.next();
            object2 = (String)object3.getKey();
            hashSet.add((String)object2);
            if (object3.getValue() instanceof Import) {
                XMLInputSource xMLInputSource;
                object = (Import)object3.getValue();
                if (object3.getValue().equals(this.mProcessedImports.get(object2))) continue;
                if (object instanceof Import_impl) {
                    ((Import_impl)object).setSourceUrlIfNull(this.getSourceUrl());
                }
                URL uRL = object.findAbsoluteUrl(resourceManager);
                try {
                    xMLInputSource = new XMLInputSource(uRL);
                }
                catch (IOException iOException) {
                    throw new InvalidXMLException("import_failed_could_not_read_from_url", new Object[]{uRL, object.getSourceUrlString()}, iOException);
                }
                ResourceSpecifier resourceSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xMLInputSource);
                this.mDelegateAnalysisEngineSpecifiers.put(object2, resourceSpecifier);
                this.mProcessedImports.put(object2, object);
                continue;
            }
            this.mDelegateAnalysisEngineSpecifiers.put(object3.getKey(), object3.getValue());
        }
        object3 = new ArrayList();
        iterator = this.mDelegateAnalysisEngineSpecifiers.entrySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next().getKey();
            if (hashSet.contains(object2)) continue;
            object3.add(object2);
        }
        object2 = object3.iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            this.mDelegateAnalysisEngineSpecifiers.remove(object);
            this.mProcessedImports.remove(object);
        }
    }

    protected void writePropertyAsElement(PropertyXmlInfo propertyXmlInfo, String string, ContentHandler contentHandler) throws SAXException {
        if (this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS.equals(propertyXmlInfo.propertyName)) {
            String string2 = this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS;
            if (this.mDelegateAnalysisEngineSpecifiers.isEmpty()) {
                string2 = this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS;
            }
            this.writeMapPropertyToXml(string2, this.ELEM_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS, "key", "delegateAnalysisEngine", propertyXmlInfo.omitIfNull, string, contentHandler);
        } else {
            super.writePropertyAsElement(propertyXmlInfo, string, contentHandler);
        }
    }

    protected void readPropertyValueFromXMLElement(PropertyXmlInfo propertyXmlInfo, Element element, XMLParser xMLParser, XMLParser.ParsingOptions parsingOptions) throws InvalidXMLException {
        String string = propertyXmlInfo.propertyName;
        if (this.PROP_DELEGATE_ANALYSIS_ENGINE_SPECIFIERS_WITH_IMPORTS.equals(string)) {
            this.readMapPropertyFromXml(string, element, "key", "delegateAnalysisEngine", xMLParser, parsingOptions, false);
        } else {
            super.readPropertyValueFromXMLElement(propertyXmlInfo, element, xMLParser, parsingOptions);
        }
    }

    public void buildFromXMLElement(Element element, XMLParser xMLParser, XMLParser.ParsingOptions parsingOptions) throws InvalidXMLException {
        super.buildFromXMLElement(element, xMLParser, parsingOptions);
        if (this.getAnalysisEngineMetaData().getOperationalProperties() == null) {
            OperationalProperties operationalProperties = UIMAFramework.getResourceSpecifierFactory().createOperationalProperties();
            operationalProperties.setModifiesCas(true);
            operationalProperties.setMultipleDeploymentAllowed(true);
            this.getAnalysisEngineMetaData().setOperationalProperties(operationalProperties);
        }
    }

    protected XmlizationInfo getXmlizationInfo() {
        return XMLIZATION_INFO;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

