/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.util;

import com.ibm.uima.UIMAException;
import com.ibm.uima.UIMAFramework;
import com.ibm.uima.UIMARuntimeException;
import com.ibm.uima.analysis_engine.AnalysisEngineDescription;
import com.ibm.uima.collection.CasConsumerDescription;
import com.ibm.uima.collection.CasInitializerDescription;
import com.ibm.uima.collection.CollectionReaderDescription;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.util.XMLInputSource;
import com.ibm.uima.util.XMLParser;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;

public class UIMAUtil {
    public static final String ANALYSIS_ENGINE_CTG = "AE";
    public static final String CAS_CONSUMER_CTG = "CC";
    public static final String CAS_INITIALIZER_CTG = "CI";
    public static final String COLLECTION_READER_CTG = "CR";
    public static final String CPE_CONFIGURATION_CTG = "CPE";
    public static final String TYPE_SYSTEM_CTG = "TS";
    public static final String REUSABLE_RESOURCE_CTG = "RR";
    private static Hashtable __errTableByUri = new Hashtable();

    public static Exception getLastErrorForXmlDesc(File file) {
        return (Exception)__errTableByUri.get(file.getAbsolutePath());
    }

    public static Exception getLastErrorForXmlDesc(URL uRL) {
        return (Exception)__errTableByUri.get(uRL.toString());
    }

    public static synchronized String identifyUimaComponentCategory(File file) throws IOException {
        return UIMAUtil.identifyUimaComponentCategory(file, null);
    }

    public static synchronized String identifyUimaComponentCategory(URL uRL) throws IOException {
        return UIMAUtil.identifyUimaComponentCategory(null, uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static synchronized String identifyUimaComponentCategory(File file, URL uRL) throws IOException {
        Object object;
        String string = null;
        XMLInputSource xMLInputSource = null;
        String string2 = file != null ? file.getAbsolutePath() : uRL.toString();
        __errTableByUri.remove(string2);
        XMLParser xMLParser = UIMAFramework.getXMLParser();
        xMLInputSource = file != null ? new XMLInputSource(file) : new XMLInputSource(uRL);
        ResourceSpecifier resourceSpecifier = null;
        try {
            resourceSpecifier = xMLParser.parseResourceSpecifier(xMLInputSource);
        }
        catch (UIMAException uIMAException) {
            __errTableByUri.put(file, uIMAException);
        }
        catch (UIMARuntimeException uIMARuntimeException) {
            __errTableByUri.put(file, uIMARuntimeException);
        }
        if (resourceSpecifier != null) {
            if (resourceSpecifier instanceof AnalysisEngineDescription) {
                string = ANALYSIS_ENGINE_CTG;
            } else if (resourceSpecifier instanceof CollectionReaderDescription) {
                string = COLLECTION_READER_CTG;
            } else if (resourceSpecifier instanceof CasInitializerDescription) {
                string = CAS_INITIALIZER_CTG;
            } else if (resourceSpecifier instanceof CasConsumerDescription) {
                string = CAS_CONSUMER_CTG;
            }
        }
        if (string == null) {
            try {
                xMLInputSource.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            xMLInputSource = file != null ? new XMLInputSource(file) : new XMLInputSource(uRL);
            try {
                object = xMLParser.parseCpeDescription(xMLInputSource);
                string = CPE_CONFIGURATION_CTG;
                __errTableByUri.remove(file);
            }
            catch (UIMAException uIMAException) {
                __errTableByUri.put(file, uIMAException);
            }
            catch (UIMARuntimeException uIMARuntimeException) {
                __errTableByUri.put(file, uIMARuntimeException);
            }
        }
        if (string == null) {
            try {
                xMLInputSource.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            xMLInputSource = file != null ? new XMLInputSource(file) : new XMLInputSource(uRL);
            try {
                object = xMLParser.parseTypeSystemDescription(xMLInputSource);
                string = TYPE_SYSTEM_CTG;
                __errTableByUri.remove(file);
            }
            catch (UIMAException uIMAException) {
                __errTableByUri.put(file, uIMAException);
            }
            catch (UIMARuntimeException uIMARuntimeException) {
                __errTableByUri.put(file, uIMARuntimeException);
            }
        }
        if (string == null) {
            try {
                xMLInputSource.getInputStream().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            xMLInputSource = new XMLInputSource(file);
            try {
                object = xMLParser.parseResourceManagerConfiguration(xMLInputSource);
                string = REUSABLE_RESOURCE_CTG;
                __errTableByUri.remove(file);
            }
            catch (UIMAException uIMAException) {
                __errTableByUri.put(file, uIMAException);
            }
            catch (UIMARuntimeException uIMARuntimeException) {
                __errTableByUri.put(file, uIMARuntimeException);
            }
        }
        Object var9_21 = null;
        if (xMLInputSource == null || xMLInputSource.getInputStream() == null) return string;
        try {
            xMLInputSource.getInputStream().close();
            return string;
        }
        catch (Exception exception) {}
        return string;
        {
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                __errTableByUri.put(file, exception);
                Object var9_22 = null;
                if (xMLInputSource == null) return string;
                if (xMLInputSource.getInputStream() == null) return string;
                try {
                    xMLInputSource.getInputStream().close();
                    return string;
                }
                catch (Exception exception2) {}
                return string;
            }
        }
        catch (Throwable throwable) {
            Object var9_23 = null;
            if (xMLInputSource == null || xMLInputSource.getInputStream() == null) throw throwable;
            try {
                xMLInputSource.getInputStream().close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }
}

