/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.util;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;

public class ProcessUtil {

    public static class Runner
    implements Runnable {
        private static final String DEF_PROC_NAME = "Process_";
        private static int __processNumber = 0;
        private Process _process;
        private String _pName;
        private Thread _errThread;
        private Thread _outThread;
        private StringWriter _stdOut;
        private StringWriter _stdErr;
        private int _exitCode = Integer.MAX_VALUE;
        private boolean _printToConsole = true;
        private ArrayList _listeners = new ArrayList();

        public Runner(Process process) {
            this(process, null);
        }

        public Runner(Process process, String string) {
            this(process, string, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Runner(Process process, String string, boolean bl) {
            Class<?> clazz = this.getClass();
            synchronized (clazz) {
            }
            this._process = process;
            this._pName = string != null ? string : DEF_PROC_NAME + Integer.toString(++__processNumber);
            this._errThread = new Thread((Runnable)this, "ERR@Runner");
            this._outThread = new Thread((Runnable)this, "OUT@Runner");
            this._stdOut = new StringWriter();
            this._stdErr = new StringWriter();
            this._printToConsole = bl;
            this.start();
        }

        public synchronized void addStreamListener(StdStreamListener stdStreamListener) {
            if (!this._listeners.contains(stdStreamListener)) {
                String string;
                String string2 = this._stdErr.toString();
                if (string2.length() > 0) {
                    stdStreamListener.errMsgPrinted(string2);
                }
                if ((string = this._stdOut.toString()).length() > 0) {
                    stdStreamListener.outMsgPrinted(string);
                }
                this._listeners.add(stdStreamListener);
            }
        }

        public synchronized int getExitCode() {
            return this._exitCode;
        }

        public synchronized String getErrOutput() {
            return this._stdErr.toString();
        }

        public Process getProcess() {
            return this._process;
        }

        public synchronized String getStdOutput() {
            return this._stdOut.toString();
        }

        public synchronized void removeListener(StdStreamListener stdStreamListener) {
            this._listeners.remove(stdStreamListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            Object object;
            block31: {
                Exception exception2222;
                PrintWriter printWriter;
                BufferedReader bufferedReader;
                String string;
                block29: {
                    block28: {
                        string = Thread.currentThread().getName();
                        String string2 = string.substring(0, 3);
                        bufferedReader = null;
                        printWriter = null;
                        bufferedReader = string2.equals("ERR") ? new BufferedReader(new InputStreamReader(this._process.getErrorStream())) : new BufferedReader(new InputStreamReader(this._process.getInputStream()));
                        object = string2.equals("ERR") ? this._stdErr : this._stdOut;
                        printWriter = new PrintWriter((Writer)object);
                        PrintStream printStream = string2.equals("ERR") ? System.err : System.out;
                        String string3 = null;
                        while ((string3 = bufferedReader.readLine()) != null) {
                            if (this._printToConsole) {
                                printStream.println("[" + this._pName + ":" + string2 + "] " + string3);
                            }
                            Runner runner = this;
                            synchronized (runner) {
                                int n = ((StringWriter)object).getBuffer().length();
                                printWriter.println(string3);
                                String string4 = ((StringWriter)object).getBuffer().substring(n);
                                Iterator iterator = this._listeners.iterator();
                                while (string4.length() > 0 && iterator.hasNext()) {
                                    StdStreamListener stdStreamListener = (StdStreamListener)iterator.next();
                                    if (string2.equals("ERR")) {
                                        stdStreamListener.errMsgPrinted(string4);
                                        continue;
                                    }
                                    stdStreamListener.outMsgPrinted(string4);
                                }
                            }
                        }
                        int n = this._process.waitFor();
                        this.setExitCode(n);
                        if (!this._printToConsole) break block28;
                        System.out.println("[" + this._pName + " " + string + "]: completed (rc = " + n + ")");
                    }
                    Object var15_16 = null;
                    if (bufferedReader == null) break block29;
                    try {
                        bufferedReader.close();
                    }
                    catch (Exception exception2222) {
                        // empty catch block
                    }
                }
                if (printWriter != null) {
                    try {
                        printWriter.close();
                    }
                    catch (Exception exception2222) {}
                }
                break block31;
                {
                    catch (Throwable throwable) {
                        Exception exception32222;
                        if (this._printToConsole) {
                            System.err.println("[" + this._pName + " " + string + "]: terminated - " + throwable.toString());
                        }
                        Object var15_17 = null;
                        if (bufferedReader != null) {
                            try {
                                bufferedReader.close();
                            }
                            catch (Exception exception32222) {
                                // empty catch block
                            }
                        }
                        if (printWriter != null) {
                            try {
                                printWriter.close();
                            }
                            catch (Exception exception32222) {}
                        }
                    }
                }
                catch (Throwable throwable) {
                    Exception exception42222;
                    Object var15_18 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception42222) {
                            // empty catch block
                        }
                    }
                    if (printWriter != null) {
                        try {
                            printWriter.close();
                        }
                        catch (Exception exception42222) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
        }

        private synchronized void setExitCode(int n) {
            this._exitCode = n;
        }

        private void start() {
            this._errThread.start();
            this._outThread.start();
        }

        public int waitFor() {
            return this.waitFor(0L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int waitFor(long l) {
            Runner runner = this;
            synchronized (runner) {
                if (this.getExitCode() == Integer.MAX_VALUE) {
                    try {
                        this.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            return this.getExitCode();
        }
    }

    public static interface StdStreamListener {
        public void errMsgPrinted(String var1);

        public void outMsgPrinted(String var1);
    }
}

