/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Iterator;

public class MessageRouter
implements Runnable {
    private static final String OUT_MSG_ID = "OUT";
    private static final String ERR_MSG_ID = "ERR";
    private static final long WAITING_TIME = 5L;
    private StringWriter _errStream;
    private StringBuffer _errBuffer;
    private PrintWriter _errWriter;
    private int _errOffset;
    private StringWriter _outStream;
    private StringBuffer _outBuffer;
    private PrintWriter _outWriter;
    private int _outOffset;
    private boolean _terminated = false;
    private Thread _thread;
    private ArrayList _stdHistory = new ArrayList();
    private ArrayList _stdListeners = new ArrayList();

    public MessageRouter() {
        this._errStream = new StringWriter();
        this._errBuffer = this._errStream.getBuffer();
        this._errWriter = new PrintWriter(this._errStream);
        this._errOffset = this._errBuffer.length();
        this._outStream = new StringWriter();
        this._outBuffer = this._outStream.getBuffer();
        this._outWriter = new PrintWriter(this._outStream);
        this._outOffset = this._outBuffer.length();
        this._thread = new Thread((Runnable)this, "MessageRouter");
    }

    public synchronized void addChannelListener(StdChannelListener stdChannelListener) {
        if (!this._stdListeners.contains(stdChannelListener)) {
            if (this._stdHistory.size() > 0) {
                Iterator iterator = this._stdHistory.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    String string2 = string.substring(4);
                    if (string.startsWith(ERR_MSG_ID)) {
                        stdChannelListener.errMsgPosted(string2);
                        continue;
                    }
                    stdChannelListener.outMsgPosted(string2);
                }
            }
            this._stdListeners.add(stdChannelListener);
        }
    }

    public int countStdChannelListeners() {
        return this._stdListeners.size();
    }

    public boolean isRunning() {
        return this._thread.isAlive();
    }

    public synchronized void removeChannelListener(StdChannelListener stdChannelListener) {
        this._stdListeners.remove(stdChannelListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        String string = null;
        String string2 = null;
        while (!bl) {
            Object object = this._errStream;
            synchronized (object) {
                if (this._errBuffer.length() > this._errOffset) {
                    string = this._errBuffer.substring(this._errOffset);
                    this._errOffset = this._errBuffer.length();
                }
            }
            object = this._outStream;
            synchronized (object) {
                if (this._outBuffer.length() > this._outOffset) {
                    string2 = this._outBuffer.substring(this._outOffset);
                    this._outOffset = this._outBuffer.length();
                }
            }
            object = this;
            synchronized (object) {
                if (string != null || string2 != null) {
                    if (string != null) {
                        this._stdHistory.add("ERR^" + string);
                    }
                    if (string2 != null) {
                        this._stdHistory.add("OUT^" + string2);
                    }
                    Iterator iterator = this._stdListeners.iterator();
                    while (iterator.hasNext()) {
                        StdChannelListener stdChannelListener = (StdChannelListener)iterator.next();
                        if (string != null) {
                            stdChannelListener.errMsgPosted(string);
                        }
                        if (string2 == null) continue;
                        stdChannelListener.outMsgPosted(string2);
                    }
                    string = null;
                    string2 = null;
                }
                bl = this._terminated;
            }
            if (bl) continue;
            try {
                Thread.sleep(5L);
            }
            catch (Exception exception) {}
        }
    }

    public PrintWriter errWriter() {
        return this._errWriter;
    }

    public PrintWriter outWriter() {
        return this._outWriter;
    }

    public void start() {
        this._thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        this._errWriter.flush();
        this._outWriter.flush();
        MessageRouter messageRouter = this;
        synchronized (messageRouter) {
            this._terminated = true;
        }
        try {
            this._thread.join();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static interface StdChannelListener {
        public void errMsgPosted(String var1);

        public void outMsgPosted(String var1);
    }
}

