/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.util;

import com.ibm.uima.pear.util.StringUtil;
import com.ibm.uima.pear.util.XMLUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileUtil {
    public static int cleanUpDirectoryContent(File file) throws IOException {
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (file2.isDirectory()) {
                    n += FileUtil.cleanUpDirectoryContent(file2);
                    if (file2.delete()) {
                        ++n;
                        continue;
                    }
                    file2.deleteOnExit();
                    continue;
                }
                if (!file2.isFile()) continue;
                if (file2.delete()) {
                    ++n;
                    continue;
                }
                file2.deleteOnExit();
            }
        }
        return n;
    }

    public static int cleanUpDirectoryFiles(File file) throws IOException {
        int n = 0;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (!file2.isFile()) continue;
                if (file2.delete()) {
                    ++n;
                    continue;
                }
                file2.deleteOnExit();
            }
        }
        return n;
    }

    public static int cleanUpDirectoryFiles(File file, int n) throws IOException {
        int n2 = 0;
        Collection collection = FileUtil.createFileList(file, false);
        SortedSet sortedSet = FileUtil.sortFileListByTime(collection);
        if (sortedSet.size() > n) {
            Iterator iterator = sortedSet.iterator();
            int n3 = 0;
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (++n3 <= n) continue;
                if (file2.delete()) {
                    ++n2;
                    continue;
                }
                file2.deleteOnExit();
            }
        }
        return n2;
    }

    public static String computeRelativePath(File file, File file2) throws IOException {
        String string = file.getCanonicalPath().replace('\\', '/');
        String string2 = file2.getCanonicalPath().replace('\\', '/');
        StringBuffer stringBuffer = new StringBuffer();
        while (string != null && !string2.startsWith(string)) {
            stringBuffer.append("../");
            if ((string = new File(string).getParent()) == null) continue;
            string = string.replace('\\', '/');
        }
        if (string != null) {
            String string3 = string2.substring(string.length());
            if (stringBuffer.length() == 0) {
                stringBuffer.append("./");
            }
            if (string3.startsWith("/")) {
                stringBuffer.append(string3.substring(1));
            } else {
                stringBuffer.append(string3);
            }
            return stringBuffer.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(File file, File file2) throws IOException {
        Exception exception3;
        FilterOutputStream filterOutputStream;
        boolean bl;
        block12: {
            bl = false;
            BufferedInputStream bufferedInputStream = null;
            filterOutputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[4096];
                int n = 0;
                while ((n = bufferedInputStream.read(byArray)) > 0) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                }
                bufferedInputStream.close();
                filterOutputStream.close();
                bl = true;
                Object var8_7 = null;
                if (bufferedInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var8_8 = null;
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (filterOutputStream != null) {
            try {
                filterOutputStream.close();
            }
            catch (Exception exception3) {}
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean copyFile(URL uRL, File file) throws IOException {
        Exception exception3;
        FilterOutputStream filterOutputStream;
        boolean bl;
        block12: {
            bl = false;
            BufferedInputStream bufferedInputStream = null;
            filterOutputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(uRL.openStream());
                filterOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                byte[] byArray = new byte[4096];
                int n = 0;
                while ((n = bufferedInputStream.read(byArray)) > 0) {
                    ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                }
                bufferedInputStream.close();
                filterOutputStream.close();
                bl = true;
                Object var8_7 = null;
                if (bufferedInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var8_8 = null;
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                bufferedInputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (filterOutputStream != null) {
            try {
                filterOutputStream.close();
            }
            catch (Exception exception3) {}
        }
        return bl;
    }

    public static Collection createDirList(File file) throws IOException {
        return FileUtil.createDirList(file, true);
    }

    public static Collection createDirList(File file, boolean bl) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new FileNotFoundException("invalid directory specified");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (!file2.isDirectory()) continue;
            arrayList.add(file2);
            if (!bl) continue;
            arrayList.addAll(FileUtil.createDirList(file2, bl));
        }
        return arrayList;
    }

    public static Collection createDirList(JarFile jarFile) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = jarFile.getName().lastIndexOf(46);
        String string = n > 0 ? jarFile.getName().substring(0, n) : jarFile.getName();
        File file = new File(string);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            File file2 = new File(file, jarEntry.getName());
            if (jarEntry.isDirectory()) {
                arrayList.add(file2);
                continue;
            }
            File file3 = file2.getParentFile();
            while (!file3.equals(file)) {
                if (!arrayList.contains(file3)) {
                    arrayList.add(file3);
                }
                file3 = file3.getParentFile();
            }
        }
        return arrayList;
    }

    public static Collection createFileList(File file) throws IOException {
        return FileUtil.createFileList(file, true);
    }

    public static Collection createFileList(File file, boolean bl) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            throw new FileNotFoundException("invalid directory specified");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory() && bl) {
                arrayList.addAll(FileUtil.createFileList(file2, bl));
                continue;
            }
            if (file2.isDirectory()) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    public static Collection createFileList(JarFile jarFile) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = jarFile.getName().lastIndexOf(46);
        String string = n > 0 ? jarFile.getName().substring(0, n) : jarFile.getName();
        File file = new File(string);
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            JarEntry jarEntry = enumeration.nextElement();
            File file2 = new File(file, jarEntry.getName());
            if (jarEntry.isDirectory()) continue;
            arrayList.add(file2);
        }
        return arrayList;
    }

    public static File createTempFile(String string, String string2) throws IOException {
        String string3 = System.getProperty("java.io.tmpdir");
        if (string3 == null) {
            string3 = System.getProperty("user.home");
        }
        if (string3 == null) {
            throw new IOException("could not find temporary directory");
        }
        File file = new File(string3);
        if (!file.isDirectory()) {
            throw new IOException("temporary directory not available");
        }
        return File.createTempFile(string, string2, file);
    }

    public static boolean deleteDirectory(File file) throws IOException {
        boolean bl = true;
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                bl = FileUtil.deleteDirectory(file2);
                continue;
            }
            if (file2.delete()) continue;
            file2.deleteOnExit();
            bl = false;
        }
        if (!file.delete()) {
            file.deleteOnExit();
            bl = false;
        }
        return bl;
    }

    public static long extractDirectoryFromJar(JarFile jarFile, String string, File file) throws IOException {
        return FileUtil.extractFilesFromJar(jarFile, file, new DirFileFilter(string, null));
    }

    public static long extractFilesWithExtFromJar(JarFile jarFile, String string, File file) throws IOException {
        return FileUtil.extractFilesFromJar(jarFile, file, new DirFileFilter(null, string));
    }

    public static long extractFilesFromJar(JarFile jarFile, File file) throws IOException {
        return FileUtil.extractFilesFromJar(jarFile, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long extractFilesFromJar(JarFile jarFile, File file, FileFilter fileFilter) throws IOException {
        long l = 0L;
        byte[] byArray = new byte[4096];
        Enumeration<JarEntry> enumeration = jarFile.entries();
        while (enumeration.hasMoreElements()) {
            Exception exception2;
            FilterOutputStream filterOutputStream;
            block13: {
                Object var14_12;
                JarEntry jarEntry = enumeration.nextElement();
                if (jarEntry.isDirectory() || fileFilter != null && !fileFilter.accept(new File(jarEntry.getName()))) continue;
                File file2 = new File(file, jarEntry.getName());
                File file3 = file2.getParentFile();
                if (!file3.exists() && !file3.mkdirs()) {
                    throw new IOException("could not create directory " + file3.getAbsolutePath());
                }
                BufferedInputStream bufferedInputStream = null;
                filterOutputStream = null;
                try {
                    bufferedInputStream = new BufferedInputStream(jarFile.getInputStream(jarEntry));
                    filterOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
                    int n = 0;
                    while ((n = bufferedInputStream.read(byArray)) > 0) {
                        l += (long)n;
                        ((BufferedOutputStream)filterOutputStream).write(byArray, 0, n);
                    }
                    bufferedInputStream.close();
                    filterOutputStream.close();
                    var14_12 = null;
                    if (bufferedInputStream == null) break block13;
                }
                catch (Throwable throwable) {
                    var14_12 = null;
                    if (bufferedInputStream != null) {
                        try {
                            bufferedInputStream.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    if (filterOutputStream != null) {
                        try {
                            filterOutputStream.close();
                        }
                        catch (Exception exception2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            if (filterOutputStream == null) continue;
            try {
                filterOutputStream.close();
            }
            catch (Exception exception2) {}
        }
        return l;
    }

    public static String getAbsolutePath(File file, String string) {
        File file2 = new File(file, string);
        return file2.getAbsolutePath();
    }

    public static String getFileNameExtension(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.lastIndexOf(46);
        if (n > 0) {
            char c;
            stringBuffer.append('.');
            for (int i = n + 1; i < string.length() && Character.isLetterOrDigit(c = string.charAt(i)); ++i) {
                stringBuffer.append(c);
            }
        }
        return stringBuffer.toString();
    }

    public static long getFileSize(String string) {
        long l = 0L;
        File file = new File(string);
        if (file.isFile()) {
            l = file.length();
        } else {
            try {
                URL uRL = new URL(string);
                URLConnection uRLConnection = uRL.openConnection();
                l = uRLConnection.getContentLength();
            }
            catch (IOException iOException) {
                l = -1L;
            }
        }
        return l;
    }

    public static String getRelativePath(File file, String string) {
        String string2 = file.getAbsolutePath().replace('\\', '/');
        String string3 = string.replace('\\', '/');
        if (string3.startsWith(string2)) {
            string3 = string3.substring(string2.length());
        }
        if (string3.startsWith("/")) {
            string3 = string3.substring(1);
        }
        return string3;
    }

    public static String identifyUtfSignature(int[] nArray, int n) {
        String string = null;
        if (n == 3) {
            if (nArray[0] == 239 && nArray[1] == 187 && nArray[2] == 191) {
                string = "UTF-8";
            }
        } else if (n == 2) {
            if (nArray[0] == 254 && nArray[1] == 255) {
                string = "UTF-16BE";
            } else if (nArray[0] == 255 && nArray[1] == 254) {
                string = "UTF-16LE";
            }
        } else if (n == 4) {
            if (nArray[0] == 0 && nArray[1] == 0 && nArray[2] == 254 && nArray[3] == 255) {
                string = "UTF-32BE";
            } else if (nArray[0] == 255 && nArray[1] == 254 && nArray[2] == 0 && nArray[3] == 0) {
                string = "UTF-32LE";
            }
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAsciiFile(File file) throws IOException {
        boolean bl = true;
        FileInputStream fileInputStream = null;
        try {
            try {
                fileInputStream = new FileInputStream(file);
                bl = FileUtil.isAsciiStream(fileInputStream);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                bl = false;
                throw iOException;
            }
            Object var5_3 = null;
            if (fileInputStream == null) return bl;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        fileInputStream.close();
        return bl;
    }

    public static boolean isAsciiStream(InputStream inputStream) throws IOException {
        boolean bl = true;
        try {
            int n = 0;
            while ((n = inputStream.read()) >= 0) {
                if (n <= 127) continue;
                bl = false;
                break;
            }
        }
        catch (IOException iOException) {
            bl = false;
            throw iOException;
        }
        return bl;
    }

    public static String[] loadListOfStrings(BufferedReader bufferedReader) throws IOException {
        String[] stringArray = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        while ((string = bufferedReader.readLine()) != null) {
            String string2 = string.trim();
            if (string2.length() <= 0) continue;
            arrayList.add(string2);
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray != null ? stringArray : new String[]{};
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] loadListOfStrings(File file) throws IOException {
        String[] stringArray;
        String[] stringArray2;
        block8: {
            BufferedReader bufferedReader = null;
            stringArray2 = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                stringArray2 = FileUtil.loadListOfStrings(bufferedReader);
                Object var5_3 = null;
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            bufferedReader.close();
        }
        if (stringArray2 != null) {
            stringArray = stringArray2;
            return stringArray;
        }
        stringArray = new String[]{};
        return stringArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String[] loadListOfStrings(URL uRL) throws IOException {
        String[] stringArray;
        String[] stringArray2;
        block8: {
            URLConnection uRLConnection = uRL.openConnection();
            BufferedReader bufferedReader = null;
            stringArray2 = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
                stringArray2 = FileUtil.loadListOfStrings(bufferedReader);
                Object var6_4 = null;
                if (bufferedReader == null) break block8;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                if (bufferedReader == null) throw throwable;
                try {
                    bufferedReader.close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            bufferedReader.close();
        }
        if (stringArray2 != null) {
            stringArray = stringArray2;
            return stringArray;
        }
        stringArray = new String[]{};
        return stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Properties loadPropertiesFromJar(String string, JarFile jarFile) throws IOException {
        Properties properties = null;
        String string2 = string.replace('\\', '/');
        JarEntry jarEntry = jarFile.getJarEntry(string2);
        if (jarEntry == null) return properties;
        InputStream inputStream = null;
        try {
            inputStream = jarFile.getInputStream(jarEntry);
            properties = new Properties();
            properties.load(inputStream);
            Object var7_6 = null;
            if (inputStream == null) return properties;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (inputStream == null) throw throwable;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            inputStream.close();
            return properties;
        }
        catch (Exception exception) {}
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadTextFile(BufferedReader bufferedReader) throws IOException {
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            printWriter.flush();
            Object var5_5 = null;
            if (printWriter == null) return stringWriter.toString();
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (printWriter == null) throw throwable;
            try {
                printWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        printWriter.close();
        return stringWriter.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadTextFile(File file) throws IOException {
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            bufferedReader = new BufferedReader(new FileReader(file));
            string = FileUtil.loadTextFile(bufferedReader);
            Object var5_3 = null;
            if (bufferedReader == null) return string;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadTextFile(File file, String string) throws IOException {
        BufferedReader bufferedReader = null;
        String string2 = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), string));
            string2 = FileUtil.loadTextFile(bufferedReader);
            Object var6_4 = null;
            if (bufferedReader == null) return string2;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        return string2;
    }

    public static String loadTextFile(URL uRL) throws IOException {
        URLConnection uRLConnection = uRL.openConnection();
        return FileUtil.loadTextFile(uRLConnection);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String loadTextFile(URLConnection uRLConnection) throws IOException {
        BufferedReader bufferedReader = null;
        String string = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));
            string = FileUtil.loadTextFile(bufferedReader);
            Object var5_3 = null;
            if (bufferedReader == null) return string;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        bufferedReader.close();
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String loadTextFileFromJar(String string, JarFile jarFile) throws IOException {
        String string2 = null;
        String string3 = string.replace('\\', '/');
        JarEntry jarEntry = jarFile.getJarEntry(string3);
        if (jarEntry == null) return string2;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader(jarFile.getInputStream(jarEntry)));
            string2 = FileUtil.loadTextFile(bufferedReader);
            Object var7_6 = null;
            if (bufferedReader == null) return string2;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return string2;
        }
        catch (Exception exception) {}
        return string2;
    }

    public static String localPathToFileUrl(String string) {
        File file = new File(string);
        String string2 = file.getAbsolutePath().replace('\\', '/');
        StringBuffer stringBuffer = new StringBuffer("file:///");
        stringBuffer.append(string2.replace(':', '|'));
        String string3 = stringBuffer.toString().replaceAll(" ", "%20");
        URL uRL = null;
        try {
            uRL = new URL(string3);
        }
        catch (MalformedURLException malformedURLException) {
            uRL = null;
        }
        return uRL != null ? uRL.toExternalForm() : string3;
    }

    public static boolean moveFile(File file, File file2) throws IOException {
        boolean bl = false;
        File file3 = new File(file2, file.getName());
        if (file3.exists()) {
            file3.delete();
        }
        if (FileUtil.copyFile(file, file3)) {
            bl = file.delete();
        }
        return bl;
    }

    /*
     * Loose catch block
     */
    public static int replaceStringInFile(File file, String string, String string2) throws IOException {
        int n;
        block28: {
            Exception exception2222;
            File file2;
            boolean bl;
            PrintStream printStream;
            BufferedReader bufferedReader;
            block26: {
                String string3;
                String string4;
                n = 0;
                String string5 = "ASCII";
                int n2 = file.getName().lastIndexOf(46);
                String string6 = string4 = n2 > 0 ? file.getName().substring(n2) : null;
                if (".xml".equalsIgnoreCase(string4)) {
                    string3 = XMLUtil.detectXmlFileEncoding(file);
                    if (string3 != null) {
                        string5 = string3;
                    } else {
                        throw new UnsupportedEncodingException("can't detect encoding in " + file.getAbsolutePath());
                    }
                }
                string3 = FileUtil.loadTextFile(file, string5);
                bufferedReader = null;
                printStream = null;
                bl = false;
                file2 = null;
                Pattern pattern = Pattern.compile(string);
                String string7 = StringUtil.toRegExpReplacement(string2);
                file2 = new File(file.getAbsolutePath() + ".bak");
                if (file2.exists()) {
                    file2.delete();
                }
                if (!file.renameTo(file2)) {
                    throw new IOException("can't save backup copy of " + file.getAbsolutePath());
                }
                bufferedReader = new BufferedReader(new StringReader(string3));
                printStream = new PrintStream((OutputStream)new FileOutputStream(file), true, string5);
                String string8 = null;
                while ((string8 = bufferedReader.readLine()) != null) {
                    Matcher matcher = pattern.matcher(string8);
                    while (matcher.find()) {
                        ++n;
                    }
                    String string9 = string8.replaceAll(string, string7);
                    printStream.println(string9);
                }
                printStream.close();
                bl = true;
                Object var18_19 = null;
                if (bufferedReader == null) break block26;
                try {
                    bufferedReader.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (printStream != null) {
                try {
                    printStream.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (bl) {
                file2.delete();
            } else {
                file.delete();
                file2.renameTo(file);
                {
                    break block28;
                    catch (IOException iOException) {
                        throw iOException;
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof IOException) {
                            throw new IOException(throwable.toString() + " in " + file.getAbsolutePath());
                        }
                        throw new RuntimeException(throwable.toString() + " in " + file.getAbsolutePath());
                    }
                }
                catch (Throwable throwable) {
                    Exception exception32222;
                    Object var18_20 = null;
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (Exception exception32222) {
                            // empty catch block
                        }
                    }
                    if (printStream != null) {
                        try {
                            printStream.close();
                        }
                        catch (Exception exception32222) {
                            // empty catch block
                        }
                    }
                    if (bl) {
                        file2.delete();
                    } else {
                        file.delete();
                        file2.renameTo(file);
                    }
                    throw throwable;
                }
            }
        }
        return n;
    }

    public static SortedSet sortFileListByTime(Collection collection) {
        TreeSet treeSet = new TreeSet(new FileTimeComparator());
        treeSet.addAll(collection);
        return treeSet;
    }

    public static File zipDirectory(File file) throws IOException {
        String string = file.getName() + ".zip";
        File file2 = new File(file, string);
        return FileUtil.zipDirectory(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File zipDirectory(File file, File file2) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
            File[] fileArray = new File[]{file2};
            FileUtil.zipDirectory(file, zipOutputStream, file, fileArray);
            Object var5_4 = null;
            if (zipOutputStream == null) return file2;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (zipOutputStream == null) throw throwable;
            try {
                zipOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            zipOutputStream.close();
            return file2;
        }
        catch (Exception exception) {}
        return file2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ZipOutputStream zipDirectory(File file, ZipOutputStream zipOutputStream, File file2, File[] fileArray) throws IOException {
        byte[] byArray = new byte[4096];
        int n = 0;
        FileInputStream fileInputStream = null;
        try {
            File[] fileArray2 = file.listFiles();
            for (int i = 0; i < fileArray2.length; ++i) {
                File file3 = fileArray2[i];
                boolean bl = false;
                for (int j = 0; j < fileArray.length; ++j) {
                    if (!file3.equals(fileArray[j])) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                if (file3.isFile()) {
                    fileInputStream = new FileInputStream(file3);
                    String string = file2 != null ? FileUtil.getRelativePath(file2, file3.getAbsolutePath()) : FileUtil.getRelativePath(file, file3.getAbsolutePath());
                    ZipEntry zipEntry = new ZipEntry(string);
                    zipOutputStream.putNextEntry(zipEntry);
                    while ((n = fileInputStream.read(byArray)) > 0) {
                        zipOutputStream.write(byArray, 0, n);
                    }
                    fileInputStream.close();
                    continue;
                }
                if (!file3.isDirectory()) continue;
                FileUtil.zipDirectory(file3, zipOutputStream, file2, fileArray);
            }
            Object var14_14 = null;
            if (fileInputStream == null) return zipOutputStream;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            fileInputStream.close();
            return zipOutputStream;
        }
        catch (Exception exception) {}
        return zipOutputStream;
    }

    public static File zipFile(File file) throws IOException {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        string = n >= 0 ? string.substring(0, n) + ".zip" : string + ".zip";
        File file2 = new File(file.getParentFile(), string);
        return FileUtil.zipFile(file, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File zipFile(File file, File file2) throws IOException {
        Exception exception3;
        ZipOutputStream zipOutputStream;
        block12: {
            byte[] byArray = new byte[4096];
            int n = 0;
            FileInputStream fileInputStream = null;
            zipOutputStream = null;
            try {
                fileInputStream = new FileInputStream(file);
                ZipEntry zipEntry = new ZipEntry(file.getName());
                zipOutputStream = new ZipOutputStream(new FileOutputStream(file2));
                zipOutputStream.putNextEntry(zipEntry);
                while ((n = fileInputStream.read(byArray)) > 0) {
                    zipOutputStream.write(byArray, 0, n);
                }
                Object var8_7 = null;
                if (fileInputStream == null) break block12;
            }
            catch (Throwable throwable) {
                Exception exception22;
                Object var8_8 = null;
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (Exception exception22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
            try {
                fileInputStream.close();
            }
            catch (Exception exception3) {
                // empty catch block
            }
        }
        if (zipOutputStream != null) {
            try {
                zipOutputStream.close();
            }
            catch (Exception exception3) {}
        }
        return file2;
    }

    public static class ExtFilenameFilter
    implements FilenameFilter {
        private String _fileExt;
        private boolean _ignoreCase;

        public ExtFilenameFilter(String string) {
            this(string, true);
        }

        public ExtFilenameFilter(String string, boolean bl) {
            this._fileExt = string.startsWith(".") ? string : "." + string;
            this._ignoreCase = bl;
            if (bl) {
                this._fileExt = this._fileExt.toLowerCase();
            }
        }

        public boolean accept(File file, String string) {
            String string2 = this._ignoreCase ? string.toLowerCase() : string;
            return string2.endsWith(this._fileExt);
        }
    }

    public static class NameFileFilter
    implements FileFilter {
        private String _fileName;

        public NameFileFilter(String string) {
            this._fileName = string.replace('\\', '/');
        }

        public boolean accept(File file) {
            String string = file.getAbsolutePath().replace('\\', '/');
            if (string.endsWith(this._fileName)) {
                if (string.length() > this._fileName.length()) {
                    char c = string.charAt(string.length() - this._fileName.length() - 1);
                    if (c == ':' || c == '/') {
                        return true;
                    }
                } else {
                    return true;
                }
            }
            return false;
        }
    }

    public static class DirFileFilter
    implements FileFilter {
        private String _dirPath;
        private String _fileExt;

        public DirFileFilter(String string, String string2) {
            String string3 = this._dirPath = string != null ? string.replace('\\', '/') : null;
            this._fileExt = string2 != null ? (string2.startsWith(".") ? string2.toLowerCase() : "." + string2.toLowerCase()) : null;
        }

        public boolean accept(File file) {
            boolean bl = true;
            boolean bl2 = true;
            if (this._dirPath != null) {
                String string = file.getParent();
                boolean bl3 = bl = string != null && string.replace('\\', '/').startsWith(this._dirPath);
            }
            if (this._fileExt != null) {
                bl2 = file.getPath().toLowerCase().endsWith(this._fileExt);
            }
            return bl && bl2;
        }
    }

    public static class FileTimeComparator
    implements Comparator {
        public int compare(Object object, Object object2) throws ClassCastException {
            long l;
            if (!(object instanceof File) || !(object2 instanceof File)) {
                throw new ClassCastException("invalid object type");
            }
            long l2 = ((File)object).lastModified();
            return l2 >= (l = ((File)object2).lastModified()) ? -1 : 1;
        }

        public boolean equals(Object object) {
            return object instanceof FileTimeComparator;
        }
    }
}

