/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.tools;

import com.ibm.uima.pear.tools.InstallationController;
import com.ibm.uima.pear.util.FileUtil;
import java.io.File;
import java.net.URL;
import java.util.prefs.Preferences;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public class PackageSelectorGUI
implements InstallationController.PackageSelector {
    private static final String LAST_PACKAGE_DIR_KEY = "last_package_dir";
    private static final String LAST_PACKAGE_FILE_KEY = "last_package_file";
    private JFrame _dialogFrame = new JFrame();

    public PackageSelectorGUI() {
        this._dialogFrame.setDefaultCloseOperation(0);
    }

    public synchronized File selectPackageDirectory(String string) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String string2 = preferences != null ? preferences.get(LAST_PACKAGE_DIR_KEY, "./") : "./";
        File file = new File(string2);
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new PackageDirFilter());
        jFileChooser.setCurrentDirectory(file);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Select " + string + " root directory");
        String string3 = "Select the root directory of installed\n\n" + string + "\n" + "\ncomponent using the following file dialog,\n" + "or press 'Cancel' in the file dialog, if this\n" + "component is not installed in your file system.";
        JOptionPane.showMessageDialog(this._dialogFrame, string3);
        File file2 = null;
        int n = jFileChooser.showDialog(this._dialogFrame, "Select");
        if (n == 0 && (file2 = jFileChooser.getSelectedFile()) != null) {
            file = file2.getParentFile();
            preferences.put(LAST_PACKAGE_DIR_KEY, file.getAbsolutePath());
        }
        return file2;
    }

    public synchronized File selectPackageFile(String string) {
        Preferences preferences = Preferences.userNodeForPackage(this.getClass());
        String string2 = preferences != null ? preferences.get(LAST_PACKAGE_FILE_KEY, "") : "";
        File file = string2.length() > 0 ? new File(string2) : null;
        File file2 = file != null ? file.getParentFile() : new File(".");
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.addChoosableFileFilter(new PackageFileFilter());
        jFileChooser.setCurrentDirectory(file2);
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogTitle("Select " + string + " PEAR file");
        String string3 = "Select the PEAR file of the\n\n" + string + "\n" + "\ncomponent using the following file dialog.";
        JOptionPane.showMessageDialog(this._dialogFrame, string3);
        File file3 = null;
        int n = jFileChooser.showDialog(this._dialogFrame, "Select");
        if (n == 0 && (file3 = jFileChooser.getSelectedFile()) != null) {
            preferences.put(LAST_PACKAGE_FILE_KEY, file3.getAbsolutePath());
        }
        return file3;
    }

    public URL selectPackageUrl(String string) {
        return null;
    }

    public static class PackageFileFilter
    extends FileFilter {
        private static final String TEAR_EXT = ".tear";
        private static final String PEAR_EXT = ".pear";

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = FileUtil.getFileNameExtension(file.getName()).toLowerCase();
            return string.equals(TEAR_EXT) || string.equals(PEAR_EXT);
        }

        public String getDescription() {
            return "PEAR package files";
        }
    }

    public static class PackageDirFilter
    extends FileFilter {
        public boolean accept(File file) {
            return file.isDirectory();
        }

        public String getDescription() {
            return "Root directories of installed PEAR packages";
        }
    }
}

