/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.tools;

import com.ibm.uima.pear.tools.InstallationController;
import com.ibm.uima.pear.tools.InstallationDescriptor;
import com.ibm.uima.pear.tools.InstallationDescriptorHandler;
import com.ibm.uima.pear.util.FileUtil;
import com.ibm.uima.pear.util.StringUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import java.util.jar.JarFile;
import org.xml.sax.SAXException;

public class PackageBrowser {
    public static final String BINARY_DIR = File.separator + "bin";
    public static final String CONFIGURATION_DIR = File.separator + "conf";
    public static final String DATA_DIR = File.separator + "data";
    public static final String DESCRIPTORS_DIR = File.separator + "desc";
    public static final String DOCUMENTATION_DIR = File.separator + "doc";
    public static final String LIBRARY_DIR = File.separator + "lib";
    public static final String METADATA_DIR = File.separator + "metadata";
    public static final String RESOURCES_DIR = File.separator + "resources";
    public static final String SOURCES_DIR = File.separator + "src";
    public static final String INSTALLATION_DESCRIPTOR_FILE = File.separator + "metadata/install.xml";
    public static final String PEAR_PROPERTIES_FILE = File.separator + "metadata/PEAR.properties";
    public static final String SUBMISSION_PROPERTIES_FILE = METADATA_DIR + "/submission.properties";
    public static final String SETENV_TXT_FILE = File.separator + "metadata/setenv.txt";
    private File _rootDir;
    private JarFile _pearPackage;
    private File _pearFile;
    private boolean _archived;
    private TreeSet _allFiles = new TreeSet();
    private TreeSet _allDirs = new TreeSet();

    public PackageBrowser(JarFile jarFile) throws IOException {
        this._pearPackage = jarFile;
        this._pearFile = new File(jarFile.getName());
        int n = this._pearFile.getAbsolutePath().lastIndexOf(46);
        String string = n > 0 ? this._pearFile.getAbsolutePath().substring(0, n) : this._pearFile.getAbsolutePath();
        this._rootDir = new File(string);
        this._archived = true;
        this._allDirs.addAll(FileUtil.createDirList(jarFile));
        this._allFiles.addAll(FileUtil.createFileList(jarFile));
    }

    public PackageBrowser(File file) throws IOException {
        this._rootDir = file;
        this._archived = false;
        this._allFiles.addAll(FileUtil.createFileList(this._rootDir, true));
        this._allDirs.addAll(FileUtil.createDirList(this._rootDir, true));
    }

    public String buildComponentClassPath() throws IOException {
        return this.buildComponentClassPath(false);
    }

    public String buildComponentClassPath(boolean bl) throws IOException {
        InstallationDescriptor installationDescriptor;
        if (!this.isArchived() && (installationDescriptor = this.getInstallationDescriptor()) != null) {
            String string = InstallationController.buildComponentClassPath(this.getRootDirectory().getAbsolutePath(), installationDescriptor);
            String string2 = StringUtil.toRegExpReplacement(this.getRootDirectory().getAbsolutePath().replace('\\', '/'));
            return bl ? string.replaceAll(string2, "\\.") : string;
        }
        return null;
    }

    public String buildComponentPath() throws IOException {
        return this.buildComponentPath(false);
    }

    public String buildComponentPath(boolean bl) throws IOException {
        InstallationDescriptor installationDescriptor;
        if (!this.isArchived() && (installationDescriptor = this.getInstallationDescriptor()) != null) {
            String string = InstallationController.buildComponentPath(this.getRootDirectory().getAbsolutePath(), installationDescriptor);
            String string2 = StringUtil.toRegExpReplacement(this.getRootDirectory().getAbsolutePath().replace('\\', '/'));
            return bl ? string.replaceAll(string2, "\\.") : string;
        }
        return null;
    }

    public File[] findDirectory(String string) {
        String string2 = string.replace('\\', '/');
        File[] fileArray = new File[]{};
        ArrayList<File> arrayList = new ArrayList<File>();
        Iterator iterator = this._allDirs.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            String string3 = file.getAbsolutePath().substring(this._rootDir.getAbsolutePath().length()).replace('\\', '/');
            if (string2.startsWith(File.separator)) {
                if (!string3.startsWith(string2)) continue;
                arrayList.add(file);
                continue;
            }
            if (string3.indexOf(string2) < 0) continue;
            arrayList.add(file);
        }
        if (arrayList.size() > 0) {
            fileArray = new File[arrayList.size()];
            arrayList.toArray(fileArray);
        }
        return fileArray;
    }

    public File[] findFile(String string) {
        String string2 = string.replace('\\', '/');
        File[] fileArray = new File[]{};
        ArrayList<File> arrayList = new ArrayList<File>();
        Iterator iterator = this._allFiles.iterator();
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            String string3 = file.getAbsolutePath().substring(this._rootDir.getAbsolutePath().length()).replace('\\', '/');
            if (string2.startsWith(File.separator) && string3.startsWith(string2)) {
                arrayList.add(file);
            }
            if (string3.indexOf(string2) < 0) continue;
            arrayList.add(file);
        }
        if (arrayList.size() > 0) {
            fileArray = new File[arrayList.size()];
            arrayList.toArray(fileArray);
        }
        return fileArray;
    }

    public File findStandardDirectory(String string) {
        String string2 = string.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        File file = new File(this._rootDir, string2);
        File file2 = this._allDirs.contains(file) ? file : null;
        return file2;
    }

    public File findStandardFile(String string) {
        String string2 = string.replace('\\', File.separatorChar).replace('/', File.separatorChar);
        File file = new File(this._rootDir, string2);
        File file2 = this._allFiles.contains(file) ? file : null;
        return file2;
    }

    public File[] getAllDirectories() {
        File[] fileArray = new File[this._allDirs.size()];
        this._allDirs.toArray(fileArray);
        return fileArray;
    }

    public File[] getAllFiles() {
        File[] fileArray = new File[this._allFiles.size()];
        this._allFiles.toArray(fileArray);
        return fileArray;
    }

    public InstallationDescriptor getInstallationDescriptor() throws IOException {
        InstallationDescriptorHandler installationDescriptorHandler = new InstallationDescriptorHandler();
        InstallationDescriptor installationDescriptor = null;
        if (this.isArchived()) {
            try {
                installationDescriptorHandler.parseInstallationDescriptor(this._pearPackage);
                installationDescriptor = installationDescriptorHandler.getInstallationDescriptor();
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.toString());
            }
        }
        File file = this.findStandardFile(INSTALLATION_DESCRIPTOR_FILE);
        if (file != null) {
            try {
                installationDescriptorHandler.parse(file);
                installationDescriptor = installationDescriptorHandler.getInstallationDescriptor();
                installationDescriptor.setMainComponentRoot(this.getRootDirectory().getAbsolutePath());
            }
            catch (SAXException sAXException) {
                throw new IOException(sAXException.toString());
            }
        }
        return installationDescriptor;
    }

    public File getRootDirectory() {
        return this._rootDir;
    }

    public boolean isArchived() {
        return this._archived;
    }
}

