/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.tools;

import com.ibm.uima.pear.tools.InstallationController;
import com.ibm.uima.pear.tools.InstallationDescriptor;
import com.ibm.uima.pear.tools.InstallationDescriptorHandler;
import com.ibm.uima.pear.tools.InstallationProcessor;
import com.ibm.uima.pear.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class LocalInstallationAgent {
    protected static final String BACKUP_FILE_SUFFIX = ".$";
    protected static final String MAIN_ROOT = "$main_root";
    protected static final String COMP_ROOT_PREFIX = "$";
    protected static final String COMP_ROOT_SUFFIX = "$root";
    private String _osName;
    private String _uimaHomePath;
    private File _mainRootDir;
    private Properties _packageConfig = new Properties();
    private InstallationDescriptor _insdObject;
    private File[] _localizedFiles;

    public static boolean checkPackageConfig(Properties properties, InstallationDescriptor installationDescriptor) {
        boolean bl = false;
        if (properties.getProperty(MAIN_ROOT) != null) {
            Hashtable hashtable = installationDescriptor.getDelegateComponents();
            Iterator iterator = hashtable.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = COMP_ROOT_PREFIX + string + COMP_ROOT_SUFFIX;
                if (properties.getProperty(string2) == null) continue;
                ++n;
            }
            if (n == hashtable.size()) {
                bl = true;
            }
        }
        return bl;
    }

    public static void localizeComponentFile(File file, InstallationDescriptor installationDescriptor, Properties properties) throws IOException {
        Object object;
        String string = properties.getProperty(MAIN_ROOT);
        if (string != null) {
            object = FileUtil.localPathToFileUrl(string);
            FileUtil.replaceStringInFile(file, "\\$main_root_url", (String)object);
            object = string;
            FileUtil.replaceStringInFile(file, "\\$main_root", (String)object);
        }
        object = installationDescriptor.getDelegateComponents().keySet().iterator();
        while (object.hasNext()) {
            String string2 = (String)object.next();
            String string3 = COMP_ROOT_PREFIX + string2 + COMP_ROOT_SUFFIX;
            String string4 = properties.getProperty(string3);
            String string5 = InstallationProcessor.componentIdRootRegExp(string2, "\\$root_rel");
            String string6 = FileUtil.computeRelativePath(file.getParentFile(), new File(string4));
            FileUtil.replaceStringInFile(file, string5, string6);
            string5 = InstallationProcessor.componentIdRootRegExp(string2, "\\$root_url");
            string6 = FileUtil.localPathToFileUrl(string4);
            FileUtil.replaceStringInFile(file, string5, string6);
            string5 = InstallationProcessor.componentIdRootRegExp(string2, "\\$root");
            string6 = string4;
            FileUtil.replaceStringInFile(file, string5, string6);
        }
    }

    public static void localizeInstallationDescriptor(InstallationDescriptor installationDescriptor, Properties properties) {
        String string = properties.getProperty(MAIN_ROOT);
        installationDescriptor.setMainComponentRoot(string);
        Iterator iterator = installationDescriptor.getDelegateComponents().keySet().iterator();
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            String string3 = COMP_ROOT_PREFIX + string2 + COMP_ROOT_SUFFIX;
            String string4 = properties.getProperty(string3);
            installationDescriptor.setDelegateComponentRoot(string2, string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] stringArray) {
        block16: {
            LocalInstallationAgent localInstallationAgent;
            block15: {
                if (stringArray.length < 1) {
                    System.err.println("usage: LocalInstallationAgent main_component_root_dir");
                    return;
                }
                localInstallationAgent = new LocalInstallationAgent(stringArray[0]);
                if (localInstallationAgent.localizeComponent()) {
                    System.out.println("[LocalInstallationAgent]: localization completed successfully");
                    if (localInstallationAgent.verifyLocalizedComponent()) {
                        System.out.println("[LocalInstallationAgent]: verification completed successfully");
                    } else {
                        System.out.println("[LocalInstallationAgent]: verification failed");
                    }
                    break block15;
                }
                System.out.println("[LocalInstallationAgent]: localization failed");
            }
            Object var4_2 = null;
            try {
                if (!localInstallationAgent.undoComponentLocalization()) {
                    throw new RuntimeException("failed to undo changes");
                }
                break block16;
            }
            catch (Throwable throwable) {
                System.err.println("Error trying to undo component localization: " + throwable);
                System.out.println("> Please, make sure that all *.$ files in conf and desc dirs\n> are renamed back to their original names");
            }
            break block16;
            {
                catch (Throwable throwable) {
                    System.err.println("Error in LocalInstallationAgent: " + throwable);
                    throwable.printStackTrace(System.err);
                    Object var4_3 = null;
                    try {
                        if (!localInstallationAgent.undoComponentLocalization()) {
                            throw new RuntimeException("failed to undo changes");
                        }
                        break block16;
                    }
                    catch (Throwable throwable2) {
                        System.err.println("Error trying to undo component localization: " + throwable2);
                        System.out.println("> Please, make sure that all *.$ files in conf and desc dirs\n> are renamed back to their original names");
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                try {
                    if (!localInstallationAgent.undoComponentLocalization()) {
                        throw new RuntimeException("failed to undo changes");
                    }
                }
                catch (Throwable throwable3) {
                    System.err.println("Error trying to undo component localization: " + throwable3);
                    System.out.println("> Please, make sure that all *.$ files in conf and desc dirs\n> are renamed back to their original names");
                }
                throw throwable;
            }
        }
    }

    public LocalInstallationAgent(String string) {
        this._uimaHomePath = System.getProperty("UIMA_HOME");
        if (this._uimaHomePath != null) {
            this._uimaHomePath = this._uimaHomePath.replace('\\', '/');
        }
        this._osName = System.getProperty("os.name");
        System.out.println("[LocalInstallationAgent]: OS - " + this._osName);
        this._mainRootDir = new File(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean localizeComponent() throws IOException {
        boolean bl;
        block10: {
            bl = false;
            InstallationDescriptorHandler installationDescriptorHandler = new InstallationDescriptorHandler();
            File file = new File(this._mainRootDir, "metadata/install.xml");
            try {
                installationDescriptorHandler.parse(file);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            this._insdObject = installationDescriptorHandler.getInstallationDescriptor();
            if (this._insdObject == null) {
                throw new RuntimeException("failed to load installation descriptor");
            }
            System.out.println("[LocalInstallationAgent]: loaded installation descriptor");
            File file2 = new File(this._mainRootDir, "metadata/PEAR.properties");
            FileInputStream fileInputStream = null;
            try {
                fileInputStream = new FileInputStream(file2);
                this._packageConfig.load(fileInputStream);
                ((InputStream)fileInputStream).close();
                System.out.println("[LocalInstallationAgent]: loaded PEAR configuration");
                Object var7_8 = null;
                if (fileInputStream == null) break block10;
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                if (fileInputStream == null) throw throwable;
                try {
                    ((InputStream)fileInputStream).close();
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (Exception exception) {}
            ((InputStream)fileInputStream).close();
        }
        if (LocalInstallationAgent.checkPackageConfig(this._packageConfig, this._insdObject)) {
            this._localizedFiles = this.localizeComponentFiles();
            LocalInstallationAgent.localizeInstallationDescriptor(this._insdObject, this._packageConfig);
            return true;
        }
        System.err.println("[LocalInstallationAgent]: PEAR properties do not comply with installation descriptor");
        return bl;
    }

    protected synchronized File[] localizeComponentFiles() throws IOException {
        File file;
        String string;
        File file2;
        File file3 = new File(this._mainRootDir, "conf");
        Collection collection = FileUtil.createFileList(file3, false);
        File file4 = new File(this._mainRootDir, "desc");
        Collection collection2 = FileUtil.createFileList(file4, false);
        File[] fileArray = new File[collection.size() + collection2.size()];
        int n = 0;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            file2 = (File)iterator.next();
            string = file2.getName().concat(BACKUP_FILE_SUFFIX);
            file = new File(file2.getParent(), string);
            if (!FileUtil.copyFile(file2, file)) continue;
            LocalInstallationAgent.localizeComponentFile(file2, this._insdObject, this._packageConfig);
            fileArray[n++] = file2;
        }
        iterator = collection2.iterator();
        while (iterator.hasNext()) {
            file2 = (File)iterator.next();
            string = file2.getName().concat(BACKUP_FILE_SUFFIX);
            file = new File(file2.getParent(), string);
            if (!FileUtil.copyFile(file2, file)) continue;
            LocalInstallationAgent.localizeComponentFile(file2, this._insdObject, this._packageConfig);
            fileArray[n++] = file2;
        }
        return fileArray;
    }

    public synchronized boolean undoComponentLocalization() throws IOException {
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < this._localizedFiles.length; ++i) {
            File file = this._localizedFiles[i];
            String string = file.getName().concat(BACKUP_FILE_SUFFIX);
            File file2 = new File(file.getParent(), string);
            if (FileUtil.copyFile(file2, file)) {
                file2.delete();
                ++n;
                continue;
            }
            System.err.println("[LocalInstallationAgent]: failed to undo changes for the file " + file.getAbsolutePath());
        }
        bl = n == this._localizedFiles.length;
        return bl;
    }

    public synchronized boolean verifyLocalizedComponent() throws IOException {
        boolean bl = false;
        if (this._insdObject == null) {
            throw new RuntimeException("null installation descriptor");
        }
        if (this._mainRootDir == null) {
            throw new RuntimeException("main root directory not specified");
        }
        String string = this._mainRootDir.getAbsolutePath();
        String string2 = this._insdObject.getMainComponentDesc();
        if (string2 == null) {
            throw new RuntimeException("main descriptor path not specified");
        }
        if (this._uimaHomePath == null) {
            throw new RuntimeException("UIMA_HOME variable not specified");
        }
        String string3 = InstallationController.buildComponentClassPath(string, this._insdObject);
        String string4 = InstallationController.buildUIMAClassPath(this._uimaHomePath);
        String string5 = InstallationController.buildComponentPath(string, this._insdObject);
        Properties properties = InstallationController.buildTableOfEnvVars(this._insdObject);
        if (string3.length() > 0) {
            properties.setProperty("CLASSPATH", string3);
        }
        if (string5.length() > 0) {
            properties.setProperty("PATH", string5);
            properties.setProperty("LD_LIBRARY_PATH", string5);
        }
        InstallationController.TestStatus testStatus = InstallationController.deployInstallationVerificationTest(string, this._insdObject, string2, string3, string5, properties, string4);
        if (testStatus.retCode != 0) {
            System.err.println("[LocalInstallationAgent]: localization test failed =>");
            System.out.println("> Error message: " + testStatus.message);
        } else {
            bl = true;
        }
        return bl;
    }

    public synchronized void setUimaHomePath(String string) {
        this._uimaHomePath = string.replace('\\', '/');
    }
}

