/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.tools;

import com.ibm.uima.UIMAException;
import com.ibm.uima.UIMAFramework;
import com.ibm.uima.UIMARuntimeException;
import com.ibm.uima.analysis_engine.AnalysisEngine;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.collection.CasConsumer;
import com.ibm.uima.collection.CasInitializer;
import com.ibm.uima.collection.CollectionProcessingEngine;
import com.ibm.uima.collection.CollectionReader;
import com.ibm.uima.collection.metadata.CpeDescription;
import com.ibm.uima.pear.util.UIMAUtil;
import com.ibm.uima.resource.ResourceInitializationException;
import com.ibm.uima.resource.ResourceSpecifier;
import com.ibm.uima.resource.metadata.FsIndexDescription;
import com.ibm.uima.resource.metadata.TypePriorities;
import com.ibm.uima.resource.metadata.TypeSystemDescription;
import com.ibm.uima.util.CasCreationUtils;
import com.ibm.uima.util.InvalidXMLException;
import com.ibm.uima.util.Level;
import com.ibm.uima.util.XMLInputSource;
import java.io.File;
import java.io.IOException;

public class InstallationTester {
    private boolean _passed = false;

    public static void main(String[] stringArray) throws Exception {
        if (System.getProperty("DEBUG") != null) {
            System.out.println("<DBG> [InstallationTester]: arg=" + stringArray[0] + "; CP=" + System.getProperty("java.class.path"));
        }
        UIMAFramework.getLogger().setLevel(Level.OFF);
        try {
            if (stringArray.length < 1) {
                throw new IOException("Descriptor file not specified");
            }
            InstallationTester installationTester = new InstallationTester(stringArray[0]);
            if (installationTester._passed) {
                if (System.getProperty("DEBUG") != null) {
                    System.out.println("<DBG> [InstallationTester]: test completed successfully");
                }
                System.exit(0);
            } else {
                if (System.getProperty("DEBUG") != null) {
                    System.err.println("<DBG> [InstallationTester]: test canceled");
                }
                System.exit(1);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace(System.err);
            System.exit(-1);
        }
    }

    public InstallationTester(String string) throws IOException, InvalidXMLException, ResourceInitializationException, UIMAException, UIMARuntimeException {
        File file = new File(string);
        String string2 = UIMAUtil.identifyUimaComponentCategory(file);
        if (string2 == null) {
            Exception exception = UIMAUtil.getLastErrorForXmlDesc(file);
            if (exception != null) {
                if (exception instanceof UIMAException) {
                    throw (UIMAException)exception;
                }
                if (exception instanceof UIMARuntimeException) {
                    throw (UIMARuntimeException)exception;
                }
                throw new RuntimeException(exception);
            }
        } else if (string2.equals("AE")) {
            this._passed = InstallationTester.testAnalysisEngine(file);
        } else if (string2.equals("CC")) {
            this._passed = InstallationTester.testCasConsumer(file);
        } else if (string2.equals("CI")) {
            this._passed = InstallationTester.testCasInitializer(file);
        } else if (string2.equals("CR")) {
            this._passed = InstallationTester.testCollectionReader(file);
        } else if (string2.equals("CPE")) {
            this._passed = InstallationTester.testCpeCongifuration(file);
        } else if (string2.equals("TS")) {
            this._passed = InstallationTester.testTypeSystem(file);
        }
    }

    public static boolean testAnalysisEngine(File file) throws IOException, InvalidXMLException, ResourceInitializationException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(file);
            ResourceSpecifier resourceSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xMLInputSource);
            AnalysisEngine analysisEngine = UIMAFramework.produceAnalysisEngine(resourceSpecifier);
            if (analysisEngine != null) {
                CAS cAS = analysisEngine.newCAS();
                return cAS != null;
            }
            return false;
        }
        catch (IOException iOException) {
            System.err.println("Error on creating XML source from descriptor file :: " + iOException.getMessage());
            throw iOException;
        }
        catch (InvalidXMLException invalidXMLException) {
            System.err.println("Error on parsing the XML source file :: " + invalidXMLException.getMessage());
            throw invalidXMLException;
        }
        catch (ResourceInitializationException resourceInitializationException) {
            System.err.println("Error on producing AE :: " + resourceInitializationException.getMessage());
            throw resourceInitializationException;
        }
    }

    public static boolean testCasConsumer(File file) throws IOException, InvalidXMLException, ResourceInitializationException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(file);
            ResourceSpecifier resourceSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xMLInputSource);
            CasConsumer casConsumer = UIMAFramework.produceCasConsumer(resourceSpecifier);
            return casConsumer != null;
        }
        catch (IOException iOException) {
            System.err.println("Error on creating XML source from descriptor file :: " + iOException.getMessage());
            throw iOException;
        }
        catch (InvalidXMLException invalidXMLException) {
            System.err.println("Error on parsing the XML source file :: " + invalidXMLException.getMessage());
            throw invalidXMLException;
        }
        catch (ResourceInitializationException resourceInitializationException) {
            System.err.println("Error on producing CC :: " + resourceInitializationException.getMessage());
            throw resourceInitializationException;
        }
    }

    public static boolean testCasInitializer(File file) throws IOException, InvalidXMLException, ResourceInitializationException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(file);
            ResourceSpecifier resourceSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xMLInputSource);
            CasInitializer casInitializer = UIMAFramework.produceCasInitializer(resourceSpecifier);
            return casInitializer != null;
        }
        catch (IOException iOException) {
            System.err.println("Error on creating XML source from descriptor file :: " + iOException.getMessage());
            throw iOException;
        }
        catch (InvalidXMLException invalidXMLException) {
            System.err.println("Error on parsing the XML source file :: " + invalidXMLException.getMessage());
            throw invalidXMLException;
        }
        catch (ResourceInitializationException resourceInitializationException) {
            System.err.println("Error on producing CC :: " + resourceInitializationException.getMessage());
            throw resourceInitializationException;
        }
    }

    public static boolean testCollectionReader(File file) throws IOException, InvalidXMLException, ResourceInitializationException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(file);
            ResourceSpecifier resourceSpecifier = UIMAFramework.getXMLParser().parseResourceSpecifier(xMLInputSource);
            CollectionReader collectionReader = UIMAFramework.produceCollectionReader(resourceSpecifier);
            return collectionReader != null;
        }
        catch (IOException iOException) {
            System.err.println("Error on creating XML source from descriptor file :: " + iOException.getMessage());
            throw iOException;
        }
        catch (InvalidXMLException invalidXMLException) {
            System.err.println("Error on parsing the XML source file :: " + invalidXMLException.getMessage());
            throw invalidXMLException;
        }
        catch (ResourceInitializationException resourceInitializationException) {
            System.err.println("Error on producing CC :: " + resourceInitializationException.getMessage());
            throw resourceInitializationException;
        }
    }

    public static boolean testCpeCongifuration(File file) throws IOException, InvalidXMLException, ResourceInitializationException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(file);
            CpeDescription cpeDescription = UIMAFramework.getXMLParser().parseCpeDescription(xMLInputSource);
            CollectionProcessingEngine collectionProcessingEngine = UIMAFramework.produceCollectionProcessingEngine(cpeDescription);
            return collectionProcessingEngine != null;
        }
        catch (IOException iOException) {
            System.err.println("Error on creating XML source from descriptor file :: " + iOException.getMessage());
            throw iOException;
        }
        catch (InvalidXMLException invalidXMLException) {
            System.err.println("Error on parsing the XML source file :: " + invalidXMLException.getMessage());
            throw invalidXMLException;
        }
        catch (ResourceInitializationException resourceInitializationException) {
            System.err.println("Error on producing CC :: " + resourceInitializationException.getMessage());
            throw resourceInitializationException;
        }
    }

    public static boolean testTypeSystem(File file) throws IOException, InvalidXMLException, ResourceInitializationException {
        try {
            XMLInputSource xMLInputSource = new XMLInputSource(file);
            TypeSystemDescription typeSystemDescription = UIMAFramework.getXMLParser().parseTypeSystemDescription(xMLInputSource);
            TypePriorities typePriorities = UIMAFramework.getResourceSpecifierFactory().createTypePriorities();
            FsIndexDescription[] fsIndexDescriptionArray = new FsIndexDescription[]{};
            CAS cAS = CasCreationUtils.createCas(typeSystemDescription, typePriorities, fsIndexDescriptionArray);
            return cAS != null;
        }
        catch (IOException iOException) {
            System.err.println("Error on creating XML source from descriptor file :: " + iOException.getMessage());
            throw iOException;
        }
        catch (InvalidXMLException invalidXMLException) {
            System.err.println("Error on parsing the XML source file :: " + invalidXMLException.getMessage());
            throw invalidXMLException;
        }
        catch (ResourceInitializationException resourceInitializationException) {
            System.err.println("Error on producing CC :: " + resourceInitializationException.getMessage());
            throw resourceInitializationException;
        }
    }
}

