/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.tools;

import com.ibm.uima.pear.tools.InstallationController;
import com.ibm.uima.pear.tools.InstallationDescriptor;
import com.ibm.uima.pear.tools.InstallationDescriptorHandler;
import com.ibm.uima.pear.util.FileUtil;
import com.ibm.uima.pear.util.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class InstallationProcessor {
    public static final String INSD_FILE_PATH = "metadata/install.xml";
    public static final String VS_DESCRIPTOR_PATH = "desc/vs_desc.xml";
    protected static final String MAIN_ROOT_REGEX = "\\$main_root";
    protected static final String MAIN_ROOT_REL_REGEX = "\\$main_root_rel";
    protected static final String MAIN_ROOT_URL_REGEX = "\\$main_root_url";
    protected static final String DELEGATE_ROOT_PREFIX_REGEX = "\\$";
    protected static final String DELEGATE_ROOT_SUFFIX_REGEX = "\\$root";
    protected static final String DELEGATE_ROOT_REL_SUFFIX_REGEX = "\\$root_rel";
    protected static final String DELEGATE_ROOT_URL_SUFFIX_REGEX = "\\$root_url";
    private static StringBuffer __regexBuffer = new StringBuffer();
    private String _mainRootPath;
    private Hashtable _installationTable = new Hashtable();
    private Hashtable _urlSubstitutionTable = new Hashtable();
    private Hashtable _pathSubstitutionTable = new Hashtable();
    private InstallationDescriptor _insdObject = null;
    private boolean _completed = false;
    private InstallationController _controller = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String componentIdRootRegExp(String string, String string2) {
        StringBuffer stringBuffer = __regexBuffer;
        synchronized (stringBuffer) {
            __regexBuffer.setLength(0);
            __regexBuffer.append(DELEGATE_ROOT_PREFIX_REGEX);
            __regexBuffer.append(string);
            __regexBuffer.append(string2);
            return __regexBuffer.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void generateVSDescriptor(InstallationDescriptor installationDescriptor, File file) throws IOException {
        File file2 = new File(file, VS_DESCRIPTOR_PATH);
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new FileWriter(file2));
            String string = InstallationProcessor.generateVSDescriptorContent(installationDescriptor);
            printWriter.println(string);
            printWriter.close();
            Object var6_5 = null;
            if (printWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (printWriter == null) throw throwable;
            try {
                printWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            printWriter.close();
            return;
        }
        catch (Exception exception) {}
    }

    public static InputStream generateVSDescriptorAsStream(InstallationDescriptor installationDescriptor) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        String string = InstallationProcessor.generateVSDescriptorContent(installationDescriptor);
        byte[] byArray = string.getBytes();
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    protected static String generateVSDescriptorContent(InstallationDescriptor installationDescriptor) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\"?>\n");
        stringBuffer.append("<deployment name=\"Vinci ");
        stringBuffer.append(installationDescriptor.getMainComponentName());
        stringBuffer.append(" Service\">\n");
        stringBuffer.append("\t<service name=\"");
        stringBuffer.append(installationDescriptor.getMainComponentId());
        stringBuffer.append("\" host=\"localhost\" provider=\"vinci\">\n");
        stringBuffer.append("\t\t<parameter name=\"serializerClassName\" value=\"");
        stringBuffer.append("com.ibm.uima.reference_impl.analysis_engine.");
        stringBuffer.append("service.vinci.VinciXCASSerializer_NoDocText\"/>\n");
        stringBuffer.append("\t\t<parameter name=\"resourceSpecifierPath\" ");
        stringBuffer.append("value=\"");
        stringBuffer.append(installationDescriptor.getMainComponentDesc());
        stringBuffer.append("\"/>\n");
        stringBuffer.append("\t\t<parameter name=\"numInstances\" value=\"1\"/>\n");
        stringBuffer.append("\t\t<parameter name=\"timeoutPeriod\" value=\"30000\"/>\n");
        stringBuffer.append("\t</service>\n");
        stringBuffer.append("</deployment>");
        return stringBuffer.toString();
    }

    protected static void findAndReplacePath(InstallationDescriptor.ActionInfo actionInfo) throws IOException {
        String string = actionInfo.params.getProperty("FILE");
        if (string == null) {
            throw new RuntimeException("no FILE defined");
        }
        String string2 = actionInfo.params.getProperty("FIND_STRING");
        if (string2 == null) {
            throw new RuntimeException("no FIND_STRING defined");
        }
        String string3 = actionInfo.params.getProperty("REPLACE_WITH");
        if (string3 == null) {
            throw new RuntimeException("no REPLACE_WITH defined");
        }
        File file = new File(string);
        FileUtil.replaceStringInFile(file, StringUtil.toRegExpString(string2), string3);
    }

    protected static String substituteCompIdRootInString(String string, String string2, String string3) {
        String string4 = string;
        String string5 = InstallationProcessor.componentIdRootRegExp(string2, DELEGATE_ROOT_URL_SUFFIX_REGEX);
        String string6 = FileUtil.localPathToFileUrl(string3);
        String string7 = StringUtil.toRegExpReplacement(string6);
        string4 = string4.replaceAll(string5, string7);
        string5 = InstallationProcessor.componentIdRootRegExp(string2, DELEGATE_ROOT_SUFFIX_REGEX);
        string7 = StringUtil.toRegExpReplacement(string3);
        string4 = string4.replaceAll(string5, string7);
        return string4.trim().replace('\\', '/');
    }

    protected static String substituteMainRootInString(String string, String string2) {
        String string3 = string;
        String string4 = StringUtil.toRegExpReplacement(FileUtil.localPathToFileUrl(string2));
        string3 = string3.replaceAll(MAIN_ROOT_URL_REGEX, string4);
        string4 = StringUtil.toRegExpReplacement(string2);
        string3 = string3.replaceAll(MAIN_ROOT_REGEX, string4);
        return string3.trim().replace('\\', '/');
    }

    public InstallationProcessor(String string, Hashtable hashtable) {
        this(string, hashtable, null);
    }

    public InstallationProcessor(String string, Hashtable hashtable, InstallationController installationController) {
        this._controller = installationController;
        this._mainRootPath = string.replace('\\', '/');
        this._installationTable = hashtable;
        this.initSubstitutionTables(string);
    }

    public synchronized InstallationDescriptor getInstallationDescriptor() {
        return this._completed ? this._insdObject : null;
    }

    protected void initSubstitutionTables(String string) {
        Enumeration enumeration = this._installationTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            String string3 = InstallationProcessor.componentIdRootRegExp(string2, DELEGATE_ROOT_URL_SUFFIX_REGEX);
            String string4 = InstallationProcessor.componentIdRootRegExp(string2, DELEGATE_ROOT_SUFFIX_REGEX);
            String string5 = (String)this._installationTable.get(string2);
            String string6 = FileUtil.localPathToFileUrl(string5);
            this._urlSubstitutionTable.put(string3, string6);
            this._pathSubstitutionTable.put(string4, string5);
        }
    }

    public synchronized void process() throws IOException {
        String string;
        File file;
        Object object;
        this._completed = false;
        File file2 = new File(this._mainRootPath);
        File file3 = new File(file2, INSD_FILE_PATH);
        if (this._controller != null) {
            this._controller.getOutMsgWriter().println("[InstallationProcessor]: start processing InsD file - " + file3.getAbsolutePath());
        } else {
            System.out.println("[InstallationProcessor]: start processing InsD file - " + file3.getAbsolutePath());
        }
        InstallationDescriptorHandler installationDescriptorHandler = new InstallationDescriptorHandler();
        try {
            installationDescriptorHandler.parse(file3);
        }
        catch (Exception exception) {
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new IOException(exception.toString());
        }
        this._insdObject = installationDescriptorHandler.getInstallationDescriptor();
        this._insdObject.setMainComponentRoot(this._mainRootPath);
        Iterator iterator = this._insdObject.getInstallationActions().iterator();
        while (iterator.hasNext()) {
            object = (InstallationDescriptor.ActionInfo)iterator.next();
            this.substituteStringVariablesInAction(((InstallationDescriptor.ActionInfo)object).params);
            if (!((InstallationDescriptor.ActionInfo)object).getName().equals("find_and_replace_path")) continue;
            InstallationProcessor.findAndReplacePath((InstallationDescriptor.ActionInfo)object);
        }
        object = this._mainRootPath + "/" + "conf";
        File file4 = new File((String)object);
        if (file4.isDirectory()) {
            this.substituteStringVariablesInFiles(file4);
        }
        if ((file = new File(string = this._mainRootPath + "/" + "desc")).isDirectory()) {
            this.substituteStringVariablesInFiles(file);
        }
        this._completed = true;
    }

    protected void substituteStringVariablesInAction(Properties properties) {
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2;
            String string3 = (String)enumeration.nextElement();
            if (!string3.equals("FILE") && !string3.equals("REPLACE_WITH") && !string3.equals("VAR_VALUE")) continue;
            String string4 = properties.getProperty(string3);
            string4 = InstallationProcessor.substituteMainRootInString(string4, this._mainRootPath);
            Enumeration enumeration2 = this._urlSubstitutionTable.keys();
            while (enumeration2.hasMoreElements()) {
                string2 = (String)enumeration2.nextElement();
                string = (String)this._urlSubstitutionTable.get(string2);
                string4 = string4.replaceAll(string2, StringUtil.toRegExpReplacement(string));
            }
            enumeration2 = this._pathSubstitutionTable.keys();
            while (enumeration2.hasMoreElements()) {
                string2 = (String)enumeration2.nextElement();
                string = (String)this._pathSubstitutionTable.get(string2);
                string4 = string4.replaceAll(string2, StringUtil.toRegExpReplacement(string));
            }
            properties.setProperty(string3, string4);
        }
    }

    protected void substituteStringVariablesInFiles(File file) throws IOException {
        Iterator iterator = FileUtil.createFileList(file, true).iterator();
        while (iterator.hasNext()) {
            String string;
            Enumeration enumeration;
            File file2 = (File)iterator.next();
            String string2 = FileUtil.localPathToFileUrl(this._mainRootPath);
            FileUtil.replaceStringInFile(file2, MAIN_ROOT_URL_REGEX, string2);
            string2 = this._mainRootPath;
            FileUtil.replaceStringInFile(file2, MAIN_ROOT_REGEX, string2);
            Enumeration enumeration2 = this._installationTable.keys();
            while (enumeration2.hasMoreElements()) {
                enumeration = (String)enumeration2.nextElement();
                string = (String)this._installationTable.get(enumeration);
                String string3 = InstallationProcessor.componentIdRootRegExp(enumeration, DELEGATE_ROOT_REL_SUFFIX_REGEX);
                try {
                    string2 = FileUtil.computeRelativePath(file2.getParentFile(), new File(string));
                    if (string2 == null) continue;
                    FileUtil.replaceStringInFile(file2, string3, string2);
                }
                catch (Exception exception) {}
            }
            enumeration = this._urlSubstitutionTable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = (String)this._urlSubstitutionTable.get(string);
                FileUtil.replaceStringInFile(file2, string, string2);
            }
            enumeration = this._pathSubstitutionTable.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                string2 = (String)this._pathSubstitutionTable.get(string);
                FileUtil.replaceStringInFile(file2, string, string2);
            }
        }
    }
}

