/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.tools;

import com.ibm.uima.pear.tools.InstallationDescriptor;
import com.ibm.uima.pear.util.XMLUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.xml.parsers.SAXParser;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class InstallationDescriptorHandler
extends DefaultHandler {
    protected static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String ROOT_TAG = "COMPONENT_INSTALLATION_DESCRIPTOR";
    public static final String OS_TAG = "OS";
    public static final String NAME_TAG = "NAME";
    public static final String VERSION_TAG = "VERSION";
    public static final String TOOLKITS_TAG = "TOOLKITS";
    public static final String JDK_VERSION_TAG = "JDK_VERSION";
    public static final String UIMA_FRAMEWORK_TAG = "UIMA_FRAMEWORK";
    public static final String UIMA_VERSION_TAG = "UIMA_VERSION";
    public static final String TAF_VERSION_TAG = "TAF_VERSION";
    public static final String SUBMITTED_COMPONENT_TAG = "SUBMITTED_COMPONENT";
    public static final String ID_TAG = "ID";
    public static final String DESC_TAG = "DESC";
    public static final String DEPLOYMENT_TAG = "DEPLOYMENT";
    public static final String STANDARD_TAG = "standard";
    public static final String SERVICE_TAG = "service";
    public static final String NETWORK_TAG = "network";
    public static final String SERVICE_COMMAND_TAG = "SERVICE_COMMAND";
    public static final String SERVICE_WORKING_DIR_TAG = "SERVICE_WORKING_DIR";
    public static final String SERVICE_COMMAND_ARGS_TAG = "SERVICE_COMMAND_ARGS";
    public static final String ARGUMENT_TAG = "ARGUMENT";
    public static final String VALUE_TAG = "VALUE";
    public static final String NETWORK_PARAMETERS_TAG = "NETWORK_PARAMETERS";
    public static final String COMMENTS_TAG = "COMMENTS";
    public static final String COLLECTION_READER_TAG = "COLLECTION_READER";
    public static final String COLLECTION_ITERATOR_DESC_TAG = "COLLECTION_ITERATOR_DESC";
    public static final String CAS_INITIALIZER_DESC_TAG = "CAS_INITIALIZER_DESC";
    public static final String CAS_CONSUMER_TAG = "CAS_CONSUMER";
    public static final String INSTALLATION_TAG = "INSTALLATION";
    public static final String DELEGATE_COMPONENT_TAG = "DELEGATE_COMPONENT";
    public static final String PROCESS_TAG = "PROCESS";
    public static final String ACTION_TAG = "ACTION";
    public static final String PARAMETERS_TAG = "PARAMETERS";
    public static final String FILE_TAG = "FILE";
    public static final String FIND_STRING_TAG = "FIND_STRING";
    public static final String REPLACE_WITH_TAG = "REPLACE_WITH";
    public static final String VAR_NAME_TAG = "VAR_NAME";
    public static final String VAR_VALUE_TAG = "VAR_VALUE";
    private SAXParser _parser = null;
    private StringBuffer _activeBuffer = new StringBuffer();
    private String _mainTag = null;
    private InstallationDescriptor _insdObject = null;
    private String _activeSection = "";
    private String _activeSubSection = "";
    private String _activeComponentId = null;
    private InstallationDescriptor.ActionInfo _activeAction = null;
    private InstallationDescriptor.ServiceInfo _activeService = null;
    private InstallationDescriptor.ArgInfo _activeArg = null;
    private boolean _insdLoaded = false;

    public static InputStream getInstallationDescriptorAsStream(InstallationDescriptor installationDescriptor) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(XML_HEADER);
        stringBuffer.append('\n');
        stringBuffer.append(installationDescriptor.toString());
        byte[] byArray = stringBuffer.toString().getBytes("UTF-8");
        byteArrayInputStream = new ByteArrayInputStream(byArray);
        return byteArrayInputStream;
    }

    public static void printInstallationDescriptor(InstallationDescriptor installationDescriptor, PrintWriter printWriter) throws IOException {
        Object object;
        Object object2;
        Iterator iterator;
        Object object3;
        String[] stringArray = null;
        XMLUtil.printXMLTag(ROOT_TAG, printWriter, false, 0);
        printWriter.println();
        XMLUtil.printXMLTag(OS_TAG, printWriter, false, 1);
        printWriter.println();
        stringArray = new String[]{NAME_TAG};
        if (installationDescriptor.getOSSpecs().size() > 0) {
            XMLUtil.printAllXMLElements(installationDescriptor.getOSSpecs(), "\n", stringArray, printWriter, 2);
        }
        XMLUtil.printXMLTag(OS_TAG, printWriter, true, 1);
        printWriter.println();
        XMLUtil.printXMLTag(TOOLKITS_TAG, printWriter, false, 1);
        printWriter.println();
        if (installationDescriptor.getToolkitsSpecs().size() > 0) {
            XMLUtil.printAllXMLElements(installationDescriptor.getToolkitsSpecs(), "\n", null, printWriter, 2);
        }
        XMLUtil.printXMLTag(TOOLKITS_TAG, printWriter, true, 1);
        printWriter.println();
        XMLUtil.printXMLTag(UIMA_FRAMEWORK_TAG, printWriter, false, 1);
        printWriter.println();
        if (installationDescriptor.getFrameworkSpecs().size() > 0) {
            XMLUtil.printAllXMLElements(installationDescriptor.getFrameworkSpecs(), "\n", null, printWriter, 2);
        }
        XMLUtil.printXMLTag(UIMA_FRAMEWORK_TAG, printWriter, true, 1);
        printWriter.println();
        XMLUtil.printXMLTag(SUBMITTED_COMPONENT_TAG, printWriter, false, 1);
        printWriter.println();
        if (installationDescriptor.getMainComponentId() != null) {
            Object object4;
            XMLUtil.printXMLElement(ID_TAG, installationDescriptor.getMainComponentId(), printWriter, 2);
            printWriter.println();
            XMLUtil.printXMLElement(NAME_TAG, installationDescriptor.getMainComponentName(), printWriter, 2);
            printWriter.println();
            XMLUtil.printXMLElement(DESC_TAG, installationDescriptor.getMainComponentDesc(), printWriter, 2);
            printWriter.println();
            XMLUtil.printXMLElement(DEPLOYMENT_TAG, installationDescriptor.getMainComponentDeployment(), printWriter, 2);
            printWriter.println();
            object3 = installationDescriptor.getMainComponentService();
            if (object3 != null) {
                XMLUtil.printXMLElement(SERVICE_COMMAND_TAG, ((InstallationDescriptor.ServiceInfo)object3).command, printWriter, 2);
                printWriter.println();
                XMLUtil.printXMLElement(SERVICE_WORKING_DIR_TAG, ((InstallationDescriptor.ServiceInfo)object3).workingDirPath, printWriter, 2);
                printWriter.println();
                XMLUtil.printXMLTag(SERVICE_COMMAND_ARGS_TAG, printWriter, false, 2);
                printWriter.println();
                iterator = ((InstallationDescriptor.ServiceInfo)object3).getArgs().iterator();
                while (iterator.hasNext()) {
                    XMLUtil.printXMLTag(ARGUMENT_TAG, printWriter, false, 3);
                    printWriter.println();
                    object2 = (InstallationDescriptor.ArgInfo)iterator.next();
                    XMLUtil.printXMLElement(VALUE_TAG, ((InstallationDescriptor.ArgInfo)object2).value, printWriter, 4);
                    printWriter.println();
                    XMLUtil.printXMLElement(COMMENTS_TAG, ((InstallationDescriptor.ArgInfo)object2).comments, printWriter, 4);
                    printWriter.println();
                    XMLUtil.printXMLTag(ARGUMENT_TAG, printWriter, true, 3);
                    printWriter.println();
                }
                XMLUtil.printXMLTag(SERVICE_COMMAND_ARGS_TAG, printWriter, true, 2);
                printWriter.println();
            }
            if ((iterator = installationDescriptor.getMainComponentNetworkParamNames()) != null) {
                XMLUtil.printXMLTag(NETWORK_PARAMETERS_TAG, printWriter, false, 2);
                printWriter.println();
                object2 = iterator.iterator();
                while (object2.hasNext()) {
                    object = (String)object2.next();
                    object4 = installationDescriptor.getMainComponentNetworkParam((String)object);
                    XMLUtil.printXMLElement((String)object, (Properties)object4, null, printWriter, 3);
                    printWriter.println();
                }
                XMLUtil.printXMLTag(NETWORK_PARAMETERS_TAG, printWriter, true, 2);
                printWriter.println();
            }
            if (installationDescriptor.getMainComponentProps().size() > 0) {
                XMLUtil.printAllXMLElements(installationDescriptor.getMainComponentProps(), printWriter, 2);
            }
            object2 = installationDescriptor.getMainCollIteratorDesc();
            object = installationDescriptor.getMainCasInitializerDesc();
            if (object2 != null || object != null) {
                XMLUtil.printXMLTag(COLLECTION_READER_TAG, printWriter, false, 2);
                printWriter.println();
                if (object2 != null) {
                    XMLUtil.printXMLElement(COLLECTION_ITERATOR_DESC_TAG, object2, printWriter, 3);
                    printWriter.println();
                }
                if (object != null) {
                    XMLUtil.printXMLElement(CAS_INITIALIZER_DESC_TAG, (String)object, printWriter, 3);
                    printWriter.println();
                }
                XMLUtil.printXMLTag(COLLECTION_READER_TAG, printWriter, true, 2);
                printWriter.println();
            }
            if ((object4 = installationDescriptor.getMainCasConsumerDesc()) != null) {
                XMLUtil.printXMLTag(CAS_CONSUMER_TAG, printWriter, false, 2);
                printWriter.println();
                XMLUtil.printXMLElement(DESC_TAG, (String)object4, printWriter, 3);
                printWriter.println();
                XMLUtil.printXMLTag(CAS_CONSUMER_TAG, printWriter, true, 2);
                printWriter.println();
            }
        }
        XMLUtil.printXMLTag(SUBMITTED_COMPONENT_TAG, printWriter, true, 1);
        printWriter.println();
        XMLUtil.printXMLTag(INSTALLATION_TAG, printWriter, false, 1);
        printWriter.println();
        object3 = installationDescriptor.getDelegateComponents();
        iterator = ((Hashtable)object3).keySet().iterator();
        while (iterator.hasNext()) {
            XMLUtil.printXMLTag(DELEGATE_COMPONENT_TAG, printWriter, false, 2);
            printWriter.println();
            object2 = (String)iterator.next();
            object = (InstallationDescriptor.ComponentInfo)((Hashtable)object3).get(object2);
            XMLUtil.printXMLElement(ID_TAG, (String)object2, printWriter, 3);
            printWriter.println();
            XMLUtil.printXMLElement(NAME_TAG, ((InstallationDescriptor.ComponentInfo)object).name, printWriter, 3);
            printWriter.println();
            XMLUtil.printXMLTag(DELEGATE_COMPONENT_TAG, printWriter, true, 2);
            printWriter.println();
        }
        object2 = installationDescriptor.getInstallationActions().iterator();
        while (object2.hasNext()) {
            object = (InstallationDescriptor.ActionInfo)object2.next();
            XMLUtil.printXMLTag(PROCESS_TAG, printWriter, false, 2);
            printWriter.println();
            XMLUtil.printXMLElement(ACTION_TAG, ((InstallationDescriptor.ActionInfo)object).getName(), printWriter, 3);
            printWriter.println();
            XMLUtil.printXMLTag(PARAMETERS_TAG, printWriter, false, 3);
            printWriter.println();
            if (((InstallationDescriptor.ActionInfo)object).params != null && ((InstallationDescriptor.ActionInfo)object).params.size() > 0) {
                XMLUtil.printAllXMLElements(((InstallationDescriptor.ActionInfo)object).params, printWriter, 4);
            }
            XMLUtil.printXMLTag(PARAMETERS_TAG, printWriter, true, 3);
            printWriter.println();
            XMLUtil.printXMLTag(PROCESS_TAG, printWriter, true, 2);
            printWriter.println();
        }
        XMLUtil.printXMLTag(INSTALLATION_TAG, printWriter, true, 1);
        printWriter.println();
        XMLUtil.printXMLTag(ROOT_TAG, printWriter, true, 0);
        printWriter.println();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void saveInstallationDescriptor(InstallationDescriptor installationDescriptor, File file) throws IOException {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
            printWriter.println(XML_HEADER);
            InstallationDescriptorHandler.printInstallationDescriptor(installationDescriptor, printWriter);
            Object var5_3 = null;
            if (printWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (printWriter == null) throw throwable;
            try {
                printWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {}
        printWriter.close();
        return;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        this._activeBuffer.append(cArray, n, n2);
    }

    public void endDocument() throws SAXException {
        this._insdLoaded = true;
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = this._activeBuffer.toString().trim();
        if (OS_TAG.equals(this._activeSection)) {
            if (string2.equalsIgnoreCase(OS_TAG)) {
                this._activeSection = "";
            } else {
                this._insdObject.addOSSpec(string2, string4);
            }
        } else if (TOOLKITS_TAG.equals(this._activeSection)) {
            if (string2.equalsIgnoreCase(TOOLKITS_TAG)) {
                this._activeSection = "";
            } else {
                this._insdObject.addToolkitsSpec(string2, string4);
            }
        } else if (UIMA_FRAMEWORK_TAG.equals(this._activeSection)) {
            if (string2.equalsIgnoreCase(UIMA_FRAMEWORK_TAG)) {
                this._activeSection = "";
            } else {
                this._insdObject.addFrameworkSpec(string2, string4);
            }
        } else if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection)) {
            if (string2.equalsIgnoreCase(SUBMITTED_COMPONENT_TAG)) {
                this._activeSection = "";
                if (this._activeService != null) {
                    this._insdObject.setMainComponentService(this._activeService);
                }
                this._activeService = null;
            } else if (string2.equalsIgnoreCase(SERVICE_COMMAND_ARGS_TAG)) {
                this._activeSubSection = "";
            } else if (string2.equalsIgnoreCase(COLLECTION_READER_TAG)) {
                this._activeSubSection = "";
            } else if (string2.equalsIgnoreCase(CAS_CONSUMER_TAG)) {
                this._activeSubSection = "";
            } else if (string2.equalsIgnoreCase(ID_TAG)) {
                this._activeComponentId = string4;
                this._insdObject.setMainComponent(this._activeComponentId, "");
                this._activeService = new InstallationDescriptor.ServiceInfo();
            } else if (string2.equalsIgnoreCase(NAME_TAG)) {
                if (this._activeComponentId != null) {
                    this._insdObject.setMainComponentName(string4);
                    this._activeComponentId = null;
                }
            } else if (string2.equalsIgnoreCase(DESC_TAG)) {
                if (CAS_CONSUMER_TAG.equals(this._activeSubSection)) {
                    this._insdObject.setMainCasConsumerDesc(string4);
                } else {
                    this._insdObject.setMainComponentDesc(string4);
                }
            } else if (string2.equalsIgnoreCase(DEPLOYMENT_TAG)) {
                this._insdObject.setMainComponentDeployment(string4);
            } else if (string2.equalsIgnoreCase(SERVICE_COMMAND_TAG)) {
                if (this._activeService != null) {
                    this._activeService.command = string4;
                }
            } else if (string2.equalsIgnoreCase(SERVICE_WORKING_DIR_TAG)) {
                if (this._activeService != null) {
                    this._activeService.workingDirPath = string4;
                }
            } else if (string2.equalsIgnoreCase(VALUE_TAG)) {
                if (SERVICE_COMMAND_ARGS_TAG.equals(this._activeSubSection) && this._activeArg != null) {
                    this._activeArg.value = string4;
                }
            } else if (string2.equalsIgnoreCase(ARGUMENT_TAG)) {
                if (SERVICE_COMMAND_ARGS_TAG.equals(this._activeSubSection) && this._activeService != null && this._activeArg != null && this._activeArg.value != null && this._activeArg.value.length() > 0) {
                    this._activeService.addArg(this._activeArg);
                }
                this._activeArg = null;
            } else if (string2.equalsIgnoreCase(NETWORK_PARAMETERS_TAG)) {
                if (NETWORK_PARAMETERS_TAG.equals(this._activeSubSection)) {
                    this._activeSubSection = "";
                }
            } else if (string2.equalsIgnoreCase(COMMENTS_TAG)) {
                if (SERVICE_COMMAND_ARGS_TAG.equals(this._activeSubSection)) {
                    if (this._activeArg != null) {
                        this._activeArg.comments = string4;
                    }
                } else {
                    this._insdObject.setMainComponentProperty(COMMENTS_TAG, string4);
                }
            } else if (string2.equalsIgnoreCase(COLLECTION_ITERATOR_DESC_TAG)) {
                this._insdObject.setMainCollIteratorDesc(string4);
            } else if (string2.equalsIgnoreCase(CAS_INITIALIZER_DESC_TAG)) {
                this._insdObject.setMainCasInitializerDesc(string4);
            } else {
                this._insdObject.setMainComponentProperty(string2, string4);
            }
        } else if (INSTALLATION_TAG.equals(this._activeSection)) {
            if (string2.equalsIgnoreCase(INSTALLATION_TAG)) {
                this._activeSection = "";
            } else if (string2.equalsIgnoreCase(DELEGATE_COMPONENT_TAG)) {
                this._activeSubSection = "";
            } else if (string2.equalsIgnoreCase(PROCESS_TAG)) {
                if (this._activeAction != null) {
                    this._insdObject.addInstallationAction(this._activeAction);
                    this._activeAction = null;
                }
                this._activeSubSection = "";
            } else if (!string2.equalsIgnoreCase(PARAMETERS_TAG)) {
                if (string2.equalsIgnoreCase(ID_TAG)) {
                    this._activeComponentId = string4;
                } else if (string2.equalsIgnoreCase(NAME_TAG)) {
                    if (DELEGATE_COMPONENT_TAG.equals(this._activeSubSection) && this._activeComponentId != null) {
                        this._insdObject.addDelegateComponent(this._activeComponentId, string4);
                        this._activeComponentId = null;
                    }
                } else if (string2.equalsIgnoreCase(ACTION_TAG)) {
                    if (PROCESS_TAG.equals(this._activeSubSection)) {
                        this._activeAction = new InstallationDescriptor.ActionInfo(string4);
                    }
                } else if (this._activeAction != null) {
                    this._activeAction.params.setProperty(string2, string4);
                }
            }
        }
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        XMLUtil.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        XMLUtil.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    public synchronized InstallationDescriptor getInstallationDescriptor() {
        return this._insdLoaded ? this._insdObject : null;
    }

    public synchronized void parse(File file) throws IOException, SAXException {
        if (this._parser == null) {
            this._parser = XMLUtil.createSAXParser();
        }
        this._insdObject = new InstallationDescriptor(file);
        this._insdLoaded = false;
        this._parser.parse(file, (DefaultHandler)this);
    }

    public synchronized void parse(InputStream inputStream) throws IOException, SAXException {
        if (this._parser == null) {
            this._parser = XMLUtil.createSAXParser();
        }
        this._insdObject = new InstallationDescriptor();
        this._insdLoaded = false;
        this._parser.parse(inputStream, (DefaultHandler)this);
    }

    public synchronized void parseInstallationDescriptor(JarFile jarFile) throws IOException, SAXException {
        String string = "metadata/install.xml";
        JarEntry jarEntry = jarFile.getJarEntry(string);
        if (jarEntry == null) {
            throw new IOException("installation drescriptor not found");
        }
        this.parse(jarFile.getInputStream(jarEntry));
    }

    public synchronized void saveInstallationDescriptor(File file) throws IOException {
        if (this._insdLoaded) {
            InstallationDescriptorHandler.saveInstallationDescriptor(this._insdObject, file);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this._mainTag = string2;
        this._activeBuffer.setLength(0);
        if (this._mainTag.equalsIgnoreCase(OS_TAG)) {
            this._activeSection = OS_TAG;
        } else if (this._mainTag.equalsIgnoreCase(TOOLKITS_TAG)) {
            this._activeSection = TOOLKITS_TAG;
        } else if (this._mainTag.equalsIgnoreCase(UIMA_FRAMEWORK_TAG)) {
            this._activeSection = UIMA_FRAMEWORK_TAG;
        } else if (this._mainTag.equalsIgnoreCase(SUBMITTED_COMPONENT_TAG)) {
            this._activeSection = SUBMITTED_COMPONENT_TAG;
            this._activeComponentId = null;
        } else if (this._mainTag.equalsIgnoreCase(SERVICE_COMMAND_ARGS_TAG)) {
            if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection)) {
                this._activeSubSection = SERVICE_COMMAND_ARGS_TAG;
            }
        } else if (this._mainTag.equalsIgnoreCase(ARGUMENT_TAG)) {
            if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection) && SERVICE_COMMAND_ARGS_TAG.equals(this._activeSubSection)) {
                this._activeArg = new InstallationDescriptor.ArgInfo();
            }
        } else if (this._mainTag.equalsIgnoreCase(NETWORK_PARAMETERS_TAG)) {
            if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection)) {
                this._activeSubSection = NETWORK_PARAMETERS_TAG;
            }
        } else if (this._mainTag.equalsIgnoreCase(CAS_CONSUMER_TAG)) {
            if (SUBMITTED_COMPONENT_TAG.equals(this._activeSection)) {
                this._activeSubSection = CAS_CONSUMER_TAG;
            }
        } else if (this._mainTag.equalsIgnoreCase(INSTALLATION_TAG)) {
            this._activeSection = INSTALLATION_TAG;
        } else if (this._mainTag.equalsIgnoreCase(DELEGATE_COMPONENT_TAG)) {
            if (INSTALLATION_TAG.equals(this._activeSection)) {
                this._activeSubSection = DELEGATE_COMPONENT_TAG;
                this._activeComponentId = null;
            }
        } else if (this._mainTag.equalsIgnoreCase(PROCESS_TAG)) {
            if (INSTALLATION_TAG.equals(this._activeSection)) {
                this._activeSubSection = PROCESS_TAG;
                this._activeAction = null;
            }
        } else if (NETWORK_PARAMETERS_TAG.equals(this._activeSubSection)) {
            String string4 = this._mainTag;
            int n = attributes.getLength();
            Properties properties = new Properties();
            for (int i = 0; i < n; ++i) {
                String string5 = attributes.getLocalName(i);
                String string6 = attributes.getValue(i);
                properties.setProperty(string5, string6);
            }
            if (properties.size() > 0) {
                this._insdObject.setMainComponentNetworkParam(string4, properties);
            }
        }
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        XMLUtil.printError("Warning", sAXParseException);
    }
}

