/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.tools;

import com.ibm.uima.pear.tools.InstallationDescriptorHandler;
import com.ibm.uima.pear.tools.InstallationProcessor;
import com.ibm.uima.pear.util.FileUtil;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;

public class InstallationDescriptor
implements Serializable {
    public static final String PROPERTY_DELIMITER = "\n";
    public static final String VNS_SPECS = "VNS_SPECS";
    public static final String VNS_HOST = "VNS_HOST";
    public static final String VNS_PORT = "VNS_PORT";
    private File _insdFile = null;
    private Properties _osSpecs = new Properties();
    private Properties _toolkitsSpecs = new Properties();
    private Properties _frameworkSpecs = new Properties();
    private ComponentInfo _mainComponent = null;
    private Hashtable _delegateComponents = new Hashtable();
    private ArrayList _installationActions = new ArrayList();

    protected static Properties addProperty(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 == null) {
            properties.setProperty(string, string2.trim());
        } else {
            String string4;
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string3, PROPERTY_DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                string4 = stringTokenizer.nextToken().trim();
                if (!string4.equalsIgnoreCase(string2.trim())) continue;
                bl = true;
                break;
            }
            if (!bl) {
                string4 = string3 + PROPERTY_DELIMITER + string2.trim();
                properties.setProperty(string, string4);
            }
        }
        return properties;
    }

    protected static Properties deleteProperty(Properties properties, String string, String string2) {
        String string3 = properties.getProperty(string);
        if (string3 != null) {
            StringBuffer stringBuffer = new StringBuffer();
            StringTokenizer stringTokenizer = new StringTokenizer(string3, PROPERTY_DELIMITER);
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken().trim();
                if (string4.length() <= 0 || string4.equals(string2)) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(PROPERTY_DELIMITER);
                }
                stringBuffer.append(string4);
            }
            if (stringBuffer.length() > 0) {
                properties.setProperty(string, stringBuffer.toString());
            } else {
                properties.remove(string);
            }
        }
        return properties;
    }

    protected static String getRelativePathForComponentObject(String string, ComponentInfo componentInfo) {
        String string2 = string;
        if (componentInfo.rootDirPath != null && string2 != null) {
            File file = new File(componentInfo.rootDirPath);
            string2 = FileUtil.getRelativePath(file, string2);
        }
        return string2;
    }

    public InstallationDescriptor() {
    }

    public InstallationDescriptor(File file) {
        this._insdFile = file;
    }

    public synchronized void addDelegateComponent(String string, String string2) {
        String string3 = string.trim();
        if (this._delegateComponents.get(string3) == null) {
            ComponentInfo componentInfo = new ComponentInfo(string3);
            componentInfo.name = string2.trim();
            this._delegateComponents.put(string3, componentInfo);
        }
    }

    public synchronized void addFrameworkSpec(String string, String string2) {
        InstallationDescriptor.addProperty(this._frameworkSpecs, string, string2);
    }

    public synchronized void addInstallationAction(ActionInfo actionInfo) {
        if (this._mainComponent != null && actionInfo.params != null) {
            ActionInfo actionInfo2 = new ActionInfo(actionInfo);
            Enumeration<Object> enumeration = actionInfo2.params.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = actionInfo2.params.getProperty(string);
                if (!string.equals("FILE") && !string.equals("REPLACE_WITH") && !string.equals("VAR_VALUE")) continue;
                if (this._mainComponent.rootDirPath != null) {
                    string2 = InstallationProcessor.substituteMainRootInString(string2, this._mainComponent.rootDirPath);
                    actionInfo2.params.setProperty(string, string2);
                }
                Iterator iterator = this.getDelegateComponents().entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    ComponentInfo componentInfo = (ComponentInfo)entry.getValue();
                    if (componentInfo.rootDirPath == null) continue;
                    string2 = InstallationProcessor.substituteCompIdRootInString(string2, componentInfo.getId(), componentInfo.rootDirPath);
                    actionInfo2.params.setProperty(string, string2);
                }
                string2 = actionInfo2.params.getProperty(string);
                actionInfo2.params.setProperty(string, string2.replace('\\', '/'));
                if (!string.equals("VAR_VALUE")) continue;
                string2 = actionInfo2.params.getProperty(string);
                string2 = string2.replace(';', File.pathSeparatorChar);
                actionInfo2.params.setProperty(string, string2);
            }
            this._installationActions.add(actionInfo2);
        } else {
            this._installationActions.add(actionInfo);
        }
    }

    public synchronized void addOSSpec(String string, String string2) {
        InstallationDescriptor.addProperty(this._osSpecs, string, string2);
    }

    public synchronized void addToolkitsSpec(String string, String string2) {
        InstallationDescriptor.addProperty(this._toolkitsSpecs, string, string2);
    }

    public synchronized void clearDelegateComponents() {
        this._delegateComponents.clear();
    }

    public synchronized void clearFrameworkSpecs() {
        this._frameworkSpecs.clear();
    }

    public synchronized void clearInstallationActions() {
        this._installationActions.clear();
    }

    public synchronized void clearOSSpecs() {
        this._osSpecs.clear();
    }

    public synchronized void clearToolkitsSpecs() {
        this._toolkitsSpecs.clear();
    }

    public synchronized void deleteDelegateComponent(String string) {
        this._delegateComponents.remove(string);
    }

    public synchronized void deleteFrameworkSpec(String string, String string2) {
        InstallationDescriptor.deleteProperty(this._frameworkSpecs, string, string2);
    }

    public synchronized void deleteInstallationActions(String string) {
        Iterator iterator = this._installationActions.iterator();
        while (iterator.hasNext()) {
            ActionInfo actionInfo = (ActionInfo)iterator.next();
            if (!actionInfo.getName().equals(string)) continue;
            this._installationActions.remove(actionInfo);
            iterator = this._installationActions.iterator();
        }
    }

    public synchronized void deleteOSSpec(String string, String string2) {
        InstallationDescriptor.deleteProperty(this._osSpecs, string, string2);
    }

    public synchronized void deleteToolkitsSpec(String string, String string2) {
        InstallationDescriptor.deleteProperty(this._toolkitsSpecs, string, string2);
    }

    public Hashtable getDelegateComponents() {
        return this._delegateComponents;
    }

    public Properties getFrameworkSpecs() {
        return this._frameworkSpecs;
    }

    public Collection getInstallationActions() {
        return this._installationActions;
    }

    public Collection getInstallationActions(String string) {
        ArrayList<ActionInfo> arrayList = new ArrayList<ActionInfo>();
        Iterator iterator = this.getInstallationActions().iterator();
        while (iterator.hasNext()) {
            ActionInfo actionInfo = (ActionInfo)iterator.next();
            if (!actionInfo.getName().equals(string)) continue;
            arrayList.add(actionInfo);
        }
        return arrayList;
    }

    public synchronized File getInstallationDescriptorFile() {
        return this._insdFile;
    }

    public String getMainCasConsumerDesc() {
        return this.getMainCasConsumerDesc(false);
    }

    public synchronized String getMainCasConsumerDesc(boolean bl) {
        if (this._mainComponent != null) {
            return bl ? InstallationDescriptor.getRelativePathForComponentObject(this._mainComponent.casConsumerDescFilePath, this._mainComponent) : this._mainComponent.casConsumerDescFilePath;
        }
        return null;
    }

    public String getMainCasInitializerDesc() {
        return this.getMainCasInitializerDesc(false);
    }

    public synchronized String getMainCasInitializerDesc(boolean bl) {
        if (this._mainComponent != null) {
            return bl ? InstallationDescriptor.getRelativePathForComponentObject(this._mainComponent.casInitializerDescFilePath, this._mainComponent) : this._mainComponent.casInitializerDescFilePath;
        }
        return null;
    }

    public String getMainCollIteratorDesc() {
        return this.getMainCollIteratorDesc(false);
    }

    public synchronized String getMainCollIteratorDesc(boolean bl) {
        if (this._mainComponent != null) {
            return bl ? InstallationDescriptor.getRelativePathForComponentObject(this._mainComponent.collIteratorDescFilePath, this._mainComponent) : this._mainComponent.collIteratorDescFilePath;
        }
        return null;
    }

    public synchronized String getMainComponentDeployment() {
        return this._mainComponent != null ? this._mainComponent.deploymentType : null;
    }

    public String getMainComponentDesc() {
        return this.getMainComponentDesc(false);
    }

    public synchronized String getMainComponentDesc(boolean bl) {
        if (this._mainComponent != null) {
            if (this._mainComponent.descFilePath != null && this._mainComponent.descFilePath.length() > 0) {
                if (this._mainComponent.descFilePath.charAt(0) == '$') {
                    if (bl) {
                        int n = this._mainComponent.descFilePath.indexOf(47) + 1;
                        return this._mainComponent.descFilePath.substring(n);
                    }
                    return this._mainComponent.descFilePath;
                }
                return bl ? InstallationDescriptor.getRelativePathForComponentObject(this._mainComponent.descFilePath, this._mainComponent) : this._mainComponent.descFilePath;
            }
            return this._mainComponent.descFilePath;
        }
        return null;
    }

    public synchronized String getMainComponentId() {
        return this._mainComponent != null ? this._mainComponent.getId() : null;
    }

    public synchronized String getMainComponentName() {
        return this._mainComponent != null ? this._mainComponent.name : null;
    }

    public synchronized Properties getMainComponentNetworkParam(String string) {
        return this._mainComponent != null && this._mainComponent.networkParams != null ? (Properties)this._mainComponent.networkParams.get(string) : null;
    }

    public synchronized Set getMainComponentNetworkParamNames() {
        return this._mainComponent != null && this._mainComponent.networkParams != null ? this._mainComponent.networkParams.keySet() : null;
    }

    public synchronized Properties getMainComponentProps() {
        return this._mainComponent != null ? this._mainComponent.props : null;
    }

    public synchronized String getMainComponentRoot() {
        return this._mainComponent != null ? this._mainComponent.rootDirPath : null;
    }

    public synchronized ServiceInfo getMainComponentService() {
        return this._mainComponent != null ? this._mainComponent.serviceInfo : null;
    }

    public Properties getOSSpecs() {
        return this._osSpecs;
    }

    public Properties getToolkitsSpecs() {
        return this._toolkitsSpecs;
    }

    public synchronized void setInstallationDescriptorFile(File file) {
        this._insdFile = file;
    }

    public synchronized void setDelegateComponentDesc(String string, String string2) {
        String string3 = string.trim();
        ComponentInfo componentInfo = (ComponentInfo)this._delegateComponents.get(string3);
        if (componentInfo != null) {
            componentInfo.descFilePath = componentInfo.rootDirPath == null ? string2.trim().replace('\\', '/') : InstallationProcessor.substituteCompIdRootInString(componentInfo.descFilePath, string3, componentInfo.rootDirPath);
        }
    }

    public synchronized void setDelegateComponentName(String string, String string2) {
        String string3 = string.trim();
        ComponentInfo componentInfo = (ComponentInfo)this._delegateComponents.get(string3);
        if (componentInfo != null) {
            componentInfo.name = string2.trim();
        }
    }

    public synchronized void setDelegateComponentProperty(String string, String string2, String string3) {
        String string4 = string.trim();
        ComponentInfo componentInfo = (ComponentInfo)this._delegateComponents.get(string4);
        if (componentInfo != null) {
            if (componentInfo.props == null) {
                componentInfo.props = new Properties();
            }
            componentInfo.props.setProperty(string2, string3.trim());
        }
    }

    public synchronized void setDelegateComponentRoot(String string, String string2) {
        String string3 = string.trim();
        ComponentInfo componentInfo = (ComponentInfo)this._delegateComponents.get(string3);
        if (componentInfo != null) {
            componentInfo.rootDirPath = string2.trim().replace('\\', '/');
            if (componentInfo.descFilePath != null) {
                componentInfo.descFilePath = InstallationProcessor.substituteCompIdRootInString(componentInfo.descFilePath, string3, componentInfo.rootDirPath);
            }
        }
        Iterator iterator = this.getInstallationActions().iterator();
        while (iterator.hasNext()) {
            ActionInfo actionInfo = (ActionInfo)iterator.next();
            Enumeration<Object> enumeration = actionInfo.params.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = actionInfo.params.getProperty(string4);
                if (!string4.equals("FILE") && !string4.equals("REPLACE_WITH") && !string4.equals("VAR_VALUE")) continue;
                string5 = InstallationProcessor.substituteCompIdRootInString(string5, string3, componentInfo.rootDirPath);
                actionInfo.params.setProperty(string4, string5);
            }
        }
    }

    public synchronized void setMainCasConsumerDesc(String string) {
        if (this._mainComponent != null) {
            this._mainComponent.casConsumerDescFilePath = this._mainComponent.rootDirPath == null ? string.trim().replace('\\', '/') : InstallationProcessor.substituteMainRootInString(string, this._mainComponent.rootDirPath);
        }
    }

    public synchronized void setMainCasInitializerDesc(String string) {
        if (this._mainComponent != null) {
            this._mainComponent.casInitializerDescFilePath = this._mainComponent.rootDirPath == null ? string.trim().replace('\\', '/') : InstallationProcessor.substituteMainRootInString(string, this._mainComponent.rootDirPath);
        }
    }

    public synchronized void setMainCollIteratorDesc(String string) {
        if (this._mainComponent != null) {
            this._mainComponent.collIteratorDescFilePath = this._mainComponent.rootDirPath == null ? string.trim().replace('\\', '/') : InstallationProcessor.substituteMainRootInString(string, this._mainComponent.rootDirPath);
        }
    }

    public synchronized void setMainComponent(String string) {
        this.setMainComponent(string, "");
    }

    public synchronized void setMainComponent(String string, String string2) {
        this._mainComponent = new ComponentInfo(string);
        this.setMainComponentName(string2);
    }

    public synchronized void setMainComponentDeployment(String string) {
        if (this._mainComponent != null) {
            this._mainComponent.deploymentType = string;
        }
    }

    public synchronized void setMainComponentDesc(String string) {
        if (this._mainComponent != null) {
            this._mainComponent.descFilePath = this._mainComponent.rootDirPath == null ? string.trim().replace('\\', '/') : InstallationProcessor.substituteMainRootInString(string, this._mainComponent.rootDirPath);
        }
    }

    public synchronized void setMainComponentId(String string) {
        if (this._mainComponent != null) {
            this._mainComponent._id = string.trim();
        }
    }

    public synchronized void setMainComponentName(String string) {
        if (this._mainComponent != null) {
            this._mainComponent.name = string.trim();
        }
    }

    public synchronized void setMainComponentNetworkParam(String string, Properties properties) {
        if (this._mainComponent != null) {
            if (this._mainComponent.networkParams == null) {
                this._mainComponent.networkParams = new Hashtable();
            }
            this._mainComponent.networkParams.put(string, properties);
        }
    }

    public synchronized void setMainComponentProperty(String string, String string2) {
        if (this._mainComponent != null) {
            if (this._mainComponent.props == null) {
                this._mainComponent.props = new Properties();
            }
            this._mainComponent.props.setProperty(string, string2.trim());
        }
    }

    public synchronized void setMainComponentRoot(String string) {
        if (this._mainComponent != null) {
            this._mainComponent.rootDirPath = string.trim().replace('\\', '/');
            if (this._mainComponent.descFilePath != null) {
                this._mainComponent.descFilePath = InstallationProcessor.substituteMainRootInString(this._mainComponent.descFilePath, this._mainComponent.rootDirPath);
            }
            if (this._mainComponent.collIteratorDescFilePath != null) {
                this._mainComponent.collIteratorDescFilePath = InstallationProcessor.substituteMainRootInString(this._mainComponent.collIteratorDescFilePath, this._mainComponent.rootDirPath);
            }
            if (this._mainComponent.casInitializerDescFilePath != null) {
                this._mainComponent.casInitializerDescFilePath = InstallationProcessor.substituteMainRootInString(this._mainComponent.casInitializerDescFilePath, this._mainComponent.rootDirPath);
            }
            if (this._mainComponent.casConsumerDescFilePath != null) {
                this._mainComponent.casConsumerDescFilePath = InstallationProcessor.substituteMainRootInString(this._mainComponent.casConsumerDescFilePath, this._mainComponent.rootDirPath);
            }
            Iterator iterator = this.getInstallationActions().iterator();
            while (iterator.hasNext()) {
                ActionInfo actionInfo = (ActionInfo)iterator.next();
                Enumeration<Object> enumeration = actionInfo.params.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = actionInfo.params.getProperty(string2);
                    if (!string2.equals("FILE") && !string2.equals("REPLACE_WITH") && !string2.equals("VAR_VALUE")) continue;
                    string3 = InstallationProcessor.substituteMainRootInString(string3, this._mainComponent.rootDirPath);
                    actionInfo.params.setProperty(string2, string3);
                }
            }
        }
    }

    public synchronized void setMainComponentService(ServiceInfo serviceInfo) {
        if (this._mainComponent != null) {
            this._mainComponent.serviceInfo = serviceInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = null;
        printWriter = new PrintWriter(stringWriter);
        InstallationDescriptorHandler.printInstallationDescriptor(this, printWriter);
        printWriter.flush();
        Object var5_3 = null;
        if (printWriter == null) return stringWriter.toString();
        try {
            printWriter.close();
            return stringWriter.toString();
        }
        catch (Exception exception) {}
        return stringWriter.toString();
        {
            catch (Exception exception) {
                Object var5_4 = null;
                if (printWriter == null) return stringWriter.toString();
                try {
                    printWriter.close();
                    return stringWriter.toString();
                }
                catch (Exception exception2) {}
                return stringWriter.toString();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (printWriter == null) throw throwable;
            try {
                printWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public synchronized void updateMainComponentId(String string) {
        this.setMainComponentId(string);
    }

    public static class ComponentInfo
    implements Serializable {
        private String _id;
        public String name = null;
        public String descFilePath = null;
        public String rootDirPath = null;
        public String deploymentType = "standard";
        public ServiceInfo serviceInfo = null;
        public Hashtable networkParams = null;
        public String collIteratorDescFilePath = null;
        public String casInitializerDescFilePath = null;
        public String casConsumerDescFilePath = null;
        public Properties props = new Properties();

        public ComponentInfo(String string) {
            this._id = string;
        }

        public String getId() {
            return this._id;
        }
    }

    public static class ServiceInfo {
        private ArrayList _args = new ArrayList();
        public String command;
        public String workingDirPath;

        public synchronized void addArg(ArgInfo argInfo) {
            this._args.add(argInfo);
        }

        public Collection getArgs() {
            return this._args;
        }
    }

    public static class ArgInfo {
        public String value;
        public String comments;
    }

    public static class ActionInfo
    implements Serializable {
        public static final String FIND_AND_REPLACE_PATH_ACT = "find_and_replace_path";
        public static final String SET_ENV_VARIABLE_ACT = "set_env_variable";
        private String _name;
        public Properties params = new Properties();

        public ActionInfo(String string) {
            this._name = string;
        }

        protected ActionInfo(ActionInfo actionInfo) {
            this._name = actionInfo.getName();
            this.params = (Properties)actionInfo.params.clone();
        }

        public String getName() {
            return this._name;
        }
    }
}

