/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.pear.tools;

import com.ibm.uima.pear.tools.InstallationDescriptor;
import com.ibm.uima.pear.tools.InstallationDescriptorHandler;
import com.ibm.uima.pear.tools.InstallationProcessor;
import com.ibm.uima.pear.tools.PackageBrowser;
import com.ibm.uima.pear.tools.PackageSelectorGUI;
import com.ibm.uima.pear.tools.SimplePackageSelector;
import com.ibm.uima.pear.util.FileUtil;
import com.ibm.uima.pear.util.MessageRouter;
import com.ibm.uima.pear.util.StringUtil;
import com.ibm.uima.util.SystemEnvReader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.jar.JarFile;

public class InstallationController {
    public static final String INSTALLATION_IN_PROGRESS = "installation_in_progress";
    public static final String INSTALLATION_FAILED = "installation_failed";
    public static final String INSTALLATION_COMPLETED = "installation_completed";
    public static final String VERIFICATION_IN_PROGRESS = "verification_in_progress";
    public static final String VERIFICATION_FAILED = "verification_failed";
    public static final String VERIFICATION_COMPLETED = "verification_completed";
    public static final String VERIFICATION_CANCELLED = "verification_cancelled";
    protected static final String INSTALLATION_TESTER_APP = "com.ibm.uima.pear.tools.InstallationTester";
    protected static final String PACKAGE_CONFIG_FILE = "metadata/PEAR.properties";
    protected static final String PACKAGE_METADATA_DIR = "metadata";
    protected static final String PACKAGE_BIN_DIR = "bin";
    protected static final String PACKAGE_CONF_DIR = "conf";
    protected static final String PACKAGE_DATA_DIR = "data";
    protected static final String PACKAGE_DESC_DIR = "desc";
    protected static final String PACKAGE_DOC_DIR = "doc";
    protected static final String PACKAGE_LIB_DIR = "lib";
    protected static final String PACKAGE_RESOURCES_DIR = "resources";
    protected static final String PACKAGE_SOURCES_DIR = "src";
    public static final String SET_ENV_FILE = "metadata/setenv.txt";
    protected static final String UIMA_HOME_ENV = "UIMA_HOME";
    protected static final String UIMA_LIB_DIR = "/lib";
    protected static final String VINCI_LIB_DIR = "/lib/vinci";
    protected static final String JAR_FILE_EXT = ".jar";
    protected static final String CLASSPATH_VAR = "classpath";
    protected static final String PATH_VAR = "path";
    protected static final String LOCAL_OPT = "-local";
    protected static final String INSTALL_IN_ROOT_OPT = "-root";
    private static boolean __inLocalMode = false;
    private static String __osName = null;
    private String _mainComponentId;
    private String _installationDirPath;
    private File _installationDir;
    private String _mainComponentRootPath;
    private File _mainComponentRoot;
    private String _mainPearFileLocation = null;
    private Hashtable _installationTable = new Hashtable();
    private Hashtable _installationInsDs = new Hashtable();
    private InstallationDescriptor _insdObject;
    private String _hostIpAddress;
    private String _uimaHomePath;
    private String _installationMsg;
    private String _verificationMsg;
    private MessageRouter _msgRouter = null;
    private MessageRouter.StdChannelListener _defaultMsgListener = null;
    private PackageSelector _packageSelector = null;
    private InstallationMonitor _installationMonitor = null;

    protected static StringBuffer addListOfJarFiles(File file, StringBuffer stringBuffer) throws IOException {
        if (file.isDirectory()) {
            Collection collection = FileUtil.createFileList(file);
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (!file2.getName().toLowerCase().endsWith(JAR_FILE_EXT)) continue;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(File.pathSeparatorChar);
                }
                stringBuffer.append(file2.getAbsolutePath().replace('\\', '/'));
            }
        }
        return stringBuffer;
    }

    protected static boolean addToSystemEnvTable(Properties properties, String string, String string2) {
        boolean bl = false;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements() && !bl) {
            String string3 = (String)enumeration.nextElement();
            if (!string3.equalsIgnoreCase(string)) continue;
            String string4 = properties.getProperty(string3);
            properties.setProperty(string3, string2 + File.pathSeparator + string4);
            bl = true;
        }
        return bl;
    }

    public static String[] buildArrayOfNetworkParams(InstallationDescriptor installationDescriptor) {
        String[] stringArray = new String[]{};
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        Set set = installationDescriptor.getMainComponentNetworkParamNames();
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                Properties properties = installationDescriptor.getMainComponentNetworkParam(string);
                Enumeration<Object> enumeration = properties.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    String string3 = properties.getProperty(string2);
                    if (string3.length() <= 0) continue;
                    stringBuffer.setLength(0);
                    stringBuffer.append("-D");
                    stringBuffer.append(string2.trim());
                    stringBuffer.append('=');
                    stringBuffer.append(string3.trim());
                    arrayList.add(stringBuffer.toString());
                }
            }
        }
        if (arrayList.size() > 0) {
            stringArray = new String[arrayList.size()];
            arrayList.toArray(stringArray);
        }
        return stringArray;
    }

    public static String buildComponentClassPath(String string, InstallationDescriptor installationDescriptor) throws IOException {
        File file = new File(string + "/" + PACKAGE_LIB_DIR);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer = InstallationController.addListOfJarFiles(file, stringBuffer);
        Iterator iterator = installationDescriptor.getInstallationActions("set_env_variable").iterator();
        while (iterator.hasNext()) {
            InstallationDescriptor.ActionInfo actionInfo = (InstallationDescriptor.ActionInfo)iterator.next();
            if (actionInfo.params == null) continue;
            String string2 = actionInfo.params.getProperty("VAR_NAME");
            String string3 = actionInfo.params.getProperty("VAR_VALUE");
            if (string2 == null || string3 == null || !string2.equalsIgnoreCase(CLASSPATH_VAR)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(string3.replace('\\', '/'));
        }
        return stringBuffer.toString();
    }

    public static String buildComponentPath(String string, InstallationDescriptor installationDescriptor) {
        File file = new File(string + "/" + PACKAGE_BIN_DIR);
        StringBuffer stringBuffer = new StringBuffer();
        if (file.isDirectory()) {
            stringBuffer.append(file.getAbsolutePath().replace('\\', '/'));
        }
        Iterator iterator = installationDescriptor.getInstallationActions("set_env_variable").iterator();
        while (iterator.hasNext()) {
            InstallationDescriptor.ActionInfo actionInfo = (InstallationDescriptor.ActionInfo)iterator.next();
            if (actionInfo.params == null) continue;
            String string2 = actionInfo.params.getProperty("VAR_NAME");
            String string3 = actionInfo.params.getProperty("VAR_VALUE");
            if (string2 == null || string3 == null || !string2.equalsIgnoreCase(PATH_VAR)) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(string3.replace('\\', '/'));
        }
        return stringBuffer.toString();
    }

    public static String buildListOfEnvVars(InstallationDescriptor installationDescriptor) {
        Properties properties = InstallationController.buildTableOfEnvVars(installationDescriptor);
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            if (string.length() <= 0 || string2 == null || string2.length() <= 0) continue;
            if (stringBuffer.length() > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append("-D");
            stringBuffer.append(string);
            stringBuffer.append('=');
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public static String buildListOfNetworkParams(InstallationDescriptor installationDescriptor) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = InstallationController.buildArrayOfNetworkParams(installationDescriptor);
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static Properties buildTableOfEnvVars(InstallationDescriptor installationDescriptor) {
        Properties properties = new Properties();
        Iterator iterator = installationDescriptor.getInstallationActions("set_env_variable").iterator();
        while (iterator.hasNext()) {
            InstallationDescriptor.ActionInfo actionInfo = (InstallationDescriptor.ActionInfo)iterator.next();
            String string = actionInfo.params.getProperty("VAR_NAME");
            String string2 = actionInfo.params.getProperty("VAR_VALUE");
            if (string == null || string2 == null || string.equalsIgnoreCase(CLASSPATH_VAR) || string.equalsIgnoreCase(PATH_VAR)) continue;
            String string3 = properties.getProperty(string);
            if (string3 != null) {
                string3 = string3 + File.pathSeparator + string2;
                properties.setProperty(string, string3);
                continue;
            }
            properties.setProperty(string, string2);
        }
        return properties;
    }

    public static String buildUIMAClassPath(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            File file = new File(string + UIMA_LIB_DIR);
            stringBuffer = InstallationController.addListOfJarFiles(file, stringBuffer);
            File file2 = new File(string + VINCI_LIB_DIR);
            stringBuffer = InstallationController.addListOfJarFiles(file2, stringBuffer);
            return stringBuffer.toString();
        }
        catch (IOException iOException) {
            return File.pathSeparator;
        }
    }

    public static boolean deleteInstalledFiles(String string, File file, boolean bl) throws IOException {
        boolean bl2 = true;
        File file2 = new File(file, string);
        if (!file2.isDirectory()) {
            return false;
        }
        if (bl) {
            InstallationDescriptorHandler installationDescriptorHandler = new InstallationDescriptorHandler();
            File file3 = new File(file2, "metadata/install.xml");
            try {
                installationDescriptorHandler.parse(file3);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new IOException(exception.getMessage());
            }
            InstallationDescriptor installationDescriptor = installationDescriptorHandler.getInstallationDescriptor();
            Hashtable hashtable = installationDescriptor.getDelegateComponents();
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (InstallationController.deleteInstalledFiles(string2, file, true)) continue;
                bl2 = false;
            }
        }
        if (!FileUtil.deleteDirectory(file2)) {
            bl2 = false;
        }
        return bl2;
    }

    protected static TestStatus deployInstallationVerificationTest(String string, InstallationDescriptor installationDescriptor, String string2, String string3, String string4, Properties properties, String string5) throws IOException {
        String[] stringArray;
        Object object;
        Object object2;
        String string6;
        String string7;
        Object object3;
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = new StringBuffer();
        String string8 = System.getProperty("os.name");
        String string9 = System.getProperty("java.home");
        String string10 = string8.indexOf("Windows") >= 0 ? "java.exe" : "java";
        String string11 = null;
        File file = null;
        string11 = string9 + File.separator + PACKAGE_BIN_DIR + File.separator + string10;
        file = new File(string11);
        if (!file.isFile()) {
            string11 = string9 + File.separator + "jre" + File.separator + PACKAGE_BIN_DIR + File.separator + string10;
            file = new File(string11);
        }
        arrayList.add(file.getAbsolutePath());
        arrayList.add("-Xmx512M");
        arrayList.add("-cp");
        stringBuffer.setLength(0);
        stringBuffer.append(string3);
        stringBuffer.append(File.pathSeparatorChar);
        stringBuffer.append(string5);
        arrayList.add(stringBuffer.toString());
        if (string4.length() > 0) {
            stringBuffer.setLength(0);
            stringBuffer.append("-Djava.library.path=");
            stringBuffer.append(string4);
            arrayList.add(stringBuffer.toString());
        }
        if (installationDescriptor.getMainComponentDeployment().equals("network")) {
            object3 = InstallationController.buildArrayOfNetworkParams(installationDescriptor);
            for (int i = 0; i < ((String[])object3).length; ++i) {
                arrayList.add(object3[i]);
            }
        }
        object3 = new ArrayList();
        Properties properties2 = new Properties();
        try {
            properties2 = SystemEnvReader.getEnvVars();
        }
        catch (Throwable throwable) {
            throw new IOException("system environment error: " + throwable.toString());
        }
        String string12 = properties.getProperty("CLASSPATH");
        if (string12 != null && string12.length() > 0 && InstallationController.addToSystemEnvTable(properties2, "CLASSPATH", string12)) {
            properties.remove("CLASSPATH");
        }
        if ((string7 = properties.getProperty("PATH")) != null && string7.length() > 0 && InstallationController.addToSystemEnvTable(properties2, "PATH", string7)) {
            properties.remove("PATH");
        }
        if ((string6 = properties.getProperty("LD_LIBRARY_PATH")) != null && string6.length() > 0 && InstallationController.addToSystemEnvTable(properties2, "LD_LIBRARY_PATH", string6)) {
            properties.remove("LD_LIBRARY_PATH");
        }
        StringBuffer stringBuffer2 = new StringBuffer();
        Enumeration<Object> enumeration = properties2.keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = properties2.getProperty((String)object2);
            if (object.length() <= 0) continue;
            stringBuffer2.setLength(0);
            stringBuffer2.append((String)object2);
            stringBuffer2.append('=');
            stringBuffer2.append((String)object);
            ((ArrayList)object3).add(stringBuffer2.toString());
        }
        object2 = properties.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            stringArray = properties.getProperty((String)object);
            if (stringArray.length() <= 0) continue;
            stringBuffer2.setLength(0);
            stringBuffer2.append((String)object);
            stringBuffer2.append('=');
            stringBuffer2.append((String)stringArray);
            ((ArrayList)object3).add(stringBuffer2.toString());
            stringBuffer.setLength(0);
            stringBuffer.append("-D");
            stringBuffer.append(stringBuffer2.toString());
            arrayList.add(stringBuffer.toString());
        }
        arrayList.add(INSTALLATION_TESTER_APP);
        stringBuffer.setLength(0);
        stringBuffer.append(string2);
        arrayList.add(stringBuffer.toString());
        object = new String[arrayList.size()];
        arrayList.toArray((T[])object);
        stringArray = new String[((ArrayList)object3).size()];
        ((ArrayList)object3).toArray(stringArray);
        File file2 = new File(string);
        return InstallationController.runInstallationVerificationTest(object, stringArray, file2);
    }

    public static String extractFilesFromPEARFile(String string, String string2, String string3, File file) throws IOException {
        return InstallationController.extractFilesFromPEARFile(string, string2, string3, file, null);
    }

    protected static String extractFilesFromPEARFile(String string, String string2, String string3, File file, InstallationController installationController) throws IOException {
        long l = FileUtil.getFileSize(string2);
        if (!file.isDirectory() && !file.mkdirs()) {
            throw new IOException("cannot create directory " + file.getAbsolutePath());
        }
        File file2 = null;
        boolean bl = false;
        boolean bl2 = false;
        try {
            long l2;
            Object object;
            file2 = new File(string2);
            if (!file2.isFile()) {
                object = new URL(string2);
                if (installationController != null) {
                    installationController.getOutMsgWriter().println("[InstallationController]: copying " + l + " bytes from " + ((URL)object).toExternalForm() + " to " + file.getAbsolutePath());
                } else {
                    System.out.println("[InstallationController]: copying " + l + " bytes from " + ((URL)object).toExternalForm() + " to " + file.getAbsolutePath());
                }
                String string4 = new File(((URL)object).getFile()).getName();
                file2 = new File(file, string4);
                if (!FileUtil.copyFile((URL)object, file2)) {
                    throw new IOException("cannot copy " + object + " to file " + file2.getAbsolutePath());
                }
                bl = true;
            }
            if (installationController != null) {
                installationController.getOutMsgWriter().println("[InstallationController]: extracting " + file2.getAbsolutePath());
            } else {
                System.out.println("[InstallationController]: extracting " + file2.getAbsolutePath());
            }
            object = new JarFile(file2);
            long l3 = l2 = string3 == null ? FileUtil.extractFilesFromJar((JarFile)object, file) : FileUtil.extractFilesWithExtFromJar((JarFile)object, string3, file);
            if (installationController != null) {
                installationController.getOutMsgWriter().println("[InstallationController]: " + l2 + " bytes extracted");
            } else {
                System.out.println("[InstallationController]: " + l2 + " bytes extracted");
            }
            if (bl && !file2.delete()) {
                file2.deleteOnExit();
            }
            bl2 = true;
        }
        catch (MalformedURLException malformedURLException) {
            throw new FileNotFoundException(string2);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Throwable throwable) {
            throw new IOException(throwable.toString());
        }
        return bl2 ? file.getAbsolutePath() : null;
    }

    public static String extractPEARFile(String string, String string2, File file) throws IOException {
        return InstallationController.extractFilesFromPEARFile(string, string2, null, file);
    }

    protected static String extractPEARFile(String string, String string2, File file, InstallationController installationController) throws IOException {
        return InstallationController.extractFilesFromPEARFile(string, string2, null, file, installationController);
    }

    protected static Hashtable getDelegateInstallationDescriptors(Hashtable hashtable) throws IOException {
        Enumeration enumeration = hashtable.keys();
        Hashtable<String, InstallationDescriptor> hashtable2 = new Hashtable<String, InstallationDescriptor>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = (String)hashtable.get(string);
            PackageBrowser packageBrowser = new PackageBrowser(new File(string2));
            InstallationDescriptor installationDescriptor = packageBrowser.getInstallationDescriptor();
            hashtable2.put(string, installationDescriptor);
        }
        return hashtable2;
    }

    public static String getHostIpAddress() {
        String string = "127.0.0.1";
        try {
            string = InetAddress.getLocalHost().getHostAddress();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    protected static String getInstalledComponentRootPath(String string, PackageSelector packageSelector) {
        String string2 = null;
        PackageSelector packageSelector2 = packageSelector != null ? packageSelector : new SimplePackageSelector();
        File file = packageSelector2.selectPackageDirectory(string);
        if (file != null) {
            string2 = file.getAbsolutePath();
        }
        return string2;
    }

    protected static String getPEARFileLocation(String string, PackageSelector packageSelector) {
        String string2 = null;
        PackageSelector packageSelector2 = packageSelector != null ? packageSelector : new SimplePackageSelector();
        File file = packageSelector2.selectPackageFile(string);
        if (file != null) {
            string2 = file.getAbsolutePath();
        } else {
            URL uRL = packageSelector2.selectPackageUrl(string);
            if (uRL != null) {
                string2 = uRL.toString();
            }
        }
        return string2;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("usage: InstallationController {-local pear_file | main_component_id} [-root] [installation_dir]");
            return;
        }
        File file = null;
        String string = null;
        boolean bl = false;
        File file2 = null;
        int n = 0;
        if (stringArray[n].equals(LOCAL_OPT)) {
            InstallationController.setLocalMode(true);
            if (stringArray.length > n + 1) {
                file = new File(stringArray[++n]);
            }
        } else {
            string = stringArray[n++];
        }
        for (int i = n; i < stringArray.length; ++i) {
            if (stringArray[i].equals(INSTALL_IN_ROOT_OPT)) {
                bl = true;
                continue;
            }
            file2 = new File(stringArray[i]);
        }
        if (file == null && string == null) {
            System.err.println("usage: InstallationController {-local pear_file | main_component_id} [-root] [installation_dir]");
            return;
        }
        if (file != null && !file.exists()) {
            System.err.println("[InstallationController]: " + file.getAbsolutePath() + " file not found");
        }
        if (file2 == null) {
            file2 = new File(".");
        } else if (!file2.isDirectory()) {
            System.err.println("[InstallationController]: " + file2.getAbsolutePath() + " directory not found");
            return;
        }
        if (__inLocalMode) {
            try {
                JarFile jarFile = new JarFile(file);
                InstallationDescriptorHandler installationDescriptorHandler = new InstallationDescriptorHandler();
                installationDescriptorHandler.parseInstallationDescriptor(jarFile);
                InstallationDescriptor installationDescriptor = installationDescriptorHandler.getInstallationDescriptor();
                if (installationDescriptor == null) {
                    throw new FileNotFoundException("installation descriptor not found");
                }
                string = installationDescriptor.getMainComponentId();
            }
            catch (Exception exception) {
                System.err.println("[InstallationController]: terminated \n" + exception.toString());
                return;
            }
        }
        InstallationController installationController = __inLocalMode ? new InstallationController(string, file, file2, bl) : new InstallationController(string, file2.getAbsolutePath(), bl);
        installationController.setPackageSelector(new PackageSelectorGUI());
        if (installationController.installComponent() == null) {
            installationController.getErrMsgWriter().println("[InstallationController]: installation of " + string + " failed => \n" + installationController.getInstallationMsg());
        } else {
            try {
                installationController.getOutMsgWriter().println("[InstallationController]: installation of " + string + " completed");
                if (installationController.verifyComponent()) {
                    installationController.getOutMsgWriter().println("[InstallationController]: verification of " + string + " completed");
                    installationController.getOutMsgWriter().println("[InstallationController]: " + string + " installed in the " + installationController._mainComponentRootPath + " directory.");
                } else {
                    installationController.getOutMsgWriter().println("[InstallationController]: verification of " + string + " failed => \n" + installationController.getVerificationMsg());
                }
            }
            catch (Exception exception) {
                System.err.println("Error in InstallationController.main(): " + exception.toString());
                exception.printStackTrace(System.err);
            }
        }
        installationController.terminate();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static TestStatus runInstallationVerificationTest(String[] stringArray, String[] stringArray2, File file) throws IOException {
        if (System.getProperty("DEBUG") != null) {
            int n;
            System.out.println(">>> DBG: command array => ");
            for (n = 0; n < stringArray.length; ++n) {
                System.out.println("\t[" + n + "]=" + stringArray[n]);
            }
            System.out.println(">>> DBG: env array => ");
            for (n = 0; n < stringArray2.length; ++n) {
                System.out.println("\t" + stringArray2[n]);
            }
            System.out.println(">>> DBG: working dir => ");
            System.out.println("\t" + file.getAbsolutePath());
        }
        BufferedReader bufferedReader = null;
        TestStatus testStatus = new TestStatus();
        try {
            String string;
            Process process = Runtime.getRuntime().exec(stringArray, stringArray2, file);
            bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            while ((string = bufferedReader.readLine()) != null) {
                printWriter.println(string);
            }
            try {
                testStatus.retCode = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            testStatus.message = stringWriter.toString();
            Object var11_11 = null;
            if (bufferedReader == null) return testStatus;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return testStatus;
        }
        catch (Exception exception) {}
        return testStatus;
    }

    public static synchronized void setLocalMode(boolean bl) {
        __inLocalMode = bl;
    }

    public static synchronized TestStatus verifyComponentInstallation(InstallationController installationController, String string) {
        try {
            if (installationController._insdObject == null) {
                throw new RuntimeException("null installation descriptor");
            }
            InstallationDescriptor installationDescriptor = installationController._insdObject;
            String string2 = installationDescriptor.getMainComponentRoot();
            if (string2 == null) {
                throw new RuntimeException("main root directory not specified");
            }
            String string3 = installationDescriptor.getMainComponentDesc();
            if (string3 == null) {
                throw new RuntimeException("main descriptor path not specified");
            }
            if (string == null) {
                throw new RuntimeException("UIMA_HOME variable not specified");
            }
            String string4 = installationController.buildComponentClassPath();
            String string5 = InstallationController.buildUIMAClassPath(string);
            String string6 = installationController.buildComponentPath();
            Properties properties = installationController.buildTableOfEnvVars();
            if (string4.length() > 0) {
                properties.setProperty("CLASSPATH", string4);
            }
            if (string6.length() > 0) {
                properties.setProperty("PATH", string6);
                properties.setProperty("LD_LIBRARY_PATH", string6);
            }
            return InstallationController.deployInstallationVerificationTest(string2, installationDescriptor, string3, string4, string6, properties, string5);
        }
        catch (Throwable throwable) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            TestStatus testStatus = new TestStatus();
            testStatus.retCode = -1;
            testStatus.message = stringWriter.toString();
            return testStatus;
        }
    }

    public InstallationController(String string, String string2) {
        this(string, string2, false);
    }

    public InstallationController(String string, String string2, boolean bl) {
        this(string, string2, bl, null);
    }

    public InstallationController(String string, String string2, boolean bl, MessageRouter.StdChannelListener stdChannelListener) {
        this(string, string2, bl, null, stdChannelListener);
        this.getOutMsgWriter().println("[InstallationController]: OS - " + __osName + ", Host - " + this._hostIpAddress);
        if (__inLocalMode) {
            this.getOutMsgWriter().println("[InstallationController]: working in 'local' mode");
        }
    }

    protected InstallationController(String string, String string2, boolean bl, MessageRouter messageRouter, MessageRouter.StdChannelListener stdChannelListener) {
        this._msgRouter = messageRouter == null ? new MessageRouter() : messageRouter;
        this._defaultMsgListener = stdChannelListener == null ? new MessageRouter.StdChannelListener(){

            public void errMsgPosted(String string) {
                System.err.print(string);
                System.err.flush();
            }

            public void outMsgPosted(String string) {
                System.out.print(string);
                System.out.flush();
            }
        } : stdChannelListener;
        this.addMsgListener(this._defaultMsgListener);
        if (!this._msgRouter.isRunning()) {
            this._msgRouter.start();
        }
        this._mainComponentId = string;
        if (bl) {
            this._mainComponentRootPath = string2;
            this._mainComponentRoot = new File(this._mainComponentRootPath);
            this._installationDir = this._mainComponentRoot.getParentFile();
            this._installationDirPath = this._installationDir.getAbsolutePath();
        } else {
            this._installationDirPath = string2;
            this._installationDir = new File(this._installationDirPath);
            this._mainComponentRoot = new File(this._installationDir, string);
            this._mainComponentRootPath = this._mainComponentRoot.getAbsolutePath();
        }
        this._uimaHomePath = System.getProperty(UIMA_HOME_ENV);
        if (this._uimaHomePath != null) {
            this._uimaHomePath = this._uimaHomePath.replace('\\', '/');
        }
        if (__osName == null) {
            __osName = System.getProperty("os.name");
        }
        this._hostIpAddress = InstallationController.getHostIpAddress();
        this._packageSelector = new SimplePackageSelector(this.getOutMsgWriter(), this.getErrMsgWriter());
    }

    public InstallationController(String string, File file, File file2) {
        this(string, file, file2, false);
    }

    public InstallationController(String string, File file, File file2, boolean bl) {
        this(string, file2.getAbsolutePath(), bl);
        this._mainPearFileLocation = file.getAbsolutePath();
    }

    public InstallationController(String string, File file, File file2, boolean bl, MessageRouter.StdChannelListener stdChannelListener) {
        this(string, file2.getAbsolutePath(), bl, stdChannelListener);
        this._mainPearFileLocation = file.getAbsolutePath();
    }

    public void addMsgListener(MessageRouter.StdChannelListener stdChannelListener) {
        this._msgRouter.addChannelListener(stdChannelListener);
    }

    public String buildComponentClassPath() throws IOException {
        if (this._insdObject != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = InstallationController.buildComponentClassPath(this._mainComponentRootPath, this._insdObject);
            stringBuffer.append(string);
            if (this._installationTable.size() > 0) {
                Enumeration enumeration = this._installationTable.keys();
                while (enumeration.hasMoreElements()) {
                    InstallationDescriptor installationDescriptor;
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)this._installationTable.get(string2);
                    String string4 = InstallationController.buildComponentClassPath(string3, installationDescriptor = (InstallationDescriptor)this._installationInsDs.get(string2));
                    if (string4.length() <= 0) continue;
                    if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != File.pathSeparatorChar) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(string4);
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public String buildComponentPath() {
        if (this._insdObject != null) {
            StringBuffer stringBuffer = new StringBuffer();
            String string = InstallationController.buildComponentPath(this._mainComponentRootPath, this._insdObject);
            stringBuffer.append(string);
            if (this._installationTable.size() > 0) {
                Enumeration enumeration = this._installationTable.keys();
                while (enumeration.hasMoreElements()) {
                    InstallationDescriptor installationDescriptor;
                    String string2 = (String)enumeration.nextElement();
                    String string3 = (String)this._installationTable.get(string2);
                    String string4 = InstallationController.buildComponentPath(string3, installationDescriptor = (InstallationDescriptor)this._installationInsDs.get(string2));
                    if (string4.length() <= 0) continue;
                    if (stringBuffer.length() > 0 && stringBuffer.charAt(stringBuffer.length() - 1) != File.pathSeparatorChar) {
                        stringBuffer.append(File.pathSeparatorChar);
                    }
                    stringBuffer.append(string4);
                }
            }
            return stringBuffer.toString();
        }
        return null;
    }

    public Properties buildTableOfEnvVars() {
        if (this._insdObject != null) {
            Properties properties = InstallationController.buildTableOfEnvVars(this._insdObject);
            if (this._installationTable.size() > 0) {
                Enumeration enumeration = this._installationTable.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    InstallationDescriptor installationDescriptor = (InstallationDescriptor)this._installationInsDs.get(string);
                    Properties properties2 = InstallationController.buildTableOfEnvVars(installationDescriptor);
                    properties = StringUtil.appendProperties(properties, properties2, false);
                }
            }
            return properties;
        }
        return null;
    }

    protected void finalize() {
        this._msgRouter.terminate();
    }

    public synchronized InstallationDescriptor installComponent() {
        try {
            if (this._installationMonitor != null) {
                this._installationMonitor.setInstallationStatus(this._mainComponentId, INSTALLATION_IN_PROGRESS);
            }
            if (this._mainPearFileLocation == null) {
                this._mainPearFileLocation = InstallationController.getPEARFileLocation(this._mainComponentId, this._packageSelector);
            }
            if (InstallationController.extractPEARFile(this._mainComponentId, this._mainPearFileLocation, this._mainComponentRoot, this) == null) {
                this.setInstallationError(new IOException("PEAR extraction failed"));
                if (this._installationMonitor != null) {
                    this._installationMonitor.setInstallationStatus(this._mainComponentId, INSTALLATION_FAILED);
                }
                return null;
            }
            InstallationDescriptorHandler installationDescriptorHandler = new InstallationDescriptorHandler();
            File file = new File(this._mainComponentRoot, "metadata/install.xml");
            installationDescriptorHandler.parse(file);
            this._insdObject = installationDescriptorHandler.getInstallationDescriptor();
            this.installDelegateComponents();
            InstallationProcessor installationProcessor = new InstallationProcessor(this._mainComponentRootPath, this._installationTable, this);
            installationProcessor.process();
            this._insdObject = installationProcessor.getInstallationDescriptor();
            this.saveInstallationDescriptorFile();
            this.generatePackageConfigFile();
            this.generateSetEnvFile();
            this.getOutMsgWriter().println("[InstallationController]: the metadata/setenv.txt file contains required environment variables for this component");
            this.getOutMsgWriter().println("[InstallationController]: component " + this._mainComponentId + " installation completed.");
            if (this._installationMonitor != null) {
                this._installationMonitor.setInstallationLocation(this._mainComponentId, this._mainComponentRootPath);
                this._installationMonitor.setInstallationStatus(this._mainComponentId, INSTALLATION_COMPLETED);
            }
        }
        catch (Exception exception) {
            this.getErrMsgWriter().println("Error in InstallationController: " + exception);
            exception.printStackTrace(this.getErrMsgWriter());
            this.setInstallationError(exception);
            if (this._installationMonitor != null) {
                this._installationMonitor.setInstallationStatus(this._mainComponentId, INSTALLATION_FAILED);
            }
            return null;
        }
        return this._insdObject;
    }

    public synchronized InstallationDescriptor installComponentDescriptors() {
        try {
            if (this._mainPearFileLocation == null) {
                this._mainPearFileLocation = InstallationController.getPEARFileLocation(this._mainComponentId, this._packageSelector);
            }
            if (InstallationController.extractFilesFromPEARFile(this._mainComponentId, this._mainPearFileLocation, ".xml", this._mainComponentRoot, this) == null) {
                this.setInstallationError(new IOException("PEAR extraction failed"));
                return null;
            }
            InstallationDescriptorHandler installationDescriptorHandler = new InstallationDescriptorHandler();
            File file = new File(this._mainComponentRoot, "metadata/install.xml");
            installationDescriptorHandler.parse(file);
            this._insdObject = installationDescriptorHandler.getInstallationDescriptor();
            this.installDelegateComponentsDescriptors();
            InstallationProcessor installationProcessor = new InstallationProcessor(this._mainComponentRootPath, this._installationTable);
            installationProcessor.process();
            this._insdObject = installationProcessor.getInstallationDescriptor();
            this.getOutMsgWriter().println("[InstallationController]: component " + this._mainComponentId + " descriptors installation completed.");
        }
        catch (Exception exception) {
            this.getErrMsgWriter().println("Error in InstallationController: " + exception);
            exception.printStackTrace(this.getErrMsgWriter());
            this.setInstallationError(exception);
            return null;
        }
        return this._insdObject;
    }

    protected synchronized void installDelegateComponents() {
        Enumeration enumeration = this._insdObject.getDelegateComponents().keys();
        while (enumeration.hasMoreElements()) {
            InstallationDescriptor installationDescriptor;
            Object object;
            String string = (String)enumeration.nextElement();
            String string2 = null;
            try {
                string2 = InstallationController.getInstalledComponentRootPath(string, this._packageSelector);
            }
            catch (Exception exception) {
                this.getErrMsgWriter().println("[InstallationController]: failed to query " + string + " location - " + exception);
            }
            if (string2 == null) {
                object = new InstallationController(string, this._installationDirPath, false, this._msgRouter, this._defaultMsgListener);
                ((InstallationController)object).setPackageSelector(this._packageSelector);
                installationDescriptor = ((InstallationController)object).installComponent();
                if (installationDescriptor == null) {
                    this.getErrMsgWriter().println("[InstallationController]: failed to install dlg component " + string);
                    throw new RuntimeException("failed to install dlg component " + string);
                }
                string2 = installationDescriptor.getMainComponentRoot();
                this._installationTable.put(string, string2);
                this._installationInsDs.put(string, installationDescriptor);
                continue;
            }
            this._installationTable.put(string, string2);
            try {
                object = new PackageBrowser(new File(string2));
                installationDescriptor = ((PackageBrowser)object).getInstallationDescriptor();
                this._installationInsDs.put(string, installationDescriptor);
            }
            catch (IOException iOException) {}
        }
    }

    protected synchronized void installDelegateComponentsDescriptors() {
        Enumeration enumeration = this._insdObject.getDelegateComponents().keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            InstallationController installationController = new InstallationController(string, this._installationDirPath, false, this._msgRouter, this._defaultMsgListener);
            installationController.setPackageSelector(this._packageSelector);
            InstallationDescriptor installationDescriptor = installationController.installComponentDescriptors();
            if (installationDescriptor == null) {
                this.getErrMsgWriter().println("[InstallationController]: failed to install descriptors for dlg component " + string);
                throw new RuntimeException("failed to install descriptors for dlg component " + string);
            }
            String string2 = installationDescriptor.getMainComponentRoot();
            this._installationTable.put(string, string2);
            this._installationInsDs.put(string, installationDescriptor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected synchronized void generateSetEnvFile() throws IOException {
        File file = new File(this._mainComponentRoot, SET_ENV_FILE);
        PrintWriter printWriter = null;
        try {
            String string;
            printWriter = new PrintWriter(new FileWriter(file));
            printWriter.println("### Add the following environment variables");
            printWriter.println("### to appropriate existing environment variables");
            printWriter.println("### to run the " + this._mainComponentId + " component");
            printWriter.println();
            String string2 = this.buildComponentClassPath();
            if (string2.length() > 0) {
                printWriter.println("CLASSPATH=" + string2);
            }
            if ((string = this.buildComponentPath()).length() > 0) {
                printWriter.println("PATH=" + string);
            }
            Properties properties = this.buildTableOfEnvVars();
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = (String)enumeration.nextElement();
                String string4 = properties.getProperty(string3);
                if (string3.length() <= 0 || string4.length() <= 0 || string3.equalsIgnoreCase(CLASSPATH_VAR) || string3.equalsIgnoreCase(PATH_VAR)) continue;
                printWriter.println(string3 + "=" + string4);
            }
            Object var10_9 = null;
            if (printWriter == null) return;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            if (printWriter == null) throw throwable;
            try {
                printWriter.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            printWriter.close();
            return;
        }
        catch (Exception exception) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized void generatePackageConfigFile() throws IOException {
        Object object;
        String string;
        Object object2;
        File file;
        Properties properties;
        block12: {
            properties = new Properties();
            file = new File(this._mainComponentRoot, PACKAGE_CONFIG_FILE);
            if (file.exists()) {
                object2 = null;
                try {
                    object2 = new FileInputStream(file);
                    properties.load((InputStream)object2);
                    string = null;
                    if (object2 == null) break block12;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    if (object2 == null) throw throwable;
                    try {
                        ((InputStream)object2).close();
                        throw throwable;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {}
                catch (Exception exception) {}
                ((InputStream)object2).close();
            }
        }
        properties.setProperty("$main_root", this._mainComponentRootPath.replace('\\', '/'));
        object2 = this._installationTable.keySet().iterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            string = "$" + (String)object + "$root";
            properties.setProperty(string, ((String)this._installationTable.get(object)).replace('\\', '/'));
        }
        object = null;
        try {
            string = this._mainComponentId;
            object = new FileOutputStream(file);
            properties.store((OutputStream)object, string);
            Object var8_10 = null;
            if (object == null) return;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (object == null) throw throwable;
            try {
                ((OutputStream)object).close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception exception) {
            return;
        }
        ((OutputStream)object).close();
    }

    protected PrintWriter getErrMsgWriter() {
        return this._msgRouter.errWriter();
    }

    public String getInstallationMsg() {
        return this._installationMsg;
    }

    protected PrintWriter getOutMsgWriter() {
        return this._msgRouter.outWriter();
    }

    public String getVerificationMsg() {
        return this._verificationMsg;
    }

    public void removeMsgListener(MessageRouter.StdChannelListener stdChannelListener) {
        this._msgRouter.removeChannelListener(stdChannelListener);
    }

    public synchronized void saveInstallationDescriptorFile() throws IOException {
        if (this._insdObject != null) {
            File file = this._insdObject.getInstallationDescriptorFile();
            InstallationDescriptorHandler.saveInstallationDescriptor(this._insdObject, file);
        }
    }

    protected synchronized void setInstallationError(Exception exception) {
        this._installationMsg = StringUtil.errorStackTraceContent(exception);
    }

    public synchronized void setInstallationMonitor(InstallationMonitor installationMonitor) {
        if (installationMonitor != null) {
            this._installationMonitor = installationMonitor;
        }
    }

    public synchronized void setPackageSelector(PackageSelector packageSelector) {
        if (packageSelector != null) {
            this._packageSelector = packageSelector;
        }
    }

    protected synchronized void setVerificationError(Exception exception) {
        this._verificationMsg = StringUtil.errorStackTraceContent(exception);
    }

    public synchronized void setUimaHomePath(String string) {
        this._uimaHomePath = string.replace('\\', '/');
    }

    public void terminate() {
        this._msgRouter.terminate();
    }

    public synchronized boolean verifyComponent() {
        boolean bl;
        block10: {
            bl = false;
            try {
                if (this._installationMonitor != null) {
                    this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_IN_PROGRESS);
                }
                TestStatus testStatus = InstallationController.verifyComponentInstallation(this, this._uimaHomePath);
                if (testStatus.retCode == 0) {
                    bl = true;
                    this._verificationMsg = null;
                    if (this._installationMonitor != null) {
                        this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_COMPLETED);
                    }
                } else if (testStatus.retCode == -1) {
                    this._verificationMsg = testStatus.message;
                    if (this._installationMonitor != null) {
                        this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_FAILED);
                    }
                } else {
                    this._verificationMsg = null;
                    if (this._installationMonitor != null) {
                        this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_CANCELLED);
                    }
                }
            }
            catch (Exception exception) {
                this._verificationMsg = exception.toString();
                if (this._installationMonitor == null) break block10;
                this._installationMonitor.setInstallationStatus(this._mainComponentId, VERIFICATION_FAILED);
            }
        }
        return bl;
    }

    public static class TestStatus {
        public int retCode;
        public String message;
    }

    public static interface PackageSelector {
        public File selectPackageDirectory(String var1);

        public File selectPackageFile(String var1);

        public URL selectPackageUrl(String var1);
    }

    public static interface InstallationMonitor {
        public void setInstallationStatus(String var1, String var2);

        public void setInstallationLocation(String var1, String var2);
    }
}

