/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jcas.cas;

import com.ibm.uima.cas.FloatArrayFS;
import com.ibm.uima.jcas.cas.TOP;
import com.ibm.uima.jcas.cas.TOP_Type;
import com.ibm.uima.jcas.impl.JCas;

public final class FloatArray
extends TOP
implements FloatArrayFS {
    public static final int typeIndexID;
    public static final int type;

    public int getTypeIndexID() {
        return typeIndexID;
    }

    private FloatArray() {
    }

    public FloatArray(int n, TOP_Type tOP_Type) {
        super(n, tOP_Type);
    }

    public FloatArray(JCas jCas, int n) {
        this(jCas.getLowLevelCas().ll_createArray(jCas.getType((int)FloatArray.typeIndexID).casTypeCode, n), jCas.getType(typeIndexID));
        this.jcasType.casImpl.checkArrayPreconditions(n);
    }

    public FloatArray create(JCas jCas, int n) {
        return new FloatArray(jCas, n);
    }

    public float get(int n) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, n);
        return this.jcasType.ll_cas.ll_getFloatArrayValue(this.addr, n);
    }

    public void set(int n, float f) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, n);
        this.jcasType.ll_cas.ll_setFloatArrayValue(this.addr, n, f);
    }

    public void copyFromArray(float[] fArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            this.jcasType.ll_cas.ll_setFloatArrayValue(this.addr, n2, fArray[n]);
            ++n2;
            ++n;
        }
    }

    public void copyToArray(int n, float[] fArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            fArray[n2] = this.jcasType.ll_cas.ll_getFloatArrayValue(this.addr, n);
            ++n2;
            ++n;
        }
    }

    public float[] toArray() {
        int n = this.size();
        float[] fArray = new float[n];
        this.copyToArray(0, fArray, 0, n);
        return fArray;
    }

    public int size() {
        return this.jcasType.casImpl.getArraySize(this.addr);
    }

    public void copyToArray(int n, String[] stringArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            stringArray[n2] = Float.toString(this.jcasType.ll_cas.ll_getFloatArrayValue(this.addr, n));
            ++n2;
            ++n;
        }
    }

    public void copyFromArray(String[] stringArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        float[] fArray = new float[n3];
        for (int i = 0; i < n3; ++i) {
            fArray[n2] = Float.parseFloat(stringArray[i]);
        }
        this.copyFromArray(fArray, n, n2, n3);
    }

    public String[] toStringArray() {
        int n = this.size();
        String[] stringArray = new String[n];
        this.copyToArray(0, stringArray, 0, n);
        return stringArray;
    }

    static {
        type = typeIndexID = JCas.getNextIndex();
    }
}

