/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.jcas.cas;

import com.ibm.uima.cas.ArrayFS;
import com.ibm.uima.cas.FeatureStructure;
import com.ibm.uima.cas.impl.LowLevelCAS;
import com.ibm.uima.jcas.cas.TOP;
import com.ibm.uima.jcas.cas.TOP_Type;
import com.ibm.uima.jcas.impl.JCas;

public final class FSArray
extends TOP
implements ArrayFS {
    public static final int typeIndexID;
    public static final int type;

    public int getTypeIndexID() {
        return typeIndexID;
    }

    private FSArray() {
    }

    public FSArray(int n, TOP_Type tOP_Type) {
        super(n, tOP_Type);
    }

    public FSArray(JCas jCas, int n) {
        this(jCas.getLowLevelCas().ll_createArray(jCas.getType((int)FSArray.typeIndexID).casTypeCode, n), jCas.getType(typeIndexID));
        this.jcasType.casImpl.checkArrayPreconditions(n);
    }

    public FSArray create(JCas jCas, int n) {
        return new FSArray(jCas, n);
    }

    public FeatureStructure get(int n) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, n);
        LowLevelCAS lowLevelCAS = this.jcasType.ll_cas;
        return lowLevelCAS.ll_getFSForRef(lowLevelCAS.ll_getRefArrayValue(this.addr, n));
    }

    public void set(int n, FeatureStructure featureStructure) {
        this.jcasType.casImpl.checkArrayBounds(this.addr, n);
        this.jcasType.ll_cas.ll_setRefArrayValue(this.addr, n, this.jcasType.ll_cas.ll_getFSRef(featureStructure));
    }

    public int size() {
        return this.jcasType.casImpl.getArraySize(this.addr);
    }

    public void copyFromArray(FeatureStructure[] featureStructureArray, int n, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n2 < 0 || n2 + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            this.jcasType.ll_cas.ll_setRefArrayValue(this.addr, n2, this.jcasType.ll_cas.ll_getFSRef(featureStructureArray[n]));
            ++n2;
            ++n;
        }
    }

    public void copyToArray(int n, FeatureStructure[] featureStructureArray, int n2, int n3) throws ArrayIndexOutOfBoundsException {
        if (n < 0 || n + n3 > this.size()) {
            throw new ArrayIndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            featureStructureArray[n2] = this.jcasType.ll_cas.ll_getFSForRef(this.jcasType.ll_cas.ll_getRefArrayValue(this.addr, n));
            ++n2;
            ++n;
        }
    }

    public FeatureStructure[] toArray() {
        int n = this.size();
        FeatureStructure[] featureStructureArray = new FeatureStructure[n];
        this.copyToArray(0, featureStructureArray, 0, n);
        return featureStructureArray;
    }

    static {
        type = typeIndexID = JCas.getNextIndex();
    }
}

