/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.ecore;

import com.ibm.uima.ResourceSpecifierFactory;
import com.ibm.uima.UIMAFramework;
import com.ibm.uima.UIMARuntimeException;
import com.ibm.uima.resource.metadata.AllowedValue;
import com.ibm.uima.resource.metadata.FeatureDescription;
import com.ibm.uima.resource.metadata.FsIndexDescription;
import com.ibm.uima.resource.metadata.TypeDescription;
import com.ibm.uima.resource.metadata.TypeSystemDescription;
import com.ibm.uima.util.CasCreationUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;

public class Ecore2UimaTypeSystem {
    public static final String OPTION_GENERATE_UIMA_LIST_TYPES = "OPTION_GENERATE_UIMA_LIST_TYPES";
    public static final String OPTION_CREATE_ANNOTATION_SUBTYPES = "OPTION_CREATE_ANNOTATION_SUBTYPES";
    private static ResourceSpecifierFactory uimaFactory = UIMAFramework.getResourceSpecifierFactory();

    public static TypeSystemDescription ecore2UimaTypeSystem(String string, Map map) throws URISyntaxException {
        Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        File file = new File(string);
        URI uRI = URI.createFileURI((String)file.getAbsolutePath());
        Resource resource = resourceSetImpl.getResource(uRI, true);
        return Ecore2UimaTypeSystem.ecore2UimaTypeSystem(resource, map);
    }

    public static TypeSystemDescription ecore2UimaTypeSystem(Resource resource, Map map) throws URISyntaxException {
        Object object;
        if (map == null) {
            map = Collections.EMPTY_MAP;
        }
        TypeSystemDescription typeSystemDescription = uimaFactory.createTypeSystemDescription();
        EPackage ePackage = (EPackage)resource.getContents().get(0);
        EAnnotation eAnnotation = ePackage.getEAnnotation("http://uima.watson.ibm.com");
        if (eAnnotation != null) {
            typeSystemDescription.setName((String)eAnnotation.getDetails().get((Object)"name"));
            typeSystemDescription.setDescription((String)eAnnotation.getDetails().get((Object)"description"));
            typeSystemDescription.setVendor((String)eAnnotation.getDetails().get((Object)"vendor"));
            typeSystemDescription.setVersion((String)eAnnotation.getDetails().get((Object)"version"));
        }
        ArrayList arrayList = new ArrayList();
        Iterator iterator = resource.getContents().iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (!(object instanceof EPackage)) continue;
            Ecore2UimaTypeSystem.ePackage2UimaTypes((EPackage)object, arrayList, map);
        }
        object = new TypeDescription[arrayList.size()];
        arrayList.toArray((T[])object);
        typeSystemDescription.setTypes((TypeDescription[])object);
        return typeSystemDescription;
    }

    private static void ePackage2UimaTypes(EPackage ePackage, List list, Map map) throws URISyntaxException {
        String string = ePackage.getNsURI();
        String string2 = Ecore2UimaTypeSystem.namespaceUri2UimaNamespace(string);
        if ("uima.cas".equals(string2)) {
            return;
        }
        Iterator iterator = ePackage.getEClassifiers().iterator();
        while (iterator.hasNext()) {
            TypeDescription typeDescription;
            EClass eClass;
            Object e = iterator.next();
            if (e instanceof EClass) {
                eClass = (EClass)e;
                typeDescription = Ecore2UimaTypeSystem.eclass2UimaType(eClass, string2, map);
                if ("uima.tcas.Annotation".equals(typeDescription.getName())) continue;
                list.add(typeDescription);
                continue;
            }
            if (!(e instanceof EEnum)) continue;
            eClass = (EEnum)e;
            typeDescription = Ecore2UimaTypeSystem.eenum2UimaType((EEnum)eClass, string2, map);
            list.add(typeDescription);
        }
        iterator = ePackage.getESubpackages().iterator();
        while (iterator.hasNext()) {
            Ecore2UimaTypeSystem.ePackage2UimaTypes((EPackage)iterator.next(), list, map);
        }
    }

    private static TypeDescription eclass2UimaType(EClass eClass, String string, Map map) throws URISyntaxException {
        FeatureDescription featureDescription;
        Object object;
        EClass eClass2;
        EList eList;
        TypeDescription typeDescription = uimaFactory.createTypeDescription();
        if (string != null) {
            typeDescription.setName(string + "." + eClass.getName());
        } else {
            typeDescription.setName(eClass.getName());
        }
        EAnnotation eAnnotation = eClass.getEAnnotation("http://uima.watson.ibm.com");
        if (eAnnotation != null) {
            typeDescription.setDescription((String)eAnnotation.getDetails().get((Object)"description"));
        }
        if ((eList = eClass.getESuperTypes()).isEmpty()) {
            if (map.get(OPTION_CREATE_ANNOTATION_SUBTYPES) == Boolean.FALSE) {
                typeDescription.setSupertypeName("uima.cas.TOP");
            } else {
                eClass2 = eClass.getEStructuralFeature("begin");
                object = eClass.getEStructuralFeature("end");
                if (eClass2 != null && object != null && eClass2.getEType() == EcorePackage.eINSTANCE.getEInt() && object.getEType() == EcorePackage.eINSTANCE.getEInt()) {
                    typeDescription.setSupertypeName("uima.tcas.Annotation");
                } else {
                    typeDescription.setSupertypeName("uima.cas.TOP");
                }
            }
        } else {
            eClass2 = (EClass)eList.get(0);
            if (eClass2.equals(EcorePackage.eINSTANCE.getEObject())) {
                typeDescription.setSupertypeName("uima.cas.TOP");
            }
            object = Ecore2UimaTypeSystem.getUimaTypeName((EClassifier)eClass2, false, map);
            typeDescription.setSupertypeName((String)object);
            if (eList.size() > 1) {
                System.err.println("Warning: EClass " + eClass.getName() + " defines multiple supertypes. " + "The UIMA supertype will be " + typeDescription.getSupertypeName() + "; features inherited from other supertypes will be copied down.");
            }
        }
        eClass2 = eClass.getEStructuralFeatures();
        object = eClass2.iterator();
        ArrayList<FeatureDescription> arrayList = new ArrayList<FeatureDescription>();
        while (object.hasNext()) {
            EStructuralFeature eStructuralFeature = (EStructuralFeature)object.next();
            featureDescription = Ecore2UimaTypeSystem.eStructuralFeature2UimaFeature(eStructuralFeature, map);
            arrayList.add(featureDescription);
        }
        for (int i = 1; i < eList.size(); ++i) {
            featureDescription = (EClass)eList.get(i);
            EList eList2 = featureDescription.getEStructuralFeatures();
            Iterator iterator = eList2.iterator();
            while (iterator.hasNext()) {
                EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator.next();
                EList eList3 = eClass.getEStructuralFeatures();
                EList eList4 = ((EClass)eList.get(0)).getEAllStructuralFeatures();
                if (Ecore2UimaTypeSystem.containsNamedElement(eList3, eStructuralFeature.getName()) || Ecore2UimaTypeSystem.containsNamedElement(eList4, eStructuralFeature.getName())) continue;
                FeatureDescription featureDescription2 = Ecore2UimaTypeSystem.eStructuralFeature2UimaFeature(eStructuralFeature, map);
                arrayList.add(featureDescription2);
            }
        }
        FeatureDescription[] featureDescriptionArray = new FeatureDescription[arrayList.size()];
        arrayList.toArray(featureDescriptionArray);
        typeDescription.setFeatures(featureDescriptionArray);
        return typeDescription;
    }

    private static boolean containsNamedElement(EList eList, String string) {
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (!(e instanceof ENamedElement) || !string.equals(((ENamedElement)e).getName())) continue;
            return true;
        }
        return false;
    }

    private static TypeDescription eenum2UimaType(EEnum eEnum, String string, Map map) throws URISyntaxException {
        TypeDescription typeDescription = uimaFactory.createTypeDescription();
        if (string != null) {
            typeDescription.setName(string + "." + eEnum.getName());
        } else {
            typeDescription.setName(eEnum.getName());
        }
        typeDescription.setSupertypeName("uima.cas.String");
        EAnnotation eAnnotation = eEnum.getEAnnotation("http://uima.watson.ibm.com");
        if (eAnnotation != null) {
            typeDescription.setDescription((String)eAnnotation.getDetails().get((Object)"description"));
        }
        EList eList = eEnum.getELiterals();
        AllowedValue[] allowedValueArray = new AllowedValue[eList.size()];
        for (int i = 0; i < eList.size(); ++i) {
            EEnumLiteral eEnumLiteral = (EEnumLiteral)eList.get(i);
            allowedValueArray[i] = uimaFactory.createAllowedValue();
            allowedValueArray[i].setString(eEnumLiteral.getName());
            EAnnotation eAnnotation2 = eEnumLiteral.getEAnnotation("http://uima.watson.ibm.com");
            if (eAnnotation2 == null) continue;
            allowedValueArray[i].setDescription((String)eAnnotation2.getDetails().get((Object)"description"));
        }
        typeDescription.setAllowedValues(allowedValueArray);
        return typeDescription;
    }

    private static FeatureDescription eStructuralFeature2UimaFeature(EStructuralFeature eStructuralFeature, Map map) throws URISyntaxException {
        FeatureDescription featureDescription = uimaFactory.createFeatureDescription();
        featureDescription.setName(eStructuralFeature.getName());
        String string = null;
        String string2 = null;
        EAnnotation eAnnotation = eStructuralFeature.getEAnnotation("http://uima.watson.ibm.com");
        if (eAnnotation != null) {
            featureDescription.setDescription((String)eAnnotation.getDetails().get((Object)"description"));
            string = (String)eAnnotation.getDetails().get((Object)"uimaType");
            string2 = (String)eAnnotation.getDetails().get((Object)"elementType");
        }
        EClassifier eClassifier = eStructuralFeature.getEType();
        if (string == null) {
            string = Ecore2UimaTypeSystem.getUimaTypeName(eClassifier, eStructuralFeature.isMany(), map);
        }
        featureDescription.setRangeTypeName(string);
        if (eStructuralFeature.isMany()) {
            String string3 = Ecore2UimaTypeSystem.getUimaTypeName(eClassifier, false, map);
            if (!("uima.cas.Integer".equals(string3) || "uima.cas.Float".equals(string3) || "uima.cas.String".equals(string3) || "uima.cas.TOP".equals(string3))) {
                featureDescription.setElementType(string3);
            }
        } else if (Ecore2UimaTypeSystem.isArrayOrList(string)) {
            featureDescription.setMultipleReferencesAllowed(Boolean.TRUE);
            featureDescription.setElementType(string2);
        }
        return featureDescription;
    }

    private static boolean isArrayOrList(String string) {
        return "uima.cas.FSList".equals(string) || "uima.cas.IntegerList".equals(string) || "uima.cas.FloatList".equals(string) || "uima.cas.StringList".equals(string) || "uima.cas.FSArray".equals(string) || "uima.cas.IntegerArray".equals(string) || "uima.cas.FloatArray".equals(string) || "uima.cas.StringArray".equals(string);
    }

    private static String getUimaTypeName(EClassifier eClassifier, boolean bl, Map map) throws URISyntaxException {
        boolean bl2 = Boolean.TRUE.equals(map.get(OPTION_GENERATE_UIMA_LIST_TYPES));
        if (eClassifier.eIsProxy() && (eClassifier = (EClassifier)EcoreUtil.resolve((EObject)eClassifier, (EObject)eClassifier)).eIsProxy()) {
            throw new UIMARuntimeException("ecore_unresolved_proxy", new Object[]{eClassifier.toString()});
        }
        if (eClassifier instanceof EClass || eClassifier instanceof EEnum) {
            if (bl) {
                return bl2 ? "uima.cas.FSList" : "uima.cas.FSArray";
            }
            EPackage ePackage = eClassifier.getEPackage();
            if (ePackage != null) {
                String string = Ecore2UimaTypeSystem.namespaceUri2UimaNamespace(ePackage.getNsURI());
                if (string != null) {
                    return string + '.' + eClassifier.getName();
                }
                return eClassifier.getName();
            }
            return eClassifier.getName();
        }
        if (eClassifier.equals(EcorePackage.eINSTANCE.getEInt()) || eClassifier.equals(EcorePackage.eINSTANCE.getEShort()) || eClassifier.equals(EcorePackage.eINSTANCE.getELong())) {
            return bl ? (bl2 ? "uima.cas.IntegerList" : "uima.cas.IntegerArray") : "uima.cas.Integer";
        }
        if (eClassifier.equals(EcorePackage.eINSTANCE.getEFloat()) || eClassifier.equals(EcorePackage.eINSTANCE.getEDouble())) {
            return bl ? (bl2 ? "uima.cas.FloatList" : "uima.cas.FloatArray") : "uima.cas.Float";
        }
        if (!eClassifier.equals(EcorePackage.eINSTANCE.getEString())) {
            System.err.println("Warning: unknown EDataType " + eClassifier.getName() + " being mapped to uima.cas.String.");
        }
        return bl ? (bl2 ? "uima.cas.StringList" : "uima.cas.StringArray") : "uima.cas.String";
    }

    private static String namespaceUri2UimaNamespace(String string) throws URISyntaxException {
        if ("http:///uima/noNamespace.ecore".equals(string)) {
            return null;
        }
        java.net.URI uRI = new java.net.URI(string);
        String string2 = uRI.getPath();
        while (string2.startsWith("/")) {
            string2 = string2.substring(1);
        }
        if (string2.endsWith(".ecore")) {
            string2 = string2.substring(0, string2.length() - 6);
        }
        return string2.replace('/', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 2) {
            System.err.println("Usage: java " + Ecore2UimaTypeSystem.class.getName() + " <ecore filename> <filename of UIMA TypeSystem file to generate>");
            return;
        }
        if (!new File(stringArray[0]).exists()) {
            System.err.println("File " + stringArray[0] + " does not exist");
            return;
        }
        HashMap hashMap = new HashMap();
        TypeSystemDescription typeSystemDescription = Ecore2UimaTypeSystem.ecore2UimaTypeSystem(stringArray[0], hashMap);
        FileOutputStream fileOutputStream = new FileOutputStream(stringArray[1]);
        try {
            typeSystemDescription.toXML(fileOutputStream);
        }
        finally {
            fileOutputStream.close();
        }
        try {
            CasCreationUtils.createCas(typeSystemDescription, null, new FsIndexDescription[0]);
        }
        catch (Exception exception) {
            System.err.println("Warning: CAS could not be created from the output type system.  The following problem occurred:");
            System.err.println(exception.getMessage());
        }
    }
}

