/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.text;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class TCASException
extends Exception {
    private static final String resource_file = "com.ibm.uima.cas.text.tcas_errors";
    private static final String missing_resource_error = "Could not load message catalog: com.ibm.uima.cas.text.tcas_errors";
    private static final int MESSAGES_NOT_FOUND = -1;
    public static final int MUST_COMMIT_TYPE_SYSTEM = 0;
    public static final int TCAS_RESET_ERROR = 1;
    public static final int NOT_AN_ANNOTATION = 2;
    public static final int OLD_STYLE_TCAS = 3;
    private static final String[] identifiers = new String[]{"MUST_COMMIT_TYPE_SYSTEM", "TCAS_RESET_ERROR", "NOT_AN_ANNOTATION", "OLD_STYLE_TCAS"};
    private int error;
    private ResourceBundle resource = null;
    private String[] arguments = new String[9];

    public TCASException(int n) {
        this.error = n;
    }

    public int getError() {
        return this.error;
    }

    public String getMessage() {
        if (this.resource == null) {
            try {
                this.resource = ResourceBundle.getBundle(resource_file);
            }
            catch (MissingResourceException missingResourceException) {
                this.error = -1;
                return missing_resource_error;
            }
        }
        return new MessageFormat(this.resource.getString(identifiers[this.error])).format(this.arguments);
    }

    public String toString() {
        return "TCASException: " + this.getMessage();
    }

    public boolean addArgument(String string) {
        for (int i = 0; i < this.arguments.length; ++i) {
            if (this.arguments[i] != null) continue;
            this.arguments[i] = string;
            return true;
        }
        return false;
    }

    public String getMessageCode() {
        return identifiers[this.error];
    }

    public String[] getArguments() {
        return this.arguments;
    }

    public String getBundleShortName() {
        if (resource_file.indexOf(46) >= 0) {
            return resource_file.substring(resource_file.lastIndexOf(46) + 1);
        }
        return resource_file;
    }
}

