/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.text;

public class Language {
    public static final String UNSPECIFIED_LANGUAGE = "x-unspecified";
    public static final Language ZH = new Language("zh");
    public static final Language ZH_CN = new Language("zh-cn");
    public static final Language ZH_TW = new Language("zh-tw");
    public static final char CANONICAL_LANG_SEPARATOR = '-';
    private String lang;
    private String langPart = null;
    private String territoryPart = null;

    public Language(String string) {
        this.lang = Language.normalize(string);
        this.parseLanguage();
    }

    public static final String normalize(String string) {
        if (string == null) {
            return UNSPECIFIED_LANGUAGE;
        }
        string = string.toLowerCase();
        string = string.replace('_', '-');
        return string;
    }

    public String getLanguagePart() {
        return this.langPart;
    }

    public String getTerritoryPart() {
        return this.territoryPart;
    }

    public String getFullLanguage() {
        return this.lang;
    }

    private final void parseLanguage() {
        int n = this.lang.indexOf(45);
        if (n < 0) {
            this.langPart = this.lang;
            return;
        }
        this.langPart = this.lang.substring(0, n);
        if (++n < this.lang.length()) {
            this.territoryPart = this.lang.substring(n);
        }
    }

    public String toString() {
        return "Full language string: " + this.getFullLanguage() + ", language part: " + this.getLanguagePart() + ", territory part: " + this.getTerritoryPart();
    }

    public static void main(String[] stringArray) {
        System.out.println(ZH);
        System.out.println(ZH_CN);
        System.out.println(new Language("en_US_NY"));
    }
}

