/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.UimaContext;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.FSIndex;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.SofaFS;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSIndexRepositoryImpl;
import com.ibm.uima.cas.impl.ListUtils;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.cas.impl.XmiSerializationSharedData;
import com.ibm.uima.cas.impl.XmlCasSerializer;
import com.ibm.uima.util.IntStack;
import com.ibm.uima.util.IntVector;
import com.ibm.uima.util.Level;
import com.ibm.uima.util.Logger;
import com.ibm.uima.util.XMLSerializer;
import com.ibm.uima.util.rb_trees.IntRedBlackTree;
import com.ibm.uima.util.rb_trees.RedBlackTree;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;

public class XmiCasSerializer
implements XmlCasSerializer {
    private int numChildren;
    public static final String XMI_NS_URI = "http://www.omg.org/XMI";
    public static final String XSI_NS_URI = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XMI_NS_PREFIX = "xmi";
    public static final String XMI_TAG_LOCAL_NAME = "XMI";
    public static final String XMI_TAG_QNAME = "xmi:XMI";
    public static final XmlElementName XMI_TAG = new XmlElementName("http://www.omg.org/XMI", "XMI", "xmi:XMI");
    public static final String INDEXED_ATTR_NAME = "_indexed";
    public static final String ID_ATTR_NAME = "xmi:id";
    public static final String XMI_VERSION_LOCAL_NAME = "version";
    public static final String XMI_VERSION_QNAME = "xmi:version";
    public static final String XMI_VERSION_VALUE = "2.0";
    private static final int INT_TYPE = 0;
    private static final int FLOAT_TYPE = 1;
    private static final int STRING_TYPE = 2;
    private static final int FS_TYPE = 3;
    private static final int INT_ARRAY_TYPE = 4;
    private static final int FLOAT_ARRAY_TYPE = 5;
    private static final int STRING_ARRAY_TYPE = 6;
    private static final int FS_ARRAY_TYPE = 7;
    private static final int INT_LIST_TYPE = 9;
    private static final int FLOAT_LIST_TYPE = 10;
    private static final int STRING_LIST_TYPE = 11;
    private static final int FS_LIST_TYPE = 12;
    private TypeSystemImpl ts;
    private UimaContext uimaContext;
    private XmlElementName[] xmiTypeNames;
    private Map nsUriToPrefixMap = new HashMap();
    private Set nsPrefixesUsed = new HashSet();
    private Map nsUriToSchemaLocationMap = null;
    private Logger logger;

    public int getNumChildren() {
        return this.numChildren;
    }

    public XmiCasSerializer(TypeSystem typeSystem, UimaContext uimaContext, Map map) {
        this.ts = (TypeSystemImpl)typeSystem;
        this.uimaContext = uimaContext;
        this.nsUriToSchemaLocationMap = map;
        this.logger = UIMAFramework.getLogger(XmiCasSerializer.class);
        this.initTypeAndNamespaceMappings();
    }

    public XmiCasSerializer(TypeSystem typeSystem, UimaContext uimaContext) {
        this(typeSystem, uimaContext, null);
    }

    public XmiCasSerializer(TypeSystem typeSystem) {
        this(typeSystem, null, null);
    }

    public void serialize(CAS cAS, ContentHandler contentHandler) throws IOException, SAXException {
        this.serialize(cAS, contentHandler, null);
    }

    public void serialize(CAS cAS, ContentHandler contentHandler, ErrorHandler errorHandler) throws IOException, SAXException {
        contentHandler.startDocument();
        XmiCasDocSerializer xmiCasDocSerializer = new XmiCasDocSerializer(contentHandler, errorHandler, ((CASImpl)cAS).getBaseCAS(), null);
        xmiCasDocSerializer.serialize();
        contentHandler.endDocument();
    }

    public void serialize(CAS cAS, ContentHandler contentHandler, ErrorHandler errorHandler, XmiSerializationSharedData xmiSerializationSharedData) throws IOException, SAXException {
        contentHandler.startDocument();
        XmiCasDocSerializer xmiCasDocSerializer = new XmiCasDocSerializer(contentHandler, errorHandler, ((CASImpl)cAS).getBaseCAS(), xmiSerializationSharedData);
        xmiCasDocSerializer.serialize();
        contentHandler.endDocument();
    }

    public static void serialize(CAS cAS, OutputStream outputStream) throws SAXException, IOException {
        XmiCasSerializer xmiCasSerializer = new XmiCasSerializer(cAS.getTypeSystem());
        XMLSerializer xMLSerializer = new XMLSerializer(outputStream, false);
        xmiCasSerializer.serialize(cAS, xMLSerializer.getContentHandler());
    }

    private void initTypeAndNamespaceMappings() {
        this.nsUriToPrefixMap.put(XMI_NS_URI, XMI_NS_PREFIX);
        this.xmiTypeNames = new XmlElementName[this.ts.getLargestTypeCode() + 1];
        Iterator iterator = this.ts.getTypeIterator();
        while (iterator.hasNext()) {
            TypeImpl typeImpl = (TypeImpl)iterator.next();
            this.xmiTypeNames[typeImpl.getCode()] = this.uimaTypeName2XmiElementName(typeImpl.getName());
        }
    }

    private XmlElementName uimaTypeName2XmiElementName(String string) {
        String string2;
        String string3;
        String string4;
        int n = string.lastIndexOf(46);
        if (n == -1) {
            string4 = null;
            string3 = string;
            string2 = "http:///uima/noNamespace.ecore";
        } else {
            string4 = string.substring(0, n);
            string3 = string.substring(n + 1);
            string2 = "http:///" + string4.replace('.', '/') + ".ecore";
        }
        String string5 = (String)this.nsUriToPrefixMap.get(string2);
        if (string5 == null) {
            if (string4 != null) {
                int n2 = string4.lastIndexOf(46);
                string5 = string4.substring(n2 + 1);
            } else {
                string5 = "noNamespace";
            }
            if (this.nsPrefixesUsed.contains(string5)) {
                String string6 = string5;
                int n3 = 2;
                while (this.nsPrefixesUsed.contains(string6 + n3)) {
                    ++n3;
                }
                string5 = string6 + n3;
            }
            this.nsUriToPrefixMap.put(string2, string5);
        }
        return new XmlElementName(string2, string3, string5 + ':' + string3);
    }

    static class XmlElementNameAndContents {
        XmlElementName name;
        String contents;

        XmlElementNameAndContents(XmlElementName xmlElementName, String string) {
            this.name = xmlElementName;
            this.contents = string;
        }
    }

    static class XmlElementName {
        String nsUri;
        String localName;
        String qName;

        XmlElementName(String string, String string2, String string3) {
            this.nsUri = string;
            this.localName = string2;
            this.qName = string3;
        }
    }

    private class XmiCasDocSerializer {
        private ContentHandler ch;
        private ErrorHandler eh = null;
        private CASImpl cas;
        private IntRedBlackTree visited;
        private IntVector indexedFSs;
        private IntStack queue;
        private RedBlackTree sofaNumToXmiIdMap;
        private int sofaTypeCode;
        private int annotationTypeCode;
        private final AttributesImpl emptyAttrs = new AttributesImpl();
        private AttributesImpl workAttrs = new AttributesImpl();
        private static final String cdataType = "CDATA";
        private int fsCount = 0;
        private ListUtils listUtils;
        private IntRedBlackTree arrayAndListFSs;
        private XmiSerializationSharedData sharedData;

        private XmiCasDocSerializer(ContentHandler contentHandler, ErrorHandler errorHandler, CASImpl cASImpl, XmiSerializationSharedData xmiSerializationSharedData) {
            this.ch = contentHandler;
            this.eh = errorHandler;
            this.cas = cASImpl;
            this.visited = new IntRedBlackTree();
            this.queue = new IntStack();
            this.indexedFSs = new IntVector();
            this.sofaTypeCode = cASImpl.ts.getTypeCode("uima.cas.Sofa");
            this.annotationTypeCode = cASImpl.ts.getTypeCode("uima.tcas.Annotation");
            this.listUtils = new ListUtils(cASImpl, XmiCasSerializer.this.logger, errorHandler);
            this.arrayAndListFSs = new IntRedBlackTree();
            this.sofaNumToXmiIdMap = new RedBlackTree();
            this.sharedData = xmiSerializationSharedData;
        }

        private void reportWarning(String string) throws SAXException {
            XmiCasSerializer.this.logger.log(Level.WARNING, string);
            if (this.eh != null) {
                this.eh.warning(new SAXParseException(string, null));
            }
        }

        private boolean isVisited(int n) {
            return this.visited.containsKey(n);
        }

        private void serialize() throws IOException, SAXException {
            int n = 1;
            this.enqueueIndexed();
            this.enqueueFeaturesOfIndexed();
            n += this.indexedFSs.size();
            n += this.queue.size();
            FSIndex fSIndex = this.cas.getBaseCAS().indexRepository.getIndex("SofaIndex");
            this.workAttrs.clear();
            this.computeNamespaceDeclarationAttrs(this.workAttrs);
            this.workAttrs.addAttribute(XmiCasSerializer.XMI_NS_URI, XmiCasSerializer.XMI_VERSION_LOCAL_NAME, XmiCasSerializer.XMI_VERSION_QNAME, cdataType, XmiCasSerializer.XMI_VERSION_VALUE);
            this.startElement(XMI_TAG, this.workAttrs, n += fSIndex.size() + 1);
            this.writeNullObject();
            this.encodeIndexed();
            this.encodeQueued();
            this.writeViews();
            this.endElement(XMI_TAG);
        }

        private void writeViews() throws SAXException {
            FSIndexRepositoryImpl fSIndexRepositoryImpl = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getIndexRepository();
            int[] nArray = fSIndexRepositoryImpl.getIndexedFSs();
            this.writeView(0, nArray);
            FSIndex fSIndex = this.cas.getBaseCAS().indexRepository.getIndex("SofaIndex");
            FSIterator fSIterator = fSIndex.iterator();
            while (fSIterator.isValid()) {
                SofaFS sofaFS = (SofaFS)fSIterator.get();
                int n = sofaFS.getSofaRef();
                fSIterator.moveToNext();
                FSIndexRepositoryImpl fSIndexRepositoryImpl2 = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaFS);
                if (fSIndexRepositoryImpl2 == null) continue;
                nArray = fSIndexRepositoryImpl2.getIndexedFSs();
                this.writeView(n, nArray);
            }
        }

        private void writeView(int n, int[] nArray) throws SAXException {
            Object object;
            this.workAttrs.clear();
            if (n > 0) {
                this.addAttribute(this.workAttrs, "sofa", (String)this.sofaNumToXmiIdMap.get(n));
            }
            if (nArray.length > 0) {
                object = new StringBuffer();
                ((StringBuffer)object).append(this.getXmiId(nArray[0]));
                for (int i = 1; i < nArray.length; ++i) {
                    ((StringBuffer)object).append(' ').append(this.getXmiId(nArray[i]));
                }
                this.addAttribute(this.workAttrs, "members", ((StringBuffer)object).toString());
            }
            object = XmiCasSerializer.this.uimaTypeName2XmiElementName("uima.cas.View");
            this.startElement((XmlElementName)object, this.workAttrs, 0);
            this.endElement((XmlElementName)object);
        }

        private void writeNullObject() throws SAXException {
            this.workAttrs.clear();
            this.addAttribute(this.workAttrs, XmiCasSerializer.ID_ATTR_NAME, "0");
            XmlElementName xmlElementName = XmiCasSerializer.this.uimaTypeName2XmiElementName("uima.cas.NULL");
            this.startElement(xmlElementName, this.workAttrs, 0);
            this.endElement(xmlElementName);
        }

        private void computeNamespaceDeclarationAttrs(AttributesImpl attributesImpl) {
            Object object;
            Object object2;
            Iterator iterator = XmiCasSerializer.this.nsUriToPrefixMap.entrySet().iterator();
            while (iterator.hasNext()) {
                object2 = iterator.next();
                object = (String)object2.getKey();
                String string = (String)object2.getValue();
                this.workAttrs.addAttribute(null, string, "xmlns:" + string, cdataType, (String)object);
            }
            if (XmiCasSerializer.this.nsUriToSchemaLocationMap != null) {
                this.workAttrs.addAttribute(null, "xsi", "xmlns:xsi", cdataType, XmiCasSerializer.XSI_NS_URI);
                object2 = new StringBuffer();
                iterator = XmiCasSerializer.this.nsUriToSchemaLocationMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    ((StringBuffer)object2).append(object.getKey()).append(' ').append(object.getValue()).append(' ');
                }
                this.workAttrs.addAttribute(null, "xsi", "xsi:schemaLocation", cdataType, ((StringBuffer)object2).toString());
            }
        }

        private void enqueueIndexed() {
            FSIndexRepositoryImpl fSIndexRepositoryImpl = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getIndexRepository();
            int[] nArray = fSIndexRepositoryImpl.getIndexedFSs();
            for (int i = 0; i < nArray.length; ++i) {
                this.enqueueIndexedFs(nArray[i], 0);
            }
            FSIndex fSIndex = this.cas.getBaseCAS().indexRepository.getIndex("SofaIndex");
            FSIterator fSIterator = fSIndex.iterator();
            while (fSIterator.isValid()) {
                SofaFS sofaFS = (SofaFS)fSIterator.get();
                int n = sofaFS.getSofaRef();
                fSIterator.moveToNext();
                FSIndexRepositoryImpl fSIndexRepositoryImpl2 = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaFS);
                if (fSIndexRepositoryImpl2 == null) continue;
                nArray = fSIndexRepositoryImpl2.getIndexedFSs();
                for (int i = 0; i < nArray.length; ++i) {
                    this.enqueueIndexedFs(nArray[i], n);
                }
            }
        }

        private void enqueueFeaturesOfIndexed() throws SAXException {
            int n = this.indexedFSs.size();
            for (int i = 0; i < n; ++i) {
                int n2 = this.indexedFSs.get(i);
                int n3 = this.cas.getHeapValue(n2);
                this.enqueueFeatures(n2, n3);
            }
        }

        private void enqueueIndexedFs(int n, int n2) {
            if (this.isVisited(n)) {
                return;
            }
            this.visited.put(n, n);
            this.indexedFSs.add(n);
        }

        private boolean enqueue(int n) throws SAXException {
            if (this.isVisited(n)) {
                return false;
            }
            int n2 = this.cas.getHeapValue(n);
            this.visited.put(n, n);
            this.queue.push(n);
            this.enqueueFeatures(n, n2);
            if (this.cas.isFSArrayType(n2)) {
                this.enqueueFSListElements(n);
            }
            return true;
        }

        private void enqueueFeatures(int n, int n2) throws SAXException {
            boolean bl = this.listUtils.isListType(n2);
            int[] nArray = XmiCasSerializer.this.ts.getAppropriateFeatures(n2);
            block5: for (int i = 0; i < nArray.length; ++i) {
                int n3 = n + this.cas.getFeatureOffset(nArray[i]);
                int n4 = this.cas.getHeapValue(n3);
                if (n4 == 0) continue;
                int n5 = this.classifyType(XmiCasSerializer.this.ts.range(nArray[i]));
                switch (n5) {
                    case 3: {
                        this.enqueue(n4);
                        continue block5;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: {
                        if (XmiCasSerializer.this.ts.getFeature(nArray[i]).isMultipleReferencesAllowed()) {
                            this.enqueue(n4);
                            continue block5;
                        }
                        if (n5 != 7) continue block5;
                        this.enqueueFSArrayElements(n4);
                        continue block5;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: {
                        if (XmiCasSerializer.this.ts.getFeature(nArray[i]).isMultipleReferencesAllowed() || bl) {
                            this.enqueue(n4);
                            continue block5;
                        }
                        if (n5 != 12) continue block5;
                        this.enqueueFSListElements(n4);
                    }
                }
            }
        }

        private void enqueueFSArrayElements(int n) throws SAXException {
            int n2 = this.cas.getArraySize(n);
            int n3 = this.cas.getArrayStartAddress(n);
            for (int i = 0; i < n2; ++i) {
                int n4 = this.cas.getHeapValue(n3);
                if (n4 != 0) {
                    this.enqueue(n4);
                }
                ++n3;
            }
        }

        private void enqueueFSListElements(int n) throws SAXException {
            int[] nArray = this.listUtils.fsListToAddressArray(n);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) continue;
                this.enqueue(nArray[i]);
            }
        }

        private void encodeIndexed() throws IOException, SAXException {
            int n = this.indexedFSs.size();
            for (int i = 0; i < n; ++i) {
                this.encodeFS(this.indexedFSs.get(i));
            }
        }

        private void encodeQueued() throws IOException, SAXException {
            while (!this.queue.empty()) {
                int n = this.queue.pop();
                this.encodeFS(n);
            }
        }

        private void encodeFS(int n) throws IOException, SAXException {
            ++this.fsCount;
            this.workAttrs.clear();
            this.addAttribute(this.workAttrs, XmiCasSerializer.ID_ATTR_NAME, this.getXmiId(n));
            int n2 = this.cas.getHeapValue(n);
            XmlElementName xmlElementName = XmiCasSerializer.this.xmiTypeNames[n2];
            int n3 = this.classifyType(n2);
            switch (n3) {
                case 3: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    List list = this.encodeFeatures(n, this.workAttrs, n3 != 3);
                    this.startElement(xmlElementName, this.workAttrs, list.size());
                    this.sendElementEvents(list);
                    this.endElement(xmlElementName);
                    break;
                }
                case 4: 
                case 5: 
                case 7: {
                    this.workAttrs.addAttribute("", "", "elements", cdataType, this.arrayToString(n, n3));
                    this.startElement(xmlElementName, this.workAttrs, 0);
                    this.endElement(xmlElementName);
                    break;
                }
                case 6: {
                    ArrayList arrayList = new ArrayList();
                    this.stringArrayToElementList("elements", n, arrayList);
                    this.startElement(xmlElementName, this.workAttrs, arrayList.size());
                    this.sendElementEvents(arrayList);
                    this.endElement(xmlElementName);
                    break;
                }
                default: {
                    throw new SAXException("Error classifying FS type.");
                }
            }
        }

        private String getXmiId(int n) {
            if (n == 0) {
                return null;
            }
            if (this.sharedData == null) {
                return Integer.toString(n);
            }
            return this.sharedData.getXmiId(n);
        }

        private void sendElementEvents(List list) throws SAXException {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                XmlElementNameAndContents xmlElementNameAndContents = (XmlElementNameAndContents)iterator.next();
                if (xmlElementNameAndContents.contents != null) {
                    this.startElement(xmlElementNameAndContents.name, this.emptyAttrs, 1);
                    this.addText(xmlElementNameAndContents.contents);
                } else {
                    this.startElement(xmlElementNameAndContents.name, this.emptyAttrs, 0);
                }
                this.endElement(xmlElementNameAndContents.name);
            }
        }

        private List encodeFeatures(int n, AttributesImpl attributesImpl, boolean bl) throws SAXException {
            ArrayList<XmlElementNameAndContents> arrayList = new ArrayList<XmlElementNameAndContents>();
            int n2 = this.cas.getHeapValue(n);
            int[] nArray = XmiCasSerializer.this.ts.getAppropriateFeatures(n2);
            boolean bl2 = false;
            if (this.sofaTypeCode == n2) {
                bl2 = true;
            }
            for (int i = 0; i < nArray.length; ++i) {
                String string;
                int n3 = n + this.cas.getFeatureOffset(nArray[i]);
                int n4 = this.cas.getHeapValue(n3);
                String string2 = this.cas.ts.getFeature(nArray[i]).getShortName();
                int n5 = this.classifyType(XmiCasSerializer.this.ts.range(nArray[i]));
                switch (n5) {
                    case 0: {
                        if (bl2 && string2.equals("sofaNum")) {
                            this.sofaNumToXmiIdMap.put(n4, this.getXmiId(n));
                        }
                        if (string2.equals("sofa") && this.cas.ts.subsumes(this.annotationTypeCode, n2)) {
                            string = (String)this.sofaNumToXmiIdMap.get(n4);
                            break;
                        }
                        string = Integer.toString(n4);
                        break;
                    }
                    case 1: {
                        string = Float.toString(CASImpl.int2float(n4));
                        break;
                    }
                    case 2: {
                        if (n4 == 0) {
                            string = null;
                            break;
                        }
                        string = this.cas.getStringForCode(n4);
                        if (!bl2 || !string2.equals("sofaID") || XmiCasSerializer.this.uimaContext == null) break;
                        string = XmiCasSerializer.this.uimaContext.mapSofaIDToComponentSofaName(string);
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 7: {
                        if (XmiCasSerializer.this.ts.getFeature(nArray[i]).isMultipleReferencesAllowed()) {
                            string = this.getXmiId(n4);
                            break;
                        }
                        string = this.arrayToString(n4, n5);
                        break;
                    }
                    case 6: {
                        if (XmiCasSerializer.this.ts.getFeature(nArray[i]).isMultipleReferencesAllowed()) {
                            string = this.getXmiId(n4);
                            break;
                        }
                        this.stringArrayToElementList(string2, n4, arrayList);
                        string = null;
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 12: {
                        if (XmiCasSerializer.this.ts.getFeature(nArray[i]).isMultipleReferencesAllowed() || bl) {
                            string = this.getXmiId(n4);
                            break;
                        }
                        string = this.listToString(n4, n5);
                        break;
                    }
                    case 11: {
                        if (XmiCasSerializer.this.ts.getFeature(nArray[i]).isMultipleReferencesAllowed() || bl) {
                            string = this.getXmiId(n4);
                            break;
                        }
                        String[] stringArray = this.listUtils.stringListToStringArray(n4);
                        if (stringArray.length > 0 && !this.arrayAndListFSs.put(n4, n4)) {
                            this.reportWarning("Warning: multiple references to a ListFS.  Reference identity will not be preserved.");
                        }
                        for (int j = 0; j < stringArray.length; ++j) {
                            arrayList.add(new XmlElementNameAndContents(new XmlElementName(null, string2, string2), stringArray[j]));
                        }
                        string = null;
                        break;
                    }
                    default: {
                        string = this.getXmiId(n4);
                    }
                }
                if (string == null || string2 == null) continue;
                this.addAttribute(attributesImpl, string2, string);
            }
            return arrayList;
        }

        private void addText(String string) throws SAXException {
            this.ch.characters(string.toCharArray(), 0, string.length());
        }

        private void addAttribute(AttributesImpl attributesImpl, String string, String string2) {
            attributesImpl.addAttribute(null, null, string, cdataType, string2);
        }

        private void startElement(XmlElementName xmlElementName, Attributes attributes, int n) throws SAXException {
            XmiCasSerializer.this.numChildren = n;
            this.ch.startElement("", xmlElementName.localName, xmlElementName.qName, attributes);
        }

        private void endElement(XmlElementName xmlElementName) throws SAXException {
            this.ch.endElement(xmlElementName.nsUri, xmlElementName.localName, xmlElementName.qName);
        }

        private void stringArrayToElementList(String string, int n, List list) throws SAXException {
            if (n == 0) {
                return;
            }
            int n2 = this.cas.getArraySize(n);
            if (n2 > 0 && !this.arrayAndListFSs.put(n, n)) {
                this.reportWarning("Warning: multiple references to a String array.  Reference identity will not be preserved.");
            }
            int n3 = this.cas.getArrayStartAddress(n);
            for (int i = 0; i < n2; ++i) {
                String string2 = this.cas.getStringForCode(this.cas.getHeapValue(n3));
                list.add(new XmlElementNameAndContents(new XmlElementName(null, string, string), string2));
                ++n3;
            }
        }

        private String arrayToString(int n, int n2) throws SAXException {
            if (n == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = this.cas.getArraySize(n);
            if (n3 > 0 && !this.arrayAndListFSs.put(n, n)) {
                this.reportWarning("Warning: multiple references to an array.  Reference identity will not be preserved in XMI.");
            }
            int n4 = this.cas.getArrayStartAddress(n);
            for (int i = 0; i < n3; ++i) {
                int n5 = this.cas.getHeapValue(n4++);
                String string = null;
                switch (n2) {
                    case 7: {
                        String string2 = this.getXmiId(n5);
                        if (string2 != null) {
                            string = string2;
                            break;
                        }
                        string = "0";
                        break;
                    }
                    case 4: {
                        string = Integer.toString(n5);
                        break;
                    }
                    case 5: {
                        string = Float.toString(CASImpl.int2float(n5));
                        break;
                    }
                    case 6: {
                        string = this.cas.getStringForCode(n5);
                    }
                }
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(string);
            }
            return stringBuffer.toString();
        }

        private String listToString(int n, int n2) throws SAXException {
            if (n == 0) {
                return null;
            }
            StringBuffer stringBuffer = new StringBuffer();
            String[] stringArray = null;
            switch (n2) {
                case 9: {
                    stringArray = this.listUtils.intListToStringArray(n);
                    break;
                }
                case 10: {
                    stringArray = this.listUtils.floatListToStringArray(n);
                    break;
                }
                case 11: {
                    stringArray = this.listUtils.stringListToStringArray(n);
                    break;
                }
                case 12: {
                    stringArray = this.listUtils.fsListToXmiIdStringArray(n, this.sharedData);
                }
            }
            if (stringArray.length > 0 && !this.arrayAndListFSs.put(n, n)) {
                this.reportWarning("Warning: multiple references to a ListFS.  Reference identity will not be preserved.");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                if (i >= stringArray.length - 1) continue;
                stringBuffer.append(' ');
            }
            return stringBuffer.toString();
        }

        private final int classifyType(int n) {
            if (this.cas.isIntType(n)) {
                return 0;
            }
            if (this.cas.isFloatType(n)) {
                return 1;
            }
            if (this.cas.isStringType(n)) {
                return 2;
            }
            if (this.cas.isIntArrayType(n)) {
                return 4;
            }
            if (this.cas.isFloatArrayType(n)) {
                return 5;
            }
            if (this.cas.isStringArrayType(n)) {
                return 6;
            }
            if (this.cas.isFSArrayType(n)) {
                return 7;
            }
            if (this.listUtils.isIntListType(n)) {
                return 9;
            }
            if (this.listUtils.isFloatListType(n)) {
                return 10;
            }
            if (this.listUtils.isStringListType(n)) {
                return 11;
            }
            if (this.listUtils.isFsListType(n)) {
                return 12;
            }
            return 3;
        }
    }
}

