/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.UIMAFramework;
import com.ibm.uima.UimaContext;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.Feature;
import com.ibm.uima.cas.SofaFS;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSIndexRepositoryImpl;
import com.ibm.uima.cas.impl.FeatureImpl;
import com.ibm.uima.cas.impl.FeatureStructureImpl;
import com.ibm.uima.cas.impl.ListUtils;
import com.ibm.uima.cas.impl.TCASImpl;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.cas.impl.XCASParsingException;
import com.ibm.uima.cas.impl.XmiSerializationSharedData;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.reference_impl.util.I18nUtil;
import com.ibm.uima.util.IntVector;
import com.ibm.uima.util.rb_trees.IntRedBlackTree;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XmiCasDeserializer {
    private TypeSystemImpl ts;
    private UimaContext uimaContext;
    private Map xmiNamespaceToUimaNamespaceMap = new HashMap();
    static /* synthetic */ Class class$com$ibm$uima$cas$impl$XmiCasDeserializer;

    public XmiCasDeserializer(TypeSystem typeSystem, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)typeSystem;
        this.uimaContext = uimaContext;
    }

    public XmiCasDeserializer(TypeSystem typeSystem) {
        this(typeSystem, null);
    }

    public DefaultHandler getXmiCasHandler(CAS cAS) {
        return this.getXmiCasHandler(cAS, false);
    }

    public DefaultHandler getXmiCasHandler(CAS cAS, boolean bl) {
        return new XmiCasDeserializerHandler((CASImpl)cAS, bl, null);
    }

    public DefaultHandler getXmiCasHandler(CAS cAS, boolean bl, XmiSerializationSharedData xmiSerializationSharedData) {
        return new XmiCasDeserializerHandler((CASImpl)cAS, bl, xmiSerializationSharedData);
    }

    public static void deserialize(InputStream inputStream, CAS cAS) throws SAXException, IOException {
        XmiCasDeserializer.deserialize(inputStream, cAS, false);
    }

    public static void deserialize(InputStream inputStream, CAS cAS, boolean bl) throws SAXException, IOException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        XmiCasDeserializer xmiCasDeserializer = new XmiCasDeserializer(cAS.getTypeSystem());
        DefaultHandler defaultHandler = xmiCasDeserializer.getXmiCasHandler(cAS, true);
        xMLReader.setContentHandler(defaultHandler);
        xMLReader.parse(new InputSource(inputStream));
    }

    private String xmiElementName2uimaTypeName(String string, String string2) throws SAXException {
        String string3 = (String)this.xmiNamespaceToUimaNamespaceMap.get(string);
        if (string3 == null) {
            if ("http:///uima/noNamespace.ecore".equals(string)) {
                string3 = "";
            } else {
                URI uRI;
                try {
                    uRI = new URI(string);
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new SAXException(uRISyntaxException);
                }
                String string4 = uRI.getPath();
                while (string4.startsWith("/")) {
                    string4 = string4.substring(1);
                }
                if (string4.endsWith(".ecore")) {
                    string4 = string4.substring(0, string4.length() - 6);
                }
                string3 = string4.replace('/', '.') + '.';
            }
            this.xmiNamespaceToUimaNamespaceMap.put(string, string3);
        }
        return string3 + string2;
    }

    private class XmiCasDeserializerHandler
    extends DefaultHandler {
        private static final int DOC_STATE = 0;
        private static final int FS_STATE = 1;
        private static final int FEAT_STATE = 2;
        private static final int FEAT_CONTENT_STATE = 3;
        private static final int IGNORING_XMI_ELEMENTS_STATE = 4;
        private static final String unknownXMLSource = "<unknown>";
        private String ID_ATTR_NAME = "xmi:id";
        private Locator locator;
        private CASImpl cas;
        private IntRedBlackTree fsTree;
        private IntVector idLess;
        private IntVector fsListNodesFromMultivaluedProperties;
        private int state;
        private StringBuffer buffer;
        private int currentAddr;
        private TypeImpl currentType;
        private int currentArrayId;
        private List currentArrayElements;
        private Map multiValuedFeatures = new TreeMap();
        private int sofaTypeCode;
        private int sofaNumFeatCode;
        private int documentAnnotationTypeCode;
        private int sofaFeatCode;
        private ArrayList indexRepositories;
        private ArrayList tcasInstances;
        private TCAS oldTcas;
        private ListUtils listUtils;
        private int[] featureType;
        boolean lenient;
        private int ignoreDepth = 0;
        private HashMap nsPrefixToUriMap = new HashMap();
        private XmiSerializationSharedData sharedData;
        private static final int INT_TYPE = 0;
        private static final int FLOAT_TYPE = 1;
        private static final int STRING_TYPE = 2;
        private static final int FS_TYPE = 3;
        private static final int INT_ARRAY_TYPE = 4;
        private static final int FLOAT_ARRAY_TYPE = 5;
        private static final int STRING_ARRAY_TYPE = 6;
        private static final int FS_ARRAY_TYPE = 7;
        private static final int INT_LIST_TYPE = 9;
        private static final int FLOAT_LIST_TYPE = 10;
        private static final int STRING_LIST_TYPE = 11;
        private static final int FS_LIST_TYPE = 12;
        static final /* synthetic */ boolean $assertionsDisabled;

        private XmiCasDeserializerHandler(CASImpl cASImpl, boolean bl, XmiSerializationSharedData xmiSerializationSharedData) {
            this.cas = cASImpl.getBaseCAS();
            this.lenient = bl;
            this.sharedData = xmiSerializationSharedData;
            this.cas.resetNoQuestions();
            this.fsTree = new IntRedBlackTree();
            this.idLess = new IntVector();
            this.fsListNodesFromMultivaluedProperties = new IntVector();
            this.buffer = new StringBuffer();
            this.indexRepositories = new ArrayList();
            this.tcasInstances = new ArrayList();
            this.indexRepositories.add(this.cas.getIndexRepository());
            this.sofaTypeCode = this.cas.ts.getTypeCode("uima.cas.Sofa");
            this.sofaNumFeatCode = this.cas.ts.getFeatureCode("uima.cas.Sofa:sofaNum");
            this.documentAnnotationTypeCode = this.cas.ts.getTypeCode("uima.tcas.DocumentAnnotation");
            this.sofaFeatCode = this.cas.ts.getFeatureCode("uima.tcas.Annotation:sofa");
            this.oldTcas = null;
            this.listUtils = new ListUtils(this.cas, UIMAFramework.getLogger(class$com$ibm$uima$cas$impl$XmiCasDeserializer == null ? (class$com$ibm$uima$cas$impl$XmiCasDeserializer = XmiCasDeserializer.class$("com.ibm.uima.cas.impl.XmiCasDeserializer")) : class$com$ibm$uima$cas$impl$XmiCasDeserializer), null);
            if (this.sharedData != null) {
                this.sharedData.clearIdMap();
            }
            this.featureType = new int[this.cas.ts.getNumberOfFeatures() + 1];
            Iterator iterator = this.cas.ts.getFeatures();
            while (iterator.hasNext()) {
                FeatureImpl featureImpl = (FeatureImpl)iterator.next();
                this.featureType[featureImpl.getCode()] = this.classifyType(this.cas.ts.range(featureImpl.getCode()));
            }
        }

        private final void resetBuffer() {
            this.buffer = new StringBuffer();
        }

        public void startDocument() throws SAXException {
            this.state = 0;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.resetBuffer();
            switch (this.state) {
                case 0: {
                    if (attributes != null) {
                        for (int i = 0; i < attributes.getLength(); ++i) {
                            String string4 = attributes.getQName(i);
                            if (!string4.startsWith("xmlns:")) continue;
                            String string5 = string4.substring(6);
                            String string6 = attributes.getValue(i);
                            this.nsPrefixToUriMap.put(string5, string6);
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    if (string3.startsWith("xmi")) {
                        this.state = 4;
                        ++this.ignoreDepth;
                        return;
                    }
                    if (string == null || string.length() == 0) {
                        int n = string3.indexOf(58);
                        if (n != -1) {
                            String string7 = string3.substring(0, n);
                            string = (String)this.nsPrefixToUriMap.get(string7);
                            if (string == null) {
                                string = "http:///" + string7 + ".ecore";
                            }
                            string2 = string3.substring(n + 1);
                        } else {
                            string = "http:///uima/noNamespace.ecore";
                        }
                    }
                    String string8 = XmiCasDeserializer.this.xmiElementName2uimaTypeName(string, string2);
                    this.readFS(string8, attributes);
                    this.multiValuedFeatures.clear();
                    this.state = 2;
                    break;
                }
                case 2: {
                    this.state = 3;
                    break;
                }
                default: {
                    throw this.createException(1, string3);
                }
            }
        }

        private void readFS(String string, Attributes attributes) throws SAXParseException {
            this.currentType = (TypeImpl)XmiCasDeserializer.this.ts.getType(string);
            if (this.currentType == null) {
                if ("uima.cas.NULL".equals(string)) {
                    return;
                }
                if ("uima.cas.View".equals(string)) {
                    this.processView(attributes.getValue("sofa"), attributes.getValue("members"));
                    return;
                }
                if (!this.lenient) {
                    throw this.createException(4, string);
                }
                return;
            }
            if (this.cas.isArrayType(this.currentType)) {
                String string2 = attributes.getValue(this.ID_ATTR_NAME);
                this.currentArrayId = string2 == null ? -1 : Integer.parseInt(string2);
                String string3 = attributes.getValue("elements");
                if (string3 != null) {
                    String[] stringArray = this.parseArray(string3);
                    this.currentArrayElements = Arrays.asList(stringArray);
                } else {
                    this.currentArrayElements = null;
                }
            } else if (this.currentType.getCode() == this.documentAnnotationTypeCode && this.cas.isBackwardCompatibleCas()) {
                if (this.oldTcas == null) {
                    if (this.indexRepositories.size() == 0) {
                        this.indexRepositories.add(this.cas.getIndexRepository());
                    }
                    this.oldTcas = this.cas.getTCAS();
                    this.indexRepositories.add(this.oldTcas.getIndexRepository());
                }
                int n = ((FeatureStructureImpl)((Object)this.oldTcas.getDocumentAnnotation())).getAddress();
                this.readFS(n, attributes);
            } else {
                int n = this.cas.createTempFS(this.currentType.getCode());
                this.readFS(n, attributes);
            }
        }

        private void processView(String string, String string2) {
            if (string2 != null) {
                int n = 0;
                if (string != null) {
                    int n2 = Integer.parseInt(string);
                    int n3 = this.fsTree.get(n2);
                    n = this.cas.getFeatureValue(n3, this.sofaNumFeatCode);
                }
                FSIndexRepositoryImpl fSIndexRepositoryImpl = (FSIndexRepositoryImpl)this.indexRepositories.get(n);
                String[] stringArray = this.parseArray(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    int n4;
                    try {
                        n4 = this.fsTree.get(Integer.parseInt(stringArray[i]));
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (this.lenient) continue;
                        throw noSuchElementException;
                    }
                    if (this.cas.ll_getFSRefType(n4) == this.cas.ts.getTypeCode("uima.tcas.DocumentAnnotation") && this.cas.isBackwardCompatibleCas()) continue;
                    fSIndexRepositoryImpl.addFS(n4);
                }
            }
        }

        private void readFS(int n, Attributes attributes) throws SAXParseException {
            this.currentAddr = n;
            int n2 = -1;
            boolean bl = false;
            int n3 = this.cas.getHeapValue(n);
            Type type = this.cas.ts.getType(n3);
            if (this.sofaTypeCode == n3) {
                bl = true;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getQName(i);
                String string2 = attributes.getValue(i);
                if (string.equals(this.ID_ATTR_NAME)) {
                    try {
                        n2 = Integer.parseInt(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createException(5, string2);
                    }
                }
                if (bl && string.equals("sofaID") && XmiCasDeserializer.this.uimaContext != null) {
                    string2 = XmiCasDeserializer.this.uimaContext.mapToSofaID(string2).getSofaID();
                }
                this.handleFeature(type, n, string, string2, false);
            }
            if (this.sofaTypeCode == n3) {
                SofaFS sofaFS = (SofaFS)this.cas.createFS(n);
                this.cas.getIndexRepository().addFS(sofaFS);
                TCAS tCAS = this.cas.getTCAS(sofaFS);
                this.indexRepositories.add(this.cas.getSofaIndexRepository(sofaFS));
                this.tcasInstances.add(tCAS);
            }
            if (n2 < 0) {
                this.idLess.add(n);
            } else {
                this.fsTree.put(n2, n);
                if (this.sharedData != null) {
                    this.sharedData.addIdMapping(n, n2);
                }
            }
        }

        private final boolean emptyVal(String string) {
            return string == null || string.length() == 0;
        }

        private void handleFeature(Type type, int n, String string, String string2, boolean bl) throws SAXParseException {
            FeatureImpl featureImpl = (FeatureImpl)type.getFeatureByBaseName(string);
            if (featureImpl == null) {
                if (!bl) {
                    throw this.createException(8, string);
                }
                return;
            }
            this.handleFeature(n, featureImpl.getCode(), string2);
        }

        private void handleFeature(Type type, int n, String string, List list, boolean bl) throws SAXParseException {
            FeatureImpl featureImpl = (FeatureImpl)type.getFeatureByBaseName(string);
            if (featureImpl == null) {
                if (!bl) {
                    throw this.createException(8, string);
                }
                return;
            }
            this.handleFeature(n, featureImpl.getCode(), list);
        }

        private void handleFeature(int n, int n2, String string) throws SAXParseException {
            switch (this.featureType[n2]) {
                case 0: {
                    try {
                        if (this.emptyVal(string)) break;
                        if (n2 == this.sofaFeatCode) {
                            int n3 = Integer.parseInt(string);
                            int n4 = this.fsTree.get(n3);
                            int n5 = this.cas.getFeatureValue(n4, this.sofaNumFeatCode);
                            this.cas.setFeatureValue(n, n2, n5);
                            break;
                        }
                        this.cas.setFeatureValue(n, n2, Integer.parseInt(string));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createException(9, string);
                    }
                }
                case 1: {
                    try {
                        if (this.emptyVal(string)) break;
                        this.cas.setFloatValue(n, n2, Float.parseFloat(string));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createException(10, string);
                    }
                }
                case 2: {
                    if (string == null) break;
                    this.cas.setStringValue(n, n2, string);
                    break;
                }
                case 3: {
                    try {
                        if (this.emptyVal(string)) break;
                        this.cas.setFeatureValue(n, n2, Integer.parseInt(string));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createException(9, string);
                    }
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    if (XmiCasDeserializer.this.ts.getFeature(n2).isMultipleReferencesAllowed()) {
                        try {
                            if (this.emptyVal(string)) break;
                            this.cas.setFeatureValue(n, n2, Integer.parseInt(string));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.createException(9, string);
                        }
                    }
                    String[] stringArray = this.parseArray(string);
                    this.handleFeature(n, n2, Arrays.asList(stringArray));
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    if (XmiCasDeserializer.this.ts.getFeature(n2).isMultipleReferencesAllowed()) {
                        try {
                            if (this.emptyVal(string)) break;
                            this.cas.setFeatureValue(n, n2, Integer.parseInt(string));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.createException(9, string);
                        }
                    }
                    String[] stringArray = this.parseArray(string);
                    this.handleFeature(n, n2, Arrays.asList(stringArray));
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private String[] parseArray(String string) {
            String[] stringArray = this.emptyVal(string = string.trim()) ? new String[]{} : string.split("\\s+");
            return stringArray;
        }

        private void handleFeature(int n, int n2, List list) throws SAXParseException {
            switch (this.featureType[n2]) {
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    if (list.size() != 1) {
                        throw new SAXParseException(I18nUtil.localizeMessage("com.ibm.uima.UIMAException_Messages", Locale.getDefault(), "multiple_values_unexpected", new Object[]{XmiCasDeserializer.this.ts.getFeature(n2).getName()}), this.locator);
                    }
                    this.handleFeature(n, n2, (String)list.get(0));
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    int n3 = this.createArray(this.cas.ts.range(n2), list, -1);
                    this.cas.setFeatureValue(n, n2, n3);
                    break;
                }
                case 7: {
                    int n4 = this.createArray(this.cas.ts.range(n2), list, -1);
                    this.cas.setFeatureValue(n, n2, n4);
                    break;
                }
                case 9: {
                    int n5 = this.listUtils.createIntList(list);
                    this.cas.setFeatureValue(n, n2, n5);
                    break;
                }
                case 10: {
                    int n6 = this.listUtils.createFloatList(list);
                    this.cas.setFeatureValue(n, n2, n6);
                    break;
                }
                case 11: {
                    int n7 = this.listUtils.createStringList(list);
                    this.cas.setFeatureValue(n, n2, n7);
                    break;
                }
                case 12: {
                    int n8 = this.listUtils.createFsList(list, this.fsListNodesFromMultivaluedProperties);
                    this.cas.setFeatureValue(n, n2, n8);
                    break;
                }
                default: {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                    break;
                }
            }
        }

        private int createArray(int n, List list, int n2) {
            int n3 = this.cas.createTempArray(n, list.size());
            for (int i = 0; i < list.size(); ++i) {
                String string = (String)list.get(i);
                int n4 = this.cas.isFloatArrayType(n) ? CASImpl.float2int(Float.parseFloat(string)) : (this.cas.isStringArrayType(n) ? this.cas.addString(string) : Integer.parseInt(string));
                this.cas.setArrayValue(n3, i, n4);
            }
            if (n2 < 0) {
                this.idLess.add(n3);
            } else {
                this.fsTree.put(n2, n3);
                if (this.sharedData != null) {
                    this.sharedData.addIdMapping(n3, n2);
                }
            }
            return n3;
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            switch (this.state) {
                case 3: {
                    this.buffer.append(cArray, n, n2);
                    break;
                }
            }
        }

        boolean isAllWhitespace(StringBuffer stringBuffer) {
            int n = stringBuffer.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isWhitespace(stringBuffer.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 0;
                    break;
                }
                case 3: {
                    ArrayList<String> arrayList = (ArrayList<String>)this.multiValuedFeatures.get(string3);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String>();
                        this.multiValuedFeatures.put(string3, arrayList);
                    }
                    arrayList.add(this.buffer.toString());
                    this.state = 2;
                    break;
                }
                case 2: {
                    if (this.currentType != null) {
                        if (this.cas.isArrayType(this.currentType)) {
                            if (this.currentArrayElements == null) {
                                this.currentArrayElements = (List)this.multiValuedFeatures.get("elements");
                                if (this.currentArrayElements == null) {
                                    this.currentArrayElements = Collections.EMPTY_LIST;
                                }
                            }
                            this.createArray(this.currentType.getCode(), this.currentArrayElements, this.currentArrayId);
                        } else if (!this.multiValuedFeatures.isEmpty()) {
                            Iterator iterator = this.multiValuedFeatures.entrySet().iterator();
                            while (iterator.hasNext()) {
                                Map.Entry entry = iterator.next();
                                String string4 = (String)entry.getKey();
                                List list = (List)entry.getValue();
                                this.handleFeature((Type)this.currentType, this.currentAddr, string4, list, false);
                            }
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 4: {
                    --this.ignoreDepth;
                    if (this.ignoreDepth != 0) break;
                    this.state = 1;
                }
            }
        }

        public void endDocument() throws SAXException {
            int n;
            IntRedBlackTree.IntRBTIterator intRBTIterator = this.fsTree.iterator();
            while (intRBTIterator.hasNext()) {
                this.finalizeFS(intRBTIterator.next());
            }
            for (n = 0; n < this.idLess.size(); ++n) {
                this.finalizeFS(this.idLess.get(n));
            }
            for (n = 0; n < this.fsListNodesFromMultivaluedProperties.size(); ++n) {
                this.remapFSListHeads(this.fsListNodesFromMultivaluedProperties.get(n));
            }
            for (n = 0; n < this.tcasInstances.size(); ++n) {
                ((TCASImpl)this.tcasInstances.get(n)).updateDocumentAnnotation();
            }
        }

        private void finalizeFS(int n) {
            int n2 = this.cas.getHeapValue(n);
            if (this.cas.isArrayType(n2)) {
                this.finalizeArray(n2, n);
                return;
            }
            int[] nArray = this.cas.getTypeSystemImpl().getAppropriateFeatures(n2);
            for (int i = 0; i < nArray.length; ++i) {
                int n3;
                block4: {
                    int n4;
                    Feature feature = XmiCasDeserializer.this.ts.getFeature(nArray[i]);
                    int n5 = XmiCasDeserializer.this.ts.ll_getRangeType(nArray[i]);
                    if (!this.cas.ll_isRefType(n5) || this.featureType[nArray[i]] != 3 && !feature.isMultipleReferencesAllowed() || (n4 = this.cas.getFeatureValue(n, nArray[i])) == 0) continue;
                    n3 = 0;
                    try {
                        n3 = this.fsTree.get(n4);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (this.lenient) break block4;
                        throw noSuchElementException;
                    }
                }
                this.cas.setFeatureValue(n, nArray[i], n3);
            }
        }

        private void remapFSListHeads(int n) {
            int n2 = this.cas.getHeapValue(n);
            if (!this.listUtils.isFsListType(n2)) {
                return;
            }
            int[] nArray = this.cas.getTypeSystemImpl().getAppropriateFeatures(n2);
            if (nArray.length == 0) {
                return;
            }
            int n3 = nArray[0];
            int n4 = this.cas.getFeatureValue(n, n3);
            if (n4 != 0) {
                int n5;
                block5: {
                    n5 = 0;
                    try {
                        n5 = this.fsTree.get(n4);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (this.lenient) break block5;
                        throw noSuchElementException;
                    }
                }
                this.cas.setFeatureValue(n, n3, n5);
            }
        }

        private void finalizeArray(int n, int n2) {
            if (!this.cas.isFSArrayType(n)) {
                return;
            }
            int n3 = this.cas.getArraySize(n2);
            for (int i = 0; i < n3; ++i) {
                int n4;
                block4: {
                    int n5 = this.cas.getArrayValue(n2, i);
                    if (n5 == 0) continue;
                    n4 = 0;
                    try {
                        n4 = this.fsTree.get(n5);
                    }
                    catch (NoSuchElementException noSuchElementException) {
                        if (this.lenient) break block4;
                        throw noSuchElementException;
                    }
                }
                this.cas.setArrayValue(n2, i, n4);
            }
        }

        private XCASParsingException createException(int n) {
            XCASParsingException xCASParsingException = new XCASParsingException(n);
            String string = unknownXMLSource;
            String string2 = unknownXMLSource;
            String string3 = unknownXMLSource;
            if (this.locator != null) {
                string = this.locator.getSystemId();
                if (string == null) {
                    string = this.locator.getPublicId();
                }
                if (string == null) {
                    string = unknownXMLSource;
                }
                string2 = Integer.toString(this.locator.getLineNumber());
                string3 = Integer.toString(this.locator.getColumnNumber());
            }
            xCASParsingException.addArgument(string);
            xCASParsingException.addArgument(string2);
            xCASParsingException.addArgument(string3);
            return xCASParsingException;
        }

        private XCASParsingException createException(int n, String string) {
            XCASParsingException xCASParsingException = this.createException(n);
            xCASParsingException.addArgument(string);
            return xCASParsingException;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private final int classifyType(int n) {
            if (this.cas.isIntType(n)) {
                return 0;
            }
            if (this.cas.isFloatType(n)) {
                return 1;
            }
            if (this.cas.isStringType(n)) {
                return 2;
            }
            if (this.cas.isIntArrayType(n)) {
                return 4;
            }
            if (this.cas.isFloatArrayType(n)) {
                return 5;
            }
            if (this.cas.isStringArrayType(n)) {
                return 6;
            }
            if (this.cas.isFSArrayType(n)) {
                return 7;
            }
            if (this.listUtils.isIntListType(n)) {
                return 9;
            }
            if (this.listUtils.isFloatListType(n)) {
                return 10;
            }
            if (this.listUtils.isStringListType(n)) {
                return 11;
            }
            if (this.listUtils.isFsListType(n)) {
                return 12;
            }
            return 3;
        }

        static {
            $assertionsDisabled = !(class$com$ibm$uima$cas$impl$XmiCasDeserializer == null ? (class$com$ibm$uima$cas$impl$XmiCasDeserializer = XmiCasDeserializer.class$("com.ibm.uima.cas.impl.XmiCasDeserializer")) : class$com$ibm$uima$cas$impl$XmiCasDeserializer).desiredAssertionStatus();
        }
    }
}

