/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.UimaContext;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.FSIndex;
import com.ibm.uima.cas.FSIterator;
import com.ibm.uima.cas.SofaFS;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.ArrayElement;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSData;
import com.ibm.uima.cas.impl.FSIndexRepositoryImpl;
import com.ibm.uima.cas.impl.FeatureImpl;
import com.ibm.uima.cas.impl.OutOfTypeSystemData;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.cas.impl.XmlCasSerializer;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.util.IntStack;
import com.ibm.uima.util.IntVector;
import com.ibm.uima.util.StringUtils;
import com.ibm.uima.util.XMLSerializer;
import com.ibm.uima.util.rb_trees.IntRedBlackTree;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XCASSerializer
implements XmlCasSerializer {
    private int numChildren;
    public static final String casTagName = "CAS";
    public static final String DEFAULT_DOC_TYPE_NAME = "uima.tcas.Document";
    public static final String DEFAULT_DOC_TEXT_FEAT = "text";
    public static final String INDEXED_ATTR_NAME = "_indexed";
    public static final String REF_PREFIX = "_ref_";
    public static final String ID_ATTR_NAME = "_id";
    public static final String CONTENT_ATTR_NAME = "_content";
    public static final String ARRAY_SIZE_ATTR = "size";
    public static final String ARRAY_ELEMENT_TAG = "i";
    public static final String TRUE_VALUE = "true";
    private static final int INT_TYPE = 0;
    private static final int FLOAT_TYPE = 1;
    private static final int STRING_TYPE = 2;
    private static final int FS_TYPE = 3;
    private static final int INT_ARRAY_TYPE = 4;
    private static final int FLOAT_ARRAY_TYPE = 5;
    private static final int STRING_ARRAY_TYPE = 6;
    private static final int FS_ARRAY_TYPE = 7;
    private TypeSystemImpl ts;
    private UimaContext uimaContext;
    private String[] featureNames;
    private String docTypeName = "uima.tcas.Document";
    private String docTextFeature = "text";

    public int getNumChildren() {
        return this.numChildren;
    }

    private String getXCasElementName(String string) {
        if (string.indexOf(58) == -1 && string.indexOf(45) == -1) {
            return string;
        }
        return StringUtils.replaceAll(StringUtils.replaceAll(string, ":", "_colon_"), "-", "_dash_");
    }

    public XCASSerializer(TypeSystem typeSystem, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)typeSystem;
        this.uimaContext = uimaContext;
        int n = this.ts.getNumberOfFeatures() + 1;
        this.featureNames = new String[n];
        Iterator iterator = this.ts.getFeatures();
        while (iterator.hasNext()) {
            FeatureImpl featureImpl = (FeatureImpl)iterator.next();
            String string = featureImpl.getRange().getName().equals("uima.cas.Integer") || featureImpl.getRange().getName().equals("uima.cas.Float") || featureImpl.getRange().getName().equals("uima.cas.String") || typeSystem.subsumes(typeSystem.getType("uima.cas.String"), featureImpl.getRange()) ? featureImpl.getShortName() : REF_PREFIX + featureImpl.getShortName();
            this.featureNames[featureImpl.getCode()] = string;
        }
    }

    public XCASSerializer(TypeSystem typeSystem) {
        this(typeSystem, null);
    }

    public void serialize(CAS cAS, ContentHandler contentHandler) throws IOException, SAXException {
        this.serialize(cAS, contentHandler, true);
    }

    public void serialize(CAS cAS, ContentHandler contentHandler, boolean bl) throws IOException, SAXException {
        this.serialize(cAS, contentHandler, bl, null);
    }

    public void serialize(CAS cAS, ContentHandler contentHandler, boolean bl, OutOfTypeSystemData outOfTypeSystemData) throws IOException, SAXException {
        contentHandler.startDocument();
        XCASDocSerializer xCASDocSerializer = new XCASDocSerializer(contentHandler, ((CASImpl)cAS).getBaseCAS());
        xCASDocSerializer.serialize(bl, outOfTypeSystemData);
        contentHandler.endDocument();
    }

    public String getDocumentTypeName() {
        return this.docTypeName;
    }

    public void setDocumentTypeName(String string) {
        this.docTypeName = string;
    }

    public String getDocumentTextFeature() {
        return this.docTextFeature;
    }

    public void setDocumentTextFeature(String string) {
        this.docTextFeature = string;
    }

    public static void serialize(CAS cAS, OutputStream outputStream) throws SAXException, IOException {
        XCASSerializer.serialize(cAS, outputStream, false);
    }

    public static void serialize(CAS cAS, OutputStream outputStream, boolean bl) throws SAXException, IOException {
        XCASSerializer xCASSerializer = new XCASSerializer(cAS.getTypeSystem());
        XMLSerializer xMLSerializer = new XMLSerializer(outputStream, bl);
        xCASSerializer.serialize(cAS, xMLSerializer.getContentHandler());
    }

    private class XCASDocSerializer {
        private ContentHandler ch;
        private CASImpl cas;
        private IntRedBlackTree queued;
        private static final int NOT_INDEXED = -1;
        private static final int MULTIPLY_INDEXED = -2;
        private static final int INVALID_INDEX = -3;
        private IntRedBlackTree duplicates;
        int numDuplicates;
        Vector dupVectors;
        private IntVector indexedFSs;
        private IntVector indexReps;
        private IntStack queue;
        private int sofaTypeCode;
        private final AttributesImpl emptyAttrs = new AttributesImpl();
        private AttributesImpl workAttrs = new AttributesImpl();
        private static final String cdataType = "CDATA";
        private int fsCount = 0;
        private OutOfTypeSystemData mOutOfTypeSystemData;
        private static final int KEY_AND_VALUE_MATCH = 1;
        private static final int KEY_ONLY_MATCH = -1;
        private static final int KEY_NOT_FOUND = 0;

        private XCASDocSerializer(ContentHandler contentHandler, CASImpl cASImpl) {
            this.ch = contentHandler;
            this.cas = cASImpl;
            this.queued = new IntRedBlackTree();
            this.duplicates = new IntRedBlackTree();
            this.numDuplicates = 0;
            this.dupVectors = new Vector();
            this.queue = new IntStack();
            this.indexedFSs = new IntVector();
            this.indexReps = new IntVector();
            this.sofaTypeCode = cASImpl.ll_getTypeSystem().ll_getCodeForType(cASImpl.getTypeSystem().getType("uima.cas.Sofa"));
        }

        private boolean enqueue(int n) {
            if (-1 == this.isQueued(n, -3)) {
                return false;
            }
            int n2 = this.cas.getHeapValue(n);
            if (this.sofaTypeCode != n2 || !this.cas.isBackwardCompatibleCas()) {
                this.queued.put(n, -1);
                this.queue.push(n);
                int n3 = this.classifyType(n2);
                if (n3 == 3) {
                    if (this.mOutOfTypeSystemData != null) {
                        this.enqueueOutOfTypeSystemFeatures(n);
                    }
                    this.enqueueFeatures(n, n2);
                } else if (n3 == 7) {
                    this.enqueueFSArray(n);
                }
            }
            return true;
        }

        private void enqueueIndexed(int n, int n2) {
            int n3 = this.isQueued(n, n2);
            switch (n3) {
                case 0: {
                    if (this.sofaTypeCode == this.cas.getHeapValue(n) && this.cas.isBackwardCompatibleCas()) break;
                    this.queued.put(n, n2);
                    this.indexedFSs.add(n);
                    this.indexReps.add(n2);
                    break;
                }
                case 1: {
                    break;
                }
                case -1: {
                    int n4 = this.queued.get(n);
                    if (-1 == n4) {
                        this.queued.put(n, n2);
                        break;
                    }
                    if (-2 == n4) {
                        int n5 = this.duplicates.get(n);
                        ((IntVector)this.dupVectors.get(n5)).add(n2);
                        break;
                    }
                    this.duplicates.put(n, this.numDuplicates);
                    this.dupVectors.add(new IntVector());
                    ((IntVector)this.dupVectors.get(this.numDuplicates)).add(n4);
                    ((IntVector)this.dupVectors.get(this.numDuplicates)).add(n2);
                    ++this.numDuplicates;
                    this.queued.put(n, -2);
                }
            }
        }

        private int isQueued(int n, int n2) {
            return this.containsKeyValuePair(this.queued, n, n2);
        }

        private final int containsKeyValuePair(IntRedBlackTree intRedBlackTree, int n, int n2) {
            if (intRedBlackTree.containsKey(n)) {
                if (intRedBlackTree.get(n) == n2) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        private void serialize(boolean bl, OutOfTypeSystemData outOfTypeSystemData) throws IOException, SAXException {
            this.mOutOfTypeSystemData = outOfTypeSystemData;
            int n = 0;
            if (bl && this.cas.isBackwardCompatibleCas()) {
                ++n;
            }
            this.enqueueIndexed();
            this.enqueueFeaturesOfIndexed();
            if (outOfTypeSystemData != null) {
                int n2 = this.cas.getHeap().getCurrentTempSize();
                Iterator iterator = outOfTypeSystemData.fsList.iterator();
                while (iterator.hasNext()) {
                    FSData fSData = (FSData)iterator.next();
                    String string = Integer.toString(n2++);
                    outOfTypeSystemData.idMap.put(fSData.id, string);
                    fSData.id = string;
                }
                n += outOfTypeSystemData.fsList.size();
                this.enqueueOutOfTypeSystemData(outOfTypeSystemData);
            }
            n += this.indexedFSs.size();
            this.startElement(XCASSerializer.casTagName, this.emptyAttrs, n += this.queue.size());
            if (outOfTypeSystemData != null) {
                this.serializeOutOfTypeSystemData(outOfTypeSystemData);
            }
            if (bl) {
                this.encodeDocument();
            }
            this.encodeIndexed();
            this.encodeQueued();
            this.endElement(XCASSerializer.casTagName);
        }

        private void encodeDocument() throws IOException, SAXException {
            if (this.cas.isBackwardCompatibleCas()) {
                TCAS tCAS;
                String string;
                String string2 = XCASSerializer.this.getDocumentTextFeature();
                this.workAttrs.clear();
                if (string2 != null) {
                    this.addAttribute(this.workAttrs, XCASSerializer.CONTENT_ATTR_NAME, string2);
                }
                if ((string = (tCAS = this.cas.getTCAS()).getDocumentText()) != null && string.length() > 0) {
                    string = this.replaceInvalidXmlChars(string);
                    this.startElement(XCASSerializer.this.getDocumentTypeName(), this.workAttrs, 1);
                    this.addText(string);
                    this.endElement(XCASSerializer.this.getDocumentTypeName());
                } else {
                    this.startElement(XCASSerializer.this.getDocumentTypeName(), this.workAttrs, 0);
                    this.endElement(XCASSerializer.this.getDocumentTypeName());
                }
            }
        }

        private void addText(String string) throws SAXException {
            this.ch.characters(string.toCharArray(), 0, string.length());
        }

        private String replaceInvalidXmlChars(String string) {
            boolean bl = false;
            for (int i = 0; i < string.length(); ++i) {
                if (this.isValidXmlChar(string.charAt(i))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return string;
            }
            char[] cArray = string.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (this.isValidXmlChar(cArray[i])) continue;
                cArray[i] = 65533;
            }
            return new String(cArray);
        }

        private boolean isValidXmlChar(char c) {
            return c >= ' ' && c < '\ufffe' || c == '\t' || c == '\n' || c == '\r';
        }

        private void addAttribute(AttributesImpl attributesImpl, String string, String string2) {
            if ("sofaString".equals(string)) {
                string2 = this.replaceInvalidXmlChars(string2);
            }
            attributesImpl.addAttribute(null, null, string, cdataType, string2);
        }

        private void startElement(String string, Attributes attributes, int n) throws SAXException {
            XCASSerializer.this.numChildren = n;
            this.ch.startElement("", "", string, attributes);
        }

        private void endElement(String string) throws SAXException {
            this.ch.endElement("", "", string);
        }

        private void encodeIndexed() throws IOException, SAXException {
            int n = this.indexedFSs.size();
            for (int i = 0; i < n; ++i) {
                if (-2 != this.queued.get(this.indexedFSs.get(i))) {
                    IntVector intVector = new IntVector(1);
                    intVector.add(this.indexReps.get(i));
                    this.encodeFS(this.indexedFSs.get(i), intVector);
                    continue;
                }
                int n2 = this.duplicates.get(this.indexedFSs.get(i));
                this.encodeFS(this.indexedFSs.get(i), (IntVector)this.dupVectors.get(n2));
            }
        }

        private void enqueueIndexed() {
            FSIndexRepositoryImpl fSIndexRepositoryImpl = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getIndexRepository();
            int[] nArray = fSIndexRepositoryImpl.getIndexedFSs();
            for (int i = 0; i < nArray.length; ++i) {
                this.enqueueIndexed(nArray[i], 0);
            }
            FSIndex fSIndex = this.cas.getBaseCAS().indexRepository.getIndex("SofaIndex");
            FSIterator fSIterator = fSIndex.iterator();
            while (fSIterator.isValid()) {
                SofaFS sofaFS = (SofaFS)fSIterator.get();
                int n = sofaFS.getSofaRef();
                fSIterator.moveToNext();
                FSIndexRepositoryImpl fSIndexRepositoryImpl2 = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaFS);
                if (fSIndexRepositoryImpl2 == null) continue;
                nArray = fSIndexRepositoryImpl2.getIndexedFSs();
                for (int i = 0; i < nArray.length; ++i) {
                    this.enqueueIndexed(nArray[i], n);
                }
            }
        }

        private void enqueueFeaturesOfIndexed() {
            int n = this.indexedFSs.size();
            for (int i = 0; i < n; ++i) {
                int n2 = this.indexedFSs.get(i);
                int n3 = this.cas.getHeapValue(n2);
                int n4 = this.classifyType(n3);
                if (n4 == 3) {
                    if (this.mOutOfTypeSystemData != null) {
                        this.enqueueOutOfTypeSystemFeatures(n2);
                    }
                    this.enqueueFeatures(n2, n3);
                    continue;
                }
                if (n4 != 7) continue;
                this.enqueueFSArray(n2);
            }
        }

        private void encodeQueued() throws IOException, SAXException {
            while (!this.queue.empty()) {
                int n = this.queue.pop();
                this.encodeFS(n, null);
            }
        }

        private void encodeFS(int n, IntVector intVector) throws IOException, SAXException {
            ++this.fsCount;
            this.workAttrs.clear();
            if (intVector != null) {
                if (intVector.size() == 1) {
                    this.addAttribute(this.workAttrs, XCASSerializer.INDEXED_ATTR_NAME, Integer.toString(intVector.get(0)));
                } else {
                    String string = Integer.toString(intVector.get(0));
                    for (int i = 1; i < intVector.size(); ++i) {
                        string = string + " " + Integer.toString(intVector.get(i));
                    }
                    this.addAttribute(this.workAttrs, XCASSerializer.INDEXED_ATTR_NAME, string);
                }
            }
            this.addAttribute(this.workAttrs, XCASSerializer.ID_ATTR_NAME, Integer.toString(n));
            int n2 = this.classifyType(this.cas.getHeapValue(n));
            switch (n2) {
                case 3: {
                    String string = this.getTypeName(n);
                    this.encodeFeatures(n, this.workAttrs);
                    if (this.mOutOfTypeSystemData != null) {
                        this.encodeOutOfTypeSystemFeatures(n, this.workAttrs);
                    }
                    String string2 = XCASSerializer.this.getXCasElementName(string);
                    this.startElement(string2, this.workAttrs, 0);
                    this.endElement(string2);
                    break;
                }
                case 4: {
                    this.encodeIntArray(n, this.workAttrs);
                    break;
                }
                case 5: {
                    this.encodeFloatArray(n, this.workAttrs);
                    break;
                }
                case 6: {
                    this.encodeStringArray(n, this.workAttrs);
                    break;
                }
                case 7: {
                    this.encodeFSArray(n, this.workAttrs);
                    break;
                }
                default: {
                    System.err.println("Error classifying FS type.");
                }
            }
        }

        private void encodeIntArray(int n, AttributesImpl attributesImpl) throws SAXException {
            String string = this.getTypeName(n);
            int n2 = this.cas.getArraySize(n);
            int n3 = this.cas.getArrayStartAddress(n);
            this.addAttribute(attributesImpl, XCASSerializer.ARRAY_SIZE_ATTR, Integer.toString(n2));
            this.startElement(string, attributesImpl, n2);
            for (int i = 0; i < n2; ++i) {
                this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 1);
                this.addText(Integer.toString(this.cas.getHeapValue(n3)));
                this.endElement(XCASSerializer.ARRAY_ELEMENT_TAG);
                ++n3;
            }
            this.endElement(string);
        }

        private void encodeFloatArray(int n, AttributesImpl attributesImpl) throws SAXException {
            String string = this.getTypeName(n);
            int n2 = this.cas.getArraySize(n);
            int n3 = this.cas.getArrayStartAddress(n);
            this.addAttribute(attributesImpl, XCASSerializer.ARRAY_SIZE_ATTR, Integer.toString(n2));
            this.startElement(string, attributesImpl, n2);
            for (int i = 0; i < n2; ++i) {
                this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 1);
                this.addText(Float.toString(CASImpl.int2float(this.cas.getHeapValue(n3))));
                this.endElement(XCASSerializer.ARRAY_ELEMENT_TAG);
                ++n3;
            }
            this.endElement(string);
        }

        private void encodeStringArray(int n, AttributesImpl attributesImpl) throws SAXException {
            String string = this.getTypeName(n);
            int n2 = this.cas.getArraySize(n);
            int n3 = this.cas.getArrayStartAddress(n);
            this.addAttribute(attributesImpl, XCASSerializer.ARRAY_SIZE_ATTR, Integer.toString(n2));
            this.startElement(string, attributesImpl, n2);
            for (int i = 0; i < n2; ++i) {
                String string2 = this.cas.getStringForCode(this.cas.getHeapValue(n3));
                if (string2 != null) {
                    this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 1);
                    this.addText(string2);
                } else {
                    this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 0);
                }
                this.endElement(XCASSerializer.ARRAY_ELEMENT_TAG);
                ++n3;
            }
            this.endElement(string);
        }

        private void encodeFSArray(int n, AttributesImpl attributesImpl) throws SAXException {
            String string = this.getTypeName(n);
            int n2 = this.cas.getArraySize(n);
            int n3 = this.cas.getArrayStartAddress(n);
            this.addAttribute(attributesImpl, XCASSerializer.ARRAY_SIZE_ATTR, Integer.toString(n2));
            this.startElement(string, attributesImpl, n2);
            for (int i = 0; i < n2; ++i) {
                String string2 = null;
                int n4 = this.cas.getHeapValue(n3);
                if (n4 == 0 && this.mOutOfTypeSystemData != null) {
                    List list = (List)this.mOutOfTypeSystemData.arrayElements.get(new Integer(n));
                    if (list != null) {
                        Iterator iterator = list.iterator();
                        while (iterator.hasNext()) {
                            ArrayElement arrayElement = (ArrayElement)iterator.next();
                            if (arrayElement.index != i) continue;
                            string2 = (String)this.mOutOfTypeSystemData.idMap.get(arrayElement.value);
                            break;
                        }
                    }
                } else if (n4 != 0) {
                    string2 = Integer.toString(n4);
                }
                if (string2 != null) {
                    this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 1);
                    this.addText(string2);
                } else {
                    this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 0);
                }
                this.endElement(XCASSerializer.ARRAY_ELEMENT_TAG);
                ++n3;
            }
            this.endElement(string);
        }

        private void enqueueFSArray(int n) {
            int n2 = this.cas.getArraySize(n);
            int n3 = this.cas.getArrayStartAddress(n);
            for (int i = 0; i < n2; ++i) {
                int n4 = this.cas.getHeapValue(n3);
                if (n4 != 0) {
                    this.enqueue(n4);
                }
                ++n3;
            }
        }

        private void encodeFeatures(int n, AttributesImpl attributesImpl) {
            int n2 = this.cas.getHeapValue(n);
            int[] nArray = XCASSerializer.this.ts.getAppropriateFeatures(n2);
            boolean bl = false;
            if (this.sofaTypeCode == n2) {
                bl = true;
            }
            for (int i = 0; i < nArray.length; ++i) {
                String string;
                int n3 = n + this.cas.getFeatureOffset(nArray[i]);
                int n4 = this.cas.getHeapValue(n3);
                String string2 = XCASSerializer.this.featureNames[nArray[i]];
                int n5 = this.classifyType(XCASSerializer.this.ts.range(nArray[i]));
                switch (n5) {
                    case 0: {
                        string = Integer.toString(n4);
                        break;
                    }
                    case 1: {
                        string = Float.toString(CASImpl.int2float(n4));
                        break;
                    }
                    case 2: {
                        if (n4 == 0) {
                            string = null;
                            break;
                        }
                        string = this.cas.getStringForCode(n4);
                        if (!bl || !string2.equals("sofaID") || XCASSerializer.this.uimaContext == null) break;
                        string = XCASSerializer.this.uimaContext.mapSofaIDToComponentSofaName(string);
                        break;
                    }
                    default: {
                        string = n4 == 0 ? null : Integer.toString(n4);
                    }
                }
                if (string == null || string2 == null) continue;
                this.addAttribute(attributesImpl, string2, string);
            }
        }

        private void enqueueFeatures(int n, int n2) {
            int[] nArray = XCASSerializer.this.ts.getAppropriateFeatures(n2);
            block5: for (int i = 0; i < nArray.length; ++i) {
                int n3 = n + this.cas.getFeatureOffset(nArray[i]);
                int n4 = this.cas.getHeapValue(n3);
                int n5 = this.classifyType(XCASSerializer.this.ts.range(nArray[i]));
                switch (n5) {
                    case 0: {
                        continue block5;
                    }
                    case 1: {
                        continue block5;
                    }
                    case 2: {
                        continue block5;
                    }
                    default: {
                        if (n4 == 0) continue block5;
                        this.enqueue(n4);
                    }
                }
            }
        }

        private void encodeOutOfTypeSystemFeatures(int n, AttributesImpl attributesImpl) {
            List list = (List)this.mOutOfTypeSystemData.extraFeatureValues.get(new Integer(n));
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String[] stringArray = (String[])iterator.next();
                    if (stringArray[0].startsWith(XCASSerializer.REF_PREFIX) && stringArray[1].startsWith("a")) {
                        stringArray[1] = (String)this.mOutOfTypeSystemData.idMap.get(stringArray[1]);
                    }
                    this.addAttribute(attributesImpl, stringArray[0], stringArray[1]);
                }
            }
        }

        private void enqueueOutOfTypeSystemFeatures(int n) {
            List list = (List)this.mOutOfTypeSystemData.extraFeatureValues.get(new Integer(n));
            if (list != null) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String[] stringArray = (String[])iterator.next();
                    if (!stringArray[0].startsWith(XCASSerializer.REF_PREFIX) || stringArray[1].startsWith("a")) continue;
                    this.enqueue(Integer.parseInt(stringArray[1]));
                }
            }
        }

        private final String getTypeName(int n) {
            return XCASSerializer.this.ts.getTypeName(this.cas.getHeapValue(n));
        }

        private final int classifyType(int n) {
            if (this.cas.isIntType(n)) {
                return 0;
            }
            if (this.cas.isFloatType(n)) {
                return 1;
            }
            if (this.cas.isStringType(n)) {
                return 2;
            }
            if (this.cas.isIntArrayType(n)) {
                return 4;
            }
            if (this.cas.isFloatArrayType(n)) {
                return 5;
            }
            if (this.cas.isStringArrayType(n)) {
                return 6;
            }
            if (this.cas.isFSArrayType(n)) {
                return 7;
            }
            return 3;
        }

        private void enqueueOutOfTypeSystemData(OutOfTypeSystemData outOfTypeSystemData) {
            Iterator iterator = outOfTypeSystemData.fsList.iterator();
            while (iterator.hasNext()) {
                FSData fSData = (FSData)iterator.next();
                Iterator iterator2 = fSData.featVals.entrySet().iterator();
                while (iterator2.hasNext()) {
                    String string;
                    Map.Entry entry = iterator2.next();
                    String string2 = (String)entry.getKey();
                    if (!string2.startsWith(XCASSerializer.REF_PREFIX) || (string = (String)entry.getValue()).startsWith("a")) continue;
                    this.enqueue(Integer.parseInt(string));
                }
            }
        }

        private void serializeOutOfTypeSystemData(OutOfTypeSystemData outOfTypeSystemData) throws SAXException {
            Iterator iterator = outOfTypeSystemData.fsList.iterator();
            while (iterator.hasNext()) {
                Object object;
                FSData fSData = (FSData)iterator.next();
                this.workAttrs.clear();
                if (fSData.indexRep != null) {
                    this.addAttribute(this.workAttrs, XCASSerializer.INDEXED_ATTR_NAME, fSData.indexRep);
                }
                this.addAttribute(this.workAttrs, XCASSerializer.ID_ATTR_NAME, fSData.id);
                Iterator iterator2 = fSData.featVals.entrySet().iterator();
                while (iterator2.hasNext()) {
                    object = iterator2.next();
                    String string = (String)object.getKey();
                    String string2 = (String)object.getValue();
                    if (string.startsWith(XCASSerializer.REF_PREFIX) && string2.startsWith("a")) {
                        string2 = (String)this.mOutOfTypeSystemData.idMap.get(string2);
                    }
                    this.addAttribute(this.workAttrs, string, string2);
                }
                object = XCASSerializer.this.getXCasElementName(fSData.type);
                this.startElement((String)object, this.workAttrs, 0);
                this.endElement((String)object);
            }
        }
    }
}

