/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.uima.cas.impl;

import com.ibm.uima.UimaContext;
import com.ibm.uima.cas.CAS;
import com.ibm.uima.cas.SofaFS;
import com.ibm.uima.cas.Type;
import com.ibm.uima.cas.TypeSystem;
import com.ibm.uima.cas.impl.ArrayElement;
import com.ibm.uima.cas.impl.CASImpl;
import com.ibm.uima.cas.impl.FSData;
import com.ibm.uima.cas.impl.FSIndexRepositoryImpl;
import com.ibm.uima.cas.impl.FeatureImpl;
import com.ibm.uima.cas.impl.FeatureStructureImpl;
import com.ibm.uima.cas.impl.OutOfTypeSystemData;
import com.ibm.uima.cas.impl.TCASImpl;
import com.ibm.uima.cas.impl.TypeImpl;
import com.ibm.uima.cas.impl.TypeSystemImpl;
import com.ibm.uima.cas.impl.XCASParsingException;
import com.ibm.uima.cas.text.TCAS;
import com.ibm.uima.util.IntVector;
import com.ibm.uima.util.StringUtils;
import com.ibm.uima.util.rb_trees.RedBlackTree;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class XCASDeserializer {
    private static final int INT_TYPE = 0;
    private static final int FLOAT_TYPE = 1;
    private static final int STRING_TYPE = 2;
    private static final int FS_TYPE = 3;
    private TypeSystemImpl ts;
    private UimaContext uimaContext;
    private int[] featureType;
    private String docTypeName = "uima.tcas.Document";

    public XCASDeserializer(TypeSystem typeSystem, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)typeSystem;
        this.uimaContext = uimaContext;
        this.featureType = new int[this.ts.getNumberOfFeatures() + 1];
        Iterator iterator = this.ts.getFeatures();
        while (iterator.hasNext()) {
            FeatureImpl featureImpl = (FeatureImpl)iterator.next();
            Type type = featureImpl.getRange();
            if (type.getName().equals("uima.cas.Integer")) {
                this.featureType[featureImpl.getCode()] = 0;
                continue;
            }
            if (type.getName().equals("uima.cas.Float")) {
                this.featureType[featureImpl.getCode()] = 1;
                continue;
            }
            if (typeSystem.subsumes(typeSystem.getType("uima.cas.String"), type)) {
                this.featureType[featureImpl.getCode()] = 2;
                continue;
            }
            this.featureType[featureImpl.getCode()] = 3;
        }
    }

    public XCASDeserializer(TypeSystem typeSystem) {
        this(typeSystem, null);
    }

    public DefaultHandler getXCASHandler(CAS cAS) {
        return this.getXCASHandler(cAS, null);
    }

    public DefaultHandler getXCASHandler(CAS cAS, OutOfTypeSystemData outOfTypeSystemData) {
        return new XCASDeserializerHandler((CASImpl)cAS, outOfTypeSystemData);
    }

    public String getDocumentTypeName() {
        return this.docTypeName;
    }

    public void setDocumentTypeName(String string) {
        this.docTypeName = string;
    }

    public static void deserialize(InputStream inputStream, CAS cAS) throws SAXException, IOException {
        XCASDeserializer.deserialize(inputStream, cAS, false);
    }

    public static void deserialize(InputStream inputStream, CAS cAS, boolean bl) throws SAXException, IOException {
        XMLReader xMLReader = XMLReaderFactory.createXMLReader();
        XCASDeserializer xCASDeserializer = new XCASDeserializer(cAS.getTypeSystem());
        DefaultHandler defaultHandler = bl ? xCASDeserializer.getXCASHandler(cAS, new OutOfTypeSystemData()) : xCASDeserializer.getXCASHandler(cAS);
        xMLReader.setContentHandler(defaultHandler);
        xMLReader.parse(new InputSource(inputStream));
    }

    private class XCASDeserializerHandler
    extends DefaultHandler {
        private static final int DOC_STATE = 0;
        private static final int FS_STATE = 1;
        private static final int FEAT_STATE = 2;
        private static final int CONTENT_STATE = 3;
        private static final int FEAT_CONTENT_STATE = 4;
        private static final int ARRAY_ELE_CONTENT_STATE = 5;
        private static final int ARRAY_ELE_STATE = 6;
        private static final int DOC_TEXT_STATE = 7;
        private static final int OOTS_FEAT_STATE = 8;
        private static final int OOTS_CONTENT_STATE = 9;
        private static final String DEFAULT_CONTENT_FEATURE = "value";
        private static final String reservedAttrPrefix = "_";
        private static final String unknownXMLSource = "<unknown>";
        private Locator locator;
        private CASImpl cas;
        private RedBlackTree fsTree;
        private ArrayList idLess;
        private int state;
        private StringBuffer buffer;
        private int currentAddr;
        private String currentContentFeat = "value";
        private int arrayPos;
        private int arrayType;
        private OutOfTypeSystemData outOfTypeSystemData;
        private FSData currentOotsFs;
        private int sofaTypeCode;
        private ArrayList indexRepositories;
        private ArrayList tcasInstances;
        private TCAS oldTcas;

        private XCASDeserializerHandler(CASImpl cASImpl) {
            this(cASImpl, null);
        }

        private XCASDeserializerHandler(CASImpl cASImpl, OutOfTypeSystemData outOfTypeSystemData) {
            this.cas = cASImpl.getBaseCAS();
            this.cas.resetNoQuestions();
            this.fsTree = new RedBlackTree();
            this.idLess = new ArrayList();
            this.buffer = new StringBuffer();
            this.outOfTypeSystemData = outOfTypeSystemData;
            this.indexRepositories = new ArrayList();
            this.tcasInstances = new ArrayList();
            this.indexRepositories.add(this.cas.getIndexRepository());
            this.sofaTypeCode = this.cas.ll_getTypeSystem().ll_getCodeForType(this.cas.getTypeSystem().getType("uima.cas.Sofa"));
            this.oldTcas = null;
        }

        private final void resetBuffer() {
            this.buffer = new StringBuffer();
        }

        public void startDocument() throws SAXException {
            this.state = 0;
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            this.resetBuffer();
            switch (this.state) {
                case 0: {
                    if (!string3.equals("CAS")) {
                        throw this.createException(0, string3);
                    }
                    this.state = 1;
                    break;
                }
                case 1: {
                    this.currentContentFeat = DEFAULT_CONTENT_FEATURE;
                    if (string3.equals(XCASDeserializer.this.getDocumentTypeName())) {
                        this.readDocument(attributes);
                        break;
                    }
                    if (string3.equals("uima.tcas.DocumentAnnotation")) {
                        if (this.cas.isBackwardCompatibleCas()) {
                            if (this.oldTcas == null) {
                                if (this.indexRepositories.size() == 0) {
                                    this.indexRepositories.add(this.cas.getIndexRepository());
                                }
                                this.oldTcas = this.cas.getTCAS();
                                this.indexRepositories.add(this.oldTcas.getIndexRepository());
                            }
                            int n = ((FeatureStructureImpl)((Object)this.oldTcas.getDocumentAnnotation())).getAddress();
                            this.readFS(n, attributes, false);
                            break;
                        }
                        this.readFS(string3, attributes);
                        break;
                    }
                    this.readFS(string3, attributes);
                    break;
                }
                case 6: {
                    this.readArrayElement(string3, attributes);
                    break;
                }
                default: {
                    throw this.createException(1, string3);
                }
            }
        }

        private void readDocument(Attributes attributes) {
            this.state = 7;
        }

        private void readArrayElement(String string, Attributes attributes) throws SAXParseException {
            if (!string.equals("i")) {
                throw this.createException(2, string);
            }
            if (attributes.getLength() > 0) {
                throw this.createException(3);
            }
            this.state = 5;
        }

        private void readFS(String string, Attributes attributes) throws SAXParseException {
            String string2 = this.getCasTypeName(string);
            TypeImpl typeImpl = (TypeImpl)XCASDeserializer.this.ts.getType(string2);
            if (typeImpl == null && string2.equals("uima.cas.SofA")) {
                typeImpl = (TypeImpl)XCASDeserializer.this.ts.getType("uima.cas.Sofa");
            }
            if (typeImpl == null) {
                if (this.outOfTypeSystemData == null) {
                    throw this.createException(4, string2);
                }
                this.addToOutOfTypeSystemData(string2, attributes);
            } else {
                if (this.cas.isArrayType(typeImpl.getCode())) {
                    this.readArray(typeImpl, attributes);
                    return;
                }
                int n = this.cas.createTempFS(typeImpl.getCode());
                this.readFS(n, attributes, true);
            }
        }

        private void readFS(int n, Attributes attributes, boolean bl) throws SAXParseException {
            String[] stringArray;
            this.currentAddr = n;
            int n2 = -1;
            IntVector intVector = new IntVector();
            boolean bl2 = false;
            int n3 = this.cas.getHeapValue(n);
            if (this.sofaTypeCode == n3) {
                bl2 = true;
            }
            Type type = this.cas.ll_getTypeSystem().ll_getTypeForCode(this.cas.ll_getFSRefType(n));
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string = attributes.getQName(i);
                String string2 = attributes.getValue(i);
                if (string.startsWith(reservedAttrPrefix)) {
                    if (string.equals("_id")) {
                        try {
                            n2 = Integer.parseInt(string2);
                            continue;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.createException(5, string2);
                        }
                    }
                    if (string.equals("_content")) {
                        this.currentContentFeat = string2;
                        continue;
                    }
                    if (string.equals("_indexed")) {
                        if (!bl) continue;
                        if (string2.equals("true")) {
                            intVector.add(1);
                            continue;
                        }
                        if (string2.equals("false")) continue;
                        stringArray = this.parseArray(string2);
                        for (int j = 0; j < stringArray.length; ++j) {
                            intVector.add(Integer.parseInt(stringArray[j]));
                        }
                        continue;
                    }
                    this.handleFeature(type, n, string, string2, false);
                    continue;
                }
                if (bl2 && string.equals("sofaID") && XCASDeserializer.this.uimaContext != null) {
                    string2 = XCASDeserializer.this.uimaContext.mapToSofaID(string2).getSofaID();
                }
                this.handleFeature(type, n, string, string2, false);
            }
            if (this.sofaTypeCode == n3) {
                SofaFS sofaFS = (SofaFS)this.cas.createFS(n);
                this.cas.getIndexRepository().addFS(sofaFS);
                stringArray = this.cas.getTCAS(sofaFS);
                this.indexRepositories.add(this.cas.getSofaIndexRepository(sofaFS));
                this.tcasInstances.add(stringArray);
            }
            FSInfo fSInfo = new FSInfo(n, intVector);
            if (n2 < 0) {
                this.idLess.add(fSInfo);
            } else {
                this.fsTree.put(n2, fSInfo);
            }
            this.state = 3;
        }

        private void readArray(TypeImpl typeImpl, Attributes attributes) throws SAXParseException {
            String[] stringArray;
            int n;
            IntVector intVector = new IntVector();
            int n2 = 0;
            int n3 = -1;
            for (n = 0; n < attributes.getLength(); ++n) {
                String string = attributes.getQName(n);
                String string2 = attributes.getValue(n);
                if (string.equals("_id")) {
                    try {
                        n3 = Integer.parseInt(string2);
                        continue;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createException(5, string2);
                    }
                }
                if (string.equals("size")) {
                    try {
                        n2 = Integer.parseInt(string2);
                        if (n2 >= 0) continue;
                        throw this.createException(6, string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createException(9, string2);
                    }
                }
                if (string.equals("_indexed")) {
                    if (string2.equals("true")) {
                        intVector.add(1);
                        continue;
                    }
                    if (string2.equals("false")) continue;
                    stringArray = this.parseArray(string2);
                    for (int i = 0; i < stringArray.length; ++i) {
                        intVector.add(Integer.parseInt(stringArray[i]));
                    }
                    continue;
                }
                throw this.createException(7, string);
            }
            n = this.cas.createTempArray(typeImpl.getCode(), n2);
            stringArray = new FSInfo(n, intVector);
            if (n3 >= 0) {
                this.fsTree.put(n3, stringArray);
            } else {
                this.idLess.add(stringArray);
            }
            this.currentAddr = n;
            this.arrayPos = 0;
            this.arrayType = this.cas.isIntArrayType(typeImpl.getCode()) ? 0 : (this.cas.isFloatArrayType(typeImpl.getCode()) ? 1 : (this.cas.isStringArrayType(typeImpl.getCode()) ? 2 : 3));
            this.state = 6;
        }

        private final boolean emptyVal(String string) {
            return string == null || string.length() == 0;
        }

        private void handleFeature(int n, String string, String string2, boolean bl) throws SAXParseException {
            int n2 = this.cas.ll_getFSRefType(n);
            Type type = this.cas.ll_getTypeSystem().ll_getTypeForCode(n2);
            this.handleFeature(type, n, string, string2, bl);
        }

        private void handleFeature(Type type, int n, String string, String string2, boolean bl) throws SAXParseException {
            String string3 = string.startsWith("_ref_") ? string.substring("_ref_".length()) : string;
            FeatureImpl featureImpl = (FeatureImpl)type.getFeatureByBaseName(string3);
            if (featureImpl == null) {
                if (this.outOfTypeSystemData != null) {
                    Integer n2 = new Integer(n);
                    ArrayList<String[]> arrayList = (ArrayList<String[]>)this.outOfTypeSystemData.extraFeatureValues.get(n2);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String[]>();
                        this.outOfTypeSystemData.extraFeatureValues.put(n2, arrayList);
                    }
                    arrayList.add(new String[]{string, string2});
                } else if (!bl) {
                    throw this.createException(8, string);
                }
            } else {
                int n3 = featureImpl.getCode();
                switch (XCASDeserializer.this.featureType[n3]) {
                    case 0: {
                        try {
                            if (this.emptyVal(string2)) break;
                            this.cas.setFeatureValue(n, n3, Integer.parseInt(string2));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.createException(9, string2);
                        }
                    }
                    case 1: {
                        try {
                            if (this.emptyVal(string2)) break;
                            this.cas.setFloatValue(n, n3, Float.parseFloat(string2));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.createException(10, string2);
                        }
                    }
                    case 2: {
                        if (string2 == null) break;
                        this.cas.setStringValue(n, n3, string2);
                        break;
                    }
                    default: {
                        try {
                            if (this.emptyVal(string2)) break;
                            this.cas.setFeatureValue(n, n3, Integer.parseInt(string2));
                            break;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw this.createException(9, string2);
                        }
                    }
                }
            }
        }

        public void characters(char[] cArray, int n, int n2) throws SAXException {
            switch (this.state) {
                case 3: 
                case 4: 
                case 5: 
                case 7: {
                    this.buffer.append(cArray, n, n2);
                    break;
                }
            }
        }

        boolean isAllWhitespace(StringBuffer stringBuffer) {
            int n = stringBuffer.length();
            for (int i = 0; i < n; ++i) {
                if (Character.isWhitespace(stringBuffer.charAt(i))) continue;
                return false;
            }
            return true;
        }

        public void endElement(String string, String string2, String string3) throws SAXException {
            switch (this.state) {
                case 0: {
                    break;
                }
                case 1: {
                    this.state = 0;
                    break;
                }
                case 2: {
                    this.state = 1;
                    break;
                }
                case 3: {
                    if (!this.isAllWhitespace(this.buffer)) {
                        try {
                            this.handleFeature(this.currentAddr, this.currentContentFeat, this.buffer.toString(), true);
                        }
                        catch (XCASParsingException xCASParsingException) {
                            // empty catch block
                        }
                    }
                    this.state = 1;
                    break;
                }
                case 4: {
                    this.handleFeature(this.currentAddr, string3, this.buffer.toString(), false);
                    this.state = 2;
                    break;
                }
                case 5: {
                    this.addArrayElement(this.buffer.toString());
                    this.state = 6;
                    break;
                }
                case 6: {
                    this.state = 1;
                    break;
                }
                case 7: {
                    this.oldTcas = this.cas.getTCAS();
                    this.indexRepositories.add(this.oldTcas.getIndexRepository());
                    String string4 = this.buffer.toString();
                    if (this.oldTcas.getDocumentText() == null || !this.oldTcas.getDocumentText().equals(string4)) {
                        this.oldTcas.setDocumentText(string4);
                    }
                    this.state = 1;
                    break;
                }
                case 9: {
                    this.currentOotsFs.featVals.put(this.currentContentFeat, this.buffer.toString());
                    this.state = 1;
                    break;
                }
                case 8: {
                    this.state = 1;
                }
            }
        }

        private void addArrayElement(String string) throws SAXParseException {
            if (this.arrayPos >= this.cas.getArraySize(this.currentAddr)) {
                throw this.createException(11);
            }
            switch (this.arrayType) {
                case 0: {
                    if (this.emptyVal(string)) break;
                    try {
                        this.cas.setArrayValue(this.currentAddr, this.arrayPos, Integer.parseInt(string));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createException(9, string);
                    }
                }
                case 1: {
                    if (this.emptyVal(string)) break;
                    try {
                        this.cas.setArrayValue(this.currentAddr, this.arrayPos, CASImpl.float2int(Float.parseFloat(string)));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createException(10, string);
                    }
                }
                case 2: {
                    this.cas.setArrayValue(this.currentAddr, this.arrayPos, this.cas.addString(string));
                    break;
                }
                case 3: {
                    if (this.emptyVal(string)) break;
                    try {
                        this.cas.setArrayValue(this.currentAddr, this.arrayPos, Integer.parseInt(string));
                        break;
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.createException(9, string);
                    }
                }
            }
            ++this.arrayPos;
        }

        public void endDocument() throws SAXException {
            int n;
            Iterator iterator = this.fsTree.iterator();
            while (iterator.hasNext()) {
                this.finalizeFS((FSInfo)iterator.next());
            }
            for (n = 0; n < this.idLess.size(); ++n) {
                this.finalizeFS((FSInfo)this.idLess.get(n));
            }
            if (this.outOfTypeSystemData != null) {
                iterator = this.outOfTypeSystemData.fsList.iterator();
                while (iterator.hasNext()) {
                    this.finalizeOutOfTypeSystemFS((FSData)iterator.next());
                }
                this.finalizeOutOfTypeSystemFeatures();
            }
            for (n = 0; n < this.tcasInstances.size(); ++n) {
                ((TCASImpl)this.tcasInstances.get(n)).updateDocumentAnnotation();
            }
        }

        private void finalizeFS(FSInfo fSInfo) {
            int n;
            Object object;
            int n2 = fSInfo.addr;
            if (fSInfo.indexRep.size() >= 0) {
                if (this.indexRepositories.size() == 1 && fSInfo.indexRep.get(0) == 1) {
                    TCAS tCAS;
                    if (XCASDeserializer.this.uimaContext != null) {
                        object = this.cas.createSofa(XCASDeserializer.this.uimaContext.mapToSofaID("_DefaultTextSofaName"), "text");
                        tCAS = this.cas.getTCAS((SofaFS)object);
                    } else {
                        tCAS = this.cas.getTCAS();
                    }
                    this.indexRepositories.add(tCAS.getIndexRepository());
                }
                for (n = 0; n < fSInfo.indexRep.size(); ++n) {
                    ((FSIndexRepositoryImpl)this.indexRepositories.get(fSInfo.indexRep.get(n))).addFS(n2);
                }
            }
            if (this.cas.isArrayType(n = this.cas.getHeapValue(n2))) {
                this.finalizeArray(n, n2, fSInfo);
                return;
            }
            object = this.cas.getTypeSystemImpl().getAppropriateFeatures(n);
            for (int i = 0; i < ((int[])object).length; ++i) {
                int n3 = object[i];
                if (XCASDeserializer.this.featureType[n3] != 3) continue;
                int n4 = this.cas.getFeatureValue(n2, n3);
                FSInfo fSInfo2 = (FSInfo)this.fsTree.get(n4);
                if (fSInfo2 == null) {
                    this.cas.setFeatureValue(n2, n3, 0);
                    if (n4 == 0 || this.outOfTypeSystemData == null) continue;
                    Integer n5 = new Integer(n2);
                    ArrayList<String[]> arrayList = (ArrayList<String[]>)this.outOfTypeSystemData.extraFeatureValues.get(n5);
                    if (arrayList == null) {
                        arrayList = new ArrayList<String[]>();
                        this.outOfTypeSystemData.extraFeatureValues.put(n5, arrayList);
                    }
                    String string = XCASDeserializer.this.ts.getFeatureName(n3);
                    int n6 = string.indexOf(58);
                    String string2 = "_ref_" + string.substring(n6 + 1);
                    arrayList.add(new String[]{string2, Integer.toString(n4)});
                    continue;
                }
                this.cas.setFeatureValue(n2, n3, fSInfo2.addr);
            }
        }

        private void finalizeArray(int n, int n2, FSInfo fSInfo) {
            if (!this.cas.isFSArrayType(n)) {
                return;
            }
            int n3 = this.cas.getArraySize(n2);
            for (int i = 0; i < n3; ++i) {
                int n4 = this.cas.getArrayValue(n2, i);
                FSInfo fSInfo2 = (FSInfo)this.fsTree.get(n4);
                if (fSInfo2 == null) {
                    this.cas.setArrayValue(n2, i, 0);
                    if (n4 == 0 || this.outOfTypeSystemData == null) continue;
                    Integer n5 = new Integer(n2);
                    ArrayList<ArrayElement> arrayList = (ArrayList<ArrayElement>)this.outOfTypeSystemData.arrayElements.get(n5);
                    if (arrayList == null) {
                        arrayList = new ArrayList<ArrayElement>();
                        this.outOfTypeSystemData.arrayElements.put(n5, arrayList);
                    }
                    ArrayElement arrayElement = new ArrayElement(i, "a" + Integer.toString(n4));
                    arrayList.add(arrayElement);
                    continue;
                }
                this.cas.setArrayValue(n2, i, fSInfo2.addr);
            }
        }

        private void finalizeOutOfTypeSystemFS(FSData fSData) {
            fSData.id = 'a' + fSData.id;
            Iterator iterator = fSData.featVals.entrySet().iterator();
            while (iterator.hasNext()) {
                int n;
                Map.Entry entry = iterator.next();
                String string = (String)entry.getKey();
                if (!string.startsWith("_ref_") || (n = Integer.parseInt((String)entry.getValue())) < 0) continue;
                FSInfo fSInfo = (FSInfo)this.fsTree.get(n);
                if (fSInfo != null) {
                    entry.setValue(Integer.toString(fSInfo.addr));
                    continue;
                }
                entry.setValue("a" + n);
            }
        }

        private void finalizeOutOfTypeSystemFeatures() {
            Iterator iterator = this.outOfTypeSystemData.extraFeatureValues.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    int n;
                    String[] stringArray = (String[])iterator2.next();
                    if (!stringArray[0].startsWith("_ref_") || (n = Integer.parseInt(stringArray[1])) < 0) continue;
                    FSInfo fSInfo = (FSInfo)this.fsTree.get(n);
                    if (fSInfo != null) {
                        stringArray[1] = Integer.toString(fSInfo.addr);
                        continue;
                    }
                    stringArray[1] = "a" + n;
                }
            }
        }

        private XCASParsingException createException(int n) {
            XCASParsingException xCASParsingException = new XCASParsingException(n);
            String string = unknownXMLSource;
            String string2 = unknownXMLSource;
            String string3 = unknownXMLSource;
            if (this.locator != null) {
                string = this.locator.getSystemId();
                if (string == null) {
                    string = this.locator.getPublicId();
                }
                if (string == null) {
                    string = unknownXMLSource;
                }
                string2 = Integer.toString(this.locator.getLineNumber());
                string3 = Integer.toString(this.locator.getColumnNumber());
            }
            xCASParsingException.addArgument(string);
            xCASParsingException.addArgument(string2);
            xCASParsingException.addArgument(string3);
            return xCASParsingException;
        }

        private XCASParsingException createException(int n, String string) {
            XCASParsingException xCASParsingException = this.createException(n);
            xCASParsingException.addArgument(string);
            return xCASParsingException;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }

        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private void addToOutOfTypeSystemData(String string, Attributes attributes) throws XCASParsingException {
            if (this.outOfTypeSystemData != null) {
                FSData fSData = new FSData();
                fSData.type = string;
                fSData.indexRep = null;
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String string2 = attributes.getQName(i);
                    String string3 = attributes.getValue(i);
                    if (string2.startsWith(reservedAttrPrefix)) {
                        if (string2.equals("_id")) {
                            fSData.id = string3;
                            continue;
                        }
                        if (string2.equals("_content")) {
                            this.currentContentFeat = string3;
                            this.state = 9;
                            continue;
                        }
                        if (string2.equals("_indexed")) {
                            fSData.indexRep = string3;
                            continue;
                        }
                        fSData.featVals.put(string2, string3);
                        continue;
                    }
                    fSData.featVals.put(string2, string3);
                }
                this.outOfTypeSystemData.fsList.add(fSData);
                this.currentOotsFs = fSData;
                if (this.state != 9) {
                    this.state = 8;
                }
            }
        }

        private String[] parseArray(String string) {
            String[] stringArray = this.emptyVal(string = string.trim()) ? new String[]{} : string.split("\\s+");
            return stringArray;
        }

        private String getCasTypeName(String string) {
            if (string.indexOf(58) == -1 && string.indexOf(45) == -1) {
                return string;
            }
            return StringUtils.replaceAll(StringUtils.replaceAll(string, ":", "_colon_"), "-", "_dash_");
        }
    }

    private static class FSInfo {
        private int addr;
        private IntVector indexRep;

        private FSInfo(int n, IntVector intVector) {
            this.addr = n;
            this.indexRep = intVector;
        }
    }
}

